/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-09-17 08:03:01 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=946 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=53639 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2814 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_audit_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `network_id` bigint NOT NULL DEFAULT '0',
  `site_id` bigint NOT NULL DEFAULT '0',
  `username` varchar(60) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `level` varchar(25) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `event_type` varchar(25) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_general_ci NOT NULL,
  `stacktrace` text COLLATE utf8mb4_general_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_aiowps_debug_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `logtime` int unsigned DEFAULT NULL,
  `network_id` bigint NOT NULL DEFAULT '0',
  `site_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_events` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_global_meta` (
  `meta_id` bigint NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_logged_in_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `username` varchar(60) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `ip_address` varchar(45) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `site_id` bigint NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `expires` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_aiowps_login_lockdown` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT '1',
  `backtrace_log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `released` int unsigned DEFAULT NULL,
  `ip_lookup_result` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aiowps_message_store` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `message_key` text COLLATE utf8mb4_general_ci NOT NULL,
  `message_value` text COLLATE utf8mb4_general_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_aiowps_permanent_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  `created` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_run_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int unsigned NOT NULL,
  `step_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `step_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `step_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `run_number` int NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `automation_run_id_step_id` (`automation_run_id`,`step_id`),
  KEY `status` (`status`),
  KEY `step_id` (`step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_run_subjects` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `args` longtext COLLATE utf8mb4_general_ci,
  `hash` varchar(191) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_mailpoet_automation_runs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int unsigned NOT NULL,
  `version_id` int unsigned NOT NULL,
  `trigger_key` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `next_step_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`,`status`),
  KEY `created_at` (`created_at`),
  KEY `version_id` (`version_id`),
  KEY `status` (`status`),
  KEY `next_step_id` (`next_step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_triggers` (
  `automation_id` int unsigned NOT NULL,
  `trigger_key` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`automation_id`,`trigger_key`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_mailpoet_automation_versions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int unsigned NOT NULL,
  `steps` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `activated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_custom_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_dynamic_segment_filters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `filter_data` longblob,
  `filter_type` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_feature_flags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci,
  `styles` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `raw_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_mapping_to_external_entities` (
  `old_id` int unsigned NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `new_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`old_id`,`type`),
  KEY `new_id` (`new_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed_at` timestamp NULL DEFAULT NULL,
  `retries` int unsigned NOT NULL DEFAULT '0',
  `error` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_links` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_option` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `option_field_id` int unsigned NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_option_fields` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `newsletter_type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `post_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_segment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `segment_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_templates` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int DEFAULT '0',
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `categories` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '[]',
  `description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `thumbnail` longtext COLLATE utf8mb4_unicode_520_ci,
  `readonly` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `thumbnail_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `parent_id` int unsigned DEFAULT NULL,
  `subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sender_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `preheader` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ga_campaign` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `wp_post_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`),
  KEY `wp_post_id` (`wp_post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_scheduled_task_subscribers` (
  `task_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `processed` int NOT NULL,
  `failed` smallint NOT NULL DEFAULT '0',
  `error` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_scheduled_tasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` mediumint NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int DEFAULT NULL,
  `reschedule_count` int NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `cancelled_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_segments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'default',
  `description` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `display_in_manage_subscription_page` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_sending_queues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int unsigned NOT NULL,
  `newsletter_id` int unsigned NOT NULL,
  `newsletter_rendered_body` longtext COLLATE utf8mb4_unicode_520_ci,
  `newsletter_rendered_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subscribers` longtext COLLATE utf8mb4_unicode_520_ci,
  `count_total` int unsigned NOT NULL DEFAULT '0',
  `count_processed` int unsigned NOT NULL DEFAULT '0',
  `count_to_process` int unsigned NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5980 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_bounces` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_clicks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `link_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `user_agent_id` int unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_forms` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_newsletters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_opens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_agent_id` int unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_unsubscribes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned DEFAULT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `source` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT 'unknown',
  `meta` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `method` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_woocommerce_purchases` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned DEFAULT NULL,
  `subscriber_id` int unsigned NOT NULL,
  `queue_id` int unsigned NOT NULL,
  `click_id` int unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `order_currency` char(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_stats_notifications` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int unsigned NOT NULL,
  `task_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_custom_field` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int unsigned NOT NULL,
  `custom_field_id` int unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_ips` (
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_segment` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int unsigned NOT NULL,
  `segment_id` int unsigned NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_tag` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int unsigned NOT NULL,
  `tag_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_tag` (`subscriber_id`,`tag_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscribers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint DEFAULT NULL,
  `is_woocommerce_user` int NOT NULL DEFAULT '0',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `email` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `confirmed_ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') COLLATE utf8mb4_unicode_520_ci DEFAULT 'unknown',
  `count_confirmations` int unsigned NOT NULL DEFAULT '0',
  `unsubscribe_token` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `link_token` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  `email_count` int unsigned NOT NULL DEFAULT '0',
  `last_sending_at` timestamp NULL DEFAULT NULL,
  `last_open_at` timestamp NULL DEFAULT NULL,
  `last_click_at` timestamp NULL DEFAULT NULL,
  `last_purchase_at` timestamp NULL DEFAULT NULL,
  `last_page_view_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `link_token` (`link_token`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `first_name` (`first_name`(10)),
  KEY `last_name` (`last_name`(10)),
  KEY `last_sending_at` (`last_sending_at`),
  KEY `last_open_at` (`last_open_at`),
  KEY `last_click_at` (`last_click_at`),
  KEY `last_purchase_at` (`last_purchase_at`),
  KEY `last_page_view_at` (`last_page_view_at`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_user_agents` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_user_flags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=293983 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=88658 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=12424 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int unsigned DEFAULT NULL,
  `orig_size` int unsigned DEFAULT NULL,
  `file_time` int unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=924 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=57863 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=2713 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_zhk_updater_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `item` varchar(300) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ver` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `value` mediumtext COLLATE utf8mb4_general_ci,
  `parent` bigint unsigned DEFAULT NULL,
  `level` tinyint unsigned DEFAULT '0',
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("82", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2022-11-08 09:28:23", "2022-11-08 09:28:23", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1667899703;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1667899703;}", "4", "1", "2022-11-08 09:28:32", "2022-11-08 12:58:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("93", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2022-11-17 19:35:16", "2022-11-17 19:35:16", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1668713716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1668713716;}", "4", "1", "2022-11-17 19:35:27", "2022-11-17 23:05:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("124", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2022-12-13 11:06:13", "2022-12-13 11:06:13", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1670929573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1670929573;}", "4", "1", "2022-12-13 11:06:23", "2022-12-13 14:36:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("126", "action_scheduler/migration_hook", "failed", "2022-12-13 11:27:21", "2022-12-13 11:27:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1670930841;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1670930841;}", "1", "1", "2022-12-13 11:28:10", "2022-12-13 14:58:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("154", "action_scheduler/migration_hook", "failed", "2023-11-04 08:27:06", "2023-11-04 11:57:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1699086426;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1699086426;}", "1", "1", "2023-11-04 08:28:49", "2023-11-04 11:58:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("555", "action_scheduler/migration_hook", "failed", "2024-11-25 10:34:54", "2024-11-25 14:04:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732530894;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732530894;}", "1", "1", "2024-11-25 10:35:31", "2024-11-25 14:05:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("626", "action_scheduler/migration_hook", "failed", "2025-01-12 20:59:56", "2025-01-13 00:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1736715596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1736715596;}", "1", "1", "2025-01-12 21:00:01", "2025-01-13 00:30:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("627", "action_scheduler/migration_hook", "failed", "2025-01-12 20:59:56", "2025-01-13 00:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1736715596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1736715596;}", "1", "1", "2025-01-12 21:00:01", "2025-01-13 00:30:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("628", "action_scheduler/migration_hook", "failed", "2025-01-12 20:59:56", "2025-01-13 00:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1736715596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1736715596;}", "1", "1", "2025-01-12 21:00:01", "2025-01-13 00:30:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("661", "action_scheduler/migration_hook", "failed", "2025-02-04 16:00:09", "2025-02-04 19:30:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1738684809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1738684809;}", "1", "1", "2025-02-04 16:00:14", "2025-02-04 19:30:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("843", "action_scheduler/migration_hook", "failed", "2025-07-19 20:06:56", "2025-07-19 23:36:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1752955616;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1752955616;}", "1", "1", "2025-07-19 20:07:35", "2025-07-19 23:37:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("914", "woocommerce_cleanup_draft_orders", "complete", "2025-08-16 11:04:27", "2025-08-16 14:34:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755342267;s:18:\"\0*\0first_timestamp\";i:1659822803;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755342267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-11 17:39:11", "2025-09-11 21:09:11", "53286", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("916", "woocommerce_refresh_order_count_cache", "complete", "2025-08-16 18:29:48", "2025-08-16 21:59:48", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755368988;s:18:\"\0*\0first_timestamp\";i:1752988475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755368988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-09-11 17:39:11", "2025-09-11 21:09:11", "53286", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("921", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-17 07:21:08", "2025-08-17 10:51:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755415268;s:18:\"\0*\0first_timestamp\";i:1755328866;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755415268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-11 17:39:11", "2025-09-11 21:09:11", "53286", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("922", "woocommerce_cleanup_draft_orders", "complete", "2025-09-12 17:39:11", "2025-09-12 21:09:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757698751;s:18:\"\0*\0first_timestamp\";i:1659822803;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757698751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-13 07:08:36", "2025-09-13 10:38:36", "53376", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("923", "woocommerce_refresh_order_count_cache", "complete", "2025-09-12 05:39:11", "2025-09-12 09:09:11", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757655551;s:18:\"\0*\0first_timestamp\";i:1752988475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757655551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-09-13 07:08:36", "2025-09-13 10:38:36", "53376", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("924", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-12 17:39:11", "2025-09-12 21:09:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757698751;s:18:\"\0*\0first_timestamp\";i:1755328866;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757698751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-13 07:08:36", "2025-09-13 10:38:36", "53376", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("925", "woocommerce_refresh_order_count_cache", "complete", "2025-09-13 19:08:36", "2025-09-13 22:38:36", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757790516;s:18:\"\0*\0first_timestamp\";i:1752988475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757790516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-09-17 07:21:14", "2025-09-17 10:51:14", "53625", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("926", "woocommerce_cleanup_draft_orders", "complete", "2025-09-14 07:08:36", "2025-09-14 10:38:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757833716;s:18:\"\0*\0first_timestamp\";i:1659822803;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757833716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-17 07:21:14", "2025-09-17 10:51:14", "53625", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("927", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-14 07:08:36", "2025-09-14 10:38:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757833716;s:18:\"\0*\0first_timestamp\";i:1755328866;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757833716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-17 07:21:14", "2025-09-17 10:51:14", "53625", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("928", "fetch_patterns", "complete", "2025-09-13 10:17:58", "2025-09-13 13:47:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757758678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757758678;}", "6", "1", "2025-09-13 10:18:14", "2025-09-13 13:48:14", "53557", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("929", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-09-13 10:18:13", "2025-09-13 13:48:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757758693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757758693;}", "2", "1", "2025-09-13 10:18:15", "2025-09-13 13:48:15", "53557", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("930", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-09-13 10:18:12", "2025-09-13 13:48:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757758692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757758692;}", "4", "1", "2025-09-13 10:18:15", "2025-09-13 13:48:15", "53557", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("931", "woocommerce_refresh_order_count_cache", "pending", "2025-09-17 19:21:14", "2025-09-17 22:51:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758136874;s:18:\"\0*\0first_timestamp\";i:1752988475;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758136874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("932", "woocommerce_cleanup_draft_orders", "pending", "2025-09-18 07:21:14", "2025-09-18 10:51:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758180074;s:18:\"\0*\0first_timestamp\";i:1659822803;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758180074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("933", "woocommerce_scheduled_sales", "pending", "2025-09-17 21:00:00", "2025-09-18 00:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758142800;s:18:\"\0*\0first_timestamp\";i:1758142800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758142800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("934", "woocommerce_cancel_unpaid_orders", "pending", "2025-09-17 08:21:14", "2025-09-17 11:51:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758097274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758097274;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("935", "woocommerce_cleanup_personal_data", "complete", "2025-09-17 07:21:24", "2025-09-17 10:51:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758093684;s:18:\"\0*\0first_timestamp\";i:1758093684;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758093684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-17 07:30:25", "2025-09-17 11:00:25", "53627", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("936", "woocommerce_cleanup_logs", "pending", "2025-09-17 10:21:14", "2025-09-17 13:51:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758104474;s:18:\"\0*\0first_timestamp\";i:1758104474;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758104474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("937", "woocommerce_cleanup_sessions", "pending", "2025-09-17 13:21:14", "2025-09-17 16:51:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758115274;s:18:\"\0*\0first_timestamp\";i:1758115274;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758115274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("938", "woocommerce_geoip_updater", "complete", "2025-09-17 07:22:14", "2025-09-17 10:52:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758093734;s:18:\"\0*\0first_timestamp\";i:1758093734;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758093734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "9", "1", "2025-09-17 07:30:25", "2025-09-17 11:00:25", "53627", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("939", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-09-17 10:21:14", "2025-09-17 13:51:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758104474;s:18:\"\0*\0first_timestamp\";i:1758104474;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758104474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("940", "wc_admin_daily_wrapper", "complete", "2025-09-17 07:21:14", "2025-09-17 10:51:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758093674;s:18:\"\0*\0first_timestamp\";i:1758093674;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758093674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-17 07:21:41", "2025-09-17 10:51:41", "53626", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("941", "generate_category_lookup_table_wrapper", "complete", "2025-09-17 07:21:24", "2025-09-17 10:51:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758093684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758093684;}", "9", "1", "2025-09-17 07:30:25", "2025-09-17 11:00:25", "53627", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("942", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-09-18 07:21:14", "2025-09-18 10:51:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758180074;s:18:\"\0*\0first_timestamp\";i:1755328866;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758180074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("943", "wc_admin_daily_wrapper", "pending", "2025-09-18 07:21:41", "2025-09-18 10:51:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758180101;s:18:\"\0*\0first_timestamp\";i:1758093674;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758180101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("944", "woocommerce_cleanup_personal_data", "pending", "2025-09-18 07:30:25", "2025-09-18 11:00:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758180625;s:18:\"\0*\0first_timestamp\";i:1758093684;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758180625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("945", "woocommerce_geoip_updater", "pending", "2025-10-02 07:30:25", "2025-10-02 11:00:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759390225;s:18:\"\0*\0first_timestamp\";i:1758093734;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759390225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "woocommerce");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("240", "82", "action created", "2022-11-08 09:28:23", "2022-11-08 09:28:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("241", "82", "action started via WP Cron", "2022-11-08 09:28:32", "2022-11-08 09:28:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("242", "82", "action failed via WP Cron: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2022-11-08 09:28:32", "2022-11-08 09:28:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("275", "93", "action created", "2022-11-17 19:35:16", "2022-11-17 19:35:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("277", "93", "action started via WP Cron", "2022-11-17 19:35:27", "2022-11-17 19:35:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("278", "93", "action failed via WP Cron: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2022-11-17 19:35:27", "2022-11-17 19:35:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("364", "124", "action created", "2022-12-13 11:06:13", "2022-12-13 11:06:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("365", "124", "action started via WP Cron", "2022-12-13 11:06:23", "2022-12-13 11:06:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("366", "124", "action failed via WP Cron: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2022-12-13 11:06:23", "2022-12-13 11:06:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "126", "action created", "2022-12-13 11:26:21", "2022-12-13 11:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "126", "action started via WP Cron", "2022-12-13 11:28:10", "2022-12-13 11:28:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "126", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2022-12-13 11:28:10", "2022-12-13 11:28:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("458", "154", "action created", "2023-11-04 08:26:06", "2023-11-04 11:56:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("459", "154", "action started via WP Cron", "2023-11-04 08:28:49", "2023-11-04 11:58:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("460", "154", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-11-04 08:28:49", "2023-11-04 11:58:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1661", "555", "ایجاد فعالیت", "2024-11-25 10:33:54", "2024-11-25 14:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1662", "555", "عملیات توسط WP Cron شروع شد", "2024-11-25 10:35:31", "2024-11-25 14:05:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1663", "555", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-11-25 10:35:31", "2024-11-25 14:05:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1874", "626", "action created", "2025-01-12 20:58:56", "2025-01-13 00:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1875", "627", "action created", "2025-01-12 20:58:56", "2025-01-13 00:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1876", "628", "action created", "2025-01-12 20:58:56", "2025-01-13 00:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1877", "626", "action started via Async Request", "2025-01-12 21:00:01", "2025-01-13 00:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1878", "626", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-01-12 21:00:01", "2025-01-13 00:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1879", "627", "action started via Async Request", "2025-01-12 21:00:01", "2025-01-13 00:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1880", "627", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-01-12 21:00:01", "2025-01-13 00:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1881", "628", "action started via Async Request", "2025-01-12 21:00:01", "2025-01-13 00:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1882", "628", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-01-12 21:00:01", "2025-01-13 00:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1979", "661", "action created", "2025-02-04 15:59:09", "2025-02-04 19:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1980", "661", "عملیات توسط WP Cron شروع شد", "2025-02-04 16:00:14", "2025-02-04 19:30:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("1981", "661", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-02-04 16:00:14", "2025-02-04 19:30:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2523", "843", "ایجاد فعالیت", "2025-07-19 20:05:56", "2025-07-19 23:35:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2524", "843", "عملیات توسط Async Request شروع شد", "2025-07-19 20:07:35", "2025-07-19 23:37:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2525", "843", "اقدام از طریق Async Request انجام نشد: اقدام زمان‌بندی‌شده برای action_scheduler/migration_hook اجرا نخواهد شد زیرا هیچ فراخوانی برگشتی ثبت نشده است.", "2025-07-19 20:07:35", "2025-07-19 23:37:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2738", "914", "ایجاد فعالیت", "2025-08-15 11:04:27", "2025-08-15 14:34:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2744", "916", "ایجاد فعالیت", "2025-08-16 06:29:48", "2025-08-16 09:59:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2757", "921", "ایجاد فعالیت", "2025-08-16 07:21:08", "2025-08-16 10:51:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2758", "914", "عملیات توسط WP Cron شروع شد", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2759", "914", "عملیات توسط WP Cron کامل شد", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2760", "922", "ایجاد فعالیت", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2761", "916", "عملیات توسط WP Cron شروع شد", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2762", "916", "عملیات توسط WP Cron کامل شد", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2763", "923", "ایجاد فعالیت", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2764", "921", "عملیات توسط WP Cron شروع شد", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2765", "921", "عملیات توسط WP Cron کامل شد", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2766", "924", "ایجاد فعالیت", "2025-09-11 17:39:11", "2025-09-11 21:09:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2767", "923", "عملیات توسط WP Cron شروع شد", "2025-09-13 07:08:35", "2025-09-13 10:38:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2768", "923", "عملیات توسط WP Cron کامل شد", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2769", "925", "ایجاد فعالیت", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2770", "922", "عملیات توسط WP Cron شروع شد", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2771", "922", "عملیات توسط WP Cron کامل شد", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2772", "926", "ایجاد فعالیت", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2773", "924", "عملیات توسط WP Cron شروع شد", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2774", "924", "عملیات توسط WP Cron کامل شد", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2775", "927", "ایجاد فعالیت", "2025-09-13 07:08:36", "2025-09-13 10:38:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2776", "928", "ایجاد فعالیت", "2025-09-13 10:17:58", "2025-09-13 13:47:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2777", "929", "ایجاد فعالیت", "2025-09-13 10:18:12", "2025-09-13 13:48:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2778", "930", "ایجاد فعالیت", "2025-09-13 10:18:12", "2025-09-13 13:48:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2779", "928", "عملیات توسط Async Request شروع شد", "2025-09-13 10:18:14", "2025-09-13 13:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2780", "928", "عملیات توسط Async Request کامل شد", "2025-09-13 10:18:14", "2025-09-13 13:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2781", "930", "عملیات توسط Async Request شروع شد", "2025-09-13 10:18:14", "2025-09-13 13:48:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2782", "930", "عملیات توسط Async Request کامل شد", "2025-09-13 10:18:15", "2025-09-13 13:48:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2783", "929", "عملیات توسط Async Request شروع شد", "2025-09-13 10:18:15", "2025-09-13 13:48:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2784", "929", "عملیات توسط Async Request کامل شد", "2025-09-13 10:18:15", "2025-09-13 13:48:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2785", "925", "عملیات توسط WP Cron شروع شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2786", "925", "عملیات توسط WP Cron کامل شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2787", "931", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2788", "926", "عملیات توسط WP Cron شروع شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2789", "926", "عملیات توسط WP Cron کامل شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2790", "932", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2791", "927", "عملیات توسط WP Cron شروع شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2792", "933", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2793", "934", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2794", "935", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2795", "936", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2796", "937", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2797", "938", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2798", "939", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2799", "940", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2800", "941", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2801", "927", "عملیات توسط WP Cron کامل شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2802", "942", "ایجاد فعالیت", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2803", "940", "عملیات توسط WP Cron شروع شد", "2025-09-17 07:21:14", "2025-09-17 10:51:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2804", "940", "عملیات توسط WP Cron کامل شد", "2025-09-17 07:21:41", "2025-09-17 10:51:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2805", "943", "ایجاد فعالیت", "2025-09-17 07:21:41", "2025-09-17 10:51:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2806", "935", "عملیات توسط Async Request شروع شد", "2025-09-17 07:30:24", "2025-09-17 11:00:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2807", "935", "عملیات توسط Async Request کامل شد", "2025-09-17 07:30:25", "2025-09-17 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2808", "944", "ایجاد فعالیت", "2025-09-17 07:30:25", "2025-09-17 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2809", "941", "عملیات توسط Async Request شروع شد", "2025-09-17 07:30:25", "2025-09-17 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2810", "941", "عملیات توسط Async Request کامل شد", "2025-09-17 07:30:25", "2025-09-17 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2811", "938", "عملیات توسط Async Request شروع شد", "2025-09-17 07:30:25", "2025-09-17 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2812", "938", "عملیات توسط Async Request کامل شد", "2025-09-17 07:30:25", "2025-09-17 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2813", "945", "ایجاد فعالیت", "2025-09-17 07:30:25", "2025-09-17 11:00:25");

/* INSERT TABLE DATA: wp_aiowps_audit_log */
INSERT INTO `wp_aiowps_audit_log` VALUES("3879", "1", "1", "daris_admin", "37.98.73.245", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731341593", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3880", "1", "1", "daris_admin", "37.98.73.245", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731345234", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3881", "1", "1", "daris_admin", "37.98.72.117", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731398613", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3882", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480601", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3883", "1", "1", "daris_admin", "178.131.129.200", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u062f\\u0627\\u067e\\u0644\\u06cc\\u06a9\\u06cc\\u062a\\u0648\\u0631 - \\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 \\u0645\\u0647\\u0627\\u062c\\u0631\\u062a \\u0648 \\u067e\\u0634\\u062a\\u06cc\\u0628\\u0627\\u0646\\u200c\\u06af\\u06cc\\u0631\\u06cc \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"version\":\"1.5.11.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480658", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3884", "1", "1", "daris_admin", "178.131.129.200", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.25.5\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480658", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3885", "1", "1", "daris_admin", "178.131.129.200", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.3.7\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480658", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3886", "1", "1", "daris_admin", "178.131.129.200", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MetForm\",\"version\":\"3.9.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480658", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3887", "1", "1", "daris_admin", "178.131.129.200", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"9.4.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480658", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3888", "1", "1", "daris_admin", "178.131.129.200", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"9.4.1\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731480660", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3889", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731481574", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3890", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731481686", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3891", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731482153", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3892", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731482161", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3893", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731482199", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3894", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731483290", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3895", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731483293", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3896", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731483298", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3897", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731483397", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3898", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731483401", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3899", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731483526", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3900", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731484610", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3901", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731488657", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3902", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731499733", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3903", "1", "1", "daris_admin", "178.131.129.200", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731503338", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3904", "1", "1", "daris_admin", "37.98.74.179", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731520906", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3905", "1", "1", "daris_admin", "5.134.178.253", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731522170", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3906", "1", "1", "daris_admin", "37.98.73.215", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731607260", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3907", "1", "1", "daris_admin", "37.98.73.215", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731609872", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3908", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731655201", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3909", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731657588", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3910", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731673902", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3911", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731677031", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3912", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731677036", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3913", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731680236", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3914", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731680712", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3915", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731682695", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3916", "1", "1", "daris_admin", "37.98.105.43", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731684818", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3917", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731685251", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3918", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731685575", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3919", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731685579", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3920", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731686486", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3921", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731686614", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3922", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731686812", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3923", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731687161", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3924", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731693169", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3925", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731693265", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3926", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731701418", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3927", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731701500", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3928", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731701500", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3929", "1", "1", "daris_admin", "37.98.74.35", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731703058", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3930", "1", "1", "daris_admin", "93.119.210.37", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731740725", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3931", "1", "1", "daris_admin", "93.119.210.37", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731742053", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3932", "1", "1", "daris_admin", "93.119.210.37", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731745917", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3933", "1", "1", "", "176.9.21.46", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.6.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731952161", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3934", "1", "1", "", "176.9.21.46", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"9.4.1\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1731952163", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3935", "1", "1", "", "176.9.21.46", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"9.4.1\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732069272", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3936", "1", "1", "daris_admin", "188.213.195.118", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732096359", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3937", "1", "1", "daris_admin", "188.213.195.118", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732105550", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3938", "1", "1", "daris_admin", "188.213.195.118", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732105555", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3939", "1", "1", "daris_admin", "188.213.195.118", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732105759", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3940", "1", "1", "daris_admin", "188.213.195.118", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732105789", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3941", "1", "1", "daris_admin", "188.213.195.118", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732108229", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3942", "1", "1", "daris_admin", "93.119.209.36", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732124070", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3943", "1", "1", "daris_admin", "93.119.209.36", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732133801", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3944", "1", "1", "daris_admin", "93.119.210.61", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732209928", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3945", "1", "1", "daris_admin", "93.119.210.61", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732219485", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3946", "1", "1", "daris_admin", "93.119.211.115", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732298011", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3947", "1", "1", "daris_admin", "93.119.211.115", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732307522", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3948", "1", "1", "daris_admin", "178.131.25.126", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732344800", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3949", "1", "1", "daris_admin", "178.131.25.126", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.25.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732345101", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3950", "1", "1", "daris_admin", "178.131.25.126", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.4.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732345102", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3951", "1", "1", "daris_admin", "178.131.25.126", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"9.4.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732345102", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3952", "1", "1", "daris_admin", "95.162.175.75", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732391920", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3953", "1", "1", "daris_admin", "188.212.243.54", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732441512", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3954", "1", "1", "daris_admin", "188.212.243.54", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732441518", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3955", "1", "1", "daris_admin", "188.212.243.54", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732441534", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3956", "1", "1", "daris_admin", "188.212.243.54", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732446666", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3957", "1", "1", "daris_admin", "188.212.243.54", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732446687", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3958", "1", "1", "daris_admin", "5.127.231.246", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732517890", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3959", "1", "1", "daris_admin", "5.127.231.246", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732518500", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3960", "1", "1", "daris_admin", "5.127.231.246", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732518867", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3961", "1", "1", "daris_admin", "5.127.231.246", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732518884", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3962", "1", "1", "daris_admin", "178.131.138.5", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732520507", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3963", "1", "1", "daris_admin", "178.131.138.5", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633 \\u0641\\u0627\\u0631\\u0633\\u06cc\",\"version\":\"9.0.1\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732530770", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3964", "1", "1", "daris_admin", "178.131.138.5", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633 \\u0641\\u0627\\u0631\\u0633\\u06cc\",\"version\":\"9.0.1\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:239;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4770;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732530794", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3965", "1", "1", "daris_admin", "178.131.138.5", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732532851", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3966", "1", "1", "daris_admin", "178.131.138.5", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732537042", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3967", "1", "1", "daris_admin", "188.212.240.57", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732559843", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3968", "1", "1", "daris_admin", "188.212.240.57", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732559901", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3969", "1", "1", "daris_admin", "188.212.243.241", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732647054", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3970", "1", "1", "daris_admin", "188.212.243.241", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.25.10\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732650883", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3971", "1", "1", "daris_admin", "188.212.243.241", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.4.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732650883", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3972", "1", "1", "daris_admin", "188.212.243.241", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0628\\u0633\\u062a\\u06c0 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633 \\u067e\\u0627\\u0631\\u0633\\u06cc\",\"version\":\"5.1.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732650883", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3973", "1", "1", "daris_admin", "188.212.243.241", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"wp-parsidate\",\"version\":\"5.1.2\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732650884", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3974", "1", "1", "daris_admin", "188.212.243.241", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732654122", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3975", "1", "1", "daris_admin", "188.212.241.195", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732697744", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3976", "1", "1", "daris_admin", "188.212.241.195", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732717265", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3977", "1", "1", "daris_admin", "188.212.241.195", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732738597", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3978", "1", "1", "daris_admin", "188.212.243.73", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732799022", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3979", "1", "1", "daris_admin", "188.212.243.73", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732799082", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3980", "1", "1", "daris_admin", "188.212.242.24", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732900042", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3981", "1", "1", "daris_admin", "188.212.242.24", "info", "plugin_installed", "{\"plugin\":{\"name\":\"WP-Optimize - Clean, Compress, Cache\",\"version\":\"3.7.1\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:970;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4493;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732903674", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3982", "1", "1", "daris_admin", "188.212.242.24", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"wp-optimize\",\"version\":\"3.7.1\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:66:\"C:/laragon/www/darisonline/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:970;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4493;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732903676", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3983", "1", "1", "daris_admin", "188.212.242.24", "info", "plugin_activated", "{\"plugin\":{\"name\":\"\\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632 \\u067e\\u0627\\u06cc\\u06af\\u0627\\u0647 \\u062f\\u0627\\u062f\\u0647 - \\u067e\\u0627\\u06a9\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u0641\\u0634\\u0631\\u062f\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u06a9\\u0634\",\"version\":\"3.7.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732903679", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3984", "1", "1", "daris_admin", "188.212.242.147", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732904455", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3985", "1", "1", "daris_admin", "188.212.242.24", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732913468", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3986", "1", "1", "daris_admin", "188.212.241.247", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732949295", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3987", "1", "1", "daris_admin", "188.212.241.247", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732949722", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3988", "1", "1", "daris_admin", "188.212.241.247", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732986302", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3989", "1", "1", "daris_admin", "188.212.241.247", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1732988034", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3990", "1", "1", "baatiis", "37.98.115.207", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"baatiis\",\"known\":false}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:573;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733126296", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3991", "1", "1", "daris_admin", "37.98.115.207", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733126970", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3992", "1", "1", "daris_admin", "37.98.115.207", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733138963", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3993", "1", "1", "daris_admin", "188.212.240.53", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733161810", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3994", "1", "1", "daris_admin", "95.162.203.97", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733168764", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3995", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733227743", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3996", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733246591", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3997", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733246624", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3998", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733254354", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("3999", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733254937", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4000", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733254984", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4001", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733254990", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4002", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255073", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4003", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255110", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4004", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255125", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4005", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255201", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4006", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255211", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4007", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255270", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4008", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255294", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4009", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255319", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4010", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255335", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4011", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255369", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4012", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255376", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4013", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255400", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4014", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255408", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4015", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255429", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4016", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733255512", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4017", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256103", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4018", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256120", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4019", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256126", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4020", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256142", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4021", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256186", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4022", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256276", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4023", "1", "1", "daris_admin", "188.212.243.144", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733256332", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4024", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733296738", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4025", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733297482", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4026", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733297499", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4027", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733300122", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4028", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733305064", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4029", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733314602", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4030", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733314647", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4031", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733318638", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4032", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733318653", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4033", "1", "1", "daris_admin", "188.212.241.20", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733319737", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4034", "1", "1", "daris_admin", "188.212.243.12", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733410671", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4035", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733566097", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4036", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733566415", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4037", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733567404", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4038", "1", "1", "daris_admin", "95.162.177.198", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733568086", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4039", "1", "1", "daris_admin", "95.162.177.198", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733568176", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4040", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733575381", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4041", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733576269", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4042", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733577089", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4043", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733577138", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4044", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733577155", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4045", "1", "1", "daris_admin", "188.212.243.61", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733592791", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4046", "1", "1", "daris_admin", "95.162.181.244", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733594236", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4047", "1", "1", "daris_admin", "95.162.188.148", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733663862", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4048", "1", "1", "daris_admin", "188.212.240.53", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733667261", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4049", "1", "1", "daris_admin", "178.131.161.140", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733816419", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4050", "1", "1", "daris_admin", "178.131.161.140", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733818005", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4051", "1", "1", "daris_admin", "178.131.161.140", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733820485", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4052", "1", "1", "daris_admin", "178.131.161.140", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733821534", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4053", "1", "1", "daris_admin", "178.131.161.140", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733825079", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4054", "1", "1", "daris_admin", "178.131.161.140", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733833091", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4055", "1", "1", "daris_admin", "37.98.74.55", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733861996", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4056", "1", "1", "daris_admin", "95.162.137.4", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733862317", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4057", "1", "1", "daris_admin", "37.98.72.135", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733940645", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4058", "1", "1", "daris_admin", "37.98.72.135", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1733944133", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4059", "1", "1", "daris_admin", "37.98.72.174", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734105732", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4060", "1", "1", "daris_admin", "178.131.26.224", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734105931", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4061", "1", "1", "daris_admin", "37.98.72.174", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734106348", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4062", "1", "1", "daris_admin", "178.131.25.59", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734162340", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4063", "1", "1", "daris_admin", "178.131.25.59", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734167876", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4064", "1", "1", "daris_admin", "5.134.176.207", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734344499", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4065", "1", "1", "daris_admin", "5.134.176.207", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734345318", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4066", "1", "1", "daris_admin", "93.117.184.239", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734353648", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4067", "1", "1", "daris_admin", "93.117.184.239", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734358226", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4068", "1", "1", "daris_admin", "93.117.184.239", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734371743", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4069", "1", "1", "daris_admin", "93.117.184.239", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734379664", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4070", "1", "1", "daris_admin", "93.117.185.214", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734438666", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4071", "1", "1", "daris_admin", "178.131.184.19", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734527957", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4072", "1", "1", "daris_admin", "178.131.186.212", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734546023", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4073", "1", "1", "daris_admin", "178.131.186.212", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734546559", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4074", "1", "1", "daris_admin", "5.127.13.197", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734768603", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4075", "1", "1", "daris_admin", "5.127.122.137", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 All In One WP Security\",\"version\":\"5.3.8\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782545", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4076", "1", "1", "daris_admin", "5.127.122.137", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645 \\u062a\\u0645\\u0627\\u0633 \\u06f7\",\"version\":\"6.0.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782545", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4077", "1", "1", "daris_admin", "5.127.122.137", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.26.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782545", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4078", "1", "1", "daris_admin", "5.127.122.137", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.5.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782545", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4079", "1", "1", "daris_admin", "5.127.122.137", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"9.5.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782545", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4080", "1", "1", "daris_admin", "5.127.122.137", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632 \\u067e\\u0627\\u06cc\\u06af\\u0627\\u0647 \\u062f\\u0627\\u062f\\u0647 - \\u067e\\u0627\\u06a9\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u0641\\u0634\\u0631\\u062f\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u06a9\\u0634\",\"version\":\"3.8.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782545", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4081", "1", "1", "daris_admin", "5.127.122.137", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"all-in-one-wp-security-and-firewall\",\"version\":\"5.3.8\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782549", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4082", "1", "1", "daris_admin", "5.127.122.137", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.26.2\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782549", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4083", "1", "1", "daris_admin", "5.127.122.137", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"9.5.1\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:418;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline/wp-admin/update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734782549", NULL);
INSERT INTO `wp_aiowps_audit_log` VALUES("4084", "1", "1", "daris_admin", "89.47.70.154", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734785449", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4085", "1", "1", "daris_admin", "178.131.148.70", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734810171", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4086", "1", "1", "daris_admin", "178.131.148.70", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734810354", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4087", "1", "1", "daris_admin", "178.131.148.176", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline/wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734890432", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4088", "1", "1", "daris_admin", "178.131.148.176", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734892392", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4089", "1", "1", "daris_admin", "178.131.148.176", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.26.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:17:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:194;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-upgrader.php\";s:4:\"line\";i:970;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:237;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-content\\plugins\\elementor\\includes\\rollback.php\";s:4:\"line\";i:171;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-content\\plugins\\elementor\\includes\\rollback.php\";s:4:\"line\";i:184;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:18:\"Elementor\\Rollback\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:83:\"C:/laragon/www/darisonline\\wp-content\\plugins\\elementor\\includes\\settings\\tools.php\";s:4:\"line\";i:172;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:18:\"Elementor\\Rollback\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"post_elementor_rollback\";s:5:\"class\";s:15:\"Elementor\\Tools\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline\\wp-admin\\admin-post.php\";s:4:\"line\";i:85;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734892487", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4090", "1", "1", "daris_admin", "178.131.151.126", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734923163", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4091", "1", "1", "", "::1", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"woocommerce\",\"version\":\"9.5.1\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline\\wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734950094", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4092", "1", "1", "daris_admin", "178.131.171.93", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734950145", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4093", "1", "1", "daris_admin", "178.131.171.93", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.25.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:17:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:194;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-upgrader.php\";s:4:\"line\";i:970;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:237;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-content\\plugins\\elementor\\includes\\rollback.php\";s:4:\"line\";i:171;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-content\\plugins\\elementor\\includes\\rollback.php\";s:4:\"line\";i:184;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:18:\"Elementor\\Rollback\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:83:\"C:/laragon/www/darisonline\\wp-content\\plugins\\elementor\\includes\\settings\\tools.php\";s:4:\"line\";i:172;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:18:\"Elementor\\Rollback\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"post_elementor_rollback\";s:5:\"class\";s:15:\"Elementor\\Tools\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline\\wp-admin\\admin-post.php\";s:4:\"line\";i:85;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734950934", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4094", "1", "1", "daris_admin", "178.131.171.93", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1734956513", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4095", "1", "1", "", "::1", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.6.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline\\wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735019143", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4096", "1", "1", "wp_learn", "178.131.26.210", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"wp_learn\",\"known\":false}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735043092", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4097", "1", "1", "wp_learn", "178.131.26.210", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"wp_learn\",\"known\":false}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735043098", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4098", "1", "1", "daris_admin", "178.131.26.210", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"daris_admin\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:569;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735043109", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4099", "1", "1", "daris_admin", "178.131.26.210", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"daris_admin\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:569;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735043120", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4100", "1", "1", "daris_admin", "178.131.26.210", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735043134", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4101", "1", "1", "daris_admin", "157.175.154.107", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735071753", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4102", "1", "1", "daris_admin", "37.98.106.17", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735111692", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4103", "1", "1", "daris_admin", "37.98.106.17", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645 \\u062a\\u0645\\u0627\\u0633 \\u06f7\",\"version\":\"6.0.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735129006", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4104", "1", "1", "daris_admin", "37.98.106.17", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.26.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735129007", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4105", "1", "1", "daris_admin", "37.98.106.17", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.5.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735129007", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4106", "1", "1", "daris_admin", "37.98.106.17", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735130592", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4107", "1", "1", "", "::1", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.26.3\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline\\wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735149552", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4108", "1", "1", "daris_admin", "178.131.25.120", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735149687", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4109", "1", "1", "daris_admin", "178.131.25.120", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735153436", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4110", "1", "1", "daris_admin", "178.131.26.124", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735198179", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4111", "1", "1", "daris_admin", "178.131.26.124", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735222235", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4112", "1", "1", "", "::1", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.6.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline\\wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735369412", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4113", "1", "1", "daris_admin", "2a01:5ec0:d801:43f4:9032:6569:890f:5be4", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735369688", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4114", "1", "1", "daris_admin", "157.175.154.107", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735387080", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4115", "1", "1", "daris_admin", "178.131.27.188", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735398728", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4116", "1", "1", "daris_admin", "178.131.27.188", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735398835", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4117", "1", "1", "daris_admin", "178.131.27.188", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735398916", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4118", "1", "1", "daris_admin", "178.131.27.188", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735400442", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4119", "1", "1", "daris_admin", "178.131.27.188", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735400465", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4120", "1", "1", "daris_admin", "178.131.27.188", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735400471", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4121", "1", "1", "daris_admin", "178.131.25.47", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735496574", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4122", "1", "1", "daris_admin", "178.131.25.47", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735504073", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4123", "1", "1", "daris_admin", "178.131.186.77", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735542069", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4124", "1", "1", "daris_admin", "178.131.186.77", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735545504", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4125", "1", "1", "daris_admin", "178.131.186.77", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1735545522", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4126", "1", "1", "wp_learn", "178.131.27.77", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"wp_learn\",\"known\":false}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736323642", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4127", "1", "1", "daris_admin", "178.131.27.77", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736323658", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4128", "1", "1", "daris_admin", "157.175.154.107", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736328319", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4129", "1", "1", "daris_admin", "157.175.154.107", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736337273", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4130", "1", "1", "daris_admin", "178.131.27.77", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736341225", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4131", "1", "1", "", "::1", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.6.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:855;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:293;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline\\wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736400057", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4132", "1", "1", "daris_admin", "93.117.182.248", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736524980", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4133", "1", "1", "daris_admin", "93.117.182.248", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736527022", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4134", "1", "1", "daris_admin", "93.117.182.248", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736528407", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4135", "1", "1", "daris_admin", "93.117.182.248", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736539897", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4136", "1", "1", "daris_admin", "93.117.183.115", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736580275", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4137", "1", "1", "daris_admin", "93.117.183.115", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:797;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736626459", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4138", "1", "1", "daris_admin", "178.131.130.112", "info", "successful_login", "{\"successful_login\":{\"username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1315;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736686160", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4139", "1", "1", "daris_admin", "178.131.130.112", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0627\\u0644\\u0645\\u0646\\u062a\\u0648\\u0631\",\"version\":\"3.26.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736690545", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4140", "1", "1", "daris_admin", "178.131.130.112", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.6.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736690545", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4141", "1", "1", "daris_admin", "178.131.130.112", "info", "plugin_updated", "{\"plugin\":{\"name\":\"MetForm\",\"version\":\"3.9.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736690545", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4142", "1", "1", "daris_admin", "178.131.130.112", "info", "plugin_updated", "{\"plugin\":{\"name\":\"\\u0648\\u0648\\u06a9\\u0627\\u0645\\u0631\\u0633\",\"version\":\"9.5.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:51;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736690545", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4143", "1", "1", "daris_admin", "178.131.130.112", "info", "theme_updated", "{\"theme\":{\"name\":\"Twenty Twenty-Four\",\"version\":\"1.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:326;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:69:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-theme-upgrader.php\";s:4:\"line\";i:520;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:256;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736691355", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4144", "1", "1", "daris_admin", "178.131.130.112", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"theme\",\"slug\":\"twentytwentyfour\",\"version\":\"1.3\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:69:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-theme-upgrader.php\";s:4:\"line\";i:520;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:46:\"C:/laragon/www/darisonline\\wp-admin\\update.php\";s:4:\"line\";i:256;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736691358", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4145", "1", "1", "daris_admin", "178.131.130.112", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.6.2\",\"new_version\":\"6.7.1\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:145;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:60:\"C:/laragon/www/darisonline\\wp-admin\\includes\\update-core.php\";s:4:\"line\";i:1570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:68:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-core-upgrader.php\";s:4:\"line\";i:174;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:51:\"C:/laragon/www/darisonline\\wp-admin\\update-core.php\";s:4:\"line\";i:906;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:51:\"C:/laragon/www/darisonline\\wp-admin\\update-core.php\";s:4:\"line\";i:1175;s:8:\"function\";s:15:\"do_core_upgrade\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736703902", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4146", "1", "1", "daris_admin", "178.131.130.112", "info", "plugin_installed", "{\"plugin\":{\"name\":\"reSmush.it Image Optimizer\",\"version\":\"1.0.4\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-upgrader.php\";s:4:\"line\";i:984;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:70:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline\\wp-admin\\includes\\ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline\\wp-admin\\admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736704038", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4147", "1", "1", "daris_admin", "178.131.130.112", "info", "plugin_activated", "{\"plugin\":{\"name\":\"reSmush.it Image Optimizer\",\"version\":\"1.0.4\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736704057", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4148", "1", "1", "daris_admin", "178.131.130.112", "info", "user_registration", "{\"user_registration\":{\"registered_username\":\"D@ariis\",\"type\":\"admin\",\"admin_username\":\"daris_admin\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:599;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:123:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-registration.php\";s:4:\"line\";i:49;s:8:\"function\";s:23:\"event_user_registration\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:39:\"aiowps_user_registration_action_handler\";s:5:\"class\";s:31:\"AIOWPSecurity_User_Registration\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:2554;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:53:\"C:/laragon/www/darisonline\\wp-admin\\includes\\user.php\";s:4:\"line\";i:235;s:8:\"function\";s:14:\"wp_insert_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:48:\"C:/laragon/www/darisonline\\wp-admin\\user-new.php\";s:4:\"line\";i:198;s:8:\"function\";s:9:\"edit_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736706507", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4149", "1", "1", "daris_admin", "178.131.130.112", "warning", "user_deleted", "{\"user_deleted\":{\"user_id\":3,\"reassign\":5,\"user_login\":\"admin_arina\"}}", "a:9:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:524;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"user_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:53:\"C:/laragon/www/darisonline\\wp-admin\\includes\\user.php\";s:4:\"line\";i:463;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:45:\"C:/laragon/www/darisonline\\wp-admin\\users.php\";s:4:\"line\";i:214;s:8:\"function\";s:14:\"wp_delete_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736706878", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4150", "1", "1", "daris_admin", "178.131.130.112", "warning", "user_deleted", "{\"user_deleted\":{\"user_id\":2,\"reassign\":5,\"user_login\":\"ViiiH@a@nn\"}}", "a:9:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:524;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"user_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:53:\"C:/laragon/www/darisonline\\wp-admin\\includes\\user.php\";s:4:\"line\";i:463;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:45:\"C:/laragon/www/darisonline\\wp-admin\\users.php\";s:4:\"line\";i:214;s:8:\"function\";s:14:\"wp_delete_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736706881", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4151", "1", "1", "daris_admin", "178.131.130.112", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"daris_admin\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:804;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736706913", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4152", "1", "1", "D@ariis", "178.131.130.112", "info", "successful_login", "{\"successful_login\":{\"username\":\"D@ariis\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1322;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736706927", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4153", "1", "1", "D@ariis", "178.131.130.112", "warning", "user_deleted", "{\"user_deleted\":{\"user_id\":4,\"reassign\":5,\"user_login\":\"daris_admin\"}}", "a:9:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:524;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"user_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:53:\"C:/laragon/www/darisonline\\wp-admin\\includes\\user.php\";s:4:\"line\";i:463;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:45:\"C:/laragon/www/darisonline\\wp-admin\\users.php\";s:4:\"line\";i:214;s:8:\"function\";s:14:\"wp_delete_user\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736706962", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4154", "1", "1", "D@ariis", "178.131.130.112", "warning", "theme_deleted", "{\"theme\":{\"name\":\"Twenty Twenty-Four\",\"version\":\"1.3\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:356;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:54:\"C:/laragon/www/darisonline\\wp-admin\\includes\\theme.php\";s:4:\"line\";i:98;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline\\wp-admin\\includes\\ajax-actions.php\";s:4:\"line\";i:4427;s:8:\"function\";s:12:\"delete_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_ajax_delete_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline\\wp-admin\\admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736710587", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4155", "1", "1", "D@ariis", "2a03:ef43:2:cd16:8d7b:1a3f:3c33:5031", "info", "successful_login", "{\"successful_login\":{\"username\":\"D@ariis\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1322;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736713725", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4156", "1", "1", "D@ariis", "178.131.130.112", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"reSmush.it Image Optimizer\",\"version\":\"1.0.4\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736715432", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4157", "1", "1", "D@ariis", "178.131.130.112", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"reSmush.it Image Optimizer\",\"version\":\"1.0.4\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline\\wp-admin\\includes\\ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline\\wp-admin\\admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736715449", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4158", "1", "1", "D@ariis", "178.131.130.112", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"\\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632 \\u067e\\u0627\\u06cc\\u06af\\u0627\\u0647 \\u062f\\u0627\\u062f\\u0647 - \\u067e\\u0627\\u06a9\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u0641\\u0634\\u0631\\u062f\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u06a9\\u0634\",\"version\":\"3.8.0\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736716041", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4159", "1", "1", "D@ariis", "178.131.130.112", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"\\u0628\\u0647\\u06cc\\u0646\\u0647\\u200c\\u0633\\u0627\\u0632 \\u067e\\u0627\\u06cc\\u06af\\u0627\\u0647 \\u062f\\u0627\\u062f\\u0647 - \\u067e\\u0627\\u06a9\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u0641\\u0634\\u0631\\u062f\\u0647\\u200c\\u0633\\u0627\\u0632\\u06cc\\u060c \\u06a9\\u0634\",\"version\":\"3.8.0\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:61:\"C:/laragon/www/darisonline\\wp-admin\\includes\\ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:50:\"C:/laragon/www/darisonline\\wp-admin\\admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736716067", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4160", "1", "1", "D@ariis", "178.131.130.112", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"D@ariis\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:804;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736716270", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4161", "1", "1", "D@ariis", "178.131.130.112", "info", "successful_login", "{\"successful_login\":{\"username\":\"D@ariis\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1322;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736716298", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4162", "1", "1", "D@ariis", "::1", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"D@ariis\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:804;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736716396", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4163", "1", "1", "D@ariis", "178.131.128.250", "info", "successful_login", "{\"successful_login\":{\"username\":\"D@ariis\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1322;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736737510", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4164", "1", "1", "D@ariis", "178.131.128.250", "info", "plugin_activated", "{\"plugin\":{\"name\":\"MailPoet\",\"version\":\"5.6.0\",\"action\":\"activated\",\"network\":\"\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:879;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:126;s:8:\"function\";s:16:\"activate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736737880", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4165", "1", "1", "D@ariis", "178.131.128.250", "info", "plugin_activated", "{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645 \\u062a\\u0645\\u0627\\u0633 \\u06f7\",\"version\":\"6.0.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:879;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:126;s:8:\"function\";s:16:\"activate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736737894", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4166", "1", "1", "", "::1", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fa_IR\",\"type\":\"plugin\",\"slug\":\"elementor\",\"version\":\"3.26.4\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:287;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:77:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:487;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:75:\"C:/laragon/www/darisonline\\wp-admin\\includes\\class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:851;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\update.php\";s:4:\"line\";i:295;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:38:\"C:/laragon/www/darisonline\\wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736740709", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4167", "1", "1", "D@ariis", "178.131.128.250", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"D@ariis\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:638;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:688;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:52:\"C:/laragon/www/darisonline\\wp-includes\\pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:804;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736741277", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4168", "1", "1", "D@ariis", "178.131.96.96", "info", "successful_login", "{\"successful_login\":{\"username\":\"D@ariis\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:596;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:116:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-user-login.php\";s:4:\"line\";i:641;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-includes\\user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:39:\"C:/laragon/www/darisonline\\wp-login.php\";s:4:\"line\";i:1322;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736751483", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4169", "1", "1", "D@ariis", "178.131.96.96", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"\\u0641\\u0631\\u0645 \\u062a\\u0645\\u0627\\u0633 \\u06f7\",\"version\":\"6.0.2\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736751574", "");
INSERT INTO `wp_aiowps_audit_log` VALUES("4170", "1", "1", "D@ariis", "178.131.96.96", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"\\u0627\\u0641\\u0632\\u0648\\u0646\\u0647 All In One WP Security\",\"version\":\"5.3.8\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:118:\"C:/laragon/www/darisonline\\wp-content\\plugins\\all-in-one-wp-security-and-firewall\\classes\\wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:56:\"C:/laragon/www/darisonline\\wp-includes\\class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"C:/laragon/www/darisonline\\wp-includes\\plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:55:\"C:/laragon/www/darisonline\\wp-admin\\includes\\plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:47:\"C:/laragon/www/darisonline\\wp-admin\\plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1736751714", "");

/* INSERT TABLE DATA: wp_aiowps_logged_in_users */
INSERT INTO `wp_aiowps_logged_in_users` VALUES("88", "5", "D@ariis", "178.131.96.96", "1", "1736751482", "1736924282");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "3509", "ووکامرس", "", "", "", "2020-12-26 20:52:37", "2020-12-26 17:22:37", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "3509", "ووکامرس", "", "", "", "2020-12-26 20:52:45", "2020-12-26 17:22:45", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "3509", "ووکامرس", "", "", "", "2020-12-26 22:10:06", "2020-12-26 18:40:06", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "3533", "ووکامرس", "", "", "", "2021-01-30 11:32:35", "2021-01-30 08:02:35", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "3533", "ووکامرس", "", "", "", "2021-01-30 11:32:48", "2021-01-30 08:02:48", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "3533", "ووکامرس", "", "", "", "2021-01-30 11:33:06", "2021-01-30 08:03:06", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "3533", "ووکامرس", "", "", "", "2021-01-30 11:33:12", "2021-01-30 08:03:12", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "3533", "ووکامرس", "", "", "", "2021-01-30 12:52:33", "2021-01-30 09:22:33", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "4842", "امین", "amin.dev1989@gmail.sdf", "", "5.134.178.253", "2024-11-13 15:44:12", "2024-11-13 12:14:12", "سلام عجب وب سایت باحالی دارید", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:132.0) Gecko/20100101 Firefox/132.0", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "4842", "daris_admin", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 22:35:58", "2024-11-15 19:05:58", "بله همینطوره", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "11", "4");
INSERT INTO `wp_comments` VALUES("13", "8866", "amin", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 23:02:05", "2024-11-15 19:32:05", "what a beautiful website you have", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "8866", "daris_admin", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 23:03:37", "2024-11-15 19:33:37", "Yeah that\'s it", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "13", "4");
INSERT INTO `wp_comments` VALUES("17", "5202", "امین", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 23:11:54", "2024-11-15 19:41:54", "من عاشق کویرم", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "5202", "daris_admin", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 23:12:52", "2024-11-15 19:42:52", "منم همینطور", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "17", "4");
INSERT INTO `wp_comments` VALUES("19", "8898", "amin", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 23:14:07", "2024-11-15 19:44:07", "I love desert", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "8898", "daris_admin", "amin.dev1989@gmail.com", "", "37.98.74.35", "2024-11-15 23:14:47", "2024-11-15 19:44:47", "me too", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "comment", "19", "4");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("67", "daris", "51f56acfd9a392566535_20250917080217", "21", "2025-09-17 08:03:00", "D@ariis", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-17 08:02:17\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:67;s:4:\"Name\";s:5:\"daris\";s:4:\"Hash\";s:35:\"51f56acfd9a392566535_20250917080217\";s:8:\"NameHash\";s:41:\"daris_51f56acfd9a392566535_20250917080217\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:51:\"daris_51f56acfd9a392566535_20250917080217_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:7:\"D@ariis\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:53:\"daris_51f56acfd9a392566535_20250917080217_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"C:/laragon/www/darisonline\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3177;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:19571;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-17 08:02:17\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"8.1.10\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:5:\"daris\";s:4:\"Hash\";s:35:\"51f56acfd9a392566535_20250917080217\";s:8:\"NameHash\";s:41:\"daris_51f56acfd9a392566535_20250917080217\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:59:\"daris_51f56acfd9a392566535_20250917080217_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"C:/laragon/www/darisonline/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:54:\"daris_51f56acfd9a392566535_20250917080217_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:113:\"C:/laragon/www/darisonline/wp-content/backups-dup-lite/tmp/daris_51f56acfd9a392566535_20250917080217_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"C:/laragon/www/darisonline/wp-admin\";i:1;s:38:\"C:/laragon/www/darisonline/wp-includes\";i:2;s:47:\"C:/laragon/www/darisonline/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"C:/laragon/www/darisonline\";i:1;s:26:\"C:/laragon/www/darisonline\";i:2;s:37:\"C:/laragon/www/darisonline/wp-content\";i:3;s:45:\"C:/laragon/www/darisonline/wp-content/uploads\";i:4;s:45:\"C:/laragon/www/darisonline/wp-content/plugins\";i:5;s:48:\"C:/laragon/www/darisonline/wp-content/mu-plugins\";i:6;s:44:\"C:/laragon/www/darisonline/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"C:/laragon/www/darisonline/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_mailpoet_custom_fields */
INSERT INTO `wp_mailpoet_custom_fields` VALUES("1", "fewfwefwef", "textarea", "a:2:{s:8:\"validate\";s:0:\"\";s:5:\"lines\";s:1:\"1\";}", "2020-11-01 14:26:32", "2020-11-01 14:26:32");
INSERT INTO `wp_mailpoet_custom_fields` VALUES("2", "برای دریافت آخرین اخبار و پیشنهادات در خبرنامه ما مشترک شوید", "textarea", "a:2:{s:8:\"validate\";s:0:\"\";s:5:\"lines\";s:1:\"1\";}", "2020-11-01 14:28:23", "2020-11-01 14:28:23");

/* INSERT TABLE DATA: wp_mailpoet_forms */
INSERT INTO `wp_mailpoet_forms` VALUES("9", "خبرنامه", "enabled", "a:3:{i:0;a:3:{s:4:\"type\";s:9:\"paragraph\";s:2:\"id\";s:9:\"paragraph\";s:6:\"params\";a:8:{s:7:\"content\";s:110:\"برای دریافت آخرین اخبار و پیشنهادات در خبرنامه ما مشترک شوید\";s:8:\"drop_cap\";s:1:\"0\";s:5:\"align\";s:5:\"right\";s:9:\"font_size\";s:2:\"14\";s:11:\"line_height\";s:3:\"1.5\";s:10:\"text_color\";s:7:\"#ffffff\";s:16:\"background_color\";s:0:\"\";s:10:\"class_name\";s:0:\"\";}}i:1;a:5:{s:4:\"type\";s:4:\"text\";s:6:\"params\";a:4:{s:5:\"label\";s:40:\"ایمیل خود را وارد کنید\";s:10:\"class_name\";s:0:\"\";s:8:\"required\";s:1:\"1\";s:12:\"label_within\";s:1:\"1\";}s:2:\"id\";s:5:\"email\";s:4:\"name\";s:5:\"Email\";s:6:\"styles\";a:1:{s:10:\"full_width\";s:1:\"1\";}}i:2;a:5:{s:4:\"type\";s:6:\"submit\";s:6:\"params\";a:2:{s:5:\"label\";s:10:\"مشترک\";s:10:\"class_name\";s:0:\"\";}s:2:\"id\";s:6:\"submit\";s:4:\"name\";s:6:\"Submit\";s:6:\"styles\";a:1:{s:10:\"full_width\";s:1:\"1\";}}}", "a:15:{s:10:\"on_success\";s:7:\"message\";s:15:\"success_message\";s:108:\"صندوق ایمیل یا پوشه اسپم خود را جهت تائید اشتراک خود چک کنید\";s:8:\"segments\";a:1:{i:0;s:1:\"3\";}s:20:\"segments_selected_by\";s:5:\"admin\";s:9:\"alignment\";s:6:\"center\";s:8:\"fontSize\";s:2:\"15\";s:14:\"form_placement\";a:5:{s:5:\"popup\";a:7:{s:7:\"enabled\";s:0:\"\";s:19:\"exit_intent_enabled\";s:0:\"\";s:5:\"delay\";s:2:\"15\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:5:\"pixel\";s:5:\"value\";s:3:\"560\";}}s:9:\"animation\";s:7:\"slideup\";s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:9:\"fixed_bar\";a:7:{s:7:\"enabled\";s:0:\"\";s:5:\"delay\";s:2:\"15\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:7:\"percent\";s:5:\"value\";s:3:\"100\";}}s:8:\"position\";s:3:\"top\";s:9:\"animation\";s:7:\"slideup\";s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:11:\"below_posts\";a:4:{s:7:\"enabled\";s:0:\"\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:7:\"percent\";s:5:\"value\";s:3:\"100\";}}s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:8:\"slide_in\";a:7:{s:7:\"enabled\";s:0:\"\";s:5:\"delay\";s:2:\"15\";s:8:\"position\";s:5:\"right\";s:9:\"animation\";s:5:\"right\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:5:\"pixel\";s:5:\"value\";s:3:\"560\";}}s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:6:\"others\";a:1:{s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:5:\"value\";s:3:\"100\";s:4:\"unit\";s:7:\"percent\";}}}}s:24:\"success_validation_color\";s:7:\"#00d084\";s:22:\"error_validation_color\";s:7:\"#cf2e2e\";s:13:\"border_radius\";s:1:\"0\";s:11:\"border_size\";s:1:\"0\";s:12:\"form_padding\";s:2:\"10\";s:13:\"input_padding\";s:2:\"15\";s:11:\"font_family\";s:10:\"Montserrat\";s:12:\"close_button\";s:11:\"round_white\";}", "/* form */\n.mailpoet_form {\n}\n\nform {\n  margin-bottom: 0;\n}\n\np.mailpoet_form_paragraph {\n    margin-bottom: 10px;\n}\n\n/* columns */\n.mailpoet_column_with_background {\n  padding: 10px;\n}\n/* space between columns */\n.mailpoet_form_column:not(:first-child) {\n  margin-left: 20px;\n}\n\n/* input wrapper (label + input) */\n.mailpoet_paragraph {\n  line-height:20px;\n  margin-bottom: 20px;\n}\n\n/* labels */\n.mailpoet_segment_label,\n.mailpoet_text_label,\n.mailpoet_textarea_label,\n.mailpoet_select_label,\n.mailpoet_radio_label,\n.mailpoet_checkbox_label,\n.mailpoet_list_label,\n.mailpoet_date_label {\n  display:block;\n  font-weight: normal;\n}\n\n/* inputs */\n.mailpoet_text,\n.mailpoet_textarea,\n.mailpoet_select,\n.mailpoet_date_month,\n.mailpoet_date_day,\n.mailpoet_date_year,\n.mailpoet_date {\n  display:block;\n}\n\n.mailpoet_text,\n.mailpoet_textarea {\n  width: 200px;\n}\n\n.mailpoet_checkbox {\n}\n\n.mailpoet_submit {\n}\n\n.mailpoet_divider {\n}\n\n.mailpoet_message {\n}\n\n.mailpoet_form_loading {\n  width: 30px;\n  text-align: center;\n  line-height: normal;\n}\n\n.mailpoet_form_loading > span {\n  width: 5px;\n  height: 5px;\n  background-color: #5b5b5b;\n}", "2020-11-01 14:30:18", "2021-01-26 21:43:00", NULL);
INSERT INTO `wp_mailpoet_forms` VALUES("10", " Newsletters", "enabled", "a:3:{i:0;a:3:{s:4:\"type\";s:9:\"paragraph\";s:2:\"id\";s:9:\"paragraph\";s:6:\"params\";a:8:{s:7:\"content\";s:63:\"Subscribe to our newsletter to receive the latest news and offe\";s:8:\"drop_cap\";s:1:\"0\";s:5:\"align\";s:4:\"left\";s:9:\"font_size\";s:2:\"14\";s:11:\"line_height\";s:3:\"1.5\";s:10:\"text_color\";s:7:\"#ffffff\";s:16:\"background_color\";s:0:\"\";s:10:\"class_name\";s:0:\"\";}}i:1;a:5:{s:4:\"type\";s:4:\"text\";s:6:\"params\";a:4:{s:5:\"label\";s:17:\" Enter your email\";s:10:\"class_name\";s:0:\"\";s:8:\"required\";s:1:\"1\";s:12:\"label_within\";s:1:\"1\";}s:2:\"id\";s:5:\"email\";s:4:\"name\";s:5:\"Email\";s:6:\"styles\";a:1:{s:10:\"full_width\";s:1:\"1\";}}i:2;a:5:{s:4:\"type\";s:6:\"submit\";s:6:\"params\";a:2:{s:5:\"label\";s:7:\" Common\";s:10:\"class_name\";s:0:\"\";}s:2:\"id\";s:6:\"submit\";s:4:\"name\";s:6:\"Submit\";s:6:\"styles\";a:1:{s:10:\"full_width\";s:1:\"1\";}}}", "a:15:{s:10:\"on_success\";s:7:\"message\";s:15:\"success_message\";s:108:\"صندوق ایمیل یا پوشه اسپم خود را جهت تائید اشتراک خود چک کنید\";s:8:\"segments\";a:1:{i:0;s:1:\"3\";}s:20:\"segments_selected_by\";s:5:\"admin\";s:9:\"alignment\";s:4:\"left\";s:8:\"fontSize\";s:2:\"15\";s:14:\"form_placement\";a:5:{s:5:\"popup\";a:7:{s:7:\"enabled\";s:0:\"\";s:19:\"exit_intent_enabled\";s:0:\"\";s:5:\"delay\";s:2:\"15\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:5:\"pixel\";s:5:\"value\";s:3:\"560\";}}s:9:\"animation\";s:7:\"slideup\";s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:9:\"fixed_bar\";a:7:{s:7:\"enabled\";s:0:\"\";s:5:\"delay\";s:2:\"15\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:7:\"percent\";s:5:\"value\";s:3:\"100\";}}s:8:\"position\";s:3:\"top\";s:9:\"animation\";s:7:\"slideup\";s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:11:\"below_posts\";a:4:{s:7:\"enabled\";s:0:\"\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:7:\"percent\";s:5:\"value\";s:3:\"100\";}}s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:8:\"slide_in\";a:7:{s:7:\"enabled\";s:0:\"\";s:5:\"delay\";s:2:\"15\";s:8:\"position\";s:5:\"right\";s:9:\"animation\";s:5:\"right\";s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:4:\"unit\";s:5:\"pixel\";s:5:\"value\";s:3:\"560\";}}s:5:\"posts\";a:1:{s:3:\"all\";s:0:\"\";}s:5:\"pages\";a:1:{s:3:\"all\";s:0:\"\";}}s:6:\"others\";a:1:{s:6:\"styles\";a:1:{s:5:\"width\";a:2:{s:5:\"value\";s:3:\"100\";s:4:\"unit\";s:7:\"percent\";}}}}s:13:\"border_radius\";s:1:\"0\";s:11:\"border_size\";s:1:\"0\";s:12:\"form_padding\";s:2:\"10\";s:13:\"input_padding\";s:2:\"15\";s:11:\"font_family\";s:10:\"Montserrat\";s:12:\"close_button\";s:11:\"round_white\";s:24:\"success_validation_color\";s:7:\"#00d084\";s:22:\"error_validation_color\";s:7:\"#cf2e2e\";}", "/* form */\n.mailpoet_form {\n}\n\nform {\n  margin-bottom: 0;\n}\n\np.mailpoet_form_paragraph {\n    margin-bottom: 10px;\n}\n\n/* columns */\n.mailpoet_column_with_background {\n  padding: 10px;\n}\n/* space between columns */\n.mailpoet_form_column:not(:first-child) {\n  margin-left: 20px;\n}\n\n/* input wrapper (label + input) */\n.mailpoet_paragraph {\n  line-height:20px;\n  margin-bottom: 20px;\n}\n\n/* labels */\n.mailpoet_segment_label,\n.mailpoet_text_label,\n.mailpoet_textarea_label,\n.mailpoet_select_label,\n.mailpoet_radio_label,\n.mailpoet_checkbox_label,\n.mailpoet_list_label,\n.mailpoet_date_label {\n  display:block;\n  font-weight: normal;\n}\n\n/* inputs */\n.mailpoet_text,\n.mailpoet_textarea,\n.mailpoet_select,\n.mailpoet_date_month,\n.mailpoet_date_day,\n.mailpoet_date_year,\n.mailpoet_date {\n  display:block;\n}\n\n.mailpoet_text,\n.mailpoet_textarea {\n  width: 200px;\n}\n\n.mailpoet_checkbox {\n}\n\n.mailpoet_submit {\n}\n\n.mailpoet_divider {\n}\n\n.mailpoet_message {\n}\n\n.mailpoet_form_loading {\n  width: 30px;\n  text-align: center;\n  line-height: normal;\n}\n\n.mailpoet_form_loading > span {\n  width: 5px;\n  height: 5px;\n  background-color: #5b5b5b;\n}", "2020-11-05 09:51:12", "2020-11-05 10:06:33", NULL);

/* INSERT TABLE DATA: wp_mailpoet_migrations */
INSERT INTO `wp_mailpoet_migrations` VALUES("1", "Migration_20221028_105818", "2022-11-17 16:05:18", "2022-11-17 16:05:18", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("2", "Migration_20221110_151621", "2022-11-17 16:05:18", "2022-11-17 16:05:18", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("3", "Migration_20221124_131445", "2024-08-27 12:34:57", "2022-12-13 07:36:14", "1", "PDOException: SQLSTATE[42S21]: Column already exists: 1060 Duplicate column name \'display_in_manage_subscription_page\' in C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Driver/PDOConnection.php:31\nStack trace:\n#0 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Driver/PDOConnection.php(31): PDO->exec(\'\\n      ALTER TA...\')\n#1 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Connection.php(595): MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOConnection->exec(\'\\n      ALTER TA...\')\n#2 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrations/Migration_20221124_131445.php(24): MailPoetVendor\\Doctrine\\DBAL\\Connection->executeStatement(\'\\n      ALTER TA...\')\n#3 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrator/Runner.php(44): MailPoet\\Migrations\\Migration_20221124_131445->run()\n#4 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrator/Migrator.php(50): MailPoet\\Migrator\\Runner->runMigration(\'Migration_20221...\')\n#5 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Activator.php(78): MailPoet\\Migrator\\Migrator->run()\n#6 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Activator.php(60): MailPoet\\Config\\Activator->processActivate()\n#7 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Initializer.php(334): MailPoet\\Config\\Activator->activate()\n#8 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Initializer.php(291): MailPoet\\Config\\Initializer->maybeDbUpdate()\n#9 C:/laragon/www/darisonline/wp-includes/class-wp-hook.php(308): MailPoet\\Config\\Initializer->initialize(\'\')\n#10 C:/laragon/www/darisonline/wp-includes/class-wp-hook.php(332): WP_Hook->apply_filters(NULL, Array)\n#11 C:/laragon/www/darisonline/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#12 C:/laragon/www/darisonline/wp-settings.php(617): do_action(\'init\')\n#13 C:/laragon/www/darisonline/wp-config.php(98): require_once(\'/home/viihaan/d...\')\n#14 C:/laragon/www/darisonline/wp-load.php(50): require_once(\'/home/viihaan/d...\')\n#15 C:/laragon/www/darisonline/wp-admin/admin-ajax.php(22): require_once(\'/home/viihaan/d...\')\n#16 {main}\n\nNext MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\Exception: SQLSTATE[42S21]: Column already exists: 1060 Duplicate column name \'display_in_manage_subscription_page\' in C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Driver/PDO/Exception.php:10\nStack trace:\n#0 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Driver/PDOConnection.php(35): MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\Exception::new(Object(PDOException))\n#1 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Connection.php(595): MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDOConnection->exec(\'\\n      ALTER TA...\')\n#2 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrations/Migration_20221124_131445.php(24): MailPoetVendor\\Doctrine\\DBAL\\Connection->executeStatement(\'\\n      ALTER TA...\')\n#3 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrator/Runner.php(44): MailPoet\\Migrations\\Migration_20221124_131445->run()\n#4 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrator/Migrator.php(50): MailPoet\\Migrator\\Runner->runMigration(\'Migration_20221...\')\n#5 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Activator.php(78): MailPoet\\Migrator\\Migrator->run()\n#6 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Activator.php(60): MailPoet\\Config\\Activator->processActivate()\n#7 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Initializer.php(334): MailPoet\\Config\\Activator->activate()\n#8 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Initializer.php(291): MailPoet\\Config\\Initializer->maybeDbUpdate()\n#9 C:/laragon/www/darisonline/wp-includes/class-wp-hook.php(308): MailPoet\\Config\\Initializer->initialize(\'\')\n#10 C:/laragon/www/darisonline/wp-includes/class-wp-hook.php(332): WP_Hook->apply_filters(NULL, Array)\n#11 C:/laragon/www/darisonline/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#12 C:/laragon/www/darisonline/wp-settings.php(617): do_action(\'init\')\n#13 C:/laragon/www/darisonline/wp-config.php(98): require_once(\'/home/viihaan/d...\')\n#14 C:/laragon/www/darisonline/wp-load.php(50): require_once(\'/home/viihaan/d...\')\n#15 C:/laragon/www/darisonline/wp-admin/admin-ajax.php(22): require_once(\'/home/viihaan/d...\')\n#16 {main}\n\nNext MailPoetVendor\\Doctrine\\DBAL\\Exception\\NonUniqueFieldNameException: An exception occurred while executing \'\n      ALTER TABLE wp_mailpoet_segments\n      ADD display_in_manage_subscription_page tinyint(1) NOT NULL DEFAULT 0\n    \':\n\nSQLSTATE[42S21]: Column already exists: 1060 Duplicate column name \'display_in_manage_subscription_page\' in C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Driver/AbstractMySQLDriver.php:63\nStack trace:\n#0 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/DBALException.php(77): MailPoetVendor\\Doctrine\\DBAL\\Driver\\AbstractMySQLDriver->convertException(\'An exception oc...\', Object(MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\Exception))\n#1 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/DBALException.php(65): MailPoetVendor\\Doctrine\\DBAL\\DBALException::wrapException(Object(MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\MySQL\\Driver), Object(MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\Exception), \'An exception oc...\')\n#2 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Connection.php(936): MailPoetVendor\\Doctrine\\DBAL\\DBALException::driverExceptionDuringQuery(Object(MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\MySQL\\Driver), Object(MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\Exception), \'\\n      ALTER TA...\', Array)\n#3 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/vendor-prefixed/doctrine/dbal/lib/Doctrine/DBAL/Connection.php(598): MailPoetVendor\\Doctrine\\DBAL\\Connection->handleExceptionDuringQuery(Object(MailPoetVendor\\Doctrine\\DBAL\\Driver\\PDO\\Exception), \'\\n      ALTER TA...\', Array, Array)\n#4 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrations/Migration_20221124_131445.php(24): MailPoetVendor\\Doctrine\\DBAL\\Connection->executeStatement(\'\\n      ALTER TA...\')\n#5 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrator/Runner.php(44): MailPoet\\Migrations\\Migration_20221124_131445->run()\n#6 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Migrator/Migrator.php(50): MailPoet\\Migrator\\Runner->runMigration(\'Migration_20221...\')\n#7 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Activator.php(78): MailPoet\\Migrator\\Migrator->run()\n#8 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Activator.php(60): MailPoet\\Config\\Activator->processActivate()\n#9 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Initializer.php(334): MailPoet\\Config\\Activator->activate()\n#10 C:/laragon/www/darisonline/wp-content/plugins/mailpoet/lib/Config/Initializer.php(291): MailPoet\\Config\\Initializer->maybeDbUpdate()\n#11 C:/laragon/www/darisonline/wp-includes/class-wp-hook.php(308): MailPoet\\Config\\Initializer->initialize(\'\')\n#12 C:/laragon/www/darisonline/wp-includes/class-wp-hook.php(332): WP_Hook->apply_filters(NULL, Array)\n#13 C:/laragon/www/darisonline/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#14 C:/laragon/www/darisonline/wp-settings.php(617): do_action(\'init\')\n#15 C:/laragon/www/darisonline/wp-config.php(98): require_once(\'/home/viihaan/d...\')\n#16 C:/laragon/www/darisonline/wp-load.php(50): require_once(\'/home/viihaan/d...\')\n#17 C:/laragon/www/darisonline/wp-admin/admin-ajax.php(22): require_once(\'/home/viihaan/d...\')\n#18 {main}");
INSERT INTO `wp_mailpoet_migrations` VALUES("5", "Migration_20221124_160356", "2022-12-13 07:36:14", "2022-12-13 07:36:14", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("6", "Migration_20230111_120000", "2024-09-06 14:15:18", "2024-09-06 14:15:18", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("7", "Migration_20230111_130000", "2024-09-06 14:15:18", "2024-09-06 14:15:18", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("8", "Migration_20230215_050813", "2024-09-06 14:15:19", "2024-09-06 14:15:19", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("9", "Migration_20230221_200520", "2024-09-06 14:15:19", "2024-09-06 14:15:19", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("10", "Migration_20230421_135915", "2024-09-06 14:15:19", "2024-09-06 14:15:19", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("11", "Migration_20230503_210945", "2024-09-06 14:15:20", "2024-09-06 14:15:20", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("12", "Migration_20230605_174836", "2024-09-06 14:15:26", "2024-09-06 14:15:26", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("13", "Migration_20230703_105957", "2024-09-06 14:15:27", "2024-09-06 14:15:27", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("14", "Migration_20230716_130221_Db", "2024-09-06 14:15:27", "2024-09-06 14:15:27", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("15", "Migration_20230824_054259_Db", "2024-09-06 14:15:27", "2024-09-06 14:15:27", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("16", "Migration_20230831_124214_Db", "2024-09-06 14:15:27", "2024-09-06 14:15:27", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("17", "Migration_20230831_143755_Db", "2024-09-06 14:15:27", "2024-09-06 14:15:28", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("18", "Migration_20240119_113943_Db", "2024-09-06 14:15:28", "2024-09-06 14:15:29", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("19", "Migration_20240617_122847_Db", "2024-09-06 14:15:29", "2024-09-06 14:15:29", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("20", "Migration_20240725_182318_Db", "2024-09-06 14:15:29", "2024-09-06 14:15:29", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("21", "Migration_20221028_105818_App", "2024-09-06 14:15:29", "2024-09-06 14:15:29", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("22", "Migration_20230109_144830", "2024-09-06 14:15:29", "2024-09-06 14:15:29", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("23", "Migration_20230131_121621", "2024-09-06 14:15:29", "2024-09-06 14:15:40", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("24", "Migration_20230419_080000", "2024-09-06 14:15:40", "2024-09-06 14:15:40", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("25", "Migration_20230425_211517", "2024-09-06 14:15:40", "2024-09-06 14:15:40", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("26", "Migration_20230712_180341", "2024-09-06 14:15:41", "2024-09-06 14:15:41", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("27", "Migration_20230803_200413_App", "2024-09-06 14:15:41", "2024-09-06 14:15:41", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("28", "Migration_20230825_093531_App", "2024-09-06 14:15:41", "2024-09-06 14:15:41", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("29", "Migration_20231128_120355_App", "2024-09-06 14:15:41", "2024-09-06 14:15:42", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("30", "Migration_20240202_130053_App", "2024-09-06 14:15:42", "2024-09-06 14:15:42", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("31", "Migration_20240207_105912_App", "2024-09-06 14:15:42", "2024-09-06 14:15:42", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("32", "Migration_20240322_110443_App", "2024-09-06 14:15:42", "2024-09-06 14:15:42", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("33", "Migration_20240730_212419_App", "2024-09-06 14:15:42", "2024-09-06 14:15:42", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("34", "Migration_20241007_170437_Db", "2024-10-16 08:30:13", "2024-10-16 08:30:13", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("35", "Migration_20241015_105511_App", "2024-10-27 16:46:59", "2024-10-27 16:46:59", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("36", "Migration_20241108_103249_Db", "2025-01-13 06:41:04", "2025-01-13 06:41:04", "0", NULL);
INSERT INTO `wp_mailpoet_migrations` VALUES("37", "Migration_20241128_114257_App", "2025-01-13 06:41:04", "2025-01-13 06:41:04", "0", NULL);

/* INSERT TABLE DATA: wp_mailpoet_newsletter_option_fields */
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("1", "isScheduled", "standard", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("2", "scheduledAt", "standard", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("3", "event", "welcome", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("4", "segment", "welcome", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("5", "role", "welcome", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("6", "afterTimeNumber", "welcome", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("7", "afterTimeType", "welcome", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("8", "intervalType", "notification", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("9", "timeOfDay", "notification", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("10", "weekDay", "notification", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("11", "monthDay", "notification", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("12", "nthWeekDay", "notification", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("13", "schedule", "notification", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("14", "group", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("15", "event", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("16", "sendTo", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("17", "segment", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("18", "afterTimeNumber", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("19", "afterTimeType", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("20", "meta", "automatic", NULL, "2020-11-01 11:17:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("21", "afterTimeNumber", "re_engagement", NULL, "2021-11-09 08:37:41");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("22", "afterTimeType", "re_engagement", NULL, "2021-11-09 08:37:41");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("23", "workflowId", "automation", NULL, "2022-11-08 05:58:24");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("24", "workflowStepId", "automation", NULL, "2022-11-08 05:58:24");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("25", "automationId", "automation", NULL, "2022-11-17 16:05:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("26", "automationStepId", "automation", NULL, "2022-11-17 16:05:18");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("27", "group", "automation", NULL, "2024-09-06 14:15:43");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("28", "group", "automation_transactional", NULL, "2024-09-06 14:15:43");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("29", "event", "automation", NULL, "2024-09-06 14:15:43");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("30", "event", "automation_transactional", NULL, "2024-09-06 14:15:43");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("31", "filterSegmentId", "standard", NULL, "2024-09-06 14:15:43");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("32", "filterSegmentId", "re_engagement", NULL, "2024-09-06 14:15:43");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("33", "filterSegmentId", "notification", NULL, "2024-09-06 14:15:43");

/* INSERT TABLE DATA: wp_mailpoet_newsletter_templates */
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("1", "0", "ایمیل خوش آمد گویی: نمونه خالی با الگوی 1 ستون", "[\"welcome\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0633\\u0644\\u0627\\u0645\\u060c \\u0645\\u0634\\u062a\\u0631\\u06a9 \\u062c\\u062f\\u06cc\\u062f!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0628\\u0647 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u0627 \\u067e\\u06cc\\u0648\\u0633\\u062a\\u0647 \\u0627\\u06cc\\u062f \\u0648 \\u0645\\u0627 \\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0627\\u0632 \\u0634\\u0645\\u0627 \\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u06af\\u0631\\u0645 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u0645!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u0647\\u062a\\u0631\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0646\\u06cc\\u062f\\u061f \\u0628\\u0631\\u062e\\u06cc \\u0627\\u0632 \\u0645\\u062d\\u0628\\u0648\\u0628 \\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0631\\u0633\\u06cc \\u06a9\\u0646\\u06cc\\u062f: <\\/p>\\n<ol>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/the-importance-of-focus-when-writing\\/\\\">\\u0627\\u0647\\u0645\\u06cc\\u062a \\u062a\\u0645\\u0631\\u06a9\\u0632 \\u0647\\u0646\\u06af\\u0627\\u0645 \\u0646\\u0648\\u0634\\u062a\\u0646<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/write-great-subject-line\\/\\\">\\u0686\\u06af\\u0648\\u0646\\u0647 \\u06cc\\u06a9 \\u062e\\u0637 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u0645\\u061f<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/just-sit-write-advice-motivation-ernest-hemingway\\/\\\">\\u0641\\u0642\\u0637 \\u0628\\u0646\\u0634\\u06cc\\u0646\\u06cc\\u062f \\u0648 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f &ndash;  \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u0627\\u0646\\u06af\\u06cc\\u0632\\u0647 \\u0627\\u0632 \\u0627\\u0631\\u0646\\u0633\\u062a \\u0647\\u0645\\u06cc\\u0646\\u06af\\u0648\\u06cc<\\/a><\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-column/thumbnail.20190411-1500.jpg", "1", NULL, "2025-09-11 20:45:30", NULL);
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("2", "0", "ایمیل خوش آمد گویی: نمونه خالی با الگوی 1:2 ستون", "[\"welcome\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0633\\u0644\\u0627\\u0645\\u060c \\u0645\\u0634\\u062a\\u0631\\u06a9 \\u062c\\u062f\\u06cc\\u062f!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0628\\u0647 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u0627 \\u067e\\u06cc\\u0648\\u0633\\u062a\\u0647 \\u0627\\u06cc\\u062f \\u0648 \\u0645\\u0627 \\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0627\\u0632 \\u0634\\u0645\\u0627 \\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u06af\\u0631\\u0645 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u0645!<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>\\u0645\\u062d\\u0628\\u0648\\u0628 \\u062a\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0627<\\/h3>\"},{\"type\":\"text\",\"text\":\"<ul>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/the-importance-of-focus-when-writing\\/\\\">\\u0627\\u0647\\u0645\\u06cc\\u062a \\u062a\\u0645\\u0631\\u06a9\\u0632 \\u062f\\u0631 \\u0647\\u0646\\u06af\\u0627\\u0645 \\u0646\\u0648\\u0634\\u062a\\u0646<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/write-great-subject-line\\/\\\">\\u0686\\u06af\\u0648\\u0646\\u06af\\u06cc \\u0646\\u0648\\u0634\\u062a\\u0646 \\u06cc\\u06a9 \\u062e\\u0637 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u0628\\u0632\\u0631\\u06af<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/just-sit-write-advice-motivation-ernest-hemingway\\/\\\">\\u0641\\u0642\\u0637 \\u0628\\u0646\\u0634\\u06cc\\u0646\\u06cc\\u062f \\u0648 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f &ndash;  \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u0627\\u0646\\u06af\\u06cc\\u0632\\u0647 \\u0627\\u0632 \\u0627\\u0631\\u0646\\u0633\\u062a \\u0647\\u0645\\u06cc\\u0646\\u06af\\u0648\\u06cc <\\/a><\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>\\u0628\\u0639\\u062f\\u06cc \\u0686\\u06cc\\u0633\\u062a\\u061f<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>\\u06cc\\u06a9 \\u062f\\u06a9\\u0645\\u0647 \\u0628\\u0647 \\u0645\\u0646\\u0638\\u0648\\u0631 \\u062f\\u0639\\u0648\\u062a \\u0628\\u0647 \\u0627\\u0642\\u062f\\u0627\\u0645 \\u0628\\u0647 \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f. \\u0627\\u06cc\\u0646 \\u06a9\\u0627\\u0631 \\u0646\\u0631\\u062e \\u06a9\\u0644\\u06cc\\u06a9 \\u0634\\u062f\\u0646 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u0645\\u06cc \\u062f\\u0647\\u062f.<\\/p>\"},{\"type\":\"button\",\"text\":\"\\u062f\\u0641\\u0639\\u0627\\u062a \\u0628\\u0627\\u0632\\u062f\\u06cc\\u062f!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-2-column/thumbnail.20190411-1500.jpg", "1", NULL, "2025-09-11 20:45:30", NULL);
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("3", "0", "Gift Welcome", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Header-1.jpg\",\"alt\":\"Gift-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7e7e7\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #dd2d2d;\\\">We\'re so happy you\'re onboard!<\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dd2d2d\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Footer.jpg\",\"alt\":\"Gift-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 1<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 2<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>City<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">Unsubscribe<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">Manage your subscription<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#dd2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/gift/thumbnail.20190411-1500.jpg", "1", NULL, "2025-09-11 20:45:30", NULL);
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("4", "0", "Minimal", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#303c54\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo1.png\",\"alt\":\"Minimal-Logo1\",\"fullWidth\":false,\"width\":\"590px\",\"height\":\"93px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #8b9cbc;\\\">EST.2009<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"41px\"}}},{\"type\":\"text\",\"text\":\"<h2>Welcome to Minimal, Kim.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula. Cras sollicitudin nunc facilisis neque tristique sagittis.<\\/p>\\n<p><\\/p>\\n<p>Maecenas iaculis, lacus malesuada dictum dapibus, justo justo molestie lorem, ac dapibus magna urna vel arcu. Aliquam erat volutpat. Sed bibendum, ipsum sed ullamcorper blandit, eros odio interdum nibh, non venenatis metus lacus vitae lectus.<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}}},{\"type\":\"text\",\"text\":\"<h2>Some of our recent stories<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/plasma-stingray111-800x533.jpg\",\"alt\":\"plasma-stingray111-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"gettyimages-578313682-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"5_what_to_do_p352m1141746-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"47px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo-Small.png\",\"alt\":\"Minimal-Logo-Small\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"http:\\/\\/localhost\\/darisonline\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">Unsubscribe<\\/a><\\/span><\\/p>\\n<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">Manage your subscription<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">Add your postal address here!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Georgia\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Georgia\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#303c54\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAut