<?php

namespace Themento\Admin;

require_once wp_directory . "/admin/includes.php";

use Themento\Admin\Menu_Settings;

class Admin_Theme
{

	public function __construct()
	{
		add_action('admin_menu', [$this, 'admin_menu']);
		add_action('admin_enqueue_scripts', [$this, 'tmt_admin_enqueue_scripts']);
		add_filter('wp_check_filetype_and_ext', [$this, 'filter_fix_wp_check_filetype_and_ext'], 10, 4);
		add_filter('upload_mimes', [$this, 'tmt_upload_mimes']);
		add_action('admin_head', [$this, 'tmt_admin_font']);
		add_action('elementor/editor/before_enqueue_scripts', [$this, 'tmt_admin_font']);
		add_action('upgrader_process_complete', [$this, 'tmt_after_theme_update'], 10, 2);
		add_action('after_switch_theme', [$this, 'tmt_after_theme_switch']);
	}

	public function admin_menu()
	{
		add_menu_page(
			__('Theme Settings', text_domain),
			__('Theme Settings', text_domain),
			'manage_options',
			'tmt_theme_admin_panel',
			[$this, 'TMT_Theme_Settings'],
			$this->tmt_menu_icon(),
			59
		);
	}

	public function TMT_Theme_Settings()
	{
		$main_option = new Menu_Settings;
		$main_option->Main_options();
	}

	public function tmt_menu_icon()
	{
		return 'data:image/svg+xml;base64,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';
	}

	/**
	 * Enqueue Admin Style & Script Files
	 * @access public
	 */

	public function tmt_admin_enqueue_scripts()
	{
		wp_enqueue_media();
		wp_enqueue_style('wp-color-picker');
		wp_register_script('wp-color-picker-alpha', wp_directory_uri . '/admin/assets/js/wp-color-picker-alpha.min.js', array('wp-color-picker'), '1.0.0', true);
		wp_enqueue_script('wp-color-picker-alpha');

		wp_enqueue_style('tmt-admin', wp_directory_uri . '/admin/assets/css/tmt-admin.css', [], '1.0.0');
		wp_enqueue_script('tmt-admin', wp_directory_uri . '/admin/assets/js/tmt-admin.js', ['jquery'], '1.0.0', true);
		wp_localize_script('tmt-admin', 'tmt_post_types_object', array('get_post_types' => $this->tmt_get_post_types()));
		wp_localize_script('tmt-admin', 'tmt_taxonomies_object', array('get_taxonomies' => $this->tmt_get_taxonomies()));
	}

	public function tmt_get_post_types()
	{
		$args = ['public' => true];
		$get_post_types = get_post_types($args, 'objects');

		return $get_post_types;
	}

	public function tmt_get_taxonomies()
	{
		$args = ['public' => true];
		$get_taxonomies = get_taxonomies($args, 'objects');
		unset($get_taxonomies['nav_menu'], $get_taxonomies['post_format']);

		return $get_taxonomies;
	}


	private function get_file_types()
	{
		return [
			'woff' => 'font/woff|application/font-woff|application/x-font-woff|application/octet-stream',
			'woff2' => 'font/woff2|application/octet-stream|font/x-woff2',
			'ttf' => 'application/x-font-ttf|application/octet-stream|font/ttf',
			'svg' => 'image/svg+xml|application/octet-stream|image/x-svg+xml',
			'eot' => 'application/vnd.ms-fontobject|application/octet-stream|application/x-vnd.ms-fontobject',
		];
	}

	public function filter_fix_wp_check_filetype_and_ext($data, $file, $filename, $mimes)
	{
		if (! empty($data['ext']) && ! empty($data['type'])) {
			return $data;
		}

		$registered_file_types = $this->get_file_types();
		$filetype = wp_check_filetype($filename, $mimes);

		if (! isset($registered_file_types[$filetype['ext']])) {
			return $data;
		}
		// Fix incorrect file mime type
		$filetype['type'] = explode('|', $filetype['type'])[0];

		return [
			'ext' => $filetype['ext'],
			'type' => $filetype['type'],
			'proper_filename' => $data['proper_filename'],
		];
	}

	public function tmt_upload_mimes($mine_types)
	{
		foreach ($this->get_file_types() as $type => $mine) {
			if (! isset($mine_types[$type])) {
				$mine_types[$type] = $mine;
			}
		}

		return $mine_types;
	}

	public function tmt_admin_font()
	{
		echo "<style type='text/css'>@font-face {font-family: IRANSans;font-style: normal;font-weight: bold;src: url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb_Bold.eot');src: url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb_Bold.eot?#iefix') format('embedded-opentype'),url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb_Bold.woff2') format('woff2'),url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb_Bold.woff') format('woff'),url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb_Bold.ttf') format('truetype');}@font-face {font-family: IRANSans;font-style: normal;font-weight: normal;src: url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb.eot');src: url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb.eot?#iefix') format('embedded-opentype'),url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb.woff2') format('woff2'),url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb.woff') format('woff'),url('" . wp_directory_uri . "/assets/fonts/IRANSansWeb.ttf') format('truetype');}body.rtl, #wpadminbar *:not([class='ab-icon']), .wp-core-ui, .media-menu, .media-frame *, .media-modal *,.rtl h1, .rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6,.elementor-panel,.elementor-button,body,input#elementor-template-library-save-template-name,input#elementor-panel-elements-search-input,.wp-picker-clear.button,.elementor-templates-modal .dialog-widget-content,select,textarea,.tipsy-inner,.elementor-add-section-drag-title,.elementor-add-section-drag-title,.elementor-safe-mode-toast .elementor-toast-content,.elementor-safe-mode-toast header h2,#elementor-finder__search__input,#elementor-template-library-filter-text,.elementor-element-title-wrapper .title,.elementor-add-section-drag-title,.elementor-select-preset-title,.elementor-color-picker__saved-colors-edit,input.pcr-clear,.elementor-color-picker__header,.elementor-color-picker__saved-colors-title,.yoast-title,#elementor-try-safe-mode .elementor-safe-mode-button,button.dialog-button.dialog-cancel.dialog-confirm-cancel,button.dialog-button.dialog-ok.dialog-confirm-ok,input.tooltip-target.elementor-control-tag-area,input.elementor-control-tag-area.elementor-input.ui-autocomplete-input,.elementor-panel-heading-title {font-family:IRANSans !important;}.php-error #adminmenuback, .php-error #adminmenuwrap {margin-top: 0 !important;}.elementor-loading-title{letter-spacing:0px!important;font-size:13px!important}#elementor-template-library-filter .select2-selection__rendered,#select2-elementor-template-library-filter-subtype-results .select2-results__option{text-align:right}.e-global__color-hex,.e-global-colors__color-value {font-family: Roboto,Arial,Helvetica,Verdana,sans-serif;}#sub-accordion-section-custom_codes textarea {direction: ltr;}</style>" . PHP_EOL;
	}

	public function tmt_after_theme_update($upgrader_object, $options)
	{
		if ($options['action'] == 'update' && $options['type'] == 'theme') {
			$current_theme = get_stylesheet();
			if (isset($options['themes'])) {
				if (in_array($current_theme, $options['themes'])) {
					do_action('tmt_update_custom_styles');
				}
			} else {
				do_action('tmt_update_custom_styles');
			}
		}
	}

	public function tmt_after_theme_switch()
	{
		do_action('tmt_update_custom_styles');
	}
}

new Admin_Theme;
