<?php

namespace Themento\Admin;

use Themento\Admin\Config_Setting;
use Themento\Admin\Admin_Helper;
use Themento\Admin\Main_Settings;
use Themento\Admin\FlashMessage;

class Menu_Settings extends Main_Settings
{

    private $config_setting;
    private $admin_helper;
    private $main_setting;

    public function __construct()
    {
        $this->config_setting = new Config_Setting;
        $this->admin_helper = new Admin_Helper;
        $this->main_setting = new Main_Settings;
    }

    public function Main_options()
    {
        $this->Save_Change();
?>
        <div class="tmt-main-option-theme flex justify-content-between">
            <aside class="tmt-main-sidebar-options">
                <div class="logo">

                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="184px" height="100px" viewBox="0 0 183 100" version="1.1">
                        <defs>
                            <filter id="alpha" filterUnits="objectBoundingBox" x="0%" y="0%" width="100%" height="100%">
                                <feColorMatrix type="matrix" in="SourceGraphic" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 1 0" />
                            </filter>
                            <image id="image17" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAABGklEQVR4nO3SMS5EYRiG0X9uJhlRq6xBLEKvsgOxJlsQm5hCqVRahlrmWgDFHQzyOKf+vuQtnjEAAAAAAAAAAAAAAAAAAAAAAAAAAOAHrJYcza9Xl2Oebg49Bt7bzGN3fb/aXNzt+7ledLV7ORnT2fneu+DLjnZj2j585nP67inwV4ibLHGTJW6yxE2WuMkSN1niJkvcZImbLHGTJW6yxE2WuMkSN1niJkvcZImbLHGTJW6yxE2WuMkSN1niJkvcZImbLHGTJW6yxE2WuMkSN1niJkvcZImbLHGTJW6yxE2WuMkSN1niJkvcZImbLHGTJW6y1svOtk9jPr097BT4yPE8xvPjb68AAAAAAAAAAAAAAAAAAAAAAP6HN05oEzaPEuHZAAAAAElFTkSuQmCC" />
                            <mask id="mask0">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image17" />
                                </g>
                            </mask>
                            <clipPath id="clip1">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface16" clip-path="url(#clip1)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 37.664062 32.910156 C 72.210938 32.824219 106.761719 32.910156 141.308594 33.164062 C 149.277344 35.121094 154.222656 40.136719 156.152344 48.214844 C 157.621094 57.539062 154.515625 64.765625 146.84375 69.898438 C 145.109375 70.882812 143.265625 71.5625 141.308594 71.9375 C 106.761719 72.28125 72.210938 72.28125 37.664062 71.9375 C 25.273438 67.824219 20.496094 59.234375 23.328125 46.171875 C 25.890625 39.230469 30.671875 34.808594 37.664062 32.910156 Z M 41.1875 33.417969 C 73.386719 33.332031 105.585938 33.417969 137.785156 33.671875 C 148.734375 35.082031 154.773438 41.375 155.902344 52.550781 C 154.941406 63.300781 149.238281 69.511719 138.792969 71.171875 C 138.707031 68.445312 138.792969 65.726562 139.046875 63.007812 C 143.980469 64.925781 147 63.226562 148.101562 57.910156 C 148.710938 54.652344 148.207031 51.585938 146.59375 48.726562 C 145.796875 47.941406 144.875 47.34375 143.828125 46.9375 C 139.980469 47.011719 136.121094 47.097656 132.253906 47.195312 C 132.253906 55.359375 132.253906 63.523438 132.253906 71.6875 C 113.136719 71.6875 94.015625 71.6875 74.898438 71.6875 C 74.898438 63.523438 74.898438 55.359375 74.898438 47.195312 C 72.714844 47.195312 70.535156 47.195312 68.355469 47.195312 C 68.355469 55.359375 68.355469 63.523438 68.355469 71.6875 C 58.109375 71.894531 47.878906 71.640625 37.664062 70.917969 C 28.875 68.070312 24.011719 61.949219 23.074219 52.550781 C 24.285156 41.378906 30.320312 34.996094 41.1875 33.417969 Z M 139.800781 51.785156 C 140.300781 51.742188 140.71875 51.914062 141.058594 52.296875 C 142.242188 54.789062 141.90625 57.003906 140.050781 58.925781 C 139.847656 58.695312 139.589844 58.527344 139.296875 58.417969 C 138.542969 56.066406 138.707031 53.859375 139.800781 51.785156 Z M 139.800781 51.785156 " />
                            </g>
                            <image id="image26" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAAA60lEQVR4nO3XMWoCQRgF4H/WaOkpLFNbBFKm8Aq5kSfwBoKFXSoPkDYXCKQLUdgmsKAgrO3CLiksMsvwfeW85jHzmokAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOBPKXeBMWnrp3nM18uI34F7eWvSdPP+/624l3F3tJePx6gO+0g/s364+0zT75cMtbjTQ+4C4/KVIp2riHPVz5qBM8bMg1Es46ZYxk2xjJti+VB2XRd1VKttxHHSy9rnU8RrhlIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABkdAP51hpJLqgetQAAAABJRU5ErkJggg==" />
                            <mask id="mask1">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image26" />
                                </g>
                            </mask>
                            <clipPath id="clip2">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface25" clip-path="url(#clip2)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 69.863281 38.007812 C 74.4375 37.699219 75.777344 39.570312 73.890625 43.621094 C 71.773438 44.8125 69.839844 44.472656 68.101562 42.601562 C 67.589844 40.589844 68.179688 39.058594 69.863281 38.007812 Z M 69.863281 38.007812 " />
                            </g>
                            <image id="image35" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAABFUlEQVR4nO3cMS5EYRSG4XPvmIlYgDXYhlqvUJJpbMEGrEJQ2oQoVXq6KVRqiWQuao1mfv7Ml+dZwJdTvPWpAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgV0PvAzb1dTeb1eHVXtPR+9P34Xiamm7y77Y/7o+zgxrPb6tedtuNfi6Hxcljsz262Ol9wOaO5jVc71et2sVdq0W7LXoZex8Af0XcxBI3scRNLHETS9zEEjexxE0scRNL3MQSN7HETSxxE0vcxBI3scRNLHETS9zEEjexxE0scRNL3MQSN7HETSxxE2v7P06tL99qfLipep4325wuXquems0BAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADAT99H3hn2T42EdQAAAABJRU5ErkJggg==" />
                            <mask id="mask2">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image35" />
                                </g>
                            </mask>
                            <clipPath id="clip3">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface34" clip-path="url(#clip3)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 50.246094 40.050781 C 52.59375 40.050781 54.941406 40.050781 57.289062 40.050781 C 57.203125 43.457031 57.289062 46.855469 57.542969 50.253906 C 58.125 49.320312 58.710938 48.382812 59.300781 47.449219 C 61.980469 47.105469 64.667969 47.105469 67.347656 47.449219 C 65.589844 49.492188 64.082031 51.703125 62.820312 54.082031 C 64.367188 57.21875 66.042969 60.277344 67.851562 63.265625 C 65.171875 63.523438 62.496094 63.605469 59.804688 63.523438 C 58.367188 57.5 57.53125 57.5 57.289062 63.523438 C 54.941406 63.523438 52.59375 63.523438 50.246094 63.523438 C 50.246094 55.699219 50.246094 47.875 50.246094 40.050781 Z M 50.246094 40.050781 " />
                            </g>
                            <image id="image44" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAABOUlEQVR4nO3coUoEURTH4XOXZddgELOLgmgxmcXgc9gEEYyCNmHBZ7AIVh/HpMlgMKvgFkdlx5e4zrDH73uA/5nwg2k3AgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA+J9KH0fb55elGJ7XvX2705Tp5bzqJgut87jbx6tRbM/uIg4n9VY3m5g/nZbx7kO9TRbdsPOLo7cScbwW5WKj3ujkM8rNuN4eGQz6/gD4K+ImLXGTlrhJS9ykJW7SEjdpiZu0xE1a4iYtcZOWuElL3KQlbtISN2mJm7TETVriJi1xk5a4SUvcpCVu0hI3aYmbtLp/lOdrtY04eY32aLne6HoT7dZ3xFm9SRZeP28Fvs9WYrBX969xf/1RDvZ/qm4CAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD9+gU7qyN11XyeTwAAAABJRU5ErkJggg==" />
                            <mask id="mask3">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image44" />
                                </g>
                            </mask>
                            <clipPath id="clip4">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface43" clip-path="url(#clip4)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 37.160156 41.074219 C 41.503906 40.199219 45.109375 41.386719 47.980469 44.640625 C 48.585938 45.75 48.835938 46.941406 48.738281 48.214844 C 46.386719 48.214844 44.039062 48.214844 41.691406 48.214844 C 41.050781 45.859375 39.878906 45.601562 38.167969 47.449219 C 38.402344 47.660156 38.5625 47.914062 38.667969 48.214844 C 40.9375 49.464844 43.285156 50.570312 45.71875 51.53125 C 48.441406 53.699219 49.363281 56.503906 48.484375 59.949219 C 46.703125 63.046875 44.019531 64.40625 40.429688 64.03125 C 34.617188 64.335938 31.347656 61.617188 30.621094 55.863281 C 32.96875 55.863281 35.316406 55.863281 37.664062 55.863281 C 37.625 56.597656 37.792969 57.277344 38.167969 57.910156 C 39.296875 58.40625 40.46875 58.574219 41.691406 58.417969 C 41.796875 57.582031 41.632812 56.8125 41.1875 56.121094 C 38.570312 55.125 36.054688 53.933594 33.640625 52.550781 C 30.992188 50.070312 30.574219 47.265625 32.382812 44.136719 C 33.8125 42.777344 35.40625 41.753906 37.160156 41.074219 Z M 37.160156 41.074219 " />
                            </g>
                            <image id="image53" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAABBElEQVR4nO3bu00DURRF0TOICR1QgCsgIUBCLoIKKIEWHDihEjJaIHFCLciJifgJW+MGAMl6gyyu1yrg6mhmpy8BAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMrqDj3gPxm+5rPkYZGsTtsuXb6nX1532Q6jDONbjT/pyHSfZ8nkKtn0bYf613EG8ZuTQw+AvyJuyhI3ZYmbssRNWeKmLHFTlrgpS9yUJW7KEjdliZuyxE1Z4qYscVOWuClL3JTlJc4+htuPZPqc7qXtuw3nb8njSKP4ibj3cXe/zM36ov3QU7yfBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOGY7RQUZ0lLBaQQAAAAASUVORK5CYII=" />
                            <mask id="mask4">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image53" />
                                </g>
                            </mask>
                            <clipPath id="clip5">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface52" clip-path="url(#clip5)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 84.957031 46.6875 C 87.808594 46.128906 90.070312 46.976562 91.75 49.234375 C 92.464844 53.953125 92.714844 58.714844 92.507812 63.523438 C 90.324219 63.523438 88.144531 63.523438 85.96875 63.523438 C 86.046875 59.945312 85.96875 56.371094 85.714844 52.804688 C 85.171875 51.835938 84.503906 51.667969 83.703125 52.296875 C 83.449219 56.035156 83.367188 59.777344 83.449219 63.523438 C 81.269531 63.523438 79.09375 63.523438 76.910156 63.523438 C 76.910156 58.078125 76.910156 52.636719 76.910156 47.195312 C 79.121094 47.054688 81.304688 47.226562 83.449219 47.703125 C 84.070312 47.476562 84.578125 47.136719 84.957031 46.6875 Z M 84.957031 46.6875 " />
                            </g>
                            <image id="image62" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAAA/ElEQVR4nO3bsU0DQRCG0bkTuAfH1GAkAkt2asm9uAEkSxRALVRAQGKaIHQHzrCWFpysT/fzXgMz0n7abKoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgFjD1Atwu3Z5Xta4f+w+6LQ5D9v1b/c5nT1MvQC3ace3sRa7jxoOT92HvdSqqn66z+lsnHoB6EXcxBI3scRNLHETS9zEEjexxE0scRNL3MQSN7HETSxxE0vcxBI3scRNLHETyyXOrLyfq732f7P2PfsTsyo3lLPSPr/u8xltN9ehru0uswAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP6lPyqzFsuz/4MQAAAAAElFTkSuQmCC" />
                            <mask id="mask5">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image62" />
                                </g>
                            </mask>
                            <clipPath id="clip6">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface61" clip-path="url(#clip6)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 109.109375 47.195312 C 111.292969 47.195312 113.46875 47.195312 115.652344 47.195312 C 116 55.980469 116.675781 55.980469 117.664062 47.195312 C 119.371094 47.03125 121.050781 47.203125 122.691406 47.703125 C 123.976562 53.734375 124.644531 53.5625 124.707031 47.195312 C 126.886719 47.195312 129.066406 47.195312 131.246094 47.195312 C 130.320312 52.492188 129.230469 57.765625 127.976562 63.007812 C 126.09375 63.585938 124.164062 63.667969 122.191406 63.265625 C 121.488281 61.1875 120.902344 59.0625 120.429688 56.886719 C 119.605469 59.03125 119.023438 61.246094 118.667969 63.523438 C 116.65625 63.523438 114.644531 63.523438 112.632812 63.523438 C 111.457031 58.078125 110.285156 52.632812 109.109375 47.195312 Z M 109.109375 47.195312 " />
                            </g>
                            <image id="image71" width="183" height="100" xlink:href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAALcAAABkCAYAAADExKEeAAAABmJLR0QA/wD/AP+gvaeTAAAA1klEQVR4nO3WsQnCUBSG0Rs1gii4hXM4hdg6iYXjOIKFCJYKgqS1sHQHE2eIJDx8ntP/8BW3uBEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADALytSB/yr5jIsvxo+oi5W73fHOVly3Ak01W4ci/Up4jBvv97si3Ky7b4qP6PUAf/rOo3iNms9a+7jHmKyNEgdAH1x3GTLcZMtP3cKr2Udi/Mx4jltva3PVQ9FAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAB07QMdohbz45aIYAAAAABJRU5ErkJggg==" />
                            <mask id="mask6">
                                <g filter="url(#alpha)">
                                    <use xlink:href="#image71" />
                                </g>
                            </mask>
                            <clipPath id="clip7">
                                <rect x="0" y="0" width="183" height="100" />
                            </clipPath>
                            <g id="surface70" clip-path="url(#clip7)">
                                <path style=" stroke:none;fill-rule:evenodd;fill:rgb(99.607843%,100%,99.607843%);fill-opacity:1;" d="M 95.023438 53.3125 C 99.214844 53.3125 103.40625 53.3125 107.601562 53.3125 C 107.601562 55.019531 107.601562 56.71875 107.601562 58.417969 C 103.40625 58.417969 99.214844 58.417969 95.023438 58.417969 C 95.023438 56.71875 95.023438 55.019531 95.023438 53.3125 Z M 95.023438 53.3125 " />
                            </g>
                        </defs>
                        <g id="surface8">
                            <use xlink:href="#surface16" mask="url(#mask0)" />
                            <use xlink:href="#surface25" mask="url(#mask1)" />
                            <use xlink:href="#surface34" mask="url(#mask2)" />
                            <use xlink:href="#surface43" mask="url(#mask3)" />
                            <use xlink:href="#surface52" mask="url(#mask4)" />
                            <use xlink:href="#surface61" mask="url(#mask5)" />
                            <use xlink:href="#surface70" mask="url(#mask6)" />
                        </g>
                    </svg>




                </div>
                <ul class="tmt-main-menu">
                    <li id="elementor-element" class="tmt-menu-item active flex align-items-center">
                        <svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
                            <path d="M 5 5 L 5 27 L 27 27 L 27 5 L 5 5 z M 7 7 L 25 7 L 25 25 L 7 25 L 7 7 z M 11 11 L 11 21 L 13 21 L 13 11 L 11 11 z M 15 11 L 15 13 L 21 13 L 21 11 L 15 11 z M 15 15 L 15 17 L 21 17 L 21 15 L 15 15 z M 15 19 L 15 21 L 21 21 L 21 19 L 15 19 z" />
                        </svg><?php _e('Elementor Element', text_domain) ?>
                    </li>
                    <li id="theme-config" class="tmt-menu-item flex align-items-center">
                        <svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <rect x="0" fill="none" width="24" height="24" />
                            <g>
                                <path d="M4 6c-1.105 0-2 .895-2 2v12c0 1.1.9 2 2 2h12c1.105 0 2-.895 2-2H4V6zm16-4H8c-1.105 0-2 .895-2 2v12c0 1.105.895 2 2 2h12c1.105 0 2-.895 2-2V4c0-1.105-.895-2-2-2zm-5 14H8V9h7v7zm5 0h-3V9h3v7zm0-9H8V4h12v3z" />
                            </g>
                        </svg><?php _e('Theme Config', text_domain) ?>
                    </li>
                    <li id="post-type" class="tmt-menu-item flex align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="512px" height="512px" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve">
                            <path d="M447.146,8.772H214.992c-30.919,0-56.071,25.151-56.071,56.071v58.297h87.314V58.299h200.911 c3.614,0,6.545,2.936,6.545,6.545v232.155c0,3.613-2.931,6.545-6.545,6.545h-58.293v49.525h58.293 c30.926,0,56.072-25.147,56.072-56.07V64.844C503.219,33.924,478.072,8.772,447.146,8.772z M299.762,156.158H67.625c-30.924,0-56.071,25.151-56.071,56.07v232.156c0,30.923,25.147,56.07,56.071,56.07h232.137 c30.924,0,56.071-25.147,56.071-56.07V212.229C355.833,181.31,330.686,156.158,299.762,156.158z M306.306,444.385 c0,3.612-2.931,6.544-6.544,6.544H98.818V205.685h200.943c3.613,0,6.544,2.936,6.544,6.544V444.385z" />
                        </svg><?php _e('Post Type', text_domain) ?>
                    </li>
                    <li id="main-setting" class="tmt-menu-item flex align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 458.317 458.317" style="enable-background:new 0 0 458.317 458.317;" xml:space="preserve">
                            <path d="M446.185,179.159h-64.768c-2.536-7.702-5.636-15.15-9.26-22.29l45.818-45.818c4.737-4.737,4.737-12.416,0-17.152 L364.416,40.34c-4.737-4.737-12.416-4.737-17.152,0l-45.818,45.818c-7.14-3.624-14.587-6.724-22.289-9.26V12.131 c0.001-6.699-5.429-12.129-12.128-12.129h-75.743c-6.698,0-12.129,5.43-12.129,12.128v64.768 c-7.702,2.535-15.149,5.636-22.29,9.26L111.05,40.341c-4.737-4.737-12.416-4.737-17.152,0L40.339,93.9 c-4.737,4.736-4.737,12.416,0,17.152l45.817,45.817c-3.624,7.14-6.725,14.588-9.26,22.29H12.129C5.43,179.159,0,184.59,0,191.288 v75.743c0,6.698,5.43,12.128,12.129,12.128h64.768c2.536,7.702,5.636,15.149,9.26,22.29L40.34,347.266 c-4.737,4.736-4.737,12.416,0,17.152l53.559,53.559c4.737,4.736,12.416,4.736,17.152,0l45.817-45.817 c7.14,3.624,14.587,6.725,22.29,9.26v64.768c0,6.698,5.43,12.128,12.129,12.128h75.743c6.698,0,12.129-5.43,12.129-12.128v-64.768 c7.702-2.535,15.149-5.636,22.289-9.26l45.818,45.817c4.737,4.736,12.416,4.736,17.152,0l53.559-53.559 c4.737-4.737,4.737-12.416,0-17.152l-45.817-45.817c3.624-7.14,6.724-14.587,9.26-22.289h64.768 c6.698,0,12.129-5.43,12.129-12.128v-75.743C458.314,184.59,452.884,179.159,446.185,179.159z M229.157,289.542 c-33.349,0-60.384-27.035-60.384-60.384s27.035-60.384,60.384-60.384s60.384,27.035,60.384,60.384 S262.506,289.542,229.157,289.542z" />
                        </svg><?php _e('Main Setting', text_domain) ?>
                    </li>
                    <li id="login-setting" class="tmt-menu-item flex align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 330 330" style="enable-background:new 0 0 330 330;" xml:space="preserve">
                            <path d="M305,149.998H121.215l44.392-44.392c5.858-5.858,5.858-15.355,0-21.213c-5.857-5.858-15.355-5.858-21.213,0l-69.998,69.998 c-5.858,5.857-5.858,15.355,0,21.213l69.998,70.002c2.929,2.929,6.767,4.394,10.606,4.394c3.838-0.001,7.678-1.465,10.606-4.393 c5.857-5.858,5.858-15.355,0-21.213l-44.394-44.396H305c8.284,0,15-6.716,15-15C320,156.714,313.284,149.998,305,149.998z M155,300H40V30h115c8.284,0,15-6.716,15-15s-6.716-15-15-15H25c-8.284,0-15,6.716-15,15v300c0,8.284,6.716,15,15,15h130 c8.284,0,15-6.716,15-15S163.284,300,155,300z" />
                        </svg><?php _e('Login Setting', text_domain) ?>
                    </li>
                    <li id="custom-font-setting" class="tmt-menu-item flex align-items-center">
                        <svg width="512px" height="512px" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                            <path d="M221.631,109,109.92,392h58.055l24.079-61H319.946l24.079,61H402.08L290.369,109ZM213.37,277,256,169l42.63,108Z M16,496H496V16H16ZM48,48H464V464H48Z" />
                        </svg><?php _e('Custom Fonts', text_domain) ?>
                    </li>
                    <li id="custom-code-setting" class="tmt-menu-item flex align-items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="35.033px" height="35.033px" viewBox="0 0 35.033 35.033" style="enable-background:new 0 0 35.033 35.033;" xml:space="preserve">
                            <path d="M11.811,10.535l-6.983,6.984l6.983,6.981c0.78,0.781,0.78,2.048,0,2.828c-0.392,0.392-0.901,0.586-1.414,0.586 c-0.513,0-1.022-0.194-1.414-0.586l-8.397-8.396C0.211,18.558,0,18.049,0,17.519c0-0.529,0.211-1.039,0.586-1.414l8.397-8.398 c0.781-0.78,2.047-0.78,2.828,0C12.591,8.488,12.591,9.752,11.811,10.535z M34.447,16.104l-8.396-8.398 c-0.781-0.78-2.047-0.78-2.828,0c-0.781,0.781-0.781,2.047,0,2.828l6.982,6.984L23.223,24.5c-0.781,0.781-0.781,2.048,0,2.828 c0.392,0.392,0.902,0.586,1.414,0.586s1.023-0.194,1.414-0.586l8.396-8.396c0.375-0.375,0.586-0.884,0.586-1.414 C35.033,16.99,34.822,16.479,34.447,16.104z M21.012,3.831c-1.076-0.277-2.161,0.373-2.435,1.441l-6,23.498 c-0.272,1.07,0.373,2.16,1.442,2.434c0.167,0.043,0.334,0.063,0.497,0.063c0.894,0,1.706-0.603,1.937-1.505l6-23.498 C22.727,5.193,22.081,4.104,21.012,3.831z" />
                        </svg><?php _e('Custom Code', text_domain) ?>
                    </li>
                </ul>
            </aside>
            <main class="tmt-main-content-options">
                <?php echo FlashMessage::get(); ?>
                <form action="" method="POST" id="setting-form">
                    <div class="content-tab elementor-element-options">
                        <?php $this->main_setting->Elementor_Elements(); ?>
                    </div>
                    <div class="content-tab theme-config-options">
                        <?php $this->main_setting->Theme_config(); ?>
                    </div>
                    <div class="content-tab post-type-options">
                        <?php $this->main_setting->Post_type(); ?>
                    </div>
                    <div class="content-tab main-setting-options">
                        <?php $this->main_setting->General_Settings(); ?>
                    </div>
                    <div class="content-tab login-setting-options">
                        <?php $this->main_setting->Login_Settings(); ?>
                    </div>
                    <div class="content-tab custom-font-setting-options">
                        <?php $this->main_setting->Custom_Font_Settings(); ?>
                    </div>
                    <div class="content-tab custom-code-setting-options">
                        <?php $this->main_setting->Custom_Code_Settings(); ?>
                    </div>

                    <div class="form-row">
                        <button type="submit" class="button tmt-submit" name="SaveSetting"><?php _e('Save Change', text_domain); ?></button>
                    </div>
                </form>
            </main>
        </div>
<?php


    }

    public function Save_Change()
    {
        if (isset($_POST['SaveSetting'])) {

            $elements = $this->config_setting->Elementor_Elements();
            foreach ($elements as $element) {
                $id = $element['id'];
                $tmt_modules_option["$id"] = isset($_POST["$id"]);
            }
            update_option('tmt_active_modules_option', $tmt_modules_option);


            $settings = $this->config_setting->Theme_configs();
            foreach ($settings as $setting) {
                $name = $setting['name'];
                $tmt_theme_config_option["$name"] = intval($_POST["$name"]);
            }
            update_option('tmt_theme_config_option', $tmt_theme_config_option);

            $post_types = get_option('tmt_main_option', []);
            $cpt_name = $post_types['post-type']['slug'];
            $cpt_label = $_POST['cpt-label'];
            $cpt_singular = $_POST['cpt-singular'];
            if (isset($_POST['cpt-change-slug'])) {
                $cpt_new_name = $_POST['cpt-name'];
                $post_type = $this->admin_helper->convert_post_type_posts($cpt_name, $cpt_new_name);
                $cpt_name = $_POST['cpt-name'];
            }
            $tx_cat_name = $post_types['taxonomy']['cat-slug'];
            if (isset($_POST['tx-cat-change-slug'])) {
                $tx_cat_new_name = $_POST['tx-cat-name'];
                $post_type = $this->admin_helper->convert_taxonomy_terms($tx_cat_name, $tx_cat_new_name);
                $tx_cat_name = $_POST['tx-cat-name'];
            }
            $tx_tag_name = $post_types['taxonomy']['tag-slug'];
            if (isset($_POST['tx-tag-change-slug'])) {
                $tx_tag_new_name = $_POST['tx-tag-name'];
                $post_type = $this->admin_helper->convert_taxonomy_terms($tx_tag_name, $tx_tag_new_name);
                $tx_tag_name = $_POST['tx-tag-name'];
            }

            $custom_css = $this->TMT_Code_Validator($_POST['tmt-custom-css']);
            $custom_js = $this->TMT_Code_Validator($_POST['tmt-custom-js']);
            $before_head = $this->TMT_Code_Validator($_POST['tmt-custom-before-head']);
            $before_body = $this->TMT_Code_Validator($_POST['tmt-custom-before-body']);
            $main_options = [
                'login-settings' => [
                    'login-logo'                    => sanitize_url($_POST['login-logo']),
                    'login-bg'                      => sanitize_url($_POST['login-bg']),
                    'login-color-bg'                => sanitize_text_field($_POST['login-color-bg']),
                    'login-color-link'              => sanitize_text_field($_POST['login-color-link']),
                    'login-bg-color-submit'         => sanitize_text_field($_POST['login-bg-color-submit']),
                    'login-color-submit'            => sanitize_text_field($_POST['login-color-submit']),
                    'login-bg-color-submit-hover'   => sanitize_text_field($_POST['login-bg-color-submit-hover']),
                    'login-color-submit-hover'      => sanitize_text_field($_POST['login-color-submit-hover']),
                ],
                'codes-settings' => [
                    'custom-css'            => $custom_css,
                    'custom-js'             => $custom_js,
                    'custom-before-head'    => $before_head,
                    'custom-before-body'    => $before_body,
                ],
                'post-type' => [
                    'slug'              => sanitize_text_field($cpt_name),
                    'name'              => sanitize_text_field($cpt_label),
                    'singular'          => sanitize_text_field($cpt_singular),
                    'disable-archive'   => isset($_POST['disable-archive']),
                ],
                'taxonomy' => [
                    'cat-slug'  => sanitize_text_field($tx_cat_name),
                    'tag-slug'  => sanitize_text_field($tx_tag_name),
                ],
            ];

            $settings = $this->config_setting->General_Settings();
            foreach ($settings as $id => $setting) {
                $type = $setting['type'];
                $value = isset($_POST[$id]) ? $_POST[$id] : false;
                if ($value) {
                    $content = $this->TMT_Type_To_Render($value, $type);
                    if ($content) {
                        $main_options['general-settings'][$id] = $content;
                    }
                }
            }

            $main_options['general-settings']['ltr-font'] = sanitize_text_field($_POST['ltr-font']);

            $fonts = $_POST['fonts'];
            if (!empty($fonts)) {
                foreach ($fonts as $custom_font) {
                    $main_options['fonts'][] = [
                        'weight'    => sanitize_text_field($custom_font['weight']),
                        'woff'      => sanitize_url($custom_font['woff']),
                        'woff2'     => sanitize_url($custom_font['woff2']),
                        'ttf'       => sanitize_url($custom_font['ttf']),
                        'svg'       => sanitize_url($custom_font['svg']),
                        'eot'       => sanitize_url($custom_font['eot']),
                    ];
                }
            }

            update_option('tmt_main_option', $main_options);

            do_action('tmt_update_custom_styles');

            $message = __('Settings updated successfully.', text_domain);
            $this->start_session();
            FlashMessage::add($message);
            $this->end_session();
        }
    }

    private function TMT_Type_To_Render($value, $type)
    {
        switch ($type) {
            case 'text':
            case 'select':
            case 'color':
                $value = sanitize_text_field($value);
                break;
            case 'textarea':
                $value = sanitize_textarea_field($value);
                break;
            case 'select2':
                $value = $value;
                break;
            case 'image-uploader':
            case 'url':
                $value = sanitize_url($value);
                break;
            case 'checkbox':
                $value = isset($value);
                break;
            case 'repeater':
                $value = $value;
                break;
            case 'editor':
                $value = $this->TMT_Code_Validator($value);
                break;
        }

        return $value;
    }

    private function TMT_Code_Validator($code)
    {
        return str_replace(array('\'', '\"'), '"', $code);
    }

    public function start_session()
    {
        if (!session_id()) {
            session_start();
        }
    }

    public function end_session()
    {
        session_write_close();
    }
}
