<?php

class Front_CSS
{

    public function __construct()
    {
        add_filter('wp_get_custom_css', [$this, 'minify_custom_css']);
        add_action('tmt_update_custom_styles', array($this, 'save_settings_css_in_file'));
        add_action('wp_enqueue_scripts', [$this, 'custom_style_css'], 9999);
        add_action('tmt_head_css', [$this, 'Main_CSS']);
    }

    public function tmt_minify_css($css = '')
    {

        // Return if no CSS
        if (! $css) return;

        // Normalize whitespace
        $css = preg_replace('/\s+/', ' ', $css);

        // Remove ; before }
        $css = preg_replace('/;(?=\s*})/', '', $css);

        // Remove space after , : ; { } */ >
        $css = preg_replace('/(,|:|;|\{|}|\*\/|>) /', '$1', $css);

        // Remove space before , ; { }
        $css = preg_replace('/ (,|;|\{|})/', '$1', $css);

        // Strips leading 0 on decimal values (converts 0.5px into .5px)
        $css = preg_replace('/(:| )0\.([0-9]+)(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}.${2}${3}', $css);

        // Strips units if value is 0 (converts 0px to 0)
        $css = preg_replace('/(:| )(\.?)0(%|em|ex|px|in|cm|mm|pt|pc)/i', '${1}0', $css);

        // Trim
        $css = trim($css);

        // Return minified CSS
        return $css;
    }

    public function minify_custom_css($css)
    {
        return $this->tmt_minify_css($css);
    }

    public function save_settings_css_in_file($output = NULL)
    {
        // Get all the custom css
        $output = apply_filters('tmt_head_css', $output);

        // Get Custom Panel CSS
        $output_custom_css = wp_get_custom_css();

        // Minify the Custom CSS
        $output .= $this->tmt_minify_css($output_custom_css);

        // Use get_stylesheet_directory to get the current theme folder
        $dir = get_stylesheet_directory() . DIRECTORY_SEPARATOR; // Set storage directory path to theme folder

        // Initialize the WordPress filesystem, no more using 'file-put-contents' function from PHP
        if (! function_exists('WP_Filesystem')) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            WP_Filesystem();
        }

        /* @var WP_Filesystem_Base $wp_filesystem */
        global $wp_filesystem;

        // Check if the filesystem is initialized
        if (! is_a($wp_filesystem, 'WP_Filesystem_Base')) {
            // Attempt to initialize the filesystem
            $creds = request_filesystem_credentials(site_url());
            WP_Filesystem($creds);
        }

        // Check if the filesystem is initialized successfully
        if (is_a($wp_filesystem, 'WP_Filesystem_Base')) {
            // If the directory doesn't exist, create it
            if (! $wp_filesystem->is_dir($dir)) {
                $wp_filesystem->mkdir($dir); // Make a new directory, if not already created.
            }

            $file = $dir . 'style.min.css'; // Setting the file name as style.min.css in theme directory

            // Store in the file
            if (!$wp_filesystem->put_contents($file, $output, FS_CHMOD_FILE)) {
                // Handle error, unable to create file.
                error_log('Unable to save the minified CSS into style.min.css file.');
                return;
            }
        }
    }


    public function custom_style_css($output = NULL)
    {
        // Get full path to the style.min.css in the current theme directory
        $file = get_stylesheet_directory() . '/style.min.css';

        // Render CSS from the custom file if it exists
        if (file_exists($file)) {
            wp_enqueue_style('tmt-style', get_stylesheet_directory_uri() . '/style.min.css', false, null);
        }
        return;
    }


    public function Main_CSS($output)
    {
        $main_option = get_option('tmt_main_option', []);
        $modules_option = get_option('tmt_active_modules_option', []);
        $category = 'general-settings';
        $ltr_font = TMT_Get_Setting('general-settings', 'ltr-font');
        $select_text_color = TMT_Get_Setting($category, 'select-text-color');
        $select_bg_color = TMT_Get_Setting($category, 'select-bg-color');
        $link_color = TMT_Get_Setting($category, 'link-color');
        $abs_header_mobile = TMT_Get_Setting($category, 'abs-header-mobile');
        $custom_css = TMT_Get_Setting('codes-settings', 'custom-css');
        $css = '@charset "UTF-8";';
        $fonts = $main_option['fonts'];
        if (!empty($fonts[0]['woff']) || !empty($fonts[0]['woff2'])) {
            foreach ($fonts as $font) {
                $font_weight = $font['weight'];
                $WOFF_url = $font['woff'];
                $WOFF2_url = $font['woff2'];
                $TTF_url = $font['ttf'];
                $SVG_url = $font['svg'];
                $EOT_url = $font['eot'];

                $css .= "@font-face {font-family: TMT;font-style: normal;font-weight: $font_weight;";
                if (!empty($EOT_url)) {
                    $css .= "src: url($EOT_url);";
                }
                $css .= "src: ";
                $fonts = array();
                if (!empty($EOT_url)) {
                    array_push($fonts, "url($EOT_url?#iefix) format('embedded-opentype')");
                }
                if (!empty($WOFF2_url)) {
                    array_push($fonts, "url($WOFF2_url) format('woff2')");
                }
                if (!empty($WOFF_url)) {
                    array_push($fonts, "url($WOFF_url) format('woff')");
                }
                if (!empty($TTF_url)) {
                    array_push($fonts, "url($TTF_url) format('truetype')");
                }
                if (!empty($SVG_url)) {
                    array_push($fonts, "url($SVG_url) format('svg')");
                }
                $css .= implode(",", $fonts);
                $css .= ";}";
            }
            $css .= 'h1, h2, h3, h4, h5, h6 {font-family:TMT;}';
            $css .= 'body, button, input, select, textarea {font-family:TMT;}';
        } else {
            $css .= 'body, button, input, select, textarea, h1, h2, h3, h4, h5, h6,.irs-from,.irs-to {font-family:IRANSans;}';
        }
        $css .= 'body:not(.rtl) h1,body:not(.rtl) h2,body:not(.rtl) h3,body:not(.rtl) h4,body:not(.rtl) h5,body:not(.rtl) h6 {font-family: "' . $ltr_font . '",serif;}';
        $css .= 'body:not(.rtl),body:not(.rtl) button,body:not(.rtl) input,body:not(.rtl) select,body:not(.rtl) textarea {font-family: "' . $ltr_font . '",serif;}';


        $css .= 'a {color:' . $link_color . ';}';
        $css .= '::-moz-selection {color:' . $select_text_color . ';background:' . $select_bg_color . ';}::selection {color:' . $select_text_color . ';background:' . $select_bg_color . ';}';

        $css .= 'a {color:' . $link_color . ';}';
        if ($abs_header_mobile == false) {
            $css .= "@media (max-width: 767px) {.position-header {position: relative;}}";
        }
        $enable_preloader = TMT_Get_Setting($category, 'enable-preloader');
        if ($enable_preloader == true) {
            $preloader_bg_color = TMT_Get_Setting($category, 'preloader-bg-color');
            $preloader_style = TMT_Get_Setting($category, 'preloader-style');
            $css .= '.tmt-preloader {position: fixed;z-index: 9999999999;top: 0;right: 0;width: 100%;height: 100%;background-color: ' . $preloader_bg_color . ';}';
            $css .= '.tmt-preloader img {max-height: 150px;}';
            $css .= '.tmt-preloader svg {max-height: 90px;margin-top: 10px;}';
            if ($preloader_style != 'none') {
                switch ($preloader_style) {
                    case 'style1':
                        $css .= '.tmt-loading.style1{display:inline-block;width:80px;height:80px}.tmt-loading.style1:after{content:" ";display:block;width:64px;height:64px;margin:8px;border-radius:50%;border:6px solid #fff;border-color:#fff transparent #fff transparent;animation:tmt-dual-ring 1.2s linear infinite}@keyframes tmt-dual-ring{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}';
                        break;
                    case 'style2':
                        $css .= '.tmt-loading.style2{display:inline-block;transform:translateZ(1px)}.tmt-loading.style2>div{display:inline-block;width:64px;height:64px;margin:8px;border-radius:50%;background:#fff;animation:tmt-circle 2.4s cubic-bezier(0,.2,.8,1) infinite}@keyframes tmt-circle{0%,100%{animation-timing-function:cubic-bezier(.5,0,1,.5)}0%{transform:rotateY(0deg)}50%{transform:rotateY(1800deg);animation-timing-function:cubic-bezier(0,.5,.5,1)}100%{transform:rotateY(3600deg)}}';
                        break;
                    case 'style3':
                        $css .= '.tmt-loading.style3{display:inline-block;position:relative;width:80px;height:80px}.tmt-loading.style3 div{box-sizing:border-box;display:block;position:absolute;width:64px;height:64px;margin:8px;border:8px solid #fff;border-radius:50%;animation:tmt-ring 1.2s cubic-bezier(.5,0,.5,1) infinite;border-color:#fff transparent transparent transparent}.tmt-loading.style3 div:nth-child(1){animation-delay:-0.45s}.tmt-loading.style3 div:nth-child(2){animation-delay:-0.3s}.tmt-loading.style3 div:nth-child(3){animation-delay:-0.15s}@keyframes tmt-ring{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}';
                        break;
                    case 'style4':
                        $css .= '.tmt-loading.style4{display:inline-block;position:relative;width:80px;height:80px}.tmt-loading.style4 div{animation:tmt-roller 1.2s cubic-bezier(.5,0,.5,1) infinite;transform-origin:40px 40px}.tmt-loading.style4 div:after{content:" ";display:block;position:absolute;width:7px;height:7px;border-radius:50%;background:#fff;margin:-4px 0 0 -4px}.tmt-loading.style4 div:nth-child(1){animation-delay:-0.036s}.tmt-loading.style4 div:nth-child(1):after{top:63px;left:63px}.tmt-loading.style4 div:nth-child(2){animation-delay:-0.072s}.tmt-loading.style4 div:nth-child(2):after{top:68px;left:56px}.tmt-loading.style4 div:nth-child(3){animation-delay:-0.108s}.tmt-loading.style4 div:nth-child(3):after{top:71px;left:48px}.tmt-loading.style4 div:nth-child(4){animation-delay:-0.144s}.tmt-loading.style4 div:nth-child(4):after{top:72px;left:40px}.tmt-loading.style4 div:nth-child(5){animation-delay:-0.18s}.tmt-loading.style4 div:nth-child(5):after{top:71px;left:32px}.tmt-loading.style4 div:nth-child(6){animation-delay:-0.216s}.tmt-loading.style4 div:nth-child(6):after{top:68px;left:24px}.tmt-loading.style4 div:nth-child(7){animation-delay:-0.252s}.tmt-loading.style4 div:nth-child(7):after{top:63px;left:17px}.tmt-loading.style4 div:nth-child(8){animation-delay:-0.288s}.tmt-loading.style4 div:nth-child(8):after{top:56px;left:12px}@keyframes tmt-roller{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}';
                        break;
                    case 'style5':
                        $css .= '.tmt-loading.style5{display:inline-block;position:relative;width:80px;height:80px}.tmt-loading.style5 div{position:absolute;top:33px;width:13px;height:13px;border-radius:50%;background:#fff;animation-timing-function:cubic-bezier(0,1,1,0)}.tmt-loading.style5 div:nth-child(1){left:8px;animation:tmt-ellipsis1 0.6s infinite}.tmt-loading.style5 div:nth-child(2){left:8px;animation:tmt-ellipsis2 0.6s infinite}.tmt-loading.style5 div:nth-child(3){left:32px;animation:tmt-ellipsis2 0.6s infinite}.tmt-loading.style5 div:nth-child(4){left:56px;animation:tmt-ellipsis3 0.6s infinite}@keyframes tmt-ellipsis1{0%{transform:scale(0)}100%{transform:scale(1)}}@keyframes tmt-ellipsis3{0%{transform:scale(1)}100%{transform:scale(0)}}@keyframes tmt-ellipsis2{0%{transform:translate(0,0)}100%{transform:translate(24px,0)}}';
                        break;
                    case 'style6':
                        $css .= '.tmt-loading.style6{display:inline-block;position:relative;width:80px;height:80px}.tmt-loading.style6 div{position:absolute;width:16px;height:16px;border-radius:50%;background:#fff;animation:tmt-grid 1.2s linear infinite}.tmt-loading.style6 div:nth-child(1){top:8px;left:8px;animation-delay:0s}.tmt-loading.style6 div:nth-child(2){top:8px;left:32px;animation-delay:-0.4s}.tmt-loading.style6 div:nth-child(3){top:8px;left:56px;animation-delay:-0.8s}.tmt-loading.style6 div:nth-child(4){top:32px;left:8px;animation-delay:-0.4s}.tmt-loading.style6 div:nth-child(5){top:32px;left:32px;animation-delay:-0.8s}.tmt-loading.style6 div:nth-child(6){top:32px;left:56px;animation-delay:-1.2s}.tmt-loading.style6 div:nth-child(7){top:56px;left:8px;animation-delay:-0.8s}.tmt-loading.style6 div:nth-child(8){top:56px;left:32px;animation-delay:-1.2s}.tmt-loading.style6 div:nth-child(9){top:56px;left:56px;animation-delay:-1.6s}@keyframes tmt-grid{0%,100%{opacity:1}50%{opacity:.5}}';
                        break;
                    case 'style7':
                        $css .= '.tmt-loading.style7{display:inline-block;position:relative;width:80px;height:80px}.tmt-loading.style7 div{position:absolute;border:4px solid #fff;opacity:1;border-radius:50%;animation:tmt-ripple 1s cubic-bezier(0,.2,.8,1) infinite}.tmt-loading.style7 div:nth-child(2){animation-delay:-0.5s}@keyframes tmt-ripple{0%{top:36px;left:36px;width:0;height:0;opacity:0}4.9%{top:36px;left:36px;width:0;height:0;opacity:0}5%{top:36px;left:36px;width:0;height:0;opacity:1}100%{top:0;left:0;width:72px;height:72px;opacity:0}}';
                        break;
                }
            }
        }


        $css .= '
            /*--------------------------------------------------------------
            >>> Css Default
            ----------------------------------------------------------------*/
            /** === Reset === */
            @-ms-viewport {width: device-width;}
            * ,*::before, *::after{padding: 0;margin: 0;border: 0;outline: 0;-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box}
            article, aside, figcaption, figure, footer, header, hgroup, main, nav, section {display: block;}
            html {-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;}
            body {background: #fff;overflow-wrap: break-word;font-size: 16px;line-height: 1.5;overflow-x: hidden;}
            body.rtl {direction: rtl;}
            form {font-size: 16px}
            img {max-width: 100%;display: block;width: auto;height: auto;box-sizing: border-box}
            a {color: #000;text-decoration: none;transition: all .2s ease-in-out}
            h1, h2, h3, h4, h5, h6 {line-height: 1.4;font-weight: bold;box-decoration-break: clone;-webkit-box-decoration-break: clone;}
            h1 {font-size: 48px}
            h2 {font-size: 36px}
            h3 {font-size: 24px}
            h4 {font-size: 20px}
            h5 {font-size: 18px}
            h6 {font-size: 16px}
            input, textarea, select {font-weight: 400;padding: 12px;}
            textarea {width: 100% !important;}
            input[type="submit"] {cursor: pointer;color: #FFF}
            small {opacity: .8;display: block;font-size: .9em;font-weight: normal;margin: 4px 0 0}
            strong, big {font-weight: bold}
            em {font-style: itmosac}
            ul,ol {list-style-position: inside;}
            pre, blockquote, .blockquote {display: inline-block;position: relative;padding: 6px 14px;margin-bottom: 30px;background: rgba(167, 167, 167, .1);border-radius: 2px;overflow: auto;max-width: 100%}
            pre small {margin: 0;font-size: inherit;display: inline-block}
            q {font-weight: 700;position: relative;padding: 6px 14px;background: rgba(167, 167, 167, .1);border-radius: 2px;overflow: auto;max-width: 100%;}
            blockquote, .blockquote {overflow: visible;font-size: 18px;padding: 10px 20px;}
            .blockquote {text-align: center;padding: 30px}
            cite {opacity: .7;font-size: 16px;margin: 0 5px;background: rgba(167, 167, 167, .1);padding: 3px 10px;display: inline-block}
            blockquote cite, .blockquote cite, pre cite{display: block;font-size: 12px;font-style: itmosac;background: none;}
            code,tt {position: relative;padding: 8px 10px;background: rgba(167, 167, 167, .1);border-radius: 2px;overflow: auto;display: inline-block;vertical-align: middle;line-height: 1.2}
            blockquote code {padding: 4px 6px}
            pre,code{font-family: Monaco, Consolas, "Andale Mono", "DejaVu Sans Mono", monospace;white-space: pre-wrap;}
            mark {padding: 3px 5px}
            video {width: 100%;height: auto}
            iframe {max-width: 100%}
            table {text-align: center;border-collapse: collapse;width: 100%;margin: 0 0 30px;box-sizing: border-box;border: 1px solid rgba(167, 167, 167, .2) !important}
            .widget table{table-layout: fixed}
            tr {border-bottom: 1px solid rgba(167, 167, 167, .2)}
            th, td {padding: 8px;border-right: 1px solid rgba(167, 167, 167, .2)}
            .widget th:last-child, .widget td:last-child {border-right: 0}
            thead {background-color: rgba(167, 167, 167, .1)}
            table caption {padding: 0 0 10px}
            abbr, acronym {border-bottom: 1px dotted;cursor: help}
            kbd {background: rgb(111, 111, 111);padding: 4px 10px;border-radius: 4px;color: #fff}
            dl {border: 3px double rgba(167, 167, 167, .3);padding: 20px;margin: 0 0 20px}
            dt {float: left;clear: left;width: 150px;text-align: right;font-weight: bolder}
            dt:after {content: ":"}
            dd {margin: 0 0 10px 170px;padding: 0 0 10px 0;border-bottom: 1px solid rgba(167, 167, 167, .2)}
            dd:last-child {margin-bottom: 0;border-bottom: 0}
            address {border: 1px dashed rgba(167, 167, 167, .3);display: inline-block;padding: 20px;margin: 0 0 30px}
            .pointer {cursor:pointer}

            /** === Wordpress === */
            .alignleft {float: left;margin-right: 1rem;}
            @media only screen and (min-width: 768px) {.alignleft {margin-right: calc(2 * 1rem);}}
            .alignright {float: right;margin-left: 1rem;}
            @media only screen and (min-width: 768px) {.alignright {margin-left: calc(2 * 1rem);}}
            .aligncenter {clear: both;display: block;margin:0 auto}
            .gallery {display: flex;flex-flow: row wrap;justify-content: center;margin-bottom: calc(1.5 * 1rem);}
            .gallery-item {display: inline-block;margin-left: 16px;margin-bottom: 16px;text-align: center;vertical-align: top;width: 100%;}
            .gallery-columns-2 .gallery-item {max-width: calc((100% - 16px * 1) / 2);}
            .gallery-columns-2 .gallery-item:nth-of-type(2n+2) {margin-left: 0;}
            .gallery-columns-3 .gallery-item {max-width: calc((100% - 16px * 2) / 3);}
            .gallery-columns-3 .gallery-item:nth-of-type(3n+3) {margin-left: 0;}
            .gallery-columns-4 .gallery-item {max-width: calc((100% - 16px * 3) / 4);}
            .gallery-columns-4 .gallery-item:nth-of-type(4n+4) {margin-left: 0;}
            .gallery-columns-5 .gallery-item {max-width: calc((100% - 16px * 4) / 5);}
            .gallery-columns-5 .gallery-item:nth-of-type(5n+5) {margin-left: 0;}
            .gallery-columns-6 .gallery-item {max-width: calc((100% - 16px * 5) / 6);}
            .gallery-columns-6 .gallery-item:nth-of-type(6n+6) {margin-left: 0;}
            .gallery-columns-7 .gallery-item {max-width: calc((100% - 16px * 6) / 7);}
            .gallery-columns-7 .gallery-item:nth-of-type(7n+7) {margin-left: 0;}
            .gallery-columns-8 .gallery-item {max-width: calc((100% - 16px * 7) / 8);}
            .gallery-columns-8 .gallery-item:nth-of-type(8n+8) {margin-left: 0;}
            .gallery-columns-9 .gallery-item {max-width: calc((100% - 16px * 8) / 9);}
            .gallery-columns-9 .gallery-item:nth-of-type(9n+9) {margin-left: 0;}
            .gallery-item:last-of-type {padding-left: 0;}
            .gallery-caption {display: block;font-size: 0.71111em;line-height: 1.6;margin: 0;padding: 0.5rem;}
            .gallery-item > div > a {display: block;line-height: 0;box-shadow: 0 0 0 0 transparent;}
            .gallery-item > div > a:focus {box-shadow: 0 0 0 2px #0073aa;}

            /** === post password required === **/
            .post-password-required .post-password-form {margin: 50px auto;max-width: 500px;}
            .post-password-required .post-password-form > p {margin: 10px 0;}
            .post-password-required .post-password-form input[type=password] {width: 100%;margin-bottom: 15px;}
            .post-password-required .post-password-form input[type=submit] {width: 100%;background-color: black;}
            /** === Column === **/
            .cols-1 > * {-ms-flex: 0 0 100%;flex: 0 0 100%;max-width: 100%;}
            .cols-2 > * {-ms-flex: 0 0 50%;flex: 0 0 50%;max-width: 50%;}
            .cols-3 > * {-ms-flex: 0 0 33.333333%;flex: 0 0 33.333333%;max-width: 33.333333%;}
            .cols-4 > * {-ms-flex: 0 0 25%;flex: 0 0 25%;max-width: 25%;}
            .cols-5 > * {-ms-flex: 0 0 20%;flex: 0 0 20%;max-width: 20%;}
            .cols-6 > * {-ms-flex: 0 0 16.666667%;flex: 0 0 16.666667%;max-width: 16.666667%;}
            @media (max-width: 979px) {.cols-4 > *,.cols-5 > *,.cols-6 > * {-ms-flex: 0 0 33.333333%;flex: 0 0 33.333333%;max-width: 33.333333%;}}
            @media (max-width: 767px) {.cols-3 > *,.cols-4 > *,.cols-5 > *,.cols-6 > * {-ms-flex: 0 0 50%;flex: 0 0 50%;max-width: 50%;}}
            @media (max-width: 480px) {.cols-2 > *,.cols-3 > *,.cols-4 > *,.cols-5 > *,.cols-6 > * {-ms-flex: 0 0 100%;flex: 0 0 100%;max-width: 100%;}}

            /** === Flex Box === **/
            .flex {display: flex;}
            .inline-flex {display: inline-flex;}
            .flex-column {flex-direction: column;-ms-flex-direction:column;}
            .flex-row-reverse {-ms-flex-direction: row-reverse;flex-direction: row-reverse;}
            .flex-column-reverse {-ms-flex-direction: column-reverse;flex-direction: column-reverse;}
            .flex-wrap {-ms-flex-wrap: wrap;flex-wrap: wrap;}
            .flex-nowrap {-ms-flex-wrap: nowrap;flex-wrap: nowrap;}
            .flex-wrap-reverse {-ms-flex-wrap: wrap-reverse;flex-wrap: wrap-reverse;}
            .flex-fill {-ms-flex: 1 1 auto;flex: 1 1 auto;}
            .justify-content-start, .justify-content-right {-ms-flex-pack: start;justify-content: flex-start;}
            .justify-content-end, .justify-content-left {-ms-flex-pack: end;justify-content: flex-end;}
            .justify-content-center {-ms-flex-pack: center;justify-content: center;}
            .justify-content-between {-ms-flex-pack: justify;justify-content: space-between;}
            .justify-content-around {-ms-flex-pack: distribute;justify-content: space-around;}
            .align-items-center{align-items: center;}
            .align-items-start,.align-items-right {-ms-flex-align: start;align-items: flex-start;}
            .align-items-end,.align-items-left {-ms-flex-align: end;align-items: flex-end;}
            .align-items-center {-ms-flex-align: center;align-items: center;}
            .align-items-baseline {-ms-flex-align: baseline;align-items: baseline;}
            .align-items-stretch {-ms-flex-align: stretch;align-items: stretch;}
            .align-content-start {-ms-flex-line-pack: start;align-content: flex-start;}
            .align-content-end {-ms-flex-line-pack: end;align-content: flex-end;}
            .align-content-center {-ms-flex-line-pack: center;align-content: center;}
            .align-content-between {-ms-flex-line-pack: justify;align-content: space-between;}
            .align-content-around {-ms-flex-line-pack: distribute;align-content: space-around;}
            .align-content-stretch {-ms-flex-line-pack: stretch;align-content: stretch;}
            .align-self-auto {-ms-flex-item-align: auto;align-self: auto;}
            .align-self-start {-ms-flex-item-align: start;align-self: flex-start;}
            .align-self-end {-ms-flex-item-align: end;align-self: flex-end;}
            .align-self-center {-ms-flex-item-align: center;align-self: center;}
            .align-self-baseline {-ms-flex-item-align: baseline;align-self: baseline;}
            .align-self-stretch {-ms-flex-item-align: stretch;align-self: stretch;}
            .text-left {text-align: left}
            .text-center {text-align: center}
            .text-right{text-align: right}
            .grid {display: grid}

            /** === Font === */
            @font-face {font-family: IRANSans;font-style: normal;font-weight: bold;src: url("assets/fonts/IRANSansWeb_Bold.eot");src: url("assets/fonts/IRANSansWeb_Bold.eot?#iefix") format("embedded-opentype"),url("assets/fonts/IRANSansWeb_Bold.woff2") format("woff2"),url("assets/fonts/IRANSansWeb_Bold.woff") format("woff"),url("assets/fonts/IRANSansWeb_Bold.ttf") format("truetype");}
            @font-face {font-family: IRANSans;font-style: normal;font-weight: normal;src: url("assets/fonts/IRANSansWeb.eot");src: url("assets/fonts/IRANSansWeb.eot?#iefix") format("embedded-opentype"),url("assets/fonts/IRANSansWeb.woff2") format("woff2"),url("assets/fonts/IRANSansWeb.woff") format("woff"),url("assets/fonts/IRANSansWeb.ttf") format("truetype");}


            /** === Custom Css daris === **/
            .absolute {position: absolute !important;width: 100%}
            .elementor-editor-active .absolute {position: relative !important;}
            body.elementor-editor-active.elementor_library-template {background-color:#cacaca}
            .overflow-hidden .elementor-widget-container {overflow: hidden;position: relative;}
            .tmt-content,#tab-description {line-height: 2.2em;}
            .tmt-content ul,#tab-description ul {list-style: inside disc}
            .tmt-content ol,#tab-description ol {list-style: inside decimal}
            .tmt-content h1,.tmt-content h2,.tmt-content h3,.tmt-content h4,.tmt-content h5,.tmt-content h6,.tmt-content .wp-block-image,.tmt-content .wp-block-gallery,#tab-description h1,#tab-description h2,#tab-description h3,#tab-description h4,#tab-description h5,#tab-description h6,#tab-description .wp-block-image,#tab-description .wp-block-gallery {margin: 20px auto !important;}
            .position-header{position:absolute;top:0;width:100%;z-index: 999;}
            .elementor-editor-active .position-header {position:relative;}
            .elementor-section-wrap {overflow: hidden;}header .elementor-section-wrap,.elementor-location-header .elementor-section-wrap,footer .elementor-section-wrap,.elementor-location-footer .elementor-section-wrap,body.elementor-editor-active .elementor-section-wrap,.tmt-navbar-wrapper .elementor-section-wrap {overflow: visible;}
            .menu ul,.meta-data,#comments ul,.language ul,.meta-data-item,.elementor-widget-tmt-social-share ul,.user-main,.tmt-category-list,.elementor-icon-list-items,.price ul,.products,.tmt-tabs-nav ul,.cart_list,.breadcrumb,.woocommerce-MyAccount-navigation ul {list-style: none;}
            .tmt-content figure:not(.gallery-item), #tab-description figure:not(.gallery-item) {max-width: 100% !important;}
            .my-account-login h2 {text-align:center;font-size:28px}
            .my-account-login .woocommerce-form.woocommerce-form-login.login {background:#fff;margin:20px auto;max-width:365px}
            .my-account-login .woocommerce .woocommerce-form-login .woocommerce-form-login__submit {float:left;margin-left:0;background:rgb(119,119,119);transition:all 0.3s ease;padding: 10px 19px;border-radius: 3px;color:#fff;font-size:13px}
            .my-account-login .woocommerce .woocommerce-form-login .woocommerce-form-login__submit:hover {background:#ff4c15;}
            
            /** === Sticky Setting  === **/
            .tmt-hidden-yes {display: none !important;}
            .is-sticky .tmt-hidden-yes {display: block !important;}
            .elementor-editor-active .tmt-hidden-yes {opacity:0.5;display: block !important;}


             /** === Single Blog  === **/
            .elementor-widget .elementor-icon-list-item, .elementor-widget .elementor-icon-list-item a {display: flex;font-size: inherit;align-items: var(--icon-vertical-align,center);}
            .elementor-widget .elementor-icon-list-icon + .elementor-icon-list-text {align-self: center;padding-left: 5px;padding-right: 5px;}
            .elementor-widget .elementor-icon-list-icon {display: flex;position: relative;top: var(--icon-vertical-offset,initial);}
            .elementor-icon i, .elementor-icon svg {width: 1em;height: 1em;position: relative;display: block;}
            .elementor-widget.elementor-align-right .elementor-icon-list-item, .elementor-widget.elementor-align-right .elementor-icon-list-item a {justify-content: flex-start;text-align: right;}
            .elementor-widget .elementor-icon-list-items.elementor-inline-items .elementor-icon-list-item::after {width: auto;left: auto;right: auto;position: relative;height: 100%;border-top: 0;border-bottom: 0;border-right: 0;border-left-width: 1px;border-style: solid;left: -8px;}
            .elementor-widget .elementor-icon-list-items.elementor-inline-items .elementor-icon-list-item {margin-right: 8px;margin-left: 8px;}
            .elementor-widget .elementor-icon-list-items.elementor-inline-items {display: flex;flex-wrap: wrap;margin-left: -8px;margin-right: -8px;}
            .elementor-social-icon {display: inline-flex !important;background-color: #69727d;align-items: center;justify-content: center;text-align: center;cursor: pointer;font-size: var(--icon-size,25px);line-height: var(--icon-size,25px);width: calc(var(--icon-size, 25px) + 2 * var(--icon-padding, .5em));height: calc(var(--icon-size, 25px) + 2 * var(--icon-padding, .5em));}
            .elementor-social-icon i {color: #fff;}
            .tmt-transition-slide-bottom {transform: translateY(100%);}
            .tmt-transition-fade, [class*="tmt-transition-scale"], [class*="tmt-transition-slide"] {transition: .3s ease-out;transition-property: all;transition-property: opacity,transform,filter;opacity: 0;}
            .tmt-transition-toggle:hover [class*="tmt-transition-slide"], .tmt-transition-toggle:focus, .tmt-transition-active.tmt-active {opacity: 1;transform: translate(0,0);}
            .tmt-text-center {text-align: center !important;}
            .mf-input-wrapper .mf-input-label, .mf-repeater-field-label {font-family: inherit !important;}
            .mf-input-wrapper .mf-input {text-align: inherit !important;}
            .elementor-widget.elementor-align-right .elementor-inline-items {justify-content: flex-start;}
            .elementor-widget.elementor-align-center .elementor-inline-items {justify-content: center;}
            .elementor-widget.elementor-align-left .elementor-inline-items {justify-content: flex-end;}

            /** === Swiper  === **/
            .tmt-slider-yes.swiper {position: static;}
            .tmt-slider-yes.swiper .swiper-wrapper {z-index: 0 !important;}

            /** === Newsletter - Metform  === **/
            .newsletter , .newsletter-en   {position: relative;}
            form .newsletter-en .metform-btn {position: absolute !important;right:5px;top:50%;transform: translateY(-50%);}
            body.rtl  .mf-input { text-align:right; }
            body.rtl  form .newsletter .metform-btn {position: absolute !important;left: 5px;top:50%;transform: translateY(-50%);}

            .metform-btn {display: flex !important;flex-direction: column !important;justify-content: center !important;align-items:center !important;}

            /** === Btn to top  === **/
            .btn-top a {display: block !important;}

            /** === Pagination  === **/
            .navigation.pagination .nav-links span , .navigation.pagination .nav-links a {display: inline-block !important;text-align: center;}

            /** === Tag Cloud Element === **/
            .tag-cloud a {display: inline-block;transition: .3s;}

            /** === Scroll To Top Element === **/
            #top {text-decoration: none;display:none;}
            .elementor-editor-active #top {display: inline-block !important;}

            /** === Post Info Element === **/
            .elementor-post-info__terms-list-item {width: auto !important;display: inline-block !important;}

            /** === Short Link Element === **/
            .short-link textarea {direction: ltr;height: 28px !important;white-space: nowrap;overflow: hidden;}

            /** === Image Gallery === **/
            .tmt-image-gallery .gallery{transition:all .5s ease-in-out;column-gap:30px;column-fill:initial;display:block}@media (max-width: 979px){.tmt-image-gallery .gallery{column-count:2!important}}@media (max-width: 480px){.tmt-image-gallery .gallery{column-count:1!important}}

            /** === Login Element === **/
            .drop-down-btn {position: relative;cursor: pointer}
            .drop-down-content {display: none;position: absolute;top: 40px;z-index: 999;}
            .right-0 {right:0;}.left-0 {left:0;}.center-50 {right:50%;transform: translateX(50%);}
            .user-login #loginform p {display: flex;flex-direction: column;margin-bottom: 15px}
            .user-login #loginform p:last-child {margin-bottom: 0}
            .register-btn {width: 100%;display: block;padding: 8px;color: #FFF;text-align: center;margin-top: 8px;background-color: #929292;}

            /** === Reset Element === **/
            .tmt-svg,.tmt-svg:not(.tmt-preserve) [fill*="#"]:not(.tmt-preserve) {fill: currentcolor}
            .tmt-svg:not(.tmt-preserve) [stroke*="#"]:not(.tmt-preserve) {stroke: currentcolor}
            .tmt-svg {transform: translate(0, 0)}
            .tmt-display-block {display: block !important;}
            [class*="tmt-position-top"],[class*="tmt-position-bottom"],[class*="tmt-position-left"],[class*="tmt-position-right"],[class*="tmt-position-center"]{position:absolute!important}
            .tmt-position-top{top:0;left:0;right:0}
            .tmt-position-bottom{bottom:0;left:0;right:0}
            .tmt-position-left{top:0;bottom:0;left:0}
            .tmt-position-right{top:0;bottom:0;right:0}
            .tmt-position-top-left{top:0;left:0}
            .tmt-position-top-right{top:0;right:0}
            .tmt-position-bottom-left{bottom:0;left:0}
            .tmt-position-bottom-right{bottom:0;right:0}
            .tmt-position-center{top:50%;left:50%;transform:translate(-50%,-50%);width:max-content;max-width:100%;box-sizing:border-box}
            [class*="tmt-position-center-left"],[class*="tmt-position-center-right"]{top:50%;transform:translateY(-50%)}
            .tmt-position-center-left{left:0}
            .tmt-position-center-right{right:0}


            /** === tmt-svg === **/
            .tmt-svg-cover{background-image:url(assets/images/thumbnail.jpg)}.tmt-svg-cover svg{display:block;width:100%;height:100%}.tmt-svg-cover svg path{stroke:#fff;stroke-width:5px}

            /** === TMT Video === **/
            .h_iframe-aparat_embed_frame{position:relative;}.aparat_embed_frame_span {display: block;padding-top: 57%}.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}

            /** === Gallery Icon === **/
            .gallery-item, .blocks-gallery-item {position: relative;background: #000}
            .gallery-item a:before, .blocks-gallery-item a:before {color: white;content: "\f002";font-family:"Font Awesome 5 Free";font-weight: 900;position: absolute;top: 50%;transform: translateX(50%) translateY(-50%);right: 50%;font-size: 36px;opacity: 0;transition: all .3s}
            .gallery-item:hover a:before, .blocks-gallery-item:hover a:before {opacity: 1}
            .gallery-item:hover a img, .blocks-gallery-item:hover a img {opacity:.2}

            /** === Mailpoet Element === **/
            .mailpoet_form {display: flex;flex-wrap: wrap;}
            .mailpoet_form_form {width: 100%;}
            form.mailpoet_form {padding: 0px!important;}

            .themento-infobox-cta-link {position: relative;}
            .tmt-bg-back-yes .themento-infobox-cta-link-style .themento-infobox-cta-link:before {content: "";position: absolute;width: 30%;
            height: 100%;transition: .5s;border-radius: 50px;}
            .tmt-bg-back-yes .themento-infobox-cta-link-style .themento-infobox-cta-link:hover:before {width: 100%;}
            .tmt-heading .heading {z-index: 1;}
            .drop-down-btn .card-count{display: flex;align-items: center;justify-content: center;}
            .testimonial-slider button {display: flex!important;}
            .themento-image-content .back-icon, .themento-image-content .container-icon {display: flex;align-items: center;
            justify-content: center;}
            .pagination a.next i, .pagination a.prev i {transform: rotate(180deg);}
            body.rtl .pagination a.next i ,body.rtl .pagination a.prev i{transform: rotate(0);}
            .drop-down-btn .card-count {display: flex;align-items: center;justify-content: center;}
            .drop-down-btn, .drop-down-btn .card-count {transition: .5s;}
        ';

        if (pll && $modules_option['language-switcher']) {
            $css .= '
            /** === Language Switcher Element === **/
            .flags li {margin:0;transition: all .3s}
            .flags li a {padding: 0 5px;transition: all .3s;}
            .flags li a img {display: inline-block;width: auto;height: auto}
            .language {position: relative;}
            .language.dropdown {z-index: 999;}
            .flags.dropdown {flex-direction: column;position: absolute;margin-top: -11px;top: 0;}
            .flags.dropdown li.current-lang:after {font-family: "Font Awesome 5 Free";content: "\f078";font-weight: 900;font-size: 10px;display: inline-block;}
            
            .flags.dropdown li a,.flags.dropdown li a:hover {border: none !important;}
            .flags.dropdown li:not(.current-lang), .flags.dropdown:hover li.current-lang:after {display:none;}
            .flags.dropdown li.current-lang {order: -1}
            .flags.dropdown:hover {padding: 5px 0;margin-top: -20px;}
            .flags.dropdown:hover li {display:block;padding:5px 0}
            .flag-style-circle li a img {width: 20px !important;height: 20px !important;border-radius: 50%;filter: contrast(120%) brightness(120%);}
            .flag-style-circle li a {display: flex}
            .flag-names-slug li span {text-transform: uppercase;}
            .flag-style-circle li.current-lang:after {display: none !important}
            .language .current-lang a {pointer-events: none;}
            ';
        }
        if ($modules_option['image-box']) {
            $css .= '
            /** === Image Box === **/
            .tmt-image-box .image-box-content {position: relative;display: block;overflow: hidden;}
            .tmt-image-box .image-box-img img {height: 100%;width: 100%;}
            .tmt-image-box .image-box-content .image-box-overlay {position: absolute;top: 0;right:0;bottom:0;left:0;width:100%;height: 100%;}
            .tmt-image-box .image-box-content .image-box-overlay .category {position: absolute;z-index: 1;}
            ';
        }
        if ($modules_option['search']) {
            $css .= '
            /** === Search Element === **/
            .search input[type="search"] {transition: all .3s;height: 100%;}
            .search button {cursor: pointer;background: transparent;transition: all .3s;height: 100%;}
            @media (max-width: 768px){
                .position-drop-down,.position-drop-down .elementor-column-wrap,.position-drop-down .elementor-widget-wrap,.position-drop-down .elementor-inner-section,.position-drop-down .elementor-container,.position-drop-down .elementor-row,.position-drop-down .elementor-column,.position-drop-down .elementor-widget-tmt-basket,.position-drop-down .elementor-widget-tmt-login,.position-drop-down .elementor-widget-tmt-search-form {position: static !important;}
                .position-drop-down .drop-down-content {width: 95% !important;margin-top: 20px;}
            }
            ';
        }
        if ($modules_option['navbar']) {
            $css .= '
            /** === NavBar Element === **/
            .main-menu {z-index: 9999;}
            .main-menu li {position: relative;}
            .main-menu li:not(.mega-menu) {transition: all 0.3s ease}
            .main-menu li a {display: inline-block;transition: all 0.3s ease}
            .main-menu li.main-mega-menu a {transition:none;position: relative;}
            .main-menu li a i {margin-right: 5px}
            body.rtl .main-menu li a i {margin-left: 5px;margin-right: 0}
            .main-menu li.menu-item-has-children::after {font-family: "Font Awesome 5 Free";font-weight: 900;font-size: 14px;display: inline-block;}
            .main-menu li.menu-item-has-children .sub-menu {position: absolute;z-index: 999;left: 0;visibility: hidden;opacity: 0;}
            .tmt-drop-top li.menu-item-has-children > .sub-menu,.tmt-drop2-top li.menu-item-has-children > .sub-menu .sub-menu {transform: translateY(40px);}
            .tmt-drop-bottom li.menu-item-has-children > .sub-menu,.tmt-drop2-bottom li.menu-item-has-children > .sub-menu .sub-menu {transform: translateY(-40px);}
            .tmt-drop-right li.menu-item-has-children > .sub-menu,.tmt-drop2-right li.menu-item-has-children > .sub-menu .sub-menu {transform: translateX(-40px);}
            .tmt-drop-left li.menu-item-has-children > .sub-menu,.tmt-drop2-left li.menu-item-has-children > .sub-menu .sub-menu {transform: translateX(40px);}
            .tmt-drop-2db li.menu-item-has-children > .sub-menu {max-height: 0px;-webkit-transform: perspective(600px) rotate3d(1,0,0,-90deg);transform-origin: 50% 0;-webkit-transform-origin: 50% 0;transition: all 0.7s cubic-bezier(.4,0,0,1);-webkit-transition: all 0.7s cubic-bezier(.4,0,0,1);-webkit-transform-style: preserve-3d;-webkit-backface-visibility: hidden;}
            .tmt-drop-2db li.menu-item-has-children:hover > .sub-menu {max-height: 1000px;transform: perspective(600px) rotate3d(0,0,0,0);-webkit-transform: perspective(600px) rotate3d(0,0,0,0);}
            .main-menu li.menu-item-has-children:hover > .sub-menu {transition-delay: 0.15s;transform: translate(0);opacity: 1;visibility: visible;transition: 0.2s cubic-bezier(0.25, 0.46, 0.45, 0.94) all 0.1s;}
            body.rtl .main-menu li .sub-menu {right: 0;left: auto}
            .main-menu li .sub-menu li a {display: block;}
            .main-menu .sub-menu li.menu-item-has-children .sub-menu {left: 100%;top:0;}
            body.rtl .main-menu .sub-menu .sub-menu {right: 100%;left:auto}
            .main-menu .sub-menu > li.menu-item-has-children::after {position: absolute;right:0;z-index: 1;top:0}
            body.rtl .main-menu .sub-menu > li.menu-item-has-children::after {right:auto;left: 0}
            .bars {display: none;cursor: pointer;}
            .main-menu .main-mega-menu .sub-menu {min-width: 100%;}
            .main-menu li.main-mega-menu .sub-menu li a {display: inherit;}
            .main-menu .main-mega-menu, .main-menu .main-mega-menu li {position: static;}
            .position-menu > .elementor-column,.position-menu > .elementor-column > .elementor-column-wrap,.position-menu > .elementor-column > .elementor-widget-wrap,.position-menu > .elementor-column > .elementor-widget-wrap > .elementor-widget,.position-menu > .elementor-column > .elementor-column-wrap > .elementor-widget-wrap,.position-menu > .elementor-column > .elementor-column-wrap > .elementor-widget-wrap > .elementor-widget-tmt-navbar {position: static !important;}
            .tmt-icon-f107.main-menu li.menu-item-has-children:after {content: "\f107";}
            .tmt-icon-f067.main-menu li.menu-item-has-children:after {content: "\f067";}
            .tmt-icon-f150.main-menu li.menu-item-has-children:after {content: "\f150";}
            .tmt-icon-f13a.main-menu li.menu-item-has-children:after {content: "\f13a";}
            .tmt-icon-f103.main-menu li.menu-item-has-children:after {content: "\f103";}
            .tmt-icon-f078.main-menu li.menu-item-has-children:after {content: "\f078";}
            .tmt-icon-f0dd.main-menu li.menu-item-has-children:after {content: "\f0dd";}
            @media (max-width: 1024px) {
                .bars {display:inline-block;text-align: center;}
                .responsive-fix .open-menu nav.menu {background: #000c;width: 100%;height: 100%;position: fixed;right: 0;top: 0;transition: .3s;z-index: 9999;}
                .responsive-fix .main-menu {position: fixed;right: 0;top: 0;z-index: 9999;width: 70%;height: 100%;flex-direction: column;justify-content: flex-start !important;visibility: hidden;opacity: 0;transition: 0.3s;transform: translateX(100%) !important;}
                .responsive-fix .open-menu .main-menu {visibility: visible;opacity: 1;height: 100%;transition: .3s;transform: translateX(0) !important;overflow-y: auto;}
                .responsive-fix .open-menu .bars {right:70%;position: fixed;top: 20px;z-index: 99999;margin: 0 10px;}
                .open-position-left.responsive-fix .main-menu {right: auto;left: 0;transform: translateX(-100%) !important;}
                .open-position-left.responsive-fix .open-menu .main-menu {transform: translateX(0) !important;}
                .open-position-left.responsive-fix .open-menu .bars {right: auto;left:70%;}
                .responsive-under nav.menu {position: absolute;z-index: 99999;width: 100%;visibility: hidden;opacity: 0;right: 0;padding: 10px;}
                .responsive-under .open-menu nav.menu {visibility: visible;opacity: 1;}
                .responsive-under .main-menu {flex-direction: column;height: 100%;transition: all .5s ease-in;overflow: hidden;transform: scaleY(0);transition: all .5s ease-in-out;transform-origin: left top;}
                .responsive-under .open-menu .main-menu {transform: scaleY(1);}
                .main-menu li.mega-menu .elementor-element > .elementor-container {width: 100%;}
                .main-menu li .sub-menu {min-width:95%;position:relative;right: 0 !important;left: auto !important;}
                .main-menu li.menu-item-has-children .sub-menu,.main-menu li.menu-item-has-children .sub-menu .sub-menu,.main-menu li.menu-item-has-children:hover .sub-menu {visibility: hidden;padding-top: 0;transform: translate(0);opacity: 0;position:relative;height: 0;position: absolute;transition: none;}
                .open-menu .fa-bars::before {content: "\f00d" !important;}
                .main-menu li .sub-menu li a {display: inline-block}
                .main-menu li.menu-item-has-children::after,.main-menu .sub-menu > li.menu-item-has-children::after {position: absolute;right: 20px !important;top: 12px;transform: none !important;}
                body.rtl .main-menu li.menu-item-has-children::after,body.rtl .main-menu .sub-menu > li.menu-item-has-children::after {right: auto !important;left: 20px !important}
                .main-menu .main-mega-menu, .main-menu .main-mega-menu li {position: relative;}
                .open-menu .open-sub-menu > .sub-menu {visibility: visible !important;opacity: 1 !important;height:auto !important;position: relative !important;transition: height 0s 3s, opacity 300ms ease-in-out !important;}
                .main-menu > li:hover,.main-menu > li.current-menu-item {background: none !important}
                .main-menu li.menu-item-has-children::after {width: 22px;height: 22px;text-align: center}
                .tmt-sticky-yes .responsive-under .menu {overflow-y: auto;max-height: 600px;}
                .main-mega-menu .sub-menu {min-width: auto !important;}
                .tmt-navbar-wrapper.open-menu .mega-menu .elementor-column {width: 100% !important;}
            }
            .menu > .main-menu > li > a > span > hr , .menu > .main-menu > li.current-menu-item > a > span > hr {position: absolute;bottom: 0px;width: 0;transition: all 0.3s linear;-webkit-transition: all 0.3s linear;-moz-transition: all 0.3s linear;-o-transition: all 0.3s linear;-ms-transition: all 0.3s linear;}
            .menu > .main-menu > li > a > span > .line1 , .menu > .main-menu > li.current-menu-item > a > span > .line1 {right:0}
            .menu > .main-menu > li > a > span > .line2 , .menu > .main-menu > li.current-menu-item > a > span > .line2 {left:0;}
            ';
        }
        if ($modules_option['post-list']) {
            $css .= '
            /** === Post List Element === **/
            .post-list .list-item {width: 100%;transition:0.3s;}
            .post-list .list-image a {position: relative;display:inline-block;}
            .post-list .list-image i,.post-list .list-image svg {opacity:0;transition:0.3s;position: absolute;width: 100%;height: 100%;top: 0;right: 0;background-color: rgba(0,0,0,.5);display: flex;align-items: center;justify-content: center;font-size: 20px;}
            .post-list .list-item:hover .list-image i,post-list .list-item:hover .list-image svg {opacity:1;}
            .post-list .list-image img {height: 100%;}
            .post-list .list-title {font-size: 16px;overflow: hidden;}
            .meta-data i { margin-left: 5px}
            ';
        }
        if ($modules_option['business-hours']) {
            $css .= '
           /** === Business Hours Element === **/
            .business-hours .business-hour span {white-space: nowrap}
            .business-hours .business-hour span:first-child {padding-right: 10px}
            .business-hours .business-hour span:last-child {padding-left: 10px}
            body.rtl .business-hours .business-hour span:first-child {padding-left: 10px;padding-right:0}
            body.rtl .business-hours .business-hour span:last-child {padding-right: 10px;padding-left:0}
            .business-hours .business-hour hr {width:100%;transition: .3s;}
            ';
        }
        if ($modules_option['comments']) {
            $css .= '
           /** === Comment Element === **/
            .comment-list hr {width: 100%; height: 1px;}
            .comment-form {display: flex;flex-wrap: wrap}
            .comment-form .comment-notes,.comment-form input {width: 100%}
            input.submit {cursor: pointer}
            .comment-form-comment, .comment-form-comment textarea,.cms5 .comment-form-comment textarea {width: 100% !important;height: 200px !important;}
            .cms1 .comment-form-author,.cms1 .comment-form-email,.cms1 .form-submit,.cms2 .comment-form-author,.cms2 .comment-form-email,.cms2 .form-submit,.cms3 .form-submit,.cms4 .form-submit {width: 33.3333%}
            .cms2 .comment-notes,.cms4 .comment-notes {order: 1;}
            .cms2 .comment-form-author,.cms4 .comment-form-author {order: 2;}
            .cms2 .comment-form-email,.cms4 .comment-form-email {order: 3;}
            .cms2 .form-submit,.cms4 .comment-form-comment {order: 4;}
            .cms2 .comment-form-comment,.cms4 .form-submit {order: 5;}
            .cms4 .comment-form-topic {order: 3}
            .cms3 .comment-form-author,.cms3 .comment-form-email,.cms4 .comment-form-author,.cms4 .comment-form-email,.cms5 .comment-form-comment,.cms5 .comment-form-author,.cms5 .comment-form-email,.cms5 .form-submit {width: 50% !important;}
            .cms5 .comment-form {display: block;flex-wrap: unset;}
            .cms5 .comment-form-comment {float: right}
            .cms5 .comment-form-author,.cms5 .comment-form-email,.cms5 .form-submit {float: left}
            .comment-author {display: flex;align-items: center;}
            .comment-meta {display: flex;align-items: center;justify-content: space-between;}
            .reply a {display: inline-block;}
            @media (max-width: 480px) {
                .comment-meta {flex-direction: column;align-items: flex-start;}
                .comment-meta .comment-metadata {margin-top: 20px;}
            }
            ';
        }
        if ($modules_option['price']) {
            $css .= '
           /** === Price Element === **/
            .price .item {border-radius: 10px;overflow: hidden;box-shadow: 0 0 4px #e9e9e9;}
            .price .item .image-price{width: 54px;text-align: center;display: inline-block;}
            .price .item .image-price img , .price .item .image-price svg {width: 100%;height: 100%;}
            .price .item .price-header {background-color: #f5f5f5;padding: 20px 0;min-height: 125px;}
            .price .item .price-header .title{font-weight: bold;display: block;margin-top: 5px;}
            .price .item ul, .price .item footer {padding: 10px 0;}
            .price .item > div ul li{padding: 5px 0;}
            .price .item > div .price-item {color: var(--purple);display: block;margin: 10px 0 20px 0;font-weight: 500;}
            .price .item > div .link-price {border-radius: 25px;padding: 5px 20px;border: 1px solid red;color: red;font-weight: 600;display: inline-block;}
            .price .ft-text {margin-top: 20px}
            .price .item:hover .price-header {background-color: red;}
            .price .item:hover .link-price{color: #FFFFFF;background-color: red;border: 1px solid transparent;}
            .price .item:hover img{filter: brightness(0) invert(1);}
            .price .item:hover .price-header {color: #ffffff;}
            ';
        }
        if ($modules_option['post-grid']) {
            $css .= '
            /** === Post Type Daris Blog & Project === **/
            /* style-2 */
            .projects .card {position: relative;overflow: hidden;transition: all 0.3s;}
            .projects .card .card-img {position: relative;cursor: pointer;transition: all 0.3s;}
            .projects .card .card-img::before {content: "";display: block;position: absolute;top:0;right: 0;left:0;bottom: 0;opacity: 0;transition: all 0.3s;}
            .elementor-widget-tmt-post-grid.hover-enabled-yes .projects .card:hover .card-img::before {opacity: 1;}
            .projects .card .card-img img {height: 100%;transition: all 0.3s;}
            .projects .card .term{position: absolute;}
            .elementor-widget-tmt-post-grid.hover-enabled-yes .projects .card:hover .card-img {position:absolute;top: 0;right: 0;width: 100%;height: 100%;transition: all 0.3s;}
            .elementor-widget-tmt-post-grid.hover-enabled-yes .projects .card:hover .card-footer {position:absolute;width:100%;right: 0;bottom: 0;transition: all 0.3s;}
            .elementor-widget-tmt-post-grid.hover-enabled-yes .projects .card:hover .card-footer .date ,.elementor-widget-tmt-post-grid.hover-enabled-yes  .projects .card:hover .card-footer .title-project {position: absolute;width: 100%;z-index: 3;transition: all 0.3s;}

            .elementor-widget-tmt-post-grid.hover-enabled-yes .projects .card:hover .title-project a{position: absolute;}
            
            ';
        }
        if ($modules_option['slider-member']) {
            $css .= '
            /** === Slider MEmber === **/
            .slider-card .tmt-member-icon i {vertical-align: middle !important;}
            .slider-card .tmt-member-icon {display: inline-block !important;vertical-align: middle !important;}
            .post-list .list-info .meta-data > li:last-child {border: 0 !important;}
            ';
        }
        if ($modules_option['slider']) {
            $css .= '
           /** === Slider Element === **/
            .tmt-slider-item {position: relative;display:none;cursor: grab;}
            .tmt-slider.slick-initialized .tmt-slider-item,.tmt-slider-item:first-child {display:block;}
            .tmt-slider-item img {width: 100%;height: 100%;}
            .tmt-slider-item .content {position: absolute;width: 100%;height: 100%;top: 0;right: 0;display: flex;flex-direction: column;justify-content: center;align-items: center;text-align: center}
            .tmt-slider-item .content > div > * {width: 100%;}
            .tmt-slider-item .content .slide-heading {-webkit-animation-duration: 1s;animation-duration: 1s;font-size: 35px;font-weight: 700;}
            .tmt-slider-item .content .slide-description {-webkit-animation-duration: 2s;animation-duration: 2s;font-size: 17px;}
            .tmt-slider-item .content .slide-button, .tmt-slider-item .content .slide-button-two {-webkit-animation-duration: 3s;animation-duration: 3s;}
            .tmt-slider-item .content .slide-button a, .tmt-slider-item .content .slide-button-two a {display: inline-block;font-size: 15px;text-align: center;transition: all .3s;border: 2px solid #FFF;}
            .tmt-slider-item > img {overflow: hidden;}
            ';
        }
        if ($modules_option['info-box']) {
            $css .= '
           /** === Info Box === **/
            .themento-icon-wrap .themento-icon{display:inline-block}.themento-module-content{transition:all .3s}.themento-infobox-link-type-module:hover,.themento-infobox-link-type-module:hover .themento-icon i{-webkit-transition:color .2s;transition:color .2s}.themento-imgicon-style-circle .themento-icon-wrap .themento-icon,.themento-imgicon-style-circle .themento-image .themento-image-content{-webkit-border-radius:100%;border-radius:100%}.themento-infobox-photo-left-title .themento-module-content.themento-imgicon-wrap,.themento-infobox-photo-right-title .themento-module-content.themento-imgicon-wrap,.themento-infobox-photo-left .themento-module-content.themento-imgicon-wrap,.themento-infobox-photo-right .themento-module-content.themento-imgicon-wrap{-js-display:flex;display:-webkit-box;display:-webkit-flex;display:-moz-box;display:-ms-flexbox;display:flex;-webkit-flex-shrink:0;-ms-flex-negative:0;flex-shrink:0}.themento-infobox-photo-left-title .themento-infobox-title-wrap,.themento-infobox-photo-right-title .themento-infobox-title-wrap,.themento-infobox-photo-left .themento-infobox-title-wrap,.themento-infobox-photo-right .themento-infobox-title-wrap{-webkit-box-flex:1;-webkit-flex-grow:1;-moz-box-flex:1;-ms-flex-positive:1;flex-grow:1}.themento-infobox-photo-left-title.themento-infobox-image-valign-middle .themento-infobox-title-wrap,.themento-infobox-photo-right-title.themento-infobox-image-valign-middle .themento-infobox-title-wrap,.themento-infobox-icon-left-title.themento-infobox-image-valign-middle .themento-infobox-title-wrap,.themento-infobox-icon-right-title.themento-infobox-image-valign-middle .themento-infobox-title-wrap,.themento-infobox-image-valign-middle .themento-imgicon-wrap,.themento-infobox-icon-left.themento-infobox-image-valign-middle .themento-infobox-content,.themento-infobox-icon-right.themento-infobox-image-valign-middle .themento-infobox-content,.themento-infobox-photo-left.themento-infobox-image-valign-middle .themento-infobox-content,.themento-infobox-photo-right.themento-infobox-image-valign-middle .themento-infobox-content{-ms-flex-item-align:center;-webkit-align-self:center;align-self:center}.themento-infobox .themento-infobox-content{width:100%}.themento-infobox-left{text-align:left;-webkit-box-pack:start;-ms-flex-pack:start;-webkit-justify-content:flex-start;-moz-box-pack:start;justify-content:flex-start}.themento-infobox-center{text-align:center;-webkit-box-pack:center;-ms-flex-pack:center;-webkit-justify-content:center;-moz-box-pack:center;justify-content:center}.themento-infobox-right{text-align:right;-webkit-box-pack:end;-ms-flex-pack:end;-webkit-justify-content:flex-end;-moz-box-pack:end;justify-content:flex-end}.themento-infobox-left-right-wrap{width:100%}.themento-infobox-icon-above-title .themento-infobox-left-right-wrap,.themento-infobox-icon-below-title .themento-infobox-left-right-wrap,.themento-infobox-photo-above-title .themento-infobox-left-right-wrap,.themento-infobox-photo-below-title .themento-infobox-left-right-wrap{display:block;min-width:100%;width:100%}.themento-infobox-icon-left-title .themento-icon-wrap,.themento-infobox-icon-left .themento-icon-wrap,.themento-infobox-photo-left-title .themento-imgicon-wrap .themento-image-content,.themento-infobox-photo-left .themento-imgicon-wrap .themento-image-content{margin-right:10px}.themento-infobox-icon-right-title .themento-icon-wrap,.themento-infobox-icon-right .themento-icon-wrap,.themento-infobox-photo-right-title .themento-imgicon-wrap .themento-image-content,.themento-infobox-photo-right .themento-imgicon-wrap .themento-image-content{margin-left:10px}.themento-infobox-icon-left .themento-infobox-left-right-wrap,.themento-infobox-icon-right .themento-infobox-left-right-wrap,.themento-infobox-photo-left .themento-infobox-left-right-wrap,.themento-infobox-photo-right .themento-infobox-left-right-wrap,.themento-infobox-icon-left-title .left-title-image,.themento-infobox-icon-right-title .right-title-image,.themento-infobox-photo-left-title .left-title-image,.themento-infobox-photo-right-title .right-title-image{display:-webkit-box;display:-ms-flexbox;-js-display:flex;display:-webkit-flex;display:-moz-box;display:flex;flex-direction:row-reverse}.themento-infobox-icon-right .themento-infobox-left-right-wrap,.themento-infobox-icon-right-title .right-title-image,.themento-infobox-photo-right-title .right-title-image,.themento-infobox-photo-right .themento-infobox-left-right-wrap{-webkit-box-pack:end;-ms-flex-pack:end;-webkit-justify-content:flex-end;-moz-box-pack:end;justify-content:flex-end;flex-direction:row-reverse}.themento-infobox-photo-above-title .themento-imgicon-wrap{display:block}.themento-infobox-photo-below-title .themento-imgicon-wrap{display:block;margin:10px 0 15px}.themento-icon-wrap .themento-icon i{height:auto;width:auto}.themento-imgicon-wrap .themento-image-content{display:inline-block;line-height:0;position:relative;max-width:100%}.themento-imgicon-wrap .themento-image-content img{display:inline;/*height:auto!important;*/max-width:100%;width:auto;-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;-webkit-border-radius:inherit;border-radius:inherit}.themento-imgicon-wrap .themento-image-crop-circle img{-webkit-border-radius:100%;border-radius:100%}.themento-imgicon-wrap .themento-image-crop-square img{-webkit-border-radius:0;border-radius:0}.themento-infobox-module-link{position:absolute;width:100%;height:100%;left:0;top:0;bottom:0;right:0;z-index:4}.elementor-edit-mode .themento-infobox-module-link{z-index:2}.themento-infobox-link-icon-after{margin-left:5px;margin-right:0}.themento-infobox-link-icon-before{margin-left:0;margin-right:5px}.themento-infobox-link-icon{-webkit-transition:all 200ms linear;transition:all 200ms linear}.themento-infobox-link-icon i {transform: translateY(1px)}.themento-infobox-link-type-module .themento-infobox{position:relative}@media only screen and (max-width: 976px){.themento-infobox-stacked-tablet .themento-infobox-left-right-wrap .themento-imgicon-wrap{padding:0;margin-bottom:20px}.themento-infobox-stacked-tablet.themento-reverse-order-tablet .themento-infobox-left-right-wrap{display:-webkit-inline-box;display:-ms-inline-flexbox;-js-display:inline-flex;display:-webkit-inline-flex;display:-moz-inline-box;display:inline-flex;-webkit-box-orient:vertical;-webkit-box-direction:reverse;-ms-flex-direction:column-reverse;-webkit-flex-direction:column-reverse;-moz-box-orient:vertical;-moz-box-direction:reverse;flex-direction:column-reverse}.themento-infobox.themento-infobox-stacked-tablet .themento-infobox-left-right-wrap .themento-infobox-content,.themento-infobox.themento-infobox-stacked-tablet .themento-infobox-left-right-wrap .themento-imgicon-wrap{display:block;width:100%;text-align:center}.themento-infobox.themento-infobox-stacked-tablet .themento-infobox-left-right-wrap .themento-imgicon-wrap{margin-left:0;margin-right:0}.themento-infobox-stacked-tablet .themento-infobox-left-right-wrap{display:inline-block}.themento-infobox-icon-left-title.themento-infobox-stacked-tablet .themento-imgicon-wrap,.themento-infobox-icon-left.themento-infobox-stacked-tablet .themento-imgicon-wrap,.themento-infobox-photo-left-title.themento-infobox-stacked-tablet .themento-image-content,.themento-infobox-photo-left.themento-infobox-stacked-tablet .themento-image-content{margin-right:0}.themento-infobox-icon-right-title.themento-infobox-stacked-tablet .themento-imgicon-wrap,.themento-infobox-icon-right.themento-infobox-stacked-tablet .themento-imgicon-wrap,.themento-infobox-photo-right-title.themento-infobox-stacked-tablet .themento-image-content,.themento-infobox-photo-right.themento-infobox-stacked-tablet .themento-image-content{margin-left:0}}@media screen and (max-width: 767px){.themento-infobox-stacked-mobile .themento-infobox-left-right-wrap .themento-imgicon-wrap{padding:0;margin-bottom:20px}.themento-infobox-stacked-mobile.themento-reverse-order-mobile .themento-infobox-left-right-wrap{display:-webkit-inline-box;display:-ms-inline-flexbox;-js-display:inline-flex;display:-webkit-inline-flex;display:-moz-inline-box;display:inline-flex;-webkit-box-orient:vertical;-webkit-box-direction:reverse;-ms-flex-direction:column-reverse;-webkit-flex-direction:column-reverse;-moz-box-orient:vertical;-moz-box-direction:reverse;flex-direction:column-reverse}.themento-infobox.themento-infobox-stacked-mobile .themento-infobox-left-right-wrap .themento-infobox-content,.themento-infobox.themento-infobox-stacked-mobile .themento-infobox-left-right-wrap .themento-imgicon-wrap{display:block;width:100%;text-align:center}.themento-infobox.themento-infobox-stacked-mobile .themento-infobox-left-right-wrap .themento-imgicon-wrap{margin-left:0;margin-right:0}.themento-infobox-stacked-mobile .themento-infobox-left-right-wrap{display:inline-block}.themento-infobox-icon-left-title.themento-infobox-stacked-mobile .themento-imgicon-wrap,.themento-infobox-icon-left.themento-infobox-stacked-mobile .themento-imgicon-wrap,.themento-infobox-photo-left-title.themento-infobox-stacked-mobile .themento-image-content,.themento-infobox-photo-left.themento-infobox-stacked-mobile .themento-image-content{margin-right:0}.themento-infobox-icon-right-title.themento-infobox-stacked-mobile .themento-imgicon-wrap,.themento-infobox-icon-right.themento-infobox-stacked-mobile .themento-imgicon-wrap,.themento-infobox-photo-right-title.themento-infobox-stacked-mobile .themento-image-content,.themento-infobox-photo-right.themento-infobox-stacked-mobile .themento-image-content{margin-left:0}}.themento-infobox-link-type-module:hover .elementor-animation-grow{-webkit-transform:scale(1.1);-ms-transform:scale(1.1);transform:scale(1.1)}.themento-infobox-link-type-module:hover .elementor-animation-shrink{-webkit-transform:scale(0.9);-ms-transform:scale(0.9);transform:scale(0.9)}.themento-infobox-link-type-module:hover .elementor-animation-pulse{-webkit-animation-name:elementor-animation-pulse;animation-name:elementor-animation-pulse;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite}.themento-infobox-link-type-module:hover .elementor-animation-pulse-grow{-webkit-animation-name:elementor-animation-pulse-grow;animation-name:elementor-animation-pulse-grow;-webkit-animation-duration:.3s;animation-duration:.3s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-direction:alternate;animation-direction:alternate}.themento-infobox-link-type-module:hover .elementor-animation-pulse-shrink{-webkit-animation-name:elementor-animation-pulse-shrink;animation-name:elementor-animation-pulse-shrink;-webkit-animation-duration:.3s;animation-duration:.3s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite;-webkit-animation-direction:alternate;animation-direction:alternate}.themento-infobox-link-type-module:hover .elementor-animation-push{-webkit-animation-name:elementor-animation-push;animation-name:elementor-animation-push;-webkit-animation-duration:.3s;animation-duration:.3s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-pop{-webkit-animation-name:elementor-animation-pop;animation-name:elementor-animation-pop;-webkit-animation-duration:.3s;animation-duration:.3s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-bounce-in{-webkit-transform:scale(1.2);-ms-transform:scale(1.2);transform:scale(1.2);-webkit-transition-timing-function:cubic-bezier(0.47,2.02,0.31,-0.36);transition-timing-function:cubic-bezier(0.47,2.02,0.31,-0.36)}.themento-infobox-link-type-module:hover .elementor-animation-bounce-out{-webkit-transform:scale(0.8);-ms-transform:scale(0.8);transform:scale(0.8);-webkit-transition-timing-function:cubic-bezier(0.47,2.02,0.31,-0.36);transition-timing-function:cubic-bezier(0.47,2.02,0.31,-0.36)}.themento-infobox-link-type-module:hover .elementor-animation-rotate{-webkit-transform:rotate(4deg);-ms-transform:rotate(4deg);transform:rotate(4deg)}.themento-infobox-link-type-module:hover .elementor-animation-grow-rotate{-webkit-transform:scale(1.1) rotate(4deg);-ms-transform:scale(1.1) rotate(4deg);transform:scale(1.1) rotate(4deg)}.themento-infobox-link-type-module:hover .elementor-animation-float{-webkit-transform:translateY(-8px);-ms-transform:translateY(-8px);transform:translateY(-8px)}.themento-infobox-link-type-module:hover .elementor-animation-sink{-webkit-transform:translateY(8px);-ms-transform:translateY(8px);transform:translateY(8px)}.themento-infobox-link-type-module:hover .elementor-animation-bob{-webkit-animation-name:elementor-animation-bob-float,elementor-animation-bob;animation-name:elementor-animation-bob-float,elementor-animation-bob;-webkit-animation-duration:.3s,1.5s;animation-duration:.3s,1.5s;-webkit-animation-delay:0s,.3s;animation-delay:0s,.3s;-webkit-animation-timing-function:ease-out,ease-in-out;animation-timing-function:ease-out,ease-in-out;-webkit-animation-iteration-count:1,infinite;animation-iteration-count:1,infinite;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards;-webkit-animation-direction:normal,alternate;animation-direction:normal,alternate}.themento-infobox-link-type-module:hover .elementor-animation-hang{-webkit-animation-name:elementor-animation-hang-sink,elementor-animation-hang;animation-name:elementor-animation-hang-sink,elementor-animation-hang;-webkit-animation-duration:.3s,1.5s;animation-duration:.3s,1.5s;-webkit-animation-delay:0s,.3s;animation-delay:0s,.3s;-webkit-animation-timing-function:ease-out,ease-in-out;animation-timing-function:ease-out,ease-in-out;-webkit-animation-iteration-count:1,infinite;animation-iteration-count:1,infinite;-webkit-animation-fill-mode:forwards;animation-fill-mode:forwards;-webkit-animation-direction:normal,alternate;animation-direction:normal,alternate}.themento-infobox-link-type-module:hover .elementor-animation-skew{-webkit-transform:skew(-10deg);-ms-transform:skew(-10deg);transform:skew(-10deg)}.themento-infobox-link-type-module:hover .elementor-animation-skew-forward{-webkit-transform:skew(-10deg);-ms-transform:skew(-10deg);transform:skew(-10deg)}.themento-infobox-link-type-module:hover .elementor-animation-skew-backward{-webkit-transform:skew(10deg);-ms-transform:skew(10deg);transform:skew(10deg)}.themento-infobox-link-type-module:hover .elementor-animation-wobble-vertical{-webkit-animation-name:elementor-animation-wobble-vertical;animation-name:elementor-animation-wobble-vertical;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-wobble-horizontal{-webkit-animation-name:elementor-animation-wobble-horizontal;animation-name:elementor-animation-wobble-horizontal;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-wobble-to-bottom-right{-webkit-animation-name:elementor-animation-wobble-to-bottom-right;animation-name:elementor-animation-wobble-to-bottom-right;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-wobble-to-top-right{-webkit-animation-name:elementor-animation-wobble-to-top-right;animation-name:elementor-animation-wobble-to-top-right;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-wobble-top{-webkit-animation-name:elementor-animation-wobble-top;animation-name:elementor-animation-wobble-top;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-wobble-bottom{-webkit-animation-name:elementor-animation-wobble-bottom;animation-name:elementor-animation-wobble-bottom;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-wobble-skew{-webkit-animation-name:elementor-animation-wobble-skew;animation-name:elementor-animation-wobble-skew;-webkit-animation-duration:1s;animation-duration:1s;-webkit-animation-timing-function:ease-in-out;animation-timing-function:ease-in-out;-webkit-animation-iteration-count:1;animation-iteration-count:1}.themento-infobox-link-type-module:hover .elementor-animation-buzz{-webkit-animation-name:elementor-animation-buzz;animation-name:elementor-animation-buzz;-webkit-animation-duration:.15s;animation-duration:.15s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:infinite;animation-iteration-count:infinite}.themento-infobox-link-type-module:hover .elementor-animation-buzz-out{-webkit-animation-name:elementor-animation-buzz-out;animation-name:elementor-animation-buzz-out;-webkit-animation-duration:.75s;animation-duration:.75s;-webkit-animation-timing-function:linear;animation-timing-function:linear;-webkit-animation-iteration-count:1;animation-iteration-count:1}
            ';
        }
        if ($modules_option['info-box-advanced']) {
            $css .= '
            /** === Info Box Advanced === **/
            .tmt-advanced-icon-box-icon:before {position: absolute;content: "";top: 0;right: 0;z-index:99;}
            .tmt-advanced-icon-box-icon:after {position: absolute;content: "";top: 0;left:0;}
            .tmt-advanced-icon-box-icon>:last-child:before{position: absolute;content: "";bottom: 0;left: 0;}
            .tmt-advanced-icon-box-icon>:last-child:after{position: absolute;content: "";bottom:0;right: 0; }
            .tmt-advanced-icon-box-icon {display:flex!important;justify-content:center}
            .tmt-advanced-icon-box-icon .tmt-icon-wrapper {position:relative;display:flex;justify-content: center;
            align-items: center;}
            .tmt-advanced-icon-box-icon .tmt-icon-wrapper:before {content:"";position:absolute;top:0;bottom:0;right:0;left:0;width:auto;height:auto;z-index:-3;}
            .tmt-button-icon-align-left{float:left} .tmt-button-icon-align-right{float:right}.tmt-advanced-icon-box .tmt-icon-wrapper{display:inline-block;line-height:1;transition:all 350ms cubic-bezier(.24, .85, .58, 1);color:#818a91;font-size:48px;width:48px;height:auto;text-align:center;position:relative;box-sizing:content-box}.tmt-advanced-icon-box .tmt-icon-wrapper:hover{color:#818a91}.tmt-advanced-icon-box .tmt-icon-wrapper i,.tmt-advanced-icon-box .tmt-icon-wrapper svg{position:relative;display:block;transition:transform 350ms cubic-bezier(.24, .85, .58, 1);z-index:1}.tmt-advanced-icon-box .tmt-icon-wrapper i:before,.tmt-advanced-icon-box .tmt-icon-wrapper img:before{position:absolute;left:50%;transform:translateX(-50%)}.tmt-advanced-icon-box .tmt-icon-wrapper i{width:1em;height:1em}.tmt-advanced-icon-box .tmt-advanced-icon-box-readmore{display:inline-block}.tmt-advanced-icon-box .tmt-advanced-icon-box-readmore svg{width:1em}.tmt-advanced-icon-box .tmt-title-separator-wrapper{margin-bottom:24px;line-height:1}.tmt-advanced-icon-box .tmt-title-separator-wrapper>*{height:auto}.tmt-advanced-icon-box .tmt-title-separator-wrapper>svg [stroke*="#"]{stroke:currentcolor}.tmt-advanced-icon-box .tmt-title-separator{border-top:4px solid rgb(0, 0, 0);display:inline-block;width:100px}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-none .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{opacity:1}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-a .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;transition:all .3s ease-out;width:100%;height:100%;z-index:-1;opacity:0;transform:scale(0);top:0;left:0;border-radius:200px}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-a .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-a .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{opacity:1;transform:scale(1.5)}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-g .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;transition:all .3s ease-out;width:0;height:103%;top:50%;left:50%;z-index:-1;opacity:0;transform:translateX(-50%) translateY(-50%)}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-g .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-g .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{width:90%;opacity:1}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-b .tmt-advanced-icon-box .tmt-icon-wrapper{overflow:hidden}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-b .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;transition:all .3s ease-out;width:100%;height:0;top:50%;left:50%;opacity:0;z-index:-1;transform:translateX(-50%) translateY(-50%) rotate(45deg)}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-b .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-b .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{height:260%;opacity:1}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-c .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;transition:all .3s ease-out;width:101%;height:0;top:50%;left:50%;opacity:0;z-index:-1;transform:translateX(-50%) translateY(-50%)}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-c .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-c .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{height:75%;opacity:1}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-d .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;top:0;left:0;width:150%;height:100%;z-index:-1;transform:rotate3d(0, 0, 1, -45deg) translate3d(0, -3em, 0);transform-origin:0 100%;transition:transform .3s,opacity .3s,background-color .3s}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-d .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-d .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{opacity:1;transform:rotate3d(0, 0, 1, 0deg);transition-timing-function:cubic-bezier(.2, 1, .3, 1)}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-e .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;transition:all .3s ease-out;width:100%;height:0;top:0;left:0;z-index:-1}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-e .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-e .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{height:100%}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-f .tmt-advanced-icon-box .tmt-icon-wrapper:after{content:"";position:absolute;z-index:-1;transition:all .3s ease-out;background:#666;width:0;height:100%;top:0;left:0}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-f .tmt-advanced-icon-box:hover .tmt-icon-wrapper{background-color:transparent}.elementor-widget-tmt-advanced-icon-box.tmt-icon-effect-f .tmt-advanced-icon-box:hover .tmt-icon-wrapper:after{width:100%}.elementor-widget-tmt-advanced-icon-box.tmt-readmore-on-hover-yes .tmt-advanced-icon-box .tmt-advanced-icon-box-readmore{margin-top:26px;position:absolute;transform:translate(-50%, 0);opacity:0;transition:opacity 350ms cubic-bezier(.24, .85, .58, 1)}.elementor-widget-tmt-advanced-icon-box.tmt-readmore-on-hover-yes .tmt-advanced-icon-box:hover .tmt-advanced-icon-box-readmore{opacity:1}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box{text-align:center}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box-title{font-weight:700;font-size:1.25rem;transition: all .3s}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box-title a{color:inherit}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box-description{margin-bottom:20px;transition: all .3s}.elementor-widget-tmt-advanced-icon-box.tmt-global-link-yes .tmt-advanced-icon-box:hover{cursor:pointer}.elementor-widget-tmt-advanced-icon-box.tmt-title-link-yes .tmt-advanced-icon-box-title:hover{cursor:pointer}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box{text-align:center}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box-title{font-weight:700;font-size:1.25rem}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box-title a{color:inherit}.elementor-widget-tmt-advanced-icon-box .tmt-advanced-icon-box-description{margin-bottom:20px}
            .elementor-widget-tmt-advanced-icon-box.elementor-position-left .tmt-advanced-icon-box{display:flex;text-align:left;flex-direction:row}
            .elementor-widget-tmt-advanced-icon-box .tmt-indicator-svg{position:absolute;left:100%;top:0;width:150px;height:auto;transform-origin:center center;transform:translateX(0);z-index:10}@media (min-width:768px){.elementor-widget-tmt-advanced-icon-box.elementor-position-left .tmt-advanced-icon-box-icon{flex:0 0 auto}.elementor-widget-tmt-advanced-icon-box.elementor-position-right .tmt-advanced-icon-box{display:flex;text-align:right;flex-direction:row-reverse}.elementor-widget-tmt-advanced-icon-box.elementor-position-right .tmt-advanced-icon-box-icon{flex:0 0 auto}.elementor-widget-tmt-advanced-icon-box.elementor-position-top .tmt-advanced-icon-box-img{margin:auto}.elementor-widget-tmt-advanced-icon-box.elementor-position-top .tmt-advanced-icon-box-icon{display:inline-block}.elementor-widget-tmt-advanced-icon-box.elementor-vertical-align-top .tmt-advanced-icon-box{align-items:flex-start}.elementor-widget-tmt-advanced-icon-box.elementor-vertical-align-middle .tmt-advanced-icon-box{align-items:center}.elementor-widget-tmt-advanced-icon-box.elementor-vertical-align-bottom .tmt-advanced-icon-box{align-items:flex-end}.elementor-widget-tmt-advanced-icon-box .tmt-indicator-svg svg{height:auto;width:100%}}.tmt-link{cursor: pointer}
            .tmt-advanced-icon-box-icon {position : relative;}
            .tmt-icon-wrapper img {width:100%}
            .tmt-advanced-icon-box-icon .tmt-icon-wrapper:before {content:"";position:absolute;top:0;bottom:0;right:0;left:0;width:auto;height:auto;z-index:-3}.l1,.l2,.l3,.l4 {position: absolute;z-index:1}.l1 {top: 0px;right: 0;}.l2 {top: 0;left: 0;}.l3 {bottom: 0;right: 0;}
            .l4 {bottom: 0;left: 0;}
            ';
        }
        if ($modules_option['heading']) {
            $css .= '
            /** === Heading Element === **/
            .tmt-heading hr,.tmt-heading img {display: inline-block;}
            .tmt-sh-background .sub-heading {-webkit-background-clip: text;-webkit-text-fill-color: transparent;}
            .tmt-h-background .heading {-webkit-background-clip: text;-webkit-text-fill-color: transparent;}

             /** === Border Animation Heading === **/
            .title-effect {animation: rotation 12.8s steps(1) 0s infinite;z-index: -1;}
            .title-effect .bar-top {width: 100%;height: 7px;position: absolute;top: 0;left: 0;transform-origin: left top;transform: scale(0, 1);
            animation: bar-top 3.2s linear 0s infinite;}
            .title-effect .bar-right {width: 7px;height: 100%;position: absolute;top: 0;right: 0;transform-origin: left top;transform: scale(1, 0);
            animation: bar-right 3.2s linear 0s infinite;}
            .title-effect .bar-bottom {width: 100%;height: 7px;position: absolute;right: 0;bottom: 0;transform-origin: right top;
            transform: scale(0, 1);animation: bar-bottom 3.2s linear 0s infinite;}
            .title-effect .bar-left {width: 7px;height: 100%;position: absolute;left: 0;bottom: 0;transform-origin: left bottom;
            transform: scale(1, 0);animation: bar-left 3.2s linear 0s infinite;}
            /*--rotation--*/
            @keyframes rotation {0% {transform: rotate(0deg);} 25% {transform: rotate(90deg);} 50% {transform: rotate(180deg);}
                75% {transform: rotate(270deg);} 100% {transform: rotate(360deg);}}
            @keyframes bar-top {0% {transform: scale(0, 1);} 12.5% {transform: scale(1, 1);}87.5% {transform: scale(1, 1);}
                100% {transform: scale(0, 1);}}
            @keyframes bar-right {0% {transform: scale(1, 0);}12.5% {transform: scale(1, 0);}25% {transform: scale(1, 1);}
                75% {transform: scale(1, 1);}87.5% {transform: scale(1, 0);}100% {transform: scale(1, 0);}}
            @keyframes bar-bottom {0% {transform: scale(0, 1);}25% {transform: scale(0, 1);}37.5% {transform: scale(1, 1);}
                62.5% {transform: scale(1, 1);}75% {transform: scale(0, 1);}100% {transform: scale(0, 1);}}
            @keyframes bar-left {0% {transform: scale(1, 0);}37.5% {transform: scale(1, 0);}50% {transform: scale(1, 1);}
                62.5% {transform: scale(1, 0);}100% {transform: scale(1, 0);}}
            ';
        }
        if ($modules_option['testimonial']) {
            $css .= '
             /** === Testimonial Slide === **/
            .testimonial-slide,.icon-border,figure {position : relative;}
            .testimonial-slide:before,figure:before {position: absolute;content: "";top: 0;left:0;}
            .testimonial-slide:after,figure:after {position: absolute;content: "";top: 0;right: 0;}
            .testimonial-slide>:last-child:before,figure>:last-child:before {position: absolute;content: "";bottom:0;right: 0; }
            .testimonial-slide>:last-child:after,.tmt-posts:after,figure>:last-child:after {position: absolute;content: "";bottom: 0;left: 0;}
            ';
        }
        if ($modules_option['member']) {
            $css .= '
           /** === Member === **/
            .tmt-member{position:relative;width:100%;box-sizing:border-box;transition:all .25s ease-in-out}.tmt-member .tmt-member-icons a:hover .fa-facebook{color:#3B5998}.tmt-member .tmt-member-icons a:hover .fa-flickr{color:#ff0084}.tmt-member .tmt-member-icons a:hover .fa-google-plus{color:#dd4b39}.tmt-member .tmt-member-icons a:hover .fa-twitter{color:#00aced}.tmt-member .tmt-member-icons a:hover .fa-github-alt{color:#bd5990}.tmt-member .tmt-member-icons a:hover .fa-linkedin{color:#007bb6}.tmt-member .tmt-member-icons a:hover .fa-pinterest{color:#BD081C}.tmt-member .tmt-member-photo,.tmt-member .tmt-member-photo-flip{width:100%;height:100%}.tmt-member .tmt-member-photo img,.tmt-member .tmt-member-photo-flip img{width:100%;object-fit:cover;height:100%}.tmt-member-photo-wrapper{overflow:hidden}.tmt-member-photo > div{opacity:1}.tmt-member-photo img{display:block;width:100%;height:auto;margin:0;padding:0;border:none;border-radius:0;box-shadow:none;transition:all .5s ease-out}.tmt-member-description{padding:1em 1.5em}.tmt-member-name{display:block;font-size:1.2em;font-weight:700}.tmt-member-role{display:block;margin-bottom:1em;font-size:.9em;opacity:.5;filter:alpha(opacity=50)}.tmt-member-icons{border-top:1px solid rgba(0,0,0,0.05);padding:1em}.tmt-member-icons .tmt-member-icon{padding:5px}.tmt-member-icons a{display:inline-block;text-align:center;line-height:1}.tmt-member-icons a:first-child{margin-left:0}.tmt-member-icons a:last-child{margin-right:0!important}.tmt-member-icons a i{display:inline-block;min-width:16px;text-align:center}.tmt-member-icons a i:before{font-size:16px}.tmt-member-icons a img{display:block;width:16px;height:16px;margin:0;padding:0;border:none;box-shadow:none}.tmt-member-clickable:hover{cursor:pointer}.elementor-widget-tmt-member .elementor-widget-container{background-color:#fff;overflow:hidden}.tmt-member.tmt-member-skin-phaedra .tmt-member-role{margin-bottom:0}.tmt-member.tmt-member-skin-calm .tmt-member-role{transition:all .35s ease-out;margin-bottom:0}.tmt-member.tmt-member-skin-calm .tmt-member-name{margin-bottom:0}.tmt-member.tmt-member-skin-calm:hover .tmt-member-role{opacity:0}.tmt-member.tmt-member-skin-calm .tmt-member-icons{padding:0;color:#fff;margin-top:-15px}.tmt-member.tmt-member-skin-calm .tmt-member-description{opacity:1;padding:0;color:#fff}.tmt-member.tmt-member-skin-calm .tmt-overlay{bottom:-15px;padding-bottom:30px}.tmt-member.tmt-member-skin-calm .tmt-member-icons{border-top:0 solid rgba(0,0,0,0.05)}@media only screen and (max-width: 959px){.tmt-member.tmt-member-skin-partait .tmt-member-name,.tmt-member.tmt-member-skin-partait .tmt-member-icons{color:#fff}.tmt-member.tmt-member-skin-partait .tmt-member-role,.tmt-member.tmt-member-skin-partait .tmt-member-description{color:#f5f5f5}}
            ';
        }
        if ($modules_option['flip-box']) {
            $css .= '
            /** === Flip Box === **/
            .tmt-flip-box{height:280px;position:relative;perspective:1000px;transform-style:preserve-3d}.tmt-flip-box .elementor-icon{color:#fff}.tmt-flip-box .elementor-view-framed .elementor-icon{color:#fff;border-color:#fff}.tmt-flip-box .elementor-view-stacked .elementor-icon{color:#fff;background-color:rgba(0,0,0,0.5)}.tmt-flip-box .elementor-icon-wrapper{margin-bottom:20px}.tmt-flip-box-front{background-color:#1e87f0}.tmt-flip-box-back{background-color:#b7b4b4;display:block}.tmt-flip-box-layer{position:absolute;width:100%;height:100%;transition:all .6s ease-in-out}.tmt-flip-box-layer-overlay{display:flex;width:100%;height:100%;flex-direction:column;justify-content:center;align-items:stretch;text-align:center;padding:35px}.tmt-flip-box-layer-title{font-size:21px;line-height:1;font-weight:600;color:#fff}.tmt-flip-box-layer-title:not(:last-child){margin:0 0 20px;padding:0}.tmt-flip-box-layer-desc{font-size:14px;color:#e5e5e5}.tmt-flip-box-layer-desc:not(:last-child){margin:0 0 20px;padding:0}.tmt-flip-box-image{margin:0 0 20px;display:inline-block;width:100%}.tmt-flip-box-image img{width:50%;display:inline-block}.tmt-flip-box-3d-yes .tmt-flip-box-layer-inner{transform:translateZ(90px) scale(.91)}.tmt-flip-box-3d-yes .tmt-flip-box-layer-overlay{transform-style:preserve-3d;transform:translateZ(.1px)}.tmt-flip-box-effect-flip .tmt-flip-box{perspective:1000px;transform-style:preserve-3d}.tmt-flip-box-effect-flip .tmt-flip-box:hover .tmt-flip-box-back{transform:none}.tmt-flip-box-effect-flip .tmt-flip-box-layer{transform-style:preserve-3d;backface-visibility:hidden}.tmt-flip-box-effect-flip .tmt-flip-box-front{transform:none;z-index:1}.tmt-flip-box-effect-flip.tmt-flip-box-direction-right .tmt-flip-box-back{transform:rotateX(0) rotateY(-180deg)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-right .tmt-flip-box:hover .tmt-flip-box-front{transform:rotateX(0) rotateY(180deg)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-left .tmt-flip-box-back{transform:rotateX(0) rotateY(180deg)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-left .tmt-flip-box:hover .tmt-flip-box-front{transform:rotateX(0) rotateY(-180deg)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-up .tmt-flip-box-back{transform:rotateX(-180deg) rotateY(0)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-up .tmt-flip-box:hover .tmt-flip-box-front{transform:rotateX(180deg) rotateY(0)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-down .tmt-flip-box-back{transform:rotateX(180deg) rotateY(0)}.tmt-flip-box-effect-flip.tmt-flip-box-direction-down .tmt-flip-box:hover .tmt-flip-box-front{transform:rotateX(-180deg) rotateY(0)}.tmt-flip-box-effect-push .tmt-flip-box-front{transform:none}.tmt-flip-box-effect-push .tmt-flip-box{overflow:hidden}.tmt-flip-box-effect-push .tmt-flip-box:hover .tmt-flip-box-back{transform:none}.tmt-flip-box-effect-push.tmt-flip-box-direction-right .tmt-flip-box:hover .tmt-flip-box-front{transform:translateX(100%) translateY(0)}.tmt-flip-box-effect-push.tmt-flip-box-direction-right .tmt-flip-box-back{transform:translateX(-100%) translateY(0)}.tmt-flip-box-effect-push.tmt-flip-box-direction-left .tmt-flip-box:hover .tmt-flip-box-front{transform:translateX(-100%) translateY(0)}.tmt-flip-box-effect-push.tmt-flip-box-direction-left .tmt-flip-box-back{transform:translateX(100%) translateY(0)}.tmt-flip-box-effect-push.tmt-flip-box-direction-up .tmt-flip-box:hover .tmt-flip-box-front{transform:translateX(0) translateY(-100%)}.tmt-flip-box-effect-push.tmt-flip-box-direction-up .tmt-flip-box-back{transform:translateX(0) translateY(100%)}.tmt-flip-box-effect-push.tmt-flip-box-direction-down .tmt-flip-box:hover .tmt-flip-box-front{transform:translateX(0) translateY(100%)}.tmt-flip-box-effect-push.tmt-flip-box-direction-down .tmt-flip-box-back{transform:translateX(0) translateY(-100%)}.tmt-flip-box-effect-slide .tmt-flip-box{overflow:hidden}.tmt-flip-box-effect-slide .tmt-flip-box:hover .tmt-flip-box-back{transform:none}.tmt-flip-box-effect-slide.tmt-flip-box-direction-right .tmt-flip-box-back{transform:translateX(-100%) translateY(0)}.tmt-flip-box-effect-slide.tmt-flip-box-direction-left .tmt-flip-box-back{transform:translateX(100%) translateY(0)}.tmt-flip-box-effect-slide.tmt-flip-box-direction-up .tmt-flip-box-back{transform:translateX(0) translateY(100%)}.tmt-flip-box-effect-slide.tmt-flip-box-direction-down .tmt-flip-box-back{transform:translateX(0) translateY(-100%)}.tmt-flip-box-effect-zoom-out .tmt-flip-box .tmt-flip-box-front{transition:transform .7s,opacity .35s,width .1ms;opacity:1;transform:scale(1);z-index:1;width:100%}.tmt-flip-box-effect-zoom-out .tmt-flip-box:hover .tmt-flip-box-front{width:0;opacity:0;transform:scale(.7);transition:transform .8s,opacity .7s .1s,width .1ms .7s}.tmt-flip-box-effect-zoom-in .tmt-flip-box .tmt-flip-box-back{transition:transform .7s,opacity .5s .2s;opacity:0;transform:scale(.7)}.tmt-flip-box-effect-zoom-in .tmt-flip-box:hover .tmt-flip-box-back{transition:transform .7s,opacity .5s;opacity:1;transform:scale(1)}.tmt-flip-box-effect-fade .tmt-flip-box .tmt-flip-box-back{opacity:0}.tmt-flip-box-effect-fade .tmt-flip-box:hover .tmt-flip-box-back{opacity:1}.elementor-widget-tmt-flip-box.tmt-flip-box-flipped .elementor-widget-container .tmt-flip-box-front{display:none}.elementor-widget-tmt-flip-box.tmt-flip-box-flipped .elementor-widget-container .tmt-flip-box-back{transform:none;opacity:1}@media (max-device-width: 1024px){.tmt-flip-box{cursor:pointer}}
            ';
        }
        if ($modules_option['accordion']) {
            $css .= '
            /** === Accordion === **/
            .tmt-accordion-item .tmt-accordion-content {display: none}.tmt-open .tmt-accordion-content {display: block}.tmt-accordion-container .tmt-accordion{list-style-type:none;margin:0;padding:0}.tmt-accordion-container .tmt-accordion .tmt-accordion-title{outline:none;font-size:14px;cursor:pointer;font-weight:bold;line-height:1;margin:0;padding:15px 20px;background:#f3f3f3;transition:all 300ms cubic-bezier(0, .49, .27, .99)}.tmt-accordion-container .tmt-accordion .tmt-accordion-title .tmt-accordion-icon{display:inline-block;font-weight:400}.tmt-accordion-container .tmt-accordion .tmt-accordion-title .tmt-accordion-icon svg,.tmt-accordion-container .tmt-accordion .tmt-accordion-title .tmt-accordion-icon i{width:1.5em}.tmt-accordion-container .tmt-accordion .tmt-accordion-title .tmt-accordion-icon.tmt-accordion-icon-right{float:right;text-align:right}.tmt-accordion-container .tmt-accordion .tmt-accordion-title .tmt-accordion-icon.tmt-accordion-icon-left{float:left;text-align:left}.tmt-accordion-container .tmt-accordion .tmt-accordion-item .tmt-accordion-icon-closed{display:flex}.tmt-accordion-container .tmt-accordion .tmt-accordion-item .tmt-accordion-icon-opened{display:none}.tmt-accordion-container .tmt-accordion .tmt-accordion-title.tmt-open .tmt-accordion-icon-closed{display:none}.tmt-accordion-container .tmt-accordion .tmt-accordion-title.tmt-open .tmt-accordion-icon-opened{display:flex}.tmt-accordion-container .tmt-accordion .tmt-accordion-content{padding:15px 20px;margin-top:0}.tmt-accordion-container .tmt-accordion .tmt-accordion-content>*{margin:0}@media (max-width:767px){.tmt-accordion-container .tmt-accordion .tmt-accordion-title{padding:12px 15px}.tmt-accordion-container .tmt-accordion .tmt-accordion-title .tmt-accordion-icon{width:1.2em}.tmt-accordion-container .tmt-accordion .tmt-accordion-content{padding:7px 15px}}
            ';
        }
        if ($modules_option['whatsapp']) {
            $css .= '
            /** === Whatsapp Element === **/
            .whatsapp-pupup{position:fixed;text-align:center;font-size:21px;transition-timing-function:cubic-bezier(.175,.885,.32,1.275);transition-duration:400ms;box-shadow:0 6px 8px 2px rgba(0,0,0,0.14);-webkit-box-shadow:0 6px 8px 2px rgba(0,0,0,0.14);-moz-box-shadow:0 6px 8px 2px rgba(0,0,0,0.14);cursor:pointer;z-index:999;width:50px;height:50px;line-height:50px}.whatsapp-pupup:hover{transform:scale(1.1,1.1) translate3d(0,0,0)}.whatsapp-pupup i{transition:.4s ease all;-webkit-transition:.4s ease all;-moz-transition:.4s ease all}.whatsapp-pupup .fa-whatsapp{-ms-transform:rotate(-360deg);transform:rotate(-360deg);-webkit-transform:rotate(-360deg);-moz-transform:rotate(-360deg)}.whatsapp-pupup .fa-times{-ms-transform:rotate(360deg);transform:rotate(360deg);-webkit-transform:rotate(360deg);-moz-transform:rotate(360deg)}.whatsapp-chat{opacity:0;visibility:hidden;-ms-transform:translate(0,50px);transform:translate(0,50px);-webkit-transform:translate(0,50px);-moz-transform:translate(0,50px);width:370px;position:fixed;transition:.4s ease all;-webkit-transition:.4s ease all;-moz-transition:.4s ease all;will-change:transform,visibility,opacity;overflow:hidden;bottom:100px;z-index:998;background-color:#FFF;box-shadow:0 10px 10px 4px rgba(0,0,0,0.04);-webkit-box-shadow:0 10px 10px 4px rgba(0,0,0,0.04);-moz-box-shadow:0 10px 10px 4px rgba(0,0,0,0.04);border-radius:5px 5px 8px 8px;-webkit-border-radius:5px 5px 8px 8px;-moz-border-radius:5px 5px 8px 8px}.whatsapp-chat.open-chat{-ms-transform:translate(0,0);transform:translate(0,0);-webkit-transform:translate(0,0);-moz-transform:translate(0,0);visibility:visible;opacity:1}.whatsapp-chat:hover{box-shadow:0 10px 10px 4px rgba(32,32,37,0.23);-webkit-box-shadow:0 10px 10px 4px rgba(32,32,37,0.23);-moz-box-shadow:0 10px 10px 4px rgba(32,32,37,0.23)}.whatsapp-header{background:#2db742;align-items:center;justify-content:space-between;padding:15px 20px;color:#fff}.whatsapp-header h4{font-size:18px}.whatsapp-header p{opacity:.8;padding-top:4px;font-size:12px;line-height:20px;margin:0}.whatsapp-header i{font-size:36px}.whatsapp-body{padding:10px}.whatsapp-body .usrt-chat{border-left:2px solid #2db742;padding:10px;background:#f5f7f9;border-radius:2px 4px 2px 4px;-webkit-border-radius:2px 4px 2px 4px;-moz-border-radius:2px 4px;cursor:pointer;margin-bottom:10px}.whatsapp-body .usrt-chat:last-child{margin:0}.whatsapp-body .usrt-chat img{width:50px;height:50px}.whatsapp-body .usrt-chat-id i{font-size:24px;color:#2db742;margin-right:10px}body.rtl .whatsapp-body .usrt-chat-id i {margin-right:auto;margin-left:10px}.whatsapp-body .usrt-chat h6{font-size:14px;color:#363c47}.whatsapp-body .usrt-chat p{font-size:11px;color:#989b9f;padding-top:5px;margin:0}@media (max-width: 480px){.whatsapp-chat{width:270px}table:not(.variations) {display: block;overflow-x: auto;}.elementor-widget-tmt-product-add-to-cart table {display: table;}}
            ';
        }
        if ($modules_option['tabs']) {
            $css .= '
           /** === Tabs === **/
            @keyframes tabfadeIn {100% {opacity: 1;transform: none;}}
            .tmt-tabs .tab-nav-item {background-color: #eaeaea;padding: 10px 15px;margin: 0 5px;transition: all 0.3s;cursor: pointer;}
            .tmt-tabs .tab-nav-item.tmt-open {background-color: #5b5b5b;border-bottom: 3px solid #000;color: #fff;}
            .tmt-tabs .tmt-tabs-nav ul.row-nav {height: 100%;}
            .tmt-tabs .tmt-tabs-content {margin: 20px 0;}
            .tmt-tabs.row-item .tmt-tabs-content {margin: 0 20px;}
            .tmt-tabs .tabs-content-item {display: none;opacity: 0;transform: translateY(30px);animation: tabfadeIn 0.5s ease 1 forwards;}
            .tmt-tabs .tabs-content-item.tmt-open {display: block;}
            @media (max-width: 1024px) {
                .tmt-tabs {flex-direction: column;}
            }
            ';
        }
        if ($modules_option['modal']) {
            $css .= '
           /** === Model === **/
            .tmt-modal .tmt-modal-botton a{display:inline-block;text-align:center;}
            .tmt-modal .tmt-modal-botton {color: #FFF;}
            .tmt-modal .tmt-modal-botton a {padding: 8px 15px;background-color: #818a91;}
            .tmt-modal .tmt-modal-bg {visibility: hidden;position: fixed;top:0;right:0;width: 100%;height: 100%;z-index: 1010;overflow-y: auto;-webkit-overflow-scrolling: touch;padding: 15px 15px;background: rgba(0,0,0,0.6);opacity: 0;transition: opacity .15s linear;}
            .tmt-modal.tmt-open .tmt-modal-bg {opacity: 1;visibility: visible;}
            .tmt-modal .tmt-modal-bg .tmt-modal-box {position: relative;margin: 0 auto;width: 600px;max-width: calc(100% - 0.01px) !important;background: #fff;transform: translateY(-100px);transition: .3s linear;transition-property: all;transition-property: opacity,transform;border-radius: 3px;}
            .tmt-modal.tmt-open .tmt-modal-bg .tmt-modal-box {opacity: 1;transform: translateY(0);}
            .tmt-modal .tmt-modal-header {font-size: 24px;padding: 15px 30px;background: #f8f8f8;}
            .tmt-modal .tmt-modal-content {padding: 30px 30px;}
            .tmt-modal .tmt-modal-footer {padding: 15px 30px;background: #f8f8f8;}
            .tmt-modal .tmt-modal-close {position: absolute;left: 0;top: 0;display: flex;align-items: center;justify-content: center;color: #999;background: transparent;width: 40px;height: 40px;cursor: pointer;}
            @keyframes loadAfter {to {visibility: visible;opacity: 1;}}
            ';
        }
        if ($modules_option['breadcrumb']) {
            $css .= '
           /** === Breadcrumb Element === **/
            .breadcrumb {margin-top: 15px;list-style:none !important}
            .breadcrumb i {opacity: .5;}
            .breadcrumb li,.breadcrumb li a {color: #FFF;display: inline-block;}
            .breadcrumb li:after {content: "\f30a";font-weight: 900;font-family:"Font Awesome 5 Free";display: inline-block;margin: 0 10px;opacity: .5;color: #fff;transform: rotateY(180deg);}
            .breadcrumb li:last-child:after {opacity: 0;visibility: hidden;display: none}
            .screen-reader-text {text-indent: -99999px;overflow: hidden;display: none;}
            body.rtl .breadcrumb li:after{transform: rotateY(0);}
            ';
        }
        if (class_exists('WPCF7_ContactForm')) {
            $css .= '
           /** === Contact Form 7 Style === **/
            .wpcf7-form p{margin:10px}.wpcf7-form label{font-size:14px;margin-bottom:10px;display:block}.tmt-cf7-style span.wpcf7-list-item{margin:0 1em 0 0}.tmt-cf7-loader-active span.ajax-loader.is-active{display:inline-block}.tmt-cf7-style select{-webkit-appearance:none}.tmt-cf7-style .tmt-cf7-select-custom{display:block;position:relative}.tmt-cf7-style .tmt-cf7-select-custom:after{content:"\f078";font-family: "Font Awesome 5 Free" !important;font-weight: 900;position:absolute;font-size:.7em;line-height:1;top:45%;-webkit-transform:translateY(-45%);-ms-transform:translateY(-45%);transform:translateY(-45%);right:.5em;z-index:5;pointer-events:none}.tmt-cf7-highlight-style-bottom_right span.wpcf7-not-vmosad-tip{display:inline-block;right:0;top:100%;padding:.1em .8em;-webkit-border-radius:2px;border-radius:2px}.tmt-cf7-highlight-style-bottom_right span.tmt-cf7-alert{display:block;text-align:right}.tmt-cf7-btn-size-xs .tmt-cf7-style input[type=submit]{font-size:13px;padding:10px 20px;-webkit-border-radius:2px;border-radius:2px}.tmt-cf7-input-size-xs .tmt-cf7-style input:not([type="submit"]),.tmt-cf7-input-size-xs .tmt-cf7-style .wpcf7 textarea,.tmt-cf7-input-size-xs .tmt-cf7-style select{font-size:13px;padding:8px 10px;width: 100%}.tmt-cf7-input-size-xs .tmt-cf7-style select[multiple="multiple"]{padding:0}.tmt-cf7-input-size-xs .tmt-cf7-style select[multiple="multiple"] option{padding:8px 10px}.tmt-cf7-input-size-xs .tmt-cf7-select-custom{font-size:13px}.tmt-cf7-input-size-xs .tmt-cf7-style input[type="checkbox"] + span:before,.tmt-cf7-input-size-xs .tmt-cf7-style input[type="radio"] + span:before{height:10px;width:10px}.tmt-cf7-input-size-xs .tmt-cf7-style input[type="checkbox"]:checked + span:before{font-size:-webkit-calc(10px / 1.2);font-size:calc(10px / 1.2)}.tmt-cf7-input-size-xs input[type=range]::-webkit-slider-thumb{font-size:10px}.tmt-cf7-input-size-xs input[type=range]::-moz-range-thumb{font-size:10px}.tmt-cf7-input-size-xs input[type=range]::-ms-thumb{font-size:10px}.tmt-cf7-btn-size-sm .tmt-cf7-style input[type=submit]{font-size:15px;padding:12px 24px;-webkit-border-radius:3px;border-radius:3px;cursor:pointer}.tmt-cf7-input-size-sm .tmt-cf7-style input:not([type="submit"]),.tmt-cf7-input-size-sm .tmt-cf7-style .wpcf7 textarea,.tmt-cf7-input-size-sm .tmt-cf7-style select{font-size:15px;padding:12px 10px;width:100%}.tmt-cf7-input-size-sm .tmt-cf7-style select[multiple="multiple"]{padding:0}.wpcf7 .grid{grid-gap:20px}.wpcf7 textarea{height:150px}.tmt-cf7-input-size-sm .tmt-cf7-style select[multiple="multiple"] option{padding:12px 10px}.tmt-cf7-input-size-sm .tmt-cf7-select-custom{font-size:15px}.tmt-cf7-input-size-sm .tmt-cf7-style input[type="checkbox"] + span:before,.tmt-cf7-input-size-sm .tmt-cf7-style input[type="radio"] + span:before{height:12px;width:12px}.tmt-cf7-input-size-sm .tmt-cf7-style input[type="checkbox"]:checked + span:before{font-size:-webkit-calc(12px / 1.2);font-size:calc(12px / 1.2)}.tmt-cf7-input-size-sm input[type=range]::-webkit-slider-thumb{font-size:12px}.tmt-cf7-input-size-sm input[type=range]::-moz-range-thumb{font-size:12px}.tmt-cf7-input-size-sm input[type=range]::-ms-thumb{font-size:12px}.tmt-cf7-btn-size-md .tmt-cf7-style input[type=submit]{font-size:16px;padding:15px 30px;-webkit-border-radius:4px;border-radius:4px}.tmt-cf7-input-size-md .tmt-cf7-style input:not([type="submit"]),.tmt-cf7-input-size-md .tmt-cf7-style .wpcf7 textarea,.tmt-cf7-input-size-md .tmt-cf7-style select{font-size:16px;padding:15px 10px}.tmt-cf7-input-size-md .tmt-cf7-style select[multiple="multiple"]{padding:0}.tmt-cf7-input-size-md .tmt-cf7-style select[multiple="multiple"] option{padding:15px 10px}.tmt-cf7-input-size-md .tmt-cf7-select-custom{font-size:16px}.tmt-cf7-input-size-md .tmt-cf7-style input[type="checkbox"] + span:before,.tmt-cf7-input-size-md .tmt-cf7-style input[type="radio"] + span:before{height:15px;width:15px}.tmt-cf7-input-size-md .tmt-cf7-style input[type="checkbox"]:checked + span:before{font-size:-webkit-calc(15px / 1.2);font-size:calc(15px / 1.2)}.tmt-cf7-input-size-md input[type=range]::-webkit-slider-thumb{font-size:15px}.tmt-cf7-input-size-md input[type=range]::-moz-range-thumb{font-size:15px}.tmt-cf7-input-size-md input[type=range]::-ms-thumb{font-size:15px}.tmt-cf7-btn-size-lg .tmt-cf7-style input[type=submit]{font-size:18px;padding:20px 40px;-webkit-border-radius:5px;border-radius:5px}.tmt-cf7-input-size-lg .tmt-cf7-style input:not([type="submit"]),.tmt-cf7-input-size-lg .tmt-cf7-style .wpcf7 textarea,.tmt-cf7-input-size-lg .tmt-cf7-style select{font-size:18px;padding:20px 10px}.tmt-cf7-input-size-lg .tmt-cf7-style select[multiple="multiple"]{padding:0}.tmt-cf7-input-size-lg .tmt-cf7-style select[multiple="multiple"] option{padding:20px 10px}.tmt-cf7-input-size-lg .tmt-cf7-select-custom{font-size:18px}.tmt-cf7-input-size-lg .tmt-cf7-style input[type="checkbox"] + span:before,.tmt-cf7-input-size-lg .tmt-cf7-style input[type="radio"] + span:before{height:20px;width:20px}.tmt-cf7-input-size-lg .tmt-cf7-style input[type="checkbox"]:checked + span:before{font-size:-webkit-calc(20px / 1.2);font-size:calc(20px / 1.2)}.tmt-cf7-input-size-lg input[type=range]::-webkit-slider-thumb{font-size:20px}.tmt-cf7-input-size-lg input[type=range]::-moz-range-thumb{font-size:20px}.tmt-cf7-input-size-lg input[type=range]::-ms-thumb{font-size:20px}.tmt-cf7-btn-size-xl .tmt-cf7-style input[type=submit]{font-size:20px;padding:25px 50px;-webkit-border-radius:6px;border-radius:6px}.tmt-cf7-input-size-xl .tmt-cf7-style input:not([type="submit"]),.tmt-cf7-input-size-xl .tmt-cf7-style .wpcf7 textarea,.tmt-cf7-input-size-xl .tmt-cf7-style select{font-size:20px;padding:25px 10px}.tmt-cf7-input-size-xl .tmt-cf7-style select[multiple="multiple"]{padding:0}.tmt-cf7-input-size-xl .tmt-cf7-style select[multiple="multiple"] option{padding:25px 10px}.tmt-cf7-input-size-xl .tmt-cf7-select-custom{font-size:20px}.tmt-cf7-input-size-xl .tmt-cf7-style input[type="checkbox"] + span:before,.tmt-cf7-input-size-xl .tmt-cf7-style input[type="radio"] + span:before{height:25px;width:25px}.tmt-cf7-input-size-xl .tmt-cf7-style input[type="checkbox"]:checked + span:before{font-size:-webkit-calc(25px / 1.2);font-size:calc(25px / 1.2)}.tmt-cf7-input-size-xl input[type=range]::-webkit-slider-thumb{font-size:25px}.tmt-cf7-input-size-xl input[type=range]::-moz-range-thumb{font-size:25px}.tmt-cf7-input-size-xl input[type=range]::-ms-thumb{font-size:25px}.tmt-cf7-style input[type=range]{background:transparent!important;border:none!important;padding-left:0!important;padding-right:0!important}.tmt-cf7-style input[type=range]::-ms-track{background:transparent;border-color:transparent;color:transparent}.tmt-cf7-style input[type=range]::-webkit-slider-runnable-track{height:.35em}.tmt-cf7-style input[type=range]::-moz-range-track{height:.35em}.tmt-cf7-style input[type=range]::-ms-fill-lower{height:.35em}.tmt-cf7-style input[type=range]::-ms-fill-upper{height:.35em}.tmt-cf7-style input[type=range]::-webkit-slider-thumb{-webkit-appearance:none;height:1em;width:1em;margin-top:-.35em}.tmt-cf7-style input[type=range]::-moz-range-thumb{height:1em;width:1em;margin-top:-.35em}.tmt-cf7-style input[type=range]::-ms-thumb{height:1em;width:1em;margin-top:-.35em}.tmt-cf7-style .wpcf7-radio input[type="radio"] + span:before{-webkit-border-radius:100%;border-radius:100%}.tmt-cf7-style .wpcf7 div.wpcf7-response-output{margin:0}.tmt-cf7-style-box .wpcf7-checkbox input[type="checkbox"]:checked + span:before,.tmt-cf7-style-box .wpcf7-checkbox input[type="checkbox"] + span:before,.tmt-cf7-style-box .wpcf7-acceptance input[type="checkbox"]:checked + span:before,.tmt-cf7-style-box .wpcf7-acceptance input[type="checkbox"] + span:before,.tmt-cf7-style-box .wpcf7-radio input[type="radio"] + span:before{-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box}.tmt-cf7-button-center input.wpcf7-form-control.wpcf7-submit,.tmt-cf7-button-left input.wpcf7-form-control.wpcf7-submit,.tmt-cf7-button-right input.wpcf7-form-control.wpcf7-submit,.tmt-cf7-button-justify input.wpcf7-form-control.wpcf7-submit{display:-webkit-box;display:-ms-flexbox;-js-display:flex;display:-webkit-flex;display:-moz-box;display:flex;width:auto}.tmt-cf7-button-center input.wpcf7-form-control.wpcf7-submit{margin-left:auto;margin-right:auto}.tmt-cf7-button-center .tmt-cf7-loader-active{text-align:center}.tmt-cf7-button-left input.wpcf7-form-control.wpcf7-submit{margin-left:0;margin-right:auto}.tmt-cf7-button-right input.wpcf7-form-control.wpcf7-submit{margin-left:auto;margin-right:0}.tmt-cf7-button-right .tmt-cf7-loader-active{text-align:right}.tmt-cf7-button-justify input.wpcf7-form-control.wpcf7-submit{-webkit-box-pack:center;-ms-flex-pack:center;-webkit-justify-content:center;-moz-box-pack:center;justify-content:center;width:100%}.tmt-cf7-button-justify .tmt-cf7-loader-active{text-align:center}.tmt-cf7-style .wpcf7-checkbox input[type="checkbox"],.tmt-cf7-style .wpcf7-acceptance input[type="checkbox"],.tmt-cf7-style .wpcf7-radio input[type="radio"]{display:none}.tmt-cf7-style .wpcf7-checkbox input[type="checkbox"] + span:before,.tmt-cf7-style .wpcf7-radio input[type="radio"] + span:before,.tmt-cf7-style .wpcf7-acceptance input[type="checkbox"] + span:before{content:"";display:inline-block;vertical-align:middle;margin-right:10px;text-align:center}.tmt-cf7-style .wpcf7-checkbox input[type="checkbox"]:checked + span:before,.tmt-cf7-style .wpcf7-acceptance input[type="checkbox"]:checked + span:before{content:"\2714";line-height:1.2}@media only screen and (min-width: 769px){.tmt-cf7-col{-js-display:flex;display:-webkit-box;display:-webkit-flex;display:-moz-box;display:-ms-flexbox;display:flex}.tmt-cf7-col label,.tmt-cf7-col > span{-webkit-box-flex:1;-webkit-flex-grow:1;-moz-box-flex:1;-ms-flex-positive:1;flex-grow:1;padding:0 10px}}@media only screen and (max-width: 976px){.tmt-tablet-cf7-button-center input.wpcf7-form-control.wpcf7-submit{margin-left:auto;margin-right:auto;width:auto}.tmt-tablet-cf7-button-left input.wpcf7-form-control.wpcf7-submit{margin-left:0;margin-right:auto;width:auto}.tmt-tablet-cf7-button-right input.wpcf7-form-control.wpcf7-submit{margin-left:auto;margin-right:0;width:auto}.tmt-tablet-cf7-button-justify input.wpcf7-form-control.wpcf7-submit{-webkit-box-pack:center;-ms-flex-pack:center;-webkit-justify-content:center;-moz-box-pack:center;justify-content:center;width:100%}}@media only screen and (max-width: 767px){.tmt-mobile-cf7-button-center input.wpcf7-form-control.wpcf7-submit{margin-left:auto;margin-right:auto;width:auto}.tmt-mobile-cf7-button-left input.wpcf7-form-control.wpcf7-submit{margin-left:0;margin-right:auto;width:auto}.tmt-mobile-cf7-button-right input.wpcf7-form-control.wpcf7-submit{margin-left:auto;margin-right:0;width:auto}.tmt-mobile-cf7-button-justify input.wpcf7-form-control.wpcf7-submit{-webkit-box-pack:center;-ms-flex-pack:center;-webkit-justify-content:center;-moz-box-pack:center;justify-content:center;width:100%}}
            ';
        }
        if (woo) {
            $css .= '
            /** === Basket Shop Element === **/
            .drop-down-btn .card-count {position: absolute;top: -12px;right:-12px;text-align: center;line-height: 20px;width: 1.5em;height: 1.5em;border-radius: 50%;font-size: 12px;}
            .woocommerce-mini-cart-item.mini_cart_item a, .woocommerce-mini-cart-item.mini_cart_item > span {display: block;width: 90%;}
            .woocommerce-mini-cart-item.mini_cart_item {margin-bottom: 15px;position: relative;}
            .woocommerce-mini-cart-item.mini_cart_item .remove_from_cart_button {width: 5%;text-align: center;position: absolute;left: 0;top: 50%;transform: translateY(-50%);}
            body:not(.rtl) .woocommerce-mini-cart-item.mini_cart_item .remove_from_cart_button{right: 0;left: unset;}
            body:not(.rtl) .woocommerce-mini-cart-item.mini_cart_item img{float: left;margin-right:10px}
            .woocommerce-mini-cart-item.mini_cart_item img {width:50px;float: right;margin-left:10px}
            .woocommerce-mini-cart__total.total {border-top: 2px solid #c8c8c8;padding: 10px 0;text-align: center;}
            .woocommerce-mini-cart__buttons.buttons {text-align: center;}
            .woocommerce-mini-cart__buttons.buttons a {display:inline-block;background: transparent;}
            .drop-down-offcanvas {position: fixed;z-index: 1000; top: 0;padding: 0 !important;left: 0;background: rgba(0,0,0,.8) !important;width:100% !important;height: 100%;}
            .drop-down-offcanvas > div{position: absolute;background-color: #FFF;height: 100%;top:0;bottom: 0;-webkit-overflow-scrolling: touch;-ms-overflow-scrolling: touch;-moz-overflow-scrolling: touch;left:0;box-sizing: border-box;width: 300px;padding: 20px 20px;transform: translateX(-100%);transition: 0.3s;}
            body:not(.rtl) .drop-down-offcanvas > div{right: 0; left: unset;transform: translateX(100%)}
            .content-open.drop-down-offcanvas > div { transition: .3s;transform: translateX(0)!important;overflow-y: auto;}
            .woocommerce-mini-cart .variation {display: none;}
            .widget_shopping_cart_content .go-to-shop-box .go-to-shop-button {display:inline-block}
            .widget_shopping_cart_content .close-cart-button i{vertical-align:middle}

            /** === Woocommerce Element === **/
            .price del {text-decoration:none}
            .woocommerce div.product div.images .flex-control-thumbs {margin:0 -0.5em}
            .woocommerce div.product div.images .flex-control-thumbs li {margin: 0.5em 0.5em 0 0.5em;}
            .woocommerce a.added_to_cart {display: none;}
            .woocommerce ul.products li.product, .woocommerce-page ul.products li.product {float: none;width: 100% !important;margin:0;}
            .woocommerce .tmt-product-item {position: relative;overflow: hidden;display: flex;flex-direction: column;justify-content: space-between;transition: all .3s}
            .woocommerce .products .product .woocommerce-loop-product__title {transition: all .3s}
            .woocommerce ul.products li.product a.added_to_cart {width: 100%;position: absolute;bottom: 0;}
            .woocommerce ul.products li.product .price ins,.woocommerce div.product p.price ins, .woocommerce div.product span.price ins {text-decoration:none}
            .woocommerce-archive .products ul::after, .woocommerce-archive .products ul::before, .woocommerce-archive .products::after, .woocommerce-archive .products::before,.woocommerce-archive .woocommerce-breadcrumb,.woocommerce-Tabs-panel h2:first-child {display: none}
            .woocommerce-archive #main {display: flex;flex-wrap: wrap;justify-content: space-between;}
            .woocommerce-archive .woocommerce-notices-wrapper {width: 100%;order: 1;}
            .woocommerce-archive .woocommerce-result-count {order: 3;}
            .woocommerce-archive .products {order: 4;width: 100%;}
            .elementor-wc-products ul.products {display: flex;flex-wrap: wrap;}
            .elementor-wc-products ul.products:before, .elementor-wc-products ul.products:after {display:none !important;}
            ul.products li.product.outofstock {order:1}
            .woocommerce-cart-form .product-name .variation {margin: 0 12px;padding: 0;border: none;display: flex;}
            .woocommerce-cart-form .product-name .variation dt:after {display: none;}
            .woocommerce-cart-form .product-name .variation dt,.woocommerce-cart-form .product-name .variation dd {width: auto;}
            .woocommerce .tmt-product-add-to-cart button.loading::after {right: auto !important;left: 1em !important;top: 0.800em !important;}
            body.rtl .woocommerce .tmt-product-add-to-cart button.loading::after {right: 1em !important;left: auto !important;}
            .woocommerce .tmt-product-add-to-cart button.loading::before {opacity: 0 !important;}
            .woocommerce-error::before, .woocommerce-info::before, .woocommerce-message::before {top: 50%;transform: translateY(-50%);}
            .woocommerce-message {background-color: white;border: 1px solid #8fae1b;border-radius: 10px;box-shadow: 0px 2px 6px 0px rgba(0,0,0,0.1);}
            .woocommerce .woocommerce-message .button {background-color: #8fae1b;color: white;border-radius: 10px;}
            .woocommerce .woocommerce-message .button:hover {background-color: #6b8216;color: white;}
            .woocommerce .pagination a {display: inline-block !important;}
            /* Thumbnail Secound Product */
            .woocommerce .products {list-style:none;}
            .woocommerce .products li.product .attachment-full {position: absolute;top: 0;left: 0;opacity: 0;visibility: hidden;z-index: -1;transition: all .4s ease-in-out;-moz-transition: all .4s ease-in-out;-webkit-transition: all .4s ease-in-out;-o-transition: all .4s ease-in-out;}
            .woocommerce .products li.product:hover .attachment-full {opacity: 1;visibility: visible;z-index: 2;}
            /*Broken Product*/
            .tmt-product-item .img-product {display: block;overflow: hidden;position: relative;}
            .tmt-product-item .img-product img{height: 100% !important;}
            .tmt-product-item .img-product:before {bottom: 0;content: "";left: 50%;opacity: 1;-moz-opacity: 1;-khtml-opacity: 1;-webkit-opacity: 1;
            position: absolute;right: 51%;top: 0;}
            .tmt-product-item .img-product:after {bottom: 50%;content: "";left: 0;opacity: 1;-moz-opacity: 1;-khtml-opacity: 1;-webkit-opacity: 1;
            position: absolute;right: 0;top: 50%;}
            .tmt-product-item:hover  .img-product:before, .tmt-product-item:hover  .img-product:after {left: 0px;right: 0px;top: 0px;bottom: 0px;
            transition: all 500ms ease-in-out 0s;-webkit-transition: all 500ms ease-in-out 0s;-moz-transition: all 500ms ease-in-out 0s;
            -o-transition: all 500ms ease-in-out 0s;-ms-transition: all 500ms ease-in-out 0s;}
            /*Button Product*/
            .tmt-product-item .button-product {display: inline-block;text-align: center;text-transform: uppercase;visibility: visible;
            position: relative;margin-top: 1em;transition: opacity .2s ease-in;transform: translateZ(0);opacity: 1;overflow:hidden;}
            .tmt-product-item .button-product:before {content: "";position: absolute;top: 0;left: 0;width: 150%;height: 100%;
            z-index: -1;transform: rotate3d(0,0,1,-45deg) translate3d(0,-3em,0);transform-origin: 0% 100%;
            transition: transform .3s,opacity .3s,background-color .3s;}
            .tmt-product-item .button-product:hover:before{opacity: 1;transform: rotate3d(0,0,1,0deg);
            transition-timing-function: cubic-bezier(.2,1,.3,1);}
            .elementor-product-simple form.cart {flex-direction: row !important;}
            .elementor-product-simple form.cart .button {margin: 0 !important;}
            /*Sort by Product*/
            .woocommerce-archive .sort-by {order: 2;}
            .woocommerce-archive .sort-by i {margin: 0 2px;transform: translateY(2px);}
            .woocommerce-archive .sort-by a {font-size: 14px;display: inline-block;margin: 5px 0;}
            /*Pagination Product*/
            .woocommerce-archive .woocommerce-pagination {order: 5;width: 100%;}
            .woocommerce-archive nav.woocommerce-pagination ul li a,.woocommerce-archive nav.woocommerce-pagination ul li span {line-height: 2;}
            /*Price Product*/
            .woocommerce ul.products li.product .price del {font-size: 12px;}
            .woocommerce ul.products li.product .price .woocommerce-Price-currencySymbol {font-size: 12px;margin:2px}
            /*onsale Product*/
            .woocommerce ul.products li.product .onsale,.woocommerce span.onsale {font-size: 14px;font-weight: 300;line-height:3em;width:auto;height:3.5em;border-style: solid;top: 10px;left: 10px;right:auto;margin: 0;min-height:3em;min-width: 4em;}
            .woocommerce ul.products li.product .onsale {position:absolute}
            /** === Product Images Element === **/
            .flex-control-thumbs {display: flex;}
            .flex-control-thumbs li {width: 25%;}
            .flex-control-thumbs li img {cursor: pointer;opacity: .5;width: 100%;}
            .flex-control-thumbs li img.flex-active, .flex-control-thumbs li img:hover {opacity: 1;}
            .elementor-widget-tmt-product-images span.onsale,.tmt-product-item .tmt-product-offer {right: 10px;left: auto;z-index:999}
            .elementor-widget-tmt-product-images .woocommerce-product-gallery__trigger {position: absolute;top: .5em;left: .5em;font-size: 2em;z-index: 9;width: 36px;height: 36px;background: #fff;text-indent: -9999px;border-radius: 100%;box-sizing: content-box;}
            .elementor-widget-tmt-product-images .woocommerce-product-gallery__trigger::before {content: "";display: block;width: 10px;height: 10px;border: 2px solid #000;border-radius: 100%;position: absolute;top: 9px;right: 9px;box-sizing: content-box;}
            .elementor-widget-tmt-product-images .woocommerce-product-gallery__trigger::after {content: "";display: block;width: 2px;height: 8px;background: #000;border-radius: 6px;position: absolute;top: 19px;right: 22px;-webkit-transform: rotate(45deg);-ms-transform: rotate(45deg);transform: rotate(45deg);box-sizing: content-box}
            .woocommerce #content div.product div.images, .woocommerce div.product div.images, .woocommerce-page #content div.product div.images, .woocommerce-page div.product div.images {float: none;width: 100%;}
            /** === Product Price Element === **/
            .elementor-widget-tmt-product-price p.price {font-size: 26px;}
            .elementor-widget-tmt-product-price ins {text-decoration: none;font-weight: bold;}
            .elementor-widget-tmt-product-price del {opacity: .6;}
            /** === Product Add To Cart Element === **/
            .tmt-product-add-to-cart .cart {display:flex;flex-wrap: wrap;}
            .tmt-product-add-to-cart form.cart > * {width: 100%;}
            .tmt-product-add-to-cart form.cart .quantity,.tmt-product-add-to-cart form.cart .single_add_to_cart_button {width: auto;}
            .tmt-product-add-to-cart button {margin: 10px 0px !important}
            .tmt-product-add-to-cart .single_add_to_cart_button::before {font-family: "Font Awesome 5 Free";content: "\f07a";font-weight: 900;display: inline;margin-right: 10px;}
            body.rtl .tmt-product-add-to-cart .single_add_to_cart_button::before {margin-right: auto;margin-left: 10px;}
            .product_meta > span:last-child {border-bottom:0 !important}
            /** === Product Data Tabs Element === **/
            .woocommerce #review_form .comment-form {margin: 15px 0 40px 0;display: flex;align-items: center;flex-wrap: wrap;justify-content: space-between;}
            .woocommerce #review_form #respond .comment-form-rating {flex-basis: 100%;}
            .woocommerce #review_form #respond .comment-form-comment {flex-basis:48%;}
            .woocommerce #review_form #respond .comment-form-author,.woocommerce #review_form #respond .comment-form-email {flex-basis:24%;}
            .woocommerce #review_form #respond .comment-form-cookies-consent ,.woocommerce #review_form #respond .form-submit{flex-basis:50%;}
            .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button {border-radius: 0}
            .woocommerce #reviews #comment,.woocommerce .comment-form-comment {height: 75px !important;}
            .woocommerce #wp-comment-cookies-consent {width: 5%;margin-top: 35px;}
            .woocommerce #respond input#submit {padding: 1em !important;}
            .stars a {color: goldenrod;}
            /** === Shop Elements Element === **/
            .tmt-product-add-to-cart .cart {display: flex;flex-direction: column;}
            .woocommerce-account .woocommerce-MyAccount-navigation,.woocommerce-MyAccount-content {margin-bottom:50px}
            .woocommerce-account .woocommerce-MyAccount-navigation li a {display: block;color: #000;padding: 10px 0;margin: 5px 0;border-bottom: 1px solid rgba(0,0,0,.1);width: 80%;}
            .woocommerce-account .woocommerce-MyAccount-navigation li a:hover {border-bottom-color: rgba(0,0,0,.8)}
            .post-type-archive-product .star-rating {transform: translateX(50%);right: 50%;}
            .post-type-archive-product .sidebar .star-rating {transform: translateX(0);right:0;}
            .woocommerce div.product form.cart {margin: 2em 0}
            .woocommerce .quantity .qty {padding: 10px 16px;width: 60px;height: 40px;line-height: 1.65;border: 1px solid rgba(167,167,167,.3);}
            .woocommerce div.product form.cart .button {padding: 12px 20px;}
            .woocommerce .widget_price_filter .ui-slider .ui-slider-range {background-color: rgba(0,0,0,.8)}
            .woocommerce .widget_price_filter .ui-slider .ui-slider-handle {background-color: #FFF;box-shadow:0 0 5px 0 rgba(0,0,0,.4)}
            .woocommerce-cart table.cart td.actions .coupon .input-text {width: 200px;height: 32px;}
            .woocommerce form .form-row textarea {border: 1px solid rgba(0,0,0,.1);padding: 12px;height: 15em;}
            .woocommerce form .form-row input.input-text {border: 1px solid rgba(0,0,0,.1);padding: 5px;}
            .woocommerce .select2-container--default .select2-selection--single {height: 32px;}
            .woocommerce .price {margin: 20px 0}
            .woocommerce .price del {display: block !important;}
            .woocommerce div.product .product_title {font-size: 36px}
            .product_meta {display: flex;flex-direction: column;grid-gap: 20px;}
            .woocommerce ul.products li.first, .woocommerce-page ul.products li.first {clear: none;}
            .remove-sort-by-yes .sort-by,.remove-result-count-yes .woocommerce-result-count {display: none;}

            /** === Product === **/
            @font-face{font-family:"star";src:url("../../plugins/woocommerce/assets/fonts/star.eot");src:url("../../plugins/woocommerce/assets/fonts/star.eot?#iefix") format("embedded-opentype"),url("../../plugins/woocommerce/assets/fonts/star.woff") format("woff"),url("../../plugins/woocommerce/assets/fonts/star.ttf") format("truetype"),url("../../plugins/woocommerce/assets/fonts/star.svg#star") format("svg");font-weight:normal;font-style:normal}@-webkit-keyframes spin{100%{-webkit-transform:rotate(360deg)}}@keyframes spin{100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.tmt-wc-add-to-cart a.added{display:none}.tmt-wc-add-to-cart a.loading:after{content: "\f110";font-family: "Font Awesome 5 Free";font-weight: 900;-webkit-animation:spin .5s linear infinite;animation:spin 1.2s linear infinite;margin-left:10px;display:inline-block}.tmt-wc-rating .star-rating{float:right;overflow:hidden;position:relative;height:1em;line-height:1;font-size:12px;width:6.3em;font-family:"star";letter-spacing:1px}.tmt-wc-rating .star-rating:before{font-family:star;content:"\73\73\73\73\73";color:#e7e7e7;float:left;top:0;left:0;position:absolute;letter-spacing:3px}.tmt-wc-rating .star-rating span{top:0;left:0;position:absolute;overflow:hidden;float:left;padding-top:20px;color:#FFCC00}.tmt-wc-rating .star-rating span:before{content:"\53\53\53\53\53";top:0;position:absolute;left:0;letter-spacing:3px}.tmt-wc-rating:empty{display:none}.tmt-wc-products .tmt-wc-product-inner{-webkit-transition:all .25s ease-in-out;transition:all .25s ease-in-out}.tmt-wc-products .tmt-wc-add-to-cart a{font-size:14px;margin:0;line-height:1;cursor:pointer;position:relative;text-decoration:none;overflow:visible;padding:.718em 1em;font-weight:700;border-radius:3px;left:auto;color:#515151;background-color:#ebe9eb;border:0;white-space:nowrap;display:inline-block;background-image:none;box-shadow:none;text-shadow:none;-webkit-transition:all .25s ease-in-out;transition:all .25s ease-in-out}.tmt-wc-products .tmt-wc-add-to-cart a:hover{background-color:#dcdee0;color:#000}.tmt-wc-products .tmt-wc-product{position:relative;text-align:center}.tmt-wc-products .tmt-wc-product .tmt-wc-product-title{padding:1.5em 0 .5em;margin:0;font-size:1em}.tmt-wc-products .tmt-wc-product .tmt-text-small{font-size:.775rem}.tmt-wc-products .tmt-wc-product .tmt-wc-product-price{display:block;margin-bottom:.5em;font-weight:700}.tmt-wc-products .tmt-wc-product .tmt-wc-product-price ins{background:none;text-decoration:none}.tmt-wc-products .tmt-wc-product .tmt-wc-product-price del{font-weight:600;opacity:.3;font-size:14px}.tmt-wc-products .tmt-wc-product .tmt-badge{padding:14px 8px;font-weight:700;box-sizing:initial;max-width: calc(100% - (15px * 2));margin-top: 15px;top: 0;left: 0;position: absolute;min-width: 22px;height: 22px;background: #000;color: #fff;display: inline-flex;justify-content: center;align-items: center;font-size: .875rem;}.tmt-wc-add-to-cart a.added{display: none}.tmt-wc-product-image {overflow: hidden}.tmt-wc-products .tmt-wc-rating{margin-bottom:.5em}.tmt-wc-products .tmt-wc-rating .star-rating{float:none;margin-right:0}.tmt-wc-products.tmt-wc-products-skin-table .paginate_button{text-decoration:none}.tmt-wc-products.tmt-wc-products-skin-table .tmt-wc-product{text-align:left}.tmt-wc-products.tmt-wc-products-skin-table table th,.tmt-wc-products.tmt-wc-products-skin-table table td{box-sizing:content-box}.tmt-wc-products.tmt-wc-products-skin-table table img{width:80px}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-excerpt{max-width:500px;font-size:15px}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-ep-align{text-align:center}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-price{margin-bottom:0}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-price p{margin-bottom:0}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-title{padding:0}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-categories a,.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-tags a{color:#1e87f0}.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-categories,.tmt-wc-products.tmt-wc-products-skin-table table .tmt-wc-product-tags{color:#1e87f0}@media only screen and (max-width:959px){.tmt-wc-products{overflow-x:scroll}}

            /* woocommerce extra */
            .woocommerce.woocommerce-archive .sort-by a {display: inline-block !important;}
            .woocommerce .tmt-product-item .img-product img {height: 100% !important;}
            :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button.alt {background: #757575;color: #fff;padding: 0.5rem 1rem;border-radius: 10px;cursor: pointer;}
            :where(body:not(.woocommerce-block-theme-has-button-styles)) .woocommerce button.button.alt:hover {background: #ff4c15;}
            .woocommerce nav.woocommerce-pagination ul , .woocommerce nav.woocommerce-pagination ul li {border: 0;}

            .woocommerce-message .tmt-add-to-cart-message {flex-wrap:wrap !important}
            .woocommerce p.stars a::before {color:gold;}
            ';
        }
        if (!empty($custom_css)) {
            $css .= $this->tmt_minify_css($custom_css);
        }

        if (! empty($css)) {
            $output .= '/** === Generate CSS === **/' . $this->tmt_minify_css($css);
        }
        return $output;
    }
}

new Front_CSS;
