<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
class Themento_Image_Box extends Widget_Base
{
    public function get_name()
    {
        return 'tmt-image-box';
    }

    public function get_title()
    {
        return __('Image Box', text_domain);
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return [text_domain];
    }

   
    public function get_keywords()
    {
        return ['image', 'box', 'image-box'];
    }

    public function get_script_depends() {
        return [ 'swiper' ];
    }
    public function get_style_depends() {
        return [ 'swiper' ];
    }

    protected function register_controls()
    {
        $this->register_general_controls();
        $this->register_slider_controls();
        $this->register_style_general_controls();
        $this->register_style_term_controls();
        $this->register_style_navigation_controls();
    }


    // register content controls
    protected function register_general_controls()
    {
        $this->start_controls_section(
            'section_slides',
            [
                'label' => __('Slides', text_domain),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

         
        // repeater slides
        $repeater_slides = new Repeater();


        // photo
        $repeater_slides->add_control(
            'photo',
            [
                'label'   => __('Choose Photo', text_domain),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => wp_directory_uri . '/assets/images/member.svg',
                ],
            ]
        );

        $repeater_slides->add_control(
            'object_fit',
            [
                'label' => __('Object Fit', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'       => __('Fill', text_domain),
                    'contain'    => __('Contain', text_domain),
                    'cover'      => __('Cover', text_domain),
                    'scale-down' => __('Scale Down', text_domain),
                    'none'       => __('None', text_domain),
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-image-box .image-box-img img' => 'object-fit: {{VALUE}};',
                ]
            ]
        );

        // slide title
        $repeater_slides->add_control(
            'slide_title',
            [
                'label'   => __('Title', text_domain),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            ]
        );

       // slide link
       $repeater_slides->add_control(
            'slide_link',
            [
                'label'   => __('Link', text_domain),
                'type'    => Controls_Manager::URL,
                'default' => ['' => ''],
            ]
        );


        // slides
        $this->add_control(
            'slides',
            [
                'label' => __('Slides', text_domain),
                'type' => Controls_Manager::REPEATER,
                'show_label' => true,
                'fields' =>  $repeater_slides->get_controls(),
                // 'default' => [
                //     [
                //         'text' => __('Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain),
                //         'name' => __('Ali Amini 1', text_domain),
                //         'title' => __('CEO 1', text_domain),
                //     ],
                //     [
                //         'text' => __('Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain),
                //         'name' => __('Ali Amini 2', text_domain),
                //         'title' => __('CEO 2', text_domain),
                //     ],
                //     [
                //         'text' => __('Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain),
                //         'name' => __('Ali Amini 3', text_domain),
                //         'title' => __('CEO 3', text_domain),
                //     ],
                // ],
                'title_field' => '{{{ slide_title }}}',
            ]
        );

          

        $this->end_controls_section();
    }

    // register slider controls
    protected function register_slider_controls() {
        $this->start_controls_section(
            'section_slider_options',
            [
                'label' => __( 'Slider Options', text_domain ),
                'type' => Controls_Manager::SECTION,
            ]
        );
        // $this->add_responsive_control(
        //     'slides_height',
        //     [
        //         'label' => __( 'Height', text_domain ),
        //         'type' => Controls_Manager::SLIDER,
        //         'range' => [
        //             'px' => [
        //                 'min' => 100,
        //                 'max' => 1000,
        //             ],
        //             'vh' => [
        //                 'min' => 10,
        //                 'max' => 100,
        //             ],
        //         ],
        //         'default' => [
        //             'size' => 400,
        //         ],
        //         'size_units' => [ 'px', 'vh', 'em' ],
        //         'selectors' => [
        //             '{{WRAPPER}} .tmt-slider,{{WRAPPER}} .tmt-slider-item,{{WRAPPER}} .tmt-slider-item > img' => 'height: {{SIZE}}{{UNIT}};',
        //         ],
        //         'separator' => 'before',
        //     ]
        // );

        $this->add_control(
            'slider_columns',
            [
	            'label' => __( 'Number of Columns', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_tablet',
            [
	            'label' => __( 'Columns Tablet', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_mobile',
            [
	            'label' => __( 'Columns Mobile', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );


       $this->add_control(
            'navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'both',
                'options' => [
                    'both' => __( 'Arrows and Dots', text_domain ),
                    'arrows' => __( 'Arrows', text_domain ),
                    'dots' => __( 'Dots', text_domain ),
                    'none' => __( 'None', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __( 'Pause on Hover', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Autoplay', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __( 'Autoplay Speed', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'default' => 2000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label' => __( 'Infinite Loop', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label' => __( 'Center Mode', text_domain ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );
        $this->add_control(
            'effect',
            [
                'label' => __( 'Effect', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
	                'none'      => __( 'None', text_domain ),
	                'fade'      => __( 'Fade', text_domain ),
	                'cube'      => __( 'Cube', text_domain ),
                    'coverflow' => __( 'Coverflow', text_domain ),
                    'flip'      => __( 'Flip', text_domain ),
                    'cards'     => __( 'Cards', text_domain ),
                    'creative'  => __( 'Creative', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'creative_type',
            [
                'label' => __( 'Creative Type', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
	                '1' => __( 'Type', text_domain ) . ' 1',
	                '2' => __( 'Type', text_domain ) . ' 2',
                    '3' => __( 'Type', text_domain ) . ' 3',
                    '4' => __( 'Type', text_domain ) . ' 4',
                    '5' => __( 'Type', text_domain ) . ' 5',
                    '6' => __( 'Type', text_domain ) . ' 6',
                ],
                'condition' => [
                    'effect' => 'creative'
                ],
            ]
        );
        $this->end_controls_section();
    }

    // register style general controls
    protected function register_style_general_controls() {
        $this->start_controls_section(
            'section_style_general',
            [
                'label' => __( 'General', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        //  column gap
        $this->add_responsive_control(
            'column_gap',
            [
                'label' => esc_html__( 'Space Between Column', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide' => 'padding-left: {{SIZE}}{{UNIT}};padding-right:{{SIZE}}{{UNIT}}',
                ],
            ]
        );

         // margin posts
         $this->add_responsive_control(
            'image_box_margin',
            [
                'label' => __( 'Margin Posts', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '0',
                    'right' => '10',
                    'bottom' => '0',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-image-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // // padding slider
        // $this->add_responsive_control(
        //     'padding_slider',
        //     [
        //         'label' => __( 'Padding Slider', text_domain ),
        //         'type' => Controls_Manager::DIMENSIONS,
        //         'size_units' => [ 'px'],
        //         'default' => [
        //             'top' => '0',
        //             'right' => '10',
        //             'bottom' => '0',
        //             'left' => '10',
        //             'unit' => 'px',
        //             'isLinked' => false,
        //         ],
        //         'selectors' => [
        //             '{{WRAPPER}} .swiper-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        //         ],
        //     ]
        // );

        // // margin posts
        //  $this->add_responsive_control(
        //     'margin_posts',
        //     [
        //         'label' => __( 'Margin Posts', text_domain ),
        //         'type' => Controls_Manager::DIMENSIONS,
        //         'size_units' => [ 'px', '%', 'em' ],
        //         'default' => [
        //             'top' => '0',
        //             'right' => '10',
        //             'bottom' => '0',
        //             'left' => '10',
        //             'unit' => 'px',
        //             'isLinked' => false,
        //         ],
        //         'selectors' => [
        //             '{{WRAPPER}} .tmt-image-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        //         ],
        //     ]
        // );
        // margin
        $this->add_responsive_control(
            'img_box_margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'right' => 10,
                    'bottom' => 0,
                    'left' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-box-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        // padding
        $this->add_responsive_control(
            'img_box_padding',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .image-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'height',
                [
                    'label' => esc_html__( 'Height', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'rem' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 300,
                            'step' => 1,
                        ],
                        'rem' => [
                            'min' => 0,
                            'max' => 150,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                            'unit' => 'px',
                            'size' => 150,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .image-box-img' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
        );

        $this->start_controls_tabs(
            'style_tabs_background'
        );
        $this->start_controls_tab(
            'style_background_normal_tab',
                [
                    'label' => esc_html__( 'Normal', text_domain ),
                ]
        );
        // background
        $this->add_control(
            'img_box_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                        '{{WRAPPER}} .image-box-content .image-box-overlay' => 'background-color: {{VALUE}};transition: 0.3s;',
                ],
            ]
        );    
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_background_hover_tab',
                [
                    'label' => esc_html__( 'Hover', text_domain ),
                ]
        );
        // background hover
        $this->add_control(
            'img_box_background_color_hover',
            [
                'label' => __( 'Background Hover Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                        '{{WRAPPER}} .image-box-content .image-box-overlay:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );    
        $this->end_controls_tab();
        $this->end_controls_tabs();

        // border radius
        $this->add_responsive_control(
            'img_box_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                        '{{WRAPPER}} .image-box-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // border
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'img_box_border',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} .image-box-content',
			]
		);	

        // box shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'img_box_shadow',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} .image-box-content',
            ]
        );


        $this->end_controls_section();
        
    }

    // register style term controls
    protected function register_style_term_controls() {
        $this->start_controls_section(
            'term_section',
                [
                    'label' => esc_html__( 'Term', text_domain ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
        );


        $this->add_control(
            'change_direction',
                [
                    'label' => esc_html__( 'Term Position', text_domain ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Right', text_domain ),
                    'label_off' => esc_html__( 'Left', text_domain ),
                    'return_value' => 'right',
                    'default' => 'right',
                ]
        );


        $this->add_responsive_control(
            'rtl_position',
                [
                    'label' => esc_html__( 'Position', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'allowed_dimensions' => [ 'bottom', 'right' ],
                    'selectors' => [
                            '{{WRAPPER}} .category' => 'bottom: {{BOTTOM}}px;right: {{RIGHT}}px;left: auto;',
                    ],
                    'condition' => [
                        'change_direction' => 'right',
                    ],
                ]
        );


        $this->add_responsive_control(
            'ltr_position',
            [
                'label' => esc_html__('Position', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'allowed_dimensions' => ['bottom', 'left'], 
                'selectors' => [
                    '{{WRAPPER}} .category' => 'bottom: {{BOTTOM}}px;left: {{LEFT}}px;right: auto;', 
                ],
                'condition' => [
                        'change_direction!' => 'right',
                ],
            ]
        );


        $this->add_responsive_control(
            'term_margin',
                [
                    'label' => esc_html__( 'Margin', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'top' => 0,
                        'right' => 0,
                        'bottom' => 0,
                        'left' => 0,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );

           
        
        $this->add_responsive_control(
            'term_padding',
                [
                    'label' => esc_html__( 'Padding', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'top' => 0,
                        'right' => 0,
                        'bottom' => 0,
                        'left' => 0,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        
        
        $this->start_controls_tabs(
            'style_tabs_term'
        );
        $this->start_controls_tab(
            'style_term_normal_tab',
                [
                    'label' => esc_html__( 'Normal', text_domain ),
                ]
        );

        

        $this->add_control(
            'term_color_normal',
                [
                    'label' => esc_html__( 'Term Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .category' => 'color: {{VALUE}};transition: 0.3s;',
                    ],
                ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_term_hover_tab',
                [
                    'label' => esc_html__( 'Hover', text_domain ),
                ]
        );    

        $this->add_control(
            'term_color_hover',
                [
                    'label' => esc_html__( 'Term Color Hover', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .category:hover' => 'color: {{VALUE}}',
                    ],
                ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();
        

        

        $this->add_group_control(
            Group_Control_Border::get_type(),
                [
                    'name' => 'border',
                    'selector' => '{{WRAPPER}} .category',
                ]
        );

       

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'term_typography',
                    'selector' => '{{WRAPPER}} .category',
                ]
        );



        $this->end_controls_section();
    }

   

    // // register style slider controls
    // protected function register_style_slider_controls() {
    //     $this->start_controls_section(
    //         'section_slides_style',
    //         [
    //             'label' => __( 'Slide', text_domain ),
    //             'tab' => Controls_Manager::TAB_STYLE,
    //         ]
    //     );

    //     $this->add_control(
    //         'slide_width',
    //         [
    //             'label' => __( 'Width', text_domain ),
    //             'type' => Controls_Manager::SLIDER,
    //             'size_units' => [ 'px', '%' ],
    //             'range' => [
    //                 'px' => [
    //                     'min' => 0,
    //                     'max' => 1200,
    //                     'step' => 5,
    //                 ],
    //                 '%' => [
    //                     'min' => 0,
    //                     'max' => 100,
    //                 ],
    //             ],
    //             'default' => [
    //                 'unit' => '%',
    //                 'size' => 100,
    //             ],
    //             'selectors' => [
    //                 '{{WRAPPER}} .tmt-member-slider' => 'width: {{SIZE}}{{UNIT}};',
    //             ],
    //         ]
    //     );

    //     $this->add_control(
    //         'slide_margin',
    //         [
    //             'label' => __( 'Margin', text_domain ),
    //             'type' => Controls_Manager::DIMENSIONS,
    //             'size_units' => [ 'px', '%', 'em' ],
    //             'default' => [
    //                 'top' => '0',
	//                 'right' => '0',
	//                 'bottom' => '0',
	//                 'left' => '0',
	//                 'unit' => 'px',
	//                 'isLinked' => false,
    //             ],
    //             'selectors' => [
    //                 '{{WRAPPER}} .tmt-member-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
    //             ],
    //         ]
    //     );

    //     $this->add_control(
    //         'slide_padding',
    //         [
    //             'label' => __( 'Padding', text_domain ),
    //             'type' => Controls_Manager::DIMENSIONS,
    //             'size_units' => [ 'px', '%', 'em' ],
    //             'default' => [
    //                 'top' => '0',
	//                 'right' => '0',
	//                 'bottom' => '0',
	//                 'left' => '0',
	//                 'unit' => 'px',
	//                 'isLinked' => false,
    //             ],
    //             'selectors' => [
    //                 '{{WRAPPER}} .tmt-member-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    //             ],
    //         ]
    //     );

    //     $this->add_control(
    //         'slide_radius',
    //         [
    //             'label' => __( 'Radius', text_domain ),
    //             'type' => Controls_Manager::DIMENSIONS,
    //             'size_units' => [ 'px', '%', 'em' ],
    //             'selectors' => [
    //                 '{{WRAPPER}} .tmt-member-slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
    //             ],
    //         ]
    //     );

    //     $this->add_control(
    //         'slide_bg_color',
    //         [
    //             'label' => __( 'Background Color', text_domain ),
    //             'type' => Controls_Manager::COLOR,
    //             'default' => '',
    //             'selectors' => [
    //                 '{{WRAPPER}} .tmt-member-slider' => 'background-color: {{VALUE}}',
    //             ],
    //         ]
    //     );

    //     $this->add_group_control(
    //         Group_Control_Box_Shadow::get_type(),
    //         [
    //             'name' => 'slide_box_shadow',
    //             'label' => __( 'Box Shadow', text_domain ),
    //             'selector' => '{{WRAPPER}} .tmt-member-slider',
    //         ]
    //     );

    //     $this->add_group_control(
    //         Group_Control_Border::get_type(),
    //         [
    //             'name' => 'slide_border',
    //             'label' => __( 'Border', text_domain ),
    //             'selector' => '{{WRAPPER}} .tmt-member-slider',
    //         ]
    //     );

    //     $this->end_controls_section();
    // }


    

    // register style navigation controls
    protected function register_style_navigation_controls() {
        $this->start_controls_section(
            'section_style_navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'navigation' => [ 'arrows', 'dots', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'heading_style_arrows',
            [
                'label' => __( 'Arrows', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'right_arrow',
            [
                'label' => __( 'Right Arrow', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'left_arrow',
            [
                'label' => __( 'Left Arrow', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'left' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'top: {{TOP}}%;left: {{LEFT}}%;right: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_size',
            [
                'label' => __( 'Arrows Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->start_controls_tabs( 'arrows_icon_tabs' );
        $this->start_controls_tab( 'arrows_icon_normal', [ 
            'label' => __( 'Normal', text_domain ),
            'condition' => [
                'navigation' => [ 'arrows', 'both' ],
            ],
        ] );

        $this->add_control(
            'arrows_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'arrows_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'arrows_icon_hover', [ 
            'label' => __( 'Hover', text_domain ),
            'condition' => [
                'navigation' => [ 'arrows', 'both' ],
            ],
        ] );

        $this->add_control(
            'arrows_hover_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'arrows_hover_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'arrow_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_width',
                [
                    'label' => esc_html__( 'Width', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );
            $this->add_responsive_control(
            'arrow_height',
                [
                    'label' => esc_html__( 'Height', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );
            $this->add_responsive_control(
            'arrow_line_height',
                [
                    'label' => esc_html__( 'Line Height', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'line-height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );

        $this->add_control(
            'heading_style_dots',
            [
                'label' => __( 'Dots', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_position',
            [
                'label' => __( 'Dots Position', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_width',
            [
                'label' => __( 'Width', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_height',
            [
                'label' => __( 'Height', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'dots_color',
            [
                'label' => __( 'Dots Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'active_dot_color',
            [
                'label' => __( 'Active Dot Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
                'default' => '#4054B2',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_width',
            [
                'label' => __( 'Width', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_height',
            [
                'label' => __( 'Height', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_margin',
            [
                'label' => esc_html__('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],

                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'   => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );

       $this->add_control(

           'style_outline_hover',
           [
               'label' => __( 'Style Outline', text_domain ),
               'type' => Controls_Manager::SELECT,
               'default' => 'solid',
               'options' => [
                   'none' => __( 'None', text_domain ),
                   'solid'  => __( 'Solid', text_domain ),
                   'dashed' => __( 'Dashed', text_domain ),
                   'dotted' => __( 'Dotted', text_domain ),
                   'double' => __( 'Double', text_domain ),
                ],
               'selectors' => [
                   '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-style:{{VALUE}}',
                ],
               ]
       );

       $this->add_control(
          'outline_thickness_hover',
          [
            'label' => __( 'Thickness', text_domain ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'default' => [
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-width: {{SIZE}}px;',
            ],
            'condition' => [
                'style_outline_hover!' => 'none',
                'navigation' =>  'dots',
            ],
        ]
       );

       $this->add_control(
           'outline_color_hover',
           [
            'label' => __( 'Color', text_domain ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-color: {{VALUE}}',
            ],
            'condition' => [
                'style_outline_hover!' => 'none',
                'navigation' =>  'dots',
                ],
            ]
       );

        $this->add_control(
            'outline_offset_hover',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                    'min' => 0,
                    'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-offset: {{SIZE}}px;',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
            );

            $this->add_control(
                'border_radius_outline_hover',
                [
                    'label' => __( 'Border Radius', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                    'condition' => [
                        'style_outline_hover!' => 'none',
                        'navigation' =>  'dots',
                    ],
                ]
            );


        $this->end_controls_section();
        
    }



    // render
    protected function render() {
        // Variables
        $settings = $this->get_settings();

        $id = $this->get_id();
        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
        $show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
        $columns = $settings['slider_columns'];
        $columns_tablet = $settings['slider_columns_tablet'];
        $columns_mobile = $settings['slider_columns_mobile'];
        $pause_on_hover = $settings['pause_on_hover'];
        $infinite = $settings['infinite'];
        $autoplay = $settings['autoplay'];
        $centerMode = $settings['centerMode'];
        $autoplay_speed = $settings['autoplay_speed'];
        $effect = $settings['effect'];
        $data_swiper = [
            'columns' => absint($columns),
            'columns_tablet' => absint($columns_tablet),
            'columns_mobile_h' => $columns_tablet == 1 ? 1 : $columns_tablet - 1,
            'columns_mobile' => absint($columns_mobile),
            'autoplay' => ( 'yes' === $autoplay ),
            'speed' => absint($autoplay_speed),
            'pause_on_hover' => ( 'yes' === $pause_on_hover ),
            'infinite' => ( 'yes' === $infinite ),
            'centerMode' => ( 'yes' === $centerMode ),
            'effect' => $effect,
        ];
        if($effect == 'creative') {
            $data_swiper['creative-type'] = $settings['creative_type'];
        }

        $this->add_render_attribute( 'slides', [
            'data-swiper' => wp_json_encode( $data_swiper ),
        ] );

        if ( $settings['slides'] ) { 

            echo "<div id='slider-$id' class='swiper tmt-slider-yes tmt-image-box' dir='$direction' ". $this->get_render_attribute_string( 'slides' ) .">"
            . "<div class='swiper-wrapper'>";
                    foreach($settings['slides'] as $slide) {
                        $id = $slide['_id'];
                        $img_url = $slide['photo']['url'];
                        $link = $slide['slide_link']['url'];
                        $title = $slide['slide_title'];

                        echo "<div class='swiper-slide elementor-repeater-item-$id'>"
                            . "<a  href='$link' class='image-box-content'>"
                                ."<div class='image-box-img'>"
                                    ."<img src='$img_url' alt='$title' title='$title'>"
                                ."</div>"
                                . "<div class='image-box-overlay'>"
                                     . "<div class='category'>";
                                         echo $title;
                                     echo "</div>"
                                . "</div>"
                            . "</a>"
                        . "</div>";
                    }
                    echo "</div>";
                   
                    if($show_dots) {
                        echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
                    }
                    if($show_arrows) {
                        echo "<div class='tmt-sw-button swiper-button-prev'></div>"
                        . "<div class='tmt-sw-button swiper-button-next'></div>";
                    }

            echo "</div>";

           
        }

    }    
}



Plugin::instance()->widgets_manager->register(new Themento_Image_Box);
