<?php

namespace Elementor;
if (!defined('ABSPATH')) {
     exit; // Exit if accessed directly.
}
class Themento_Post_Grid extends Widget_Base {
     public function get_name() {
         return 'tmt-post-grid';
     }
     public function get_title() {
         return __('Post Grid', text_domain );
     }
     public function get_icon() {
         return ['eicon-posts-grid'];
     }
     public function get_categories() {
         return [text_domain];
     }
     public function get_script_depends() {
        return [ 'swiper' ];
    }
    public function get_style_depends() {
        return [ 'swiper' ];
    }

    protected function _register_controls() {
          $this->register_content_controls();
          $this->register_slider_controls();
          $this->register_style_general_controls();
          $this->register_style_avatar();
          $this->register_style_term_controls();
          $this->register_style_author_controls();
          $this->register_style_date();
          $this->register_style_image_controls();
          $this->register_style_arrows_dots_slider_controls();
          $this->register_style_title_controls();
          $this->register_style_description_controls();
          $this->register_style_read_more_controls();
          $this->register_style_pagination_controls();
    }

    // Register Content Controls
    protected function register_content_controls() {
        $this->start_controls_section(
            'settings',
            [
                'label' => __( 'Content', text_domain )
            ]
		);

        // select style
        $this->add_control(
			'select_style',
			[
				'label' => __( 'Border Style', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style-1',
				'options' => [
					'style-1'  => __( 'Style One', text_domain ),
					'style-2'  => __( 'Style Two', text_domain ),
				],
			]
		);

        // post type
        $post_types = get_posts_types();
			foreach ( $post_types as $post_type => $x ) {
				$taxonomies = get_object_taxonomies($post_type, 'objects');
				unset($taxonomies['post_translations'],$taxonomies['language'],$taxonomies['post_format']);
				foreach ( $taxonomies as $taxonomy => $object ) {
					$categories = get_terms( array(
						'taxonomy'    => $object->name,
						'hide_empty' => 0,
					) );
					$cat_array  = array();
					foreach( $categories as $cat_id => $cat_name ) {
						$cat_array[ $cat_name->term_id ] = $cat_name->name;
					}
					@$this->add_control(
						$object->name,
						[
							'label' => $object->label,
							'type' => Controls_Manager::SELECT2,
							'label_block' => true,
							'multiple' => true,
							'options' => $cat_array,
							'condition' => [
								'post_type' => $object->object_type,
							],
						]
					);
				}
		}


        $this->add_control(
            'post_type',
            [
                'label' => __( 'Post Type', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'post',
                'options' => get_posts_types(),
            ]
        );

        // columns
        $this->add_responsive_control(
			'post_columns',
			[
				'label' => __( 'Number of Columns', text_domain ),
				'type' => Controls_Manager::SELECT,
				'options' => [
                    '100%'       => __( '1 Columns', text_domain ),
                    '50%'        => __( '2 Columns', text_domain ),
                    '33.333333%' => __( '3 Columns', text_domain ),
                    '25%'        => __( '4 Columns', text_domain ),
                    '20%'        => __( '5 Columns', text_domain ),
                    '16.666667%' => __( '6 Columns', text_domain ),
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => '33.333333%',
				'tablet_default' => '50%',
				'mobile_default' => '100%',
				'selectors' => [
                    '{{WRAPPER}} .tmt-posts > *' => '-ms-flex: 0 0 {{VALUE}};flex: 0 0 {{VALUE}};max-width: {{VALUE}};',
                ],
				'condition' => [
                    'enable_slider!' => 'yes',
                ],
			]
		);

   
        // post count
        $this->add_control(
            'posts_count',
              [
                'label' => __( 'Number of Posts', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
                    'condition' => [
                            'post_type!' => 'loop'
                      ],
               ]
        );

        // post order
        $this->add_control(
            'post_order',
             [
                 'label' => __( 'Order', text_domain ),
                 'type' => Controls_Manager::SELECT,
                 'options' => [
                     'asc' => __( 'Ascending', text_domain ),
                     'desc' => __( 'Descending', text_domain )
                 ],
                 'default' => 'asc',
                 'condition' => [
                     'post_type!' => 'loop'
                 ],
             ]
        );

        // enable term
		$this->add_control(
			'enable_term',
			[
				'label' => __( 'Enable Term', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'select_style' => ['style-2']
				],
			]
		);

        //show icon
		$this->add_control(
			'show_icon',
			[
			    'label' => __( 'Show Icon', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'select_style' => ['style-2'],
                    'enable_term' => 'yes'
				],
			]
		);

        // select icon
        $this->add_control(
		    'select_icon',
		    [
		        'label'            => __( 'Select Icon', text_domain ),
		        'type'             => Controls_Manager::ICONS,
		        'fa4compatibility' => 'icon',
		        'default' => [
		            'value' => 'fas fa-map',
		            'library' => 'fa-solid',
		        ],
				'condition' => [
					'select_style' => ['style-2'],
					'show_icon' => 'yes',
				],
		    ]
		);

        // enable avatar
		$this->add_control(
			'enable_avatar',
			[
				'label' => __( 'Enable avatar', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'post_type!' => 'loop',
					'select_style' => 'style-1'
				],
			]
		);
        
        // avatar
        $this->add_control(
            'avatar',
			[
                'label' => esc_html__( 'Choose avatar', text_domain ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
                    'url' => Utils::get_placeholder_image_src(),
				],
                'condition' => [
                    'enable_avatar' => 'yes',
                    'select_style' => 'style-1'
				],
            ]
        );
            
            
        // enable author
        $this->add_control(
            'enable_author',
            [
                'label' => __( 'Enable author', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                	'post_type!' => 'loop',
                	'select_style' => 'style-1'
                ],
            ]
        );       
            

        // enable date
		$this->add_control(
			'enable_date',
			[
				'label' => __( 'Enable Date', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
                    'select_style' => ['style-1','style-2'],
					'post_type!' => 'loop'
				],
			]
		);
        

        // image
		$this->add_group_control(
		    Group_Control_Image_Size::get_type(),
		    [
		        'name' => 'image',
		        'default' => 'large',
				'separator' => 'before',
		    ]
		);

        // object fit
        $this->add_control(
		    'object_fit',
		     [
		        'label' => __( 'Image Fit', text_domain ),
		        'type' => Controls_Manager::SELECT,
		        'options' => [
		            'inherit'    => __( 'None', text_domain ),
		            'cover'      => __( 'Cover', text_domain ),
		            'contain'    => __( 'Contain', text_domain ),
		            'fill'       => __( 'Fill', text_domain ),
		            'scale-down' => __( 'Scale Down', text_domain ),
		         ],
		        'default' => 'inherit',
		        'selectors' => [
		            '{{WRAPPER}} .thumbnail img ,{{WRAPPER}} .card-img img' => 'object-fit: {{VALUE}}',
				],
		    ]
		);

        // enable slider
		$this->add_control(
			'enable_slider',
			[
				'label' => __( 'Enable Slider', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'post_type!' => 'loop',
				],
			]
		);


        // enable title
		$this->add_control(
            'enable_title',
            [
                'label' => __( 'Show Title', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => 'no',
                'condition' => [
					'select_style' => ['style-1','style-2']
				],
            ]
        );

        // Title tags
        $this->add_control(
			'title_tag',
			[
				'label' => __( 'Title Tag', text_domain ),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => TMT_Title_Tags(),
				'default' => 'h4',
				'condition' => [
					'enable_title' => 'yes'
				],
			]
		);

        //enable excerpt
		$this->add_control(
            'enable_excerpt',
            [
                'label' => __( 'Show Excerpt', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => 'yes',
                'condition' => [
					'select_style' => ['style-1']
					
				],
            ]
        );

        // excerpt length
        $this->add_control(
                'excerpt_length',
                [
                    'label' => __( 'Excerpt Words', text_domain ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => '15',
                    'condition' => [
                        'select_style' => ['style-1'],
                        'enable_excerpt' => 'yes'
                    ],
                ]
        );


        // enable more
		$this->add_control(
            'enable_more',
            [
                'label' => __( 'Show Read More', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before' ,
                'default' => 'no',
                'condition' => [
					'select_style' => ['style-1']
				],
            ]
        );

        // text more link
        $this->add_control(
            'text_more_link',
            [
                'label' => __( 'Read More Text', text_domain ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Read More', text_domain ),
                'condition' => [
                    'enable_more' => 'yes',
                ],
            ]
        );

        // show_pagination
		$this->add_control(
            'show_pagination',
            [
                'label' => __( 'Show Pagination', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before' ,
                'default' => 'yes',
                'condition' =>[
                    'post_type!' => 'loop'
                ],
            ]
        );

    
        $this->end_controls_section();
        
    }

    // Register slider controls
    protected function register_slider_controls() {
        $this->start_controls_section(
            'section_slider',
            [
                'label'     => esc_html__( 'Slider', text_domain ),
                'condition' => [
                    'enable_slider' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'slider_columns',
            [
                'label' => __( 'Columns', text_domain ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => __( '1 Columns', text_domain ),
                    '2' => __( '2 Columns', text_domain ),
                    '3' => __( '3 Columns', text_domain ),
                    '4' => __( '4 Columns', text_domain ),
                    '5' => __( '5 Columns', text_domain ),
                    '6' => __( '6 Columns', text_domain ),
                ],
                'default' => '3',
                'condition' => [
                    'enable_slider' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'columns_tablet',
            [
                'label' => __( 'Columns Tablet', text_domain ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => __( '1 Columns', text_domain ),
                    '2' => __( '2 Columns', text_domain ),
                    '3' => __( '3 Columns', text_domain ),
                    '4' => __( '4 Columns', text_domain ),
                    '5' => __( '5 Columns', text_domain ),
                    '6' => __( '6 Columns', text_domain ),
                ],
                'default' => '2',
                'condition' => [
                    'enable_slider' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'columns_mobile',
            [
                'label' => __( 'Columns Mobile', text_domain ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => __( '1 Columns', text_domain ),
                    '2' => __( '2 Columns', text_domain ),
                    '3' => __( '3 Columns', text_domain ),
                    '4' => __( '4 Columns', text_domain ),
                    '5' => __( '5 Columns', text_domain ),
                    '6' => __( '6 Columns', text_domain ),
                ],
                'default' => '1',
                'condition' => [
                    'enable_slider' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'arrows',
                'options' => [
                    'both' => __( 'Arrows and Dots', text_domain ),
                    'arrows' => __( 'Arrows', text_domain ),
                    'dots' => __( 'Dots', text_domain ),
                    'none' => __( 'None', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __( 'Pause on Hover', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Autoplay', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __( 'Autoplay Speed', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'default' => 1000,
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label' => __( 'Infinite Loop', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label' => __( 'Center Mode', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
		$this->add_control(
            'effect',
            [
                'label' => __( 'Effect', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
	                'none'      => __( 'None', text_domain ),
	                'fade'      => __( 'Fade', text_domain ),
	                'cube'      => __( 'Cube', text_domain ),
                    'coverflow' => __( 'Coverflow', text_domain ),
                    'flip'      => __( 'Flip', text_domain ),
                    'cards'     => __( 'Cards', text_domain ),
                    'creative'  => __( 'Creative', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'creative_type',
            [
                'label' => __( 'Creative Type', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
	                '1' => __( 'Type', text_domain ) . ' 1',
	                '2' => __( 'Type', text_domain ) . ' 2',
                    '3' => __( 'Type', text_domain ) . ' 3',
                    '4' => __( 'Type', text_domain ) . ' 4',
                    '5' => __( 'Type', text_domain ) . ' 5',
                    '6' => __( 'Type', text_domain ) . ' 6',
                ],
                'condition' => [
                    'effect' => 'creative'
                ],
            ]
        );
        $this->end_controls_section();
    }

    // Register style general controls
    protected function register_style_general_controls() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Settings Public', text_domain ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        //  height
        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'rem',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-items .blog-item ,{{WRAPPER}} .projects .card' => 'height:{{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'select_style' => ['style-1','style-2']
                ]
            ]
        );

        //  column gap
        $this->add_responsive_control(
            'column_gap',
            [
                'label' => esc_html__( 'Space Between Column', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-items , {{WRAPPER}} .projects' => 'padding-left: {{SIZE}}{{UNIT}};padding-right:{{SIZE}}{{UNIT}}',
                ],
            ]
        );
        //  row gap
        $this->add_responsive_control(
            'row_gap',
            [
                'label' => esc_html__( 'Space Between Row', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-items , {{WRAPPER}} .projects' => 'padding-top: {{SIZE}}{{UNIT}};padding-bottom:{{SIZE}}{{UNIT}}',
                ],
                // 'conditon' => [
                //     'enable_slider!' => 'yes'
                // ]
            ]
        );

        // padding posts
        $this->add_responsive_control(
            'padding_item',
            [
                'label' => __( 'Padding Posts', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '0',
                    'right' => '10',
                    'bottom' => '0',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-items .blog-item , {{WRAPPER}} .projects .card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
            ]
       );

        // margin posts
        $this->add_responsive_control(
            'margin_posts',
            [
                'label' => __( 'Margin Posts', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '0',
                    'right' => '10',
                    'bottom' => '0',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-posts , .tmt-posts-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // background item
        $this->add_control(
            'bg_item',
            [
                'label' => __( 'Background', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .blog-items .blog-item ,{{WRAPPER}} .projects .card' => 'background: {{VALUE}}',
                ],
            ]
        );
               

        // border radius item
        $this->add_responsive_control(
            'border_radius_item',
            [
                'label' => __( 'Border Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '16',
                    'right' => '16',
                    'bottom' => '16',
                    'left' => '16',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .blog-items .blog-item ,{{WRAPPER}} .projects .card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                // 'condition' => [
                //     'select_style' => 'style-1',
                //     'select_style' => 'style-2',
                // ]
            ]
        );

       


        // border item
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} .blog-item ,{{WRAPPER}} .projects .card',
                
            ]
        );

        // box shadow item
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_item',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} .blog-item, {{WRAPPER}} .projects .card',
            ]
        );


        $this->end_controls_section();
    }

    // Register style term controls
    protected function register_style_term_controls() {
        $this->start_controls_section(
            'style_term',
            [
                'label' => __('Term', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_term' => 'yes',
                ]
            ]
        );


        // icon size
        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 35,
                ],
                'selectors' => [
                    '{{WRAPPER}} .term i,{{WRAPPER}} .term svg' => 'font-size: {{SIZE}}{{UNIT}}; width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'select_style' => ['style-2'],
                    'show_icon' => 'yes'
                ],
            ]
        );

        // icon color
		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Icon Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .term svg > * , {{WRAPPER}} .term i' => 'fill: {{VALUE}};color:{{VALUE}}',
				],
                'condition' => [
                    'select_style' => ['style-2'],
                    'show_icon' => 'yes'
                ],
			]
		);

         // icon padding
         $this->add_responsive_control(
            'icon_padding',
            [
                'label' => __( 'Icon Paddnig',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'after',
                'size_units' => [ 'px','em' ],
				'selectors' => [
					'{{WRAPPER}} .projects .term svg , {{WRAPPER}} .projects .term i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [
                    'select_style' => ['style-2'],
                    'show_icon' => 'yes'
                ],
            ]
        );

        // padding
        $this->add_responsive_control(
            'term_padding',
            [
                'label' => __( 'Paddnig',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .projects .term' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // title typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_term_typography',
                'label' => __( 'Typography', text_domain ),
                'selector' => '{{WRAPPER}} .projects .card .term',
            ]
        );

        // term position
        $this->add_control(
            'change_direction',
                [
                    'label' => esc_html__( 'Term Position', text_domain ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Right', text_domain ),
                    'label_off' => esc_html__( 'Left', text_domain ),
                    'return_value' => 'right',
                    'default' => 'right',
                ]
        );


        $this->add_responsive_control(
            'rtl_position',
                [
                    'label' => esc_html__( 'Position', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'allowed_dimensions' => [ 'top', 'right' ],
                    'selectors' => [
                            '{{WRAPPER}} .term' => 'top: {{TOP}}px;right: {{RIGHT}}px;left: auto;',
                    ],
                    'condition' => [
                        'change_direction' => 'right',
                    ],
                ]
        );


        $this->add_responsive_control(
            'ltr_position',
            [
                'label' => esc_html__('Position', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'allowed_dimensions' => ['top', 'left'], 
                'selectors' => [
                    '{{WRAPPER}} .term' => 'top: {{TOP}}px;left: {{LEFT}}px;right: auto;', 
                ],
                'condition' => [
                        'change_direction!' => 'right',
                ],
            ]
        );
      

        // background term
		$this->add_control(
			'bg_color_term',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .projects .term' => 'background: {{VALUE}}',
				],
			]
		);
        // color term
		$this->add_control(
			'color_term',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .projects .term a' => 'color: {{VALUE}}',
				],
			]
		);

        // border term
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_term',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} .projects .term',
            ]
        );


        // border radius term
        $this->add_responsive_control(
			'border_radius_term',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '0',
	                'right' => '0',
	                'bottom' => '0',
	                'left' => '0',
	                'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .projects .term' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
    }

    // Register style avatar controls
    protected function register_style_avatar() {
        $this->start_controls_section(
            'style_avatar',
            [
                'label' => __('Avatar', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_avatar' => 'yes',
                    'select_style' => 'style-1'
                ]
            ]
        );


        // width
        $this->add_responsive_control(
            'width_avatar',
            [
                'label' => __( 'Width Avatar', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .avatar img' => 'width:{{SIZE}}{{UNIT}};',
                ],
                // 'condition' => [
                //     'select_style' => 'style-one-1'
                // ],
            ]
        );

         // height
        $this->add_responsive_control(
            'height_avatar',
            [
                'label' => __( 'Height Avatar', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .avatar img' => 'height:{{SIZE}}{{UNIT}};',
                ],
                // 'condition' => [
                //     'select_style' => 'style-one-1'
                // ],
            ]
        );


        // padding
        $this->add_responsive_control(
            'avatar_padding',
            [
                'label' => __( 'Paddnig',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .avatar img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // margin
        $this->add_responsive_control(
            'avatar_margin',
            [
                'label' => __( 'Margin',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .avatar img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // border radius
        $this->add_responsive_control(
            'avatar_border_radius',
            [
                'label' => __( 'Avatar Border Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // border
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'avatar_border',
				'label' => __( 'Border Avatar', text_domain ),
				'selector' => '{{WRAPPER}} .avatar img',
			]
		);


        



        $this->end_controls_section();
    } 

  
    // Register style author controls
    protected function register_style_author_controls(){
		$this->start_controls_section(
			'section_style_author',
			[
				'label' => __('Author', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'enable_author' => 'yes',
                    'select_style' => 'style-1'
				],
			]
		);

		$this->start_controls_tabs('style_tabs_author');
		$this->start_controls_tab('style_normal_tab_a', ['label' => __( 'Normal', text_domain ),]);


         // author size
         $this->add_responsive_control(
		    'date_number_size',
		    [
			    'label' => __( 'Size Number', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 100,
				    ],
			    ],
			    'default' => [
				    'size' => 20,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .author' => 'font-size: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );
        // padding
        $this->add_responsive_control(
            'margin_author',
            [
                'label' => __( 'Margin',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .author' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // color author
		$this->add_control(
			'color_author',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#777',
				'selectors' => [
					'{{WRAPPER}} .author a' => 'color: {{VALUE}}',
				],
				//'condition' => [
					//'select_author!' => 'yesicon-author',
				//],
			]
		);

		

        // background author
		$this->add_control(
			'bg_color_author',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .author' => 'background: {{VALUE}}',
				],
			]
		);

		

        // border author
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_author',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} .author',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab('style_hover_tab_a', ['label' => __( 'Hover', text_domain ),]);

		$this->add_control(
			'color_author_hover',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .author:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'hover_bg_color_author',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .author:hover' => 'background: {{VALUE}}',
				],
			]
		);

		

		$this->end_controls_tab();
		$this->end_controls_tabs();


		$this->end_controls_section();
	}

    // Register style date controls
    protected function register_style_date() {
        $this->start_controls_section(
            'style_date',
            [
                'label' => __('Date', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'enable_date' => 'yes',
                    // 'select_style' => 'style-1'
                ]
            ]
        );


        $this->start_controls_tabs(
			'style_tabs_date',            
		);

		$this->start_controls_tab(
			'style_normal_date_tab',
			[
				'label' => __( 'Normal', text_domain ),
			]
		);

        // padding
        $this->add_responsive_control(
            'padding_date',
            [
                'label' => __( 'Paddnig',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // margin
        $this->add_responsive_control(
            'margin_date',
            [
                'label' => __( 'Margin',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

		// date number color
        $this->add_control(
		    'date_number_color',
	        [
		        'label' => __( 'Color Date Number', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#777777',
		        'selectors' => [
			        '{{WRAPPER}} .date' => 'color: {{VALUE}}',
		        ],
		    ]
	    );

        // date background color
        $this->add_control(
		    'date_number_bg_color',
	        [
		        'label' => __( 'Background Date Number', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        // 'default' => '#fff',
		        'selectors' => [
			        '{{WRAPPER}} .date' => 'background-color: {{VALUE}}',
		        ],
		    ]
	    );


		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_date_tab',
			[
				'label' => __( 'Hover', text_domain ),
			]
		);

         // date position hover
         $this->add_control(
            'date_change_direction',
                [
                    'label' => esc_html__( 'Date Hover Position', text_domain ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Right', text_domain ),
                    'label_off' => esc_html__( 'Left', text_domain ),
                    'return_value' => 'right',
                    'default' => 'right',
                    'condition' => [
                        'select_style' => 'style-2',
                    ],
                ]
        );


        $this->add_responsive_control(
            'date_rtl_position',
                [
                    'label' => esc_html__( 'Position', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'allowed_dimensions' => [ 'bottom', 'right' ],
                    'selectors' => [
                            '{{WRAPPER}} .projects .card:hover .date' => 'bottom: {{BOTTOM}}px;right: {{RIGHT}}px;left: auto;',
                    ],
                    'condition' => [
                        'select_style' => 'style-2',
                        'date_change_direction' => 'right'
                    ],
                ]
        );


        $this->add_responsive_control(
            'date_ltr_position',
            [
                'label' => esc_html__('Position', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'allowed_dimensions' => ['bottom', 'left'], 
                'selectors' => [
                                '{{WRAPPER}} .projects .card:hover .date' => 'bottom:{{BOTTOM}}px;left:{{LEFT}}px;right: auto;',
                ],
                'condition' => [
                            'select_style' => 'style-2',
                            'date_change_direction!' => 'right',
                ]
            ]
        );


		// date number color
         $this->add_control(
		    'date_number_hover_color',
	        [
		        'label' => __( 'Hover Date Number', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#777777',
		        'selectors' => [
			        '{{WRAPPER}} .projects .card:hover .date' => 'color: {{VALUE}}',
		        ],
		    ]
	    );

        // date background color
        $this->add_control(
		    'date_number_bg_hover_color',
	        [
		        'label' => __( 'Hover Background Date Number', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        // 'default' => '#fff',
		        'selectors' => [
			        '{{WRAPPER}} .projects .card:hover .date' => 'background-color: {{VALUE}}',
		        ],
		    ]
	    );

		$this->end_controls_tab();

		$this->end_controls_tabs();

          // date number border
          $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'border_date_number',
			    'label' => __( 'Border Number', text_domain ),
                'separator' => 'before',
			    'selector' => '{{WRAPPER}} .date',
            ]
	    );
       // border radius
        $this->add_responsive_control(
	        'date_number_border_radius',
	        [
	            'label' => __( 'Boder Radius', text_domain ),
	            'type' => Controls_Manager::DIMENSIONS,
	            'size_units' => [ 'px','%','em' ],
	            'selectors' => [
		            '{{WRAPPER}} .blog-item .date,{{WRAPPER}} .card  .date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	            ],
	        ]
        );


        // date number size
		$this->add_group_control(
			Group_Control_Typography::get_type(),
		  [
			  'name' => 'date_typography',
			  'label' => __( 'Typography', text_domain ),
			  'selector' => '{{WRAPPER}} .date',
		  ]
	    );
      

        $this->end_controls_section();
    }

    // Register style image controls
    protected function register_style_image_controls() {
        $this->start_controls_section(
            'style_image',
            [
                'label' => __('Image', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

       
        // show hover image
        $this->add_control(
            'show_hover_img',
            [
                'label' => __( 'Show Hover', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                      'select_style' => ['style-2'],
                ],
                'prefix_class' => 'hover-enabled-'
            ]
        );

         // height
         $this->add_responsive_control(
            'height_image',
            [
                'label' => __( 'Height Image', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 309,
                ],
                'selectors' => [
                    '{{WRAPPER}} .thumbnail img , {{WRAPPER}} .card-img' => 'height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );

         // width
         $this->add_responsive_control(
            'width_image',
            [
                'label' => __( 'Width Image', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 369,
                ],
                'selectors' => [
                    '{{WRAPPER}} .thumbnail img , {{WRAPPER}} .card-img img ' => 'width:{{SIZE}}{{UNIT}};',
                ],
                // 'condition' => [
                //     'select_style' => 'style-one-1'
                // ],
            ]
        );

        
        
        $this->start_controls_tabs(
            'style_tabs_img',
        );
        $this->start_controls_tab(
            'style_normal_tab',
             [
                'label' => __( 'Normal', text_domain ),
             ]
        );
      

        // padding
        $this->add_responsive_control(
            'padding_img',
            [
                'label' => __( 'Padding',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .thumbnail img ,{{WRAPPER}} .card-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // margin
        $this->add_responsive_control(
            'margin_img',
            [
                'label' => __( 'Margin',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .thumbnail img ,{{WRAPPER}} .card-img img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icons' => 'yes'
                // ],
            ]
        );
   

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'background_hover_img',
                'label' => __( 'Background', text_domain ),
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .projects .thumbnail .overlay ,{{WRAPPER}} .card-img .overlay',
                'condition' => [
                    'select_style' => 'style-two-2'
                ],
            ]
        );
  
        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab_img',
            [
                'label' => __( 'Hover', text_domain ),
                'condition' => [
                    'select_style' => ['style-2'],
                    'show_hover_img' => 'yes'
                ],
            ]
        );	    
        
        // padding
        $this->add_responsive_control(
            'padding_hover_img',
            [
                'label' => __( 'Padding',text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .projects .card:hover .card-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                // 'condition' => [
                //     'select_style' => 'style-two-2',
                //     'show_icon' => 'yes'
                // ],
            ]
        );

        // background hover
        $this->add_control(
            'background_hover_img',
            [
                    'label' => __( 'Background Hover Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                            '{{WRAPPER}} .projects .card:hover .card-img::before' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'select_style' => ['style-2']
                    ],
            ]
        );

               
        $this->end_controls_tab();

        
        
        $this->end_controls_tabs();
        
        // border radius
        $this->add_responsive_control(
           'border_radius_img',
           [
               'label' => __( 'Border Radius Image', text_domain ),
               'type' => Controls_Manager::DIMENSIONS,
               'size_units' => [ 'px', '%', 'em' ],
               'separator' => 'before',
               'selectors' => [
                   '{{WRAPPER}} .thumbnail img ,{{WRAPPER}} .card-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
               ],
               // 'condition' => [
               //     'select_style' => 'style-two-2',
               //     'show_icons' => 'yes'
               // ],
           ]
       );

        $this->end_controls_section();
    }


    // Register style arrow & dots of slider controls
    protected function register_style_arrows_dots_slider_controls() {
        $this->start_controls_section(
            'section_style_navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'navigation' => [ 'arrows', 'dots', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'heading_style_arrows',
            [
                'label' => __( 'Arrows', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_width',
                [
                    'label' => esc_html__( 'Width', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );
            $this->add_responsive_control(
            'arrow_height',
                [
                    'label' => esc_html__( 'Height', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );
            $this->add_responsive_control(
            'arrow_line_height',
                [
                    'label' => esc_html__( 'Line Height', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'line-height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );
        $this->add_responsive_control(
            'right_arrow',
            [
                'label' => __( 'Right Arrow', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'left_arrow',
            [
                'label' => __( 'Left Arrow', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'left' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'top: {{TOP}}%;left: {{LEFT}}%;right: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_size',
            [
                'label' => __( 'Arrows Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->start_controls_tabs( 'arrows_icon_tabs' );
        $this->start_controls_tab( 'arrows_icon_normal', [ 
            'label' => __( 'Normal', text_domain ),
            'condition' => [
                'navigation' => [ 'arrows', 'both' ],
            ],
        ] );

        $this->add_control(
            'arrows_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'arrows_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'arrows_icon_hover', [ 
            'label' => __( 'Hover', text_domain ),
            'condition' => [
                'navigation' => [ 'arrows', 'both' ],
            ],
        ] );

        $this->add_control(
            'arrows_hover_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'arrows_hover_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'arrow_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );

        $this->add_control(
            'heading_style_dots',
            [
                'label' => __( 'Dots', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_position',
            [
                'label' => __( 'Dots Position', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_width',
            [
                'label' => __( 'Width', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_height',
            [
                'label' => __( 'Height', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'dots_color',
            [
                'label' => __( 'Dots Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'active_dot_color',
            [
                'label' => __( 'Active Dot Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
                'default' => '#4054B2',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_width',
            [
                'label' => __( 'Width', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_height',
            [
                'label' => __( 'Height', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_margin',
            [
                'label' => esc_html__('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],

                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'   => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );

       $this->add_control(

           'style_outline_hover',
           [
               'label' => __( 'Style Outline', text_domain ),
               'type' => Controls_Manager::SELECT,
               'default' => 'solid',
               'options' => [
                   'none' => __( 'None', text_domain ),
                   'solid'  => __( 'Solid', text_domain ),
                   'dashed' => __( 'Dashed', text_domain ),
                   'dotted' => __( 'Dotted', text_domain ),
                   'double' => __( 'Double', text_domain ),
                ],
               'selectors' => [
                   '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-style:{{VALUE}}',
                ],
               ]
       );

       $this->add_control(
          'outline_thickness_hover',
          [
            'label' => __( 'Thickness', text_domain ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'default' => [
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-width: {{SIZE}}px;',
            ],
            'condition' => [
                'style_outline_hover!' => 'none',
                'navigation' =>  'dots',
            ],
        ]
       );

       $this->add_control(
           'outline_color_hover',
           [
            'label' => __( 'Color', text_domain ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-color: {{VALUE}}',
            ],
            'condition' => [
                'style_outline_hover!' => 'none',
                'navigation' =>  'dots',
                ],
            ]
       );

        $this->add_control(
            'outline_offset_hover',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                    'min' => 0,
                    'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-offset: {{SIZE}}px;',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
            );

            $this->add_control(
                'border_radius_outline_hover',
                [
                    'label' => __( 'Border Radius', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                    'condition' => [
                        'style_outline_hover!' => 'none',
                        'navigation' =>  'dots',
                    ],
                ]
            );


            $this->end_controls_section();
    }

    // Register style title controls
    protected function register_style_title_controls() {
        $this->start_controls_section(
			'title_style',
			[
				'label' => __('Title', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'enable_title' => 'yes'
				],
			]
		);

        // align title
		$this->add_responsive_control(
			'title_align',
			[
				'label' => __( 'Align Title', text_domain ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .title-blog, {{WRAPPER}} .title-project' => 'text-align: {{VALUE}}',
                ],
				'condition' => [
					'select_style' => 'style-1',
					'select_style' => 'style-2',
				],
			]
		);
		
      

        $this->start_controls_tabs(
			'style_tabs'
		);

        // normal tab
		$this->start_controls_tab(
			'style_normal_tile_tab',
			[
				'label' => esc_html__( 'Normal', text_domain ),
			]
		);


        // title color
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .title-blog a , {{WRAPPER}} .title-project a' => 'color: {{VALUE}};transition:0.3s',
				],
			]
		);

        $this->end_controls_tab();


        // hover tab
        $this->start_controls_tab(
			'style_hover_title_tab',
			[
				'label' => __( 'Hover', text_domain ),
			]
		);

		// hover color
        $this->add_control(
			'title_color_hover',
			[
				'label' => __( 'Color Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .title-blog a,{{WRAPPER}} .projects .card:hover .title-project a' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style' => ['style-1','style-2']
				],
			]
		);

        // title position hover
        $this->add_control(
            'title_change_direction',
                [
                    'label' => esc_html__( 'Title Hover Position', text_domain ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Right', text_domain ),
                    'label_off' => esc_html__( 'Left', text_domain ),
                    'return_value' => 'right',
                    'default' => 'right',
                    'condition' => [
                        'select_style' => 'style-2',
                    ],
                ]
        );


        $this->add_responsive_control(
            'title_rtl_position',
                [
                    'label' => esc_html__( 'Position', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'allowed_dimensions' => [ 'bottom', 'right' ],
                    'selectors' => [
                            '{{WRAPPER}} .projects .card:hover .title-project a' => 'bottom: {{BOTTOM}}px;right: {{RIGHT}}px;left: auto;',
                    ],
                    'condition' => [
                        'select_style' => 'style-2',
                        'title_change_direction' => 'right'
                    ],
                ]
        );


        $this->add_responsive_control(
            'title_ltr_position',
            [
                'label' => esc_html__('Position', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'allowed_dimensions' => ['bottom', 'left'], 
                'selectors' => [
                                '{{WRAPPER}} .projects .card:hover .title-project a' => 'bottom:{{BOTTOM}}px;left:{{LEFT}}px;right: auto;',
                ],
                'condition' => [
                            'select_style' => 'style-2',
                            'title_change_direction!' => 'right',
                ]
            ]
        );


        $this->end_controls_tab();

        $this->end_controls_tabs();
		
        // title typography
        $this->add_group_control(
            Group_Control_Typography::get_type(),
        [
            'name' => 'title_typography',
            'label' => __( 'Typography', text_domain ),
            'selector' => '{{WRAPPER}} .title-blog a, {{WRAPPER}} .title-project a',
        ]
        );

        // margin title
		$this->add_responsive_control(
			'margin_title',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .title-blog, {{WRAPPER}} .title-project' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

       

		$this->end_controls_section();
    }

    // Register style excerpt controls
    protected function register_style_description_controls(){
		$this->start_controls_section(
			'description_style',
			[
				'label' => __('Description', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'enable_excerpt' => 'yes',
					'select_style' => 'style-1',
				],
			]
		);

        // align
		$this->add_responsive_control(
			'align_description',
			[
				'label' => __( 'Alignment', text_domain ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
			   'selectors' => [
				   '{{WRAPPER}} .blog-item .description' => 'text-align:{{VALUE}}',
			   ],
			   'condition' => [
				   'select_style' => 'style-one-1',
			   ],
			]
		);

        // typography
		$this->add_group_control(
			  Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item .description',
			]
		);

        // margin
		$this->add_responsive_control(
			'margin_description',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// color
		$this->add_control(
			'description_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#474747',
				'selectors' => [
					'{{WRAPPER}} .blog-item .description' => 'color: {{VALUE}};transition:0.3s',
				],
			]
		);

        // hover color
		$this->add_control(
			'description_color_hover',
			[
				'label' => __( 'Color Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .description' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

	}

    // Register style read more controls
    protected function register_style_read_more_controls(){
		$this->start_controls_section(
				'style_read_more',
				[
						'label' => __('Read More', text_domain),
						'tab' => Controls_Manager::TAB_STYLE,
						'condition' => [
							'enable_more' => 'yes',
                            'select_style' => 'style-1'
						],
				]
		);

        // align
		$this->add_responsive_control(
			'align_read_more',
			[
				'label' => __( 'Align Read More', text_domain ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
				// 'condition' => [
				// 	'select_style' => 'style-one-1'
				// ],
			]
		);

        // color link
		$this->add_control(
			'color_text_link',
			[
				'label' => __( 'Color Text Link', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .read-more a' => 'color: {{VALUE}}',
				],
			]
		);
		
        // hover color link
		$this->add_control(
			'color_text_link_hover',
			[
				'label' => __( 'Color Text Link Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .read-more a:hover' => 'color: {{VALUE}}',
				],
			]
		);

	
        // background color read more
		$this->add_control(
			'bg_color_read_more',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .read-more a' => 'background: {{VALUE}}',
				],
			]
		);
		
        // padding read more
		$this->add_responsive_control(
			'padding_read_more',
			[
				'label' => __( 'Padding Read More', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .read-more a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        // margin read more
		$this->add_responsive_control(
			'margin_read_more',
			[
				'label' => __( 'Margin Read More', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '10',
	                'right' => '0',
	                'bottom' => '10',
	                'left' => '0',
	                'unit' => 'px',
	                'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        // border radius read more
		$this->add_responsive_control(
			'border_radius_read_more',
			[
				'label' => __( 'Border Radius Read More', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .read-more a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        // typography
		$this->add_group_control(
			Group_Control_Typography::get_type(),
		  [
			  'name' => 'read_more_typography',
			  'label' => __( 'Typography', text_domain ),
			  'selector' => '{{WRAPPER}} .read-more a',
		  ]
	    );

        // border
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_readmore',
				'label' => __( 'Border more', text_domain ),
				'selector' => '{{WRAPPER}} .read-more a',
			]
		);
		
		$this->end_controls_section();

	}
    // Register style pagination controls    
    protected function register_style_pagination_controls() {
        $this->start_controls_section(
            'style_pagination',
            [
                'label' => __('Pagination', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                   'show_pagination' => 'yes'
                ]
            ]
        );

        $this->start_controls_tabs('style_tabs_navigation');
        $this->start_controls_tab('style_normal_navigation_tab', ['label' => __( 'Normal', text_domain ),]);
        $this->add_control(
            'align_navigation',
            [
                'label' => __( 'Align Navigation', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .navigation' => 'display: flex ; align-items:center; justify-content:{{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'color_navigation',
            [
                'label' => __( 'Color Navigation', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .nav-links a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'bg_color_navigation',
            [
                'label' => __( 'Background Color Navigation', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .nav-links a' => 'Background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_navigation',
                'label' => __( 'Border Navigation', text_domain ),
                'selector' => '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span',
            ]
        );

        // width
         $this->add_responsive_control(
            'width_pagination',
            [
                'label' => __( 'Width Pagination', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span' => 'width:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // height
         $this->add_responsive_control(
            'height_pagination',
            [
                'label' => __( 'Height Pagination', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span' => 'height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // line height
         $this->add_responsive_control(
            'line_height_pagination',
            [
                'label' => __( 'Line Height Pagination', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span' => 'line-height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
             'margin_navigation',
             [
                 'label' => __( 'Margin Navigation', text_domain ),
                 'type' => Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px', '%', 'em' ],
                 'selectors' => [
                     '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span , {{WRAPPER}} .nav-links ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
             ]
         );
        $this->add_control(
             'border_radius_navigation',
             [
                 'label' => __( 'Border Radius Navigation', text_domain ),
                 'type' => Controls_Manager::DIMENSIONS,
                 'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ],
                 'selectors' => [
                     '{{WRAPPER}} .nav-links a , {{WRAPPER}} .nav-links span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                 ],
             ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_navigation_tab', ['label' => __( 'Hover', text_domain ),]);
        $this->add_control(
            'hover_color_navigation',
            [
                'label' => __( 'Hover Navigation', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .nav-links a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'hover_bg_color_navigation',
            [
                'label' => __( 'Background Hover Navigation', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .nav-links a:hover' => 'Background: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();


        $this->start_controls_tab('style_active_tab', ['label' => __( 'Active', text_domain ),]);
        $this->add_control(
            'active_color_navigation',
            [
                'label' => __( 'Active Navigation', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .nav-links span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'active_bg_color_navigation',
            [
                'label' => __( 'Background Active Navigation', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .nav-links span' => 'Background: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_navigation_active',
                'label' => __( 'Border Navigation', text_domain ),
                'selector' => '{{WRAPPER}} .nav-links span',
             ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    
    

    // Render
    protected function render() {
        // Variables
         $settings = $this->get_settings(); 
         $editor = Plugin::$instance->editor->is_edit_mode();
         $post_type=$settings['post_type'];
         $taxonomy='';
         $main_option = get_option('tmt_main_option', [] );
         $theme_post_type = $main_option['post-type']['slug'];
         switch($post_type) {
            case 'post' :
                $taxonomy = "category";
                break;
            case 'loop':
            case $theme_post_type:
                $cat_slug = $main_option['taxonomy']['cat-slug'];
                $taxonomy = $cat_slug;
                break;
        }

        $posts_count=$settings['posts_count'];
        $post_order=$settings['post_order'];
        if ( empty( $settings['avatar']['url'] ) ) {
        return;
        }
        

        $image_size = $settings['image_size'];
        $id = $this->get_id();
        if('custom' == $image_size) {
                $width = $settings['image_custom_dimension']['width'];
                $height = $settings['image_custom_dimension']['height'];
                add_image_size( "custom-$id", $width, $height, true );
        }

        $enable_title=$settings['enable_title'];
        $title_tag=$settings['title_tag'];
        $enable_more=$settings['enable_more'];
        $text_more_link=$settings['text_more_link'];
        $align_read_more=$settings['align_read_more'];


          // slider
          $enable_slider = $settings['enable_slider'];
          if($enable_slider == 'yes') {
              $is_rtl = is_rtl();
              $direction = $is_rtl ? 'rtl' : 'ltr';
              $show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
              $show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
              $columns = $settings['slider_columns'];
              $columns_tablet = $settings['columns_tablet'];
              $columns_mobile = $settings['columns_mobile'];
              $centerMode = $settings['centerMode'];
              $autoplay = $settings['autoplay'];
              $autoplay_speed = $settings['autoplay_speed'];
              $pause_on_hover = $settings['pause_on_hover'];
              $infinite = $settings['infinite'];
              $effect = $settings['effect'];
              $data_swiper = [
                  'columns' => absint($columns),
                  'columns_tablet' => absint($columns_tablet),
                  'columns_mobile_h' => $columns_tablet == 1 ? 1 : $columns_tablet - 1,
                  'columns_mobile' => absint($columns_mobile),
                  'autoplay' => ( 'yes' === $autoplay ),
                  'speed' => absint($autoplay_speed),
                  'pause_on_hover' => ( 'yes' === $pause_on_hover ),
                  'infinite' => ( 'yes' === $infinite ),
                  'centerMode' => ( 'yes' === $centerMode ),
                  'effect' => $effect,
              ];
              if($effect == 'creative') {
                  $data_swiper['creative-type'] = $settings['creative_type'];
              }
      
              $this->add_render_attribute( 'slides', [
                  'data-swiper' => wp_json_encode( $data_swiper ),
              ] );
  
              $slides = $this->get_render_attribute_string( 'slides' );

              echo "<div id='slider-$id' class='swiper tmt-slider-yes tmt-posts-slider' dir='$direction' $slides>"
              . '<div class="slider-show swiper-wrapper">';
          } else {
              echo "<div class='tmt-posts flex flex-wrap'>" ;
          }


        switch($post_type) {
            case 'loop' :
                if($editor) {
                    $args = [
                        'posts_per_page' => 12,
                        'post_status' => 'publish',
                        'post_type' => 'post',
                    ];
    
                    $query = new \WP_Query($args);
                    
                    
                        if($query->have_posts()) : while($query->have_posts()) : $query->the_post();
                            $this->post_loop($settings,$image_size,$id,$editor,$enable_title,$title_tag,$enable_more,$text_more_link, $align_read_more,$taxonomy);
                        endwhile;endif;wp_reset_postdata(); 
                        echo '</div>';  
                    
    
                    
                } else {   
                    
                        if(have_posts()) { 
                            while(have_posts()) { the_post();
                            $this->post_loop($settings,$image_size,$id,$editor,$enable_title,$title_tag,$enable_more,$text_more_link, $align_read_more,$taxonomy);
                        }   
                        echo '</div>';
                   
    
                    daris_the_posts_navigation(3);                 
                    
                    } else {
                        // When it doesn't found anything
                        echo "<header class='page-header'>"
                            . "<h1 class='page-title'>" . __( 'Nothing Found', text_domain ) . "</h1>"
                        . "</header>"
    
                        . "<div class='page-content'>";
                            if ( is_home() && current_user_can( 'publish_posts' ) ) :
                                printf('<p>' . wp_kses(__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'karauos' ),	array('a' => array('href' => array(),),)) . '</p>',esc_url( admin_url( 'post-new.php' ) ));
                            elseif ( is_search() ) :
                                echo '<p>' . __('Sorry, but nothing matched your search terms. Please try again with some different keywords.', text_domain) . '</p>';get_search_form();
                            else :
                                echo '<p>' . __('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', text_domain) . '</p>';get_search_form();
                            endif;wp_reset_postdata();
                        echo "</div></div>";
                    }
                }
                break;
            case 'related_post' :
                global $post;
                // get categories
                $cat_terms = wp_get_post_terms( $post->ID, 'category' );
                foreach ( $cat_terms as $term ) $cats_array[] = $term->term_id;

                // get tags
                $tag_terms = wp_get_post_terms( $post->ID, 'post_tag' );
                foreach ( $tag_terms as $term ) $tags_array[] = $term->term_id;

				$args = array(
					'posts_per_page' => $settings['posts_count'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'order' => $settings['post_order'],
					'post__not_in' => array( $post->ID ),
                    'tax_query' => array(
                        'relation' => 'AND',
                    ),
				);

                if(!empty($cat_terms)) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'category',
                            'field' => 'id',
                            'terms' => $cats_array
                        ),
                    );
                }

                if(!empty($tag_terms)) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'post_tag',
                            'field' => 'id',
                            'terms' => $tags_array
                        ),
                    );
                }

				$query = new \WP_Query($args);
				if ( $query->have_posts() ):while ( $query->have_posts() ):$query->the_post();
                      $this->post_loop($settings,$image_size,$id,$editor,$enable_title,$title_tag,$enable_more,$text_more_link, $align_read_more,$taxonomy);
				endwhile;endif;wp_reset_postdata();
				if($enable_slider == 'yes') {
					echo '</div>';
					if($show_dots) {
						echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
					}
					if($show_arrows) {
						echo "<div class='tmt-sw-button swiper-button-prev'></div>"
						. "<div class='tmt-sw-button swiper-button-next'></div>";
					}
				}
				echo '</div>';
                break;
            case 'related_project' :
                global $post;
				$cat_slug = TMT_Get_Setting('taxonomy', 'cat-slug');
				$tag_slug = TMT_Get_Setting('taxonomy', 'tag-slug');
                // get categories
                $cat_terms = wp_get_post_terms( $post->ID, $cat_slug );
                foreach ( $cat_terms as $term ) $cats_array[] = $term->term_id;

                // get tags
                $tag_terms = wp_get_post_terms( $post->ID, $tag_slug );
                foreach ( $tag_terms as $term ) $tags_array[] = $term->term_id;

                // get post_types
                $slug = TMT_Get_Setting('post-type', 'slug');

				$args = array(
					'posts_per_page' => $settings['posts_count'],
					'post_type' => $slug,
					'post_status' => 'publish',
					'order' => $settings['post_order'],
					'post__not_in' => array( $post->ID ),
                    'tax_query' => array(
                        'relation' => 'AND',
                    ),
				);

                if(!empty($cat_terms)) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => $cat_slug,
                            'field' => 'id',
                            'terms' => $cats_array
                        ),
                    );
                }

                if(!empty($tag_terms)) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => $tag_slug,
                            'field' => 'id',
                            'terms' => $tags_array
                        ),
                    );
                }

				$query = new \WP_Query($args);
				if ( $query->have_posts() ):while ( $query->have_posts() ):$query->the_post();
                     $this->post_loop($settings,$image_size,$id,$editor,$enable_title,$title_tag,$enable_more,$text_more_link, $align_read_more,$taxonomy);
				endwhile;endif;wp_reset_postdata();
				if($enable_slider == 'yes') {
					echo '</div>';
					if($show_dots) {
						echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
					}
					if($show_arrows) {
						echo "<div class='tmt-sw-button swiper-button-prev'></div>"
						. "<div class='tmt-sw-button swiper-button-next'></div>";
					}
				}
				echo '</div>';
                break;
                default:
                // in main page

                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args=[
                    'posts_per_page' => $posts_count,
                    'post_status'    => 'publish',
                    'post_order'     => $post_order,
                    'post_type'      => $post_type,
                    'paged'=> $paged,
                ];

               

                $query = new \WP_Query($args);

                // HTML             
                if($query->have_posts()) : while($query->have_posts()) : $query->the_post();
                        $this->post_loop($settings,$image_size,$id,$editor,$enable_title,$title_tag,$enable_more,$text_more_link, $align_read_more,$taxonomy);
                    endwhile;
                    if($enable_slider=='yes') {
                        echo "</div>";

                        if($show_dots) {
                            echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
                        }
                        if($show_arrows) {
                            echo "<div class='tmt-sw-button swiper-button-prev'></div>"
                            . "<div class='tmt-sw-button swiper-button-next'></div>";
                        }
                    }
                    
                    echo "</div>";

                    if (( $settings['show_pagination']==='yes' )) {
                        $GLOBALS['wp_query']->max_num_pages = $query->max_num_pages;
                            daris_the_posts_navigation(3);
                    };

                    

                endif;wp_reset_postdata();
                break;
        }

    }


    private function post_loop($settings,$image_size,$id,$editor,$enable_title,$title_tag,$enable_more,$text_more_link, $align_read_more,$taxonomy) {
        // variables
        $title=get_the_title();
        $link=get_the_permalink();
        $post_id= get_the_ID();
        $term = get_the_term_list( $post_id,$taxonomy,'',', ','');

        ?>

       
            <?php

        switch ($settings['select_style']) {
            // blog
            case 'style-1':
                
                echo "<div class='"; echo($settings['enable_slider']=='yes') ? 'swiper-slide' : 'blog-box' ; echo"'>"
                . "<div class='blog-items'><div class='blog-item'>"
                        ."<div class='blog-item-head flex flex-wrap align-items-center'>"
                            . "<div class='avatar flex align-items-center'>"; 

                                if($settings['enable_avatar']) {
                                    echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'avatar' );
                                }

                                if($settings['enable_author']) {
                                    echo "<div class='author'>";
                                            the_author_posts_link(); 
                                    echo "</div>";
                                }
                                echo "</div>";
                                if($settings['enable_date']=='yes') {
                                        echo "<div class='date flex align-items-center'>"; 
                                             the_time('j F Y');
                                        echo "</div>";
                                } 
                        echo "</div>"
                        . "<a href='$link' target='_blank' class='thumbnail'>";
                        ($image_size == 'custom') ? daris_post_thumbnail("$image_size-$id") : daris_post_thumbnail($image_size);
                        echo "</a>"
                        . "<div class='blog-item-footer'>";
                            if($enable_title=='yes') {
                            echo "<$title_tag class='title-blog'>"
                                . "<a href='$link'>"
                                        . $title .
                                "</a>"        
                            . "</$title_tag>";

                            }
                            if($settings['enable_excerpt'] == 'yes'){
                                echo '<p class="description">'; 
                                    if(has_excerpt()) {
                                        the_excerpt();
                                    } else {
                                        excerpt_post($settings['excerpt_length']);
                                    }
                                echo'</p>';
                            }
                            if($enable_more=='yes') {
                                echo "<div class='read-more flex align-items-center justify-content-$align_read_more'>"
                                    . "<a href='$link'>";
                                        echo  $text_more_link
                                    . "</a>"
                                . "</div>";
                            }
                        echo "</div>"
                ."</div></div></div>";

                break;
            // Project - 1
            case 'style-2':
                
                echo "<div class='"; echo($settings['enable_slider']=='yes') ? 'swiper-slide' : 'projects-box' ; echo"'>"
                . "<div class='projects'>"
                    . "<div class='card'>"
                        . "<div class='card-img'"; if ($editor) {echo '>';} else {echo ' onclick="' . "location.href='";echo $link . "'" . '">';}
                            if ('custom' == $image_size) {
                                daris_post_thumbnail("$image_size-$id");
                            } else {
                                daris_post_thumbnail($image_size);
                            }

                            if($settings['enable_term']=='yes') {
                                echo "<div class='term flex align-items-center'>";
                                    if($settings['show_icon']=='yes') {
                                        Icons_Manager::render_icon($settings['select_icon']);
                                    }
                                    echo  $term;
                                echo "</div>";
                            }
                        echo "</div>"
                        . "<div class='card-footer'>";
                            if($settings['enable_date']=='yes') {
                                echo "<div class='date flex align-items-center'>"; 
                                        the_time('j F Y');
                                echo "</div>";
                            }
                            
                            
                            if($enable_title=='yes') {
                                echo "<$title_tag class='title-project'>"
                                    . "<a href='$link'>"
                                            . $title .
                                    "</a>"
                                ."</$title_tag>";
                            }  
                        echo "</div>"
                    . "</div>"
                . "</div>"
                . "</div>";
                                
                break;            
        }
    }
}
Plugin::instance()->widgets_manager->register(new Themento_Post_Grid);