<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TMT_Basket extends Widget_Base {

	public function get_name() {
		return 'tmt-basket';
	}

	public function get_title() {
		return __( 'Basket Shop', text_domain );
	}

	public function get_icon() {
		return 'eicon-sync';
	}

	public function get_categories() {
        return [ 'shop_daris' ];
	}

	public function get_keywords() {
		return [ 'shop', 'basket', 'form'];
	}

    protected function register_controls() {
        $this->register_general_btn_controls();
        $this->register_general_basket_style_controls();
        $this->register_style_before_login_controls();
        $this->register_general_btn_style_controls();
    }
   

    protected function register_general_btn_controls() {
        $this->start_controls_section(
            'section_btn',
            [
                'label' => __( 'Button', text_domain  ),
            ]
        );
        $this->add_control(
            'btn_text',
            [
                'label' => __( 'Text', text_domain  ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Type your text here', text_domain  ),
            ]
        );
        $this->add_control(
            'btn_align',
            [
                'label' => __( 'Alignment', text_domain  ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain  ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain  ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'right',
                'toggle' => true,
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => __( 'Basket Icon', text_domain  ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-shopping-cart',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'show_count_cart',
            [
                'label' => __( 'Show Count Cart', text_domain  ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain  ),
                'label_off' => __( 'Hide', text_domain  ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'close_cart_icon',
                [
                    'label' => esc_html__( 'Close Card Icon', text_domain ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
					'value' => 'fas fa-window-close',
					'library' => 'fa-solid',
				],
                ]
        );

        $this->add_control(
            'empty_text',
                [
                    'label' => esc_html__( 'Empty Text', text_domain ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Type your text here', text_domain ),
                ]
        );
       
        $this->end_controls_section();
    }

	protected function register_general_basket_style_controls() {
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Style', text_domain  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'dropdown_width',
            [
                'label' => __( 'DropDown Width', text_domain  ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 10,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 300,
                ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-offcanvas > div' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'content_bg_color',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .drop-down-offcanvas > div' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Margin', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-offcanvas > div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __( 'Padding', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '15',
                    'right' => '15',
                    'bottom' => '15',
                    'left' => '15',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-offcanvas > div' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_border_radius',
            [
                'label' => __( 'Border Radius', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-offcanvas > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'label' => __( 'Border', text_domain  ),
                'selector' => '{{WRAPPER}} .shopping-cart-content',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_box_shadow',
                'label' => __( 'Box Shadow', text_domain  ),
                'selector' => '{{WRAPPER}} .shopping-cart-content',
            ]
        );

     

        $this->add_control(
            'empty_cart_margin',
                [
                    'label' => esc_html__( 'Basket Title Margin', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'separator' => 'before',
                    'size_units' => [ 'px', 'em' ],
                    'default' => [
                        'top' => 2,
                        'right' => 0,
                        'bottom' => 2,
                        'left' => 0,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .basket-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $this->add_control(
            'empty_cart_padding',
                [
                    'label' => esc_html__( 'Basket Title Padding', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em' ],
                    'default' => [
                        'top' => 2,
                        'right' => 0,
                        'bottom' => 2,
                        'left' => 0,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .basket-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );

        $this->add_control(
            'title_text_color',
                [
                    'label' => esc_html__( 'Basket Title Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .widget_shopping_cart_content .title' => 'color: {{VALUE}}',
                    ],
                ]
        );



        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'title_text_typography',
                    'selector' => '{{WRAPPER}} .widget_shopping_cart_content .basket-title .title',
                ]
        );


       $this->add_responsive_control(
        'close_card_btn_size',
            [
                'label' => esc_html__( 'Basket Close Button Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    
                ],
                'default' => [
                        'unit' => 'px',
                        'size' => 15,
                ],
                'selectors' => [
                        '{{WRAPPER}} .close-cart-button i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
       );

    

        $this->add_responsive_control(
            'close_btn_padding',
                [
                    'label' => esc_html__( 'Basket Close Button Padding', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em' ],
                    'default' => [
                        'top' => 5,
                        'right' => 5,
                        'bottom' => 5,
                        'left' => 5,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .empty-cart-message .close-cart-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );


        $this->add_control(
            'close_card_btn_color',
                [
                    'label' => esc_html__( 'Basket Close Card Icon Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .basket-title .close-cart-button i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .basket-title .close-cart-button svg' => 'fill: {{VALUE}}',
                        '{{WRAPPER}} .basket-title .close-cart-button svg path' => 'fill: {{VALUE}}',
                    ],
                ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
                [
                    'name' => 'empty_cart_message_border',
                    'selector' => '{{WRAPPER}} .basket-title',
                ]
        );



        $this->add_control(
            'cart_product_title',
            [
                'label' => __( 'Title', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#eead16',
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .mini_cart_item a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'cart_product_typography',
                    'selector' => '{{WRAPPER}} .mini_cart_item a',
                ]
        );


        $this->add_control(
            'cart_product_price',
            [
                'label' => __( 'Price', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .quantity' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cart_product_remove_icon',
            [
                'label' => __( 'Icon', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#eead16',
                'selectors' => [
                    '{{WRAPPER}} .mini_cart_item a.remove_from_cart_button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cart_product_total_price',
            [
                'label' => __( 'Total Price', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .total' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'cart_product_separator',
            [
                'label' => __( 'Separator', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .total' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'cart_product_quantity_typography',
                    'selector' => '{{WRAPPER}} .woocommerce-mini-cart-item.mini_cart_item >span',
                ]
        );

        $this->add_control(
            'buttons_options',
            [
                'label' => __( 'Buttons', text_domain  ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

       
			
        $this->start_controls_tabs('style_btn_tabs');
        $this->start_controls_tab('style_btn_normal_tab', ['label' => __( 'Normal', text_domain  ),]);
		
		$this->add_control(
            'cart_total_options',
            [
                'label' => __( 'Cart Total', text_domain  ),
                'type' => Controls_Manager::HEADING,
            ]
        );
		
		$this->add_control(
            'color_cart_total',
            [
                'label' => __( 'Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'bg_color_cart_total',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'woocommerce_mini_cart__total_typography',
                    'selector' => '{{WRAPPER}} .woocommerce-mini-cart__total',
                ]
        );
		
		$this->add_control(
            'options_btn_forward',
            [
                'label' => __( 'Wc Forward', text_domain  ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
		
        $this->add_control(
            'color_btn_forward',
            [
                'label' => __( 'Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .wc-forward' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'bg_color_btn_forward',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .wc-forward' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'buttons_wc_forward_typography',
                    'selector' => '{{WRAPPER}} .buttons .wc-forward',
                ]
        );
		
		$this->add_control(
            'options_btn_checkout',
            [
                'label' => __( 'Checkout', text_domain  ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
		
        $this->add_control(
            'color_btn_checkout',
            [
                'label' => __( 'Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .checkout' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'bg_color_btn_checkout',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .checkout' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'buttons_checkout_typography',
                    'selector' => '{{WRAPPER}} .buttons .checkout',
                ]
        );
		
        $this->end_controls_tab();
        $this->start_controls_tab('style_btn_hover_tab', ['label' => __( 'Hover', text_domain  ),]);
		
		$this->add_control(
            'cart_total_options_hover',
            [
                'label' => __( 'Cart Total', text_domain  ),
                'type' => Controls_Manager::HEADING,
            ]
        );
		
		$this->add_control(
            'color_cart_total_hover',
            [
                'label' => __( 'Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'bg_color_cart_total_hover',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-mini-cart__total_hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		
		$this->add_control(
            'options_btn_forward_hover',
            [
                'label' => __( 'Wc Forward', text_domain  ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
		
        $this->add_control(
            'color_btn_forward_hover',
            [
                'label' => __( 'Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .wc-forward:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'bg_color_btn_forward_hover',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .wc-forward:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		
		$this->add_control(
            'options_btn_checkout_hover',
            [
                'label' => __( 'Checkout', text_domain  ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
		
        $this->add_control(
            'color_btn_checkout_hover',
            [
                'label' => __( 'Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .checkout:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
		
        $this->add_control(
            'bg_color_btn_checkout_hover',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .buttons .checkout:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'btn_basket_margin',
            [
                'label' => __( 'Margin', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '4',
                    'right' => '4',
                    'bottom' => '4',
                    'left' => '4',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .buttons a, {{WRAPPER}} .woocommerce-mini-cart__total' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_basket_padding',
            [
                'label' => __( 'Padding', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '3',
                    'right' => '8',
                    'bottom' => '3',
                    'left' => '8',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .buttons a, {{WRAPPER}} .woocommerce-mini-cart__total' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_basket_border_radius',
            [
                'label' => __( 'Border Radius', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .buttons a, {{WRAPPER}} .woocommerce-mini-cart__total' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_basket_border',
                'label' => __( 'Border', text_domain  ),
                'selector' => '{{WRAPPER}} .buttons a, {{WRAPPER}} .woocommerce-mini-cart__total',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_basket_box_shadow',
                'label' => __( 'Box Shadow', text_domain  ),
                'selector' => '{{WRAPPER}} .buttons a, {{WRAPPER}} .woocommerce-mini-cart__total',
            ]
        );
        $this->end_controls_section();
    }

    protected function register_style_before_login_controls() {
        $this->start_controls_section(
            'before_login_section',
                [
                    'label' => esc_html__( 'Before Login', text_domain ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
        );


    
		$this->add_responsive_control(
			'empty_text_align',
			[
				'label' => __( 'Empty Text Align', text_domain ),
				'type' => Controls_Manager::CHOOSE,
                'separator' => 'before',
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .empty-cart-message p' => 'text-align: {{VALUE}}',
                ],
			]
		);

        $this->add_control(
            'empty_text_color',
                [
                    'label' => esc_html__( 'Empty Cart Text Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .empty-cart-message p' => 'color: {{VALUE}}',
                    ],
                ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'empty_text_typography',
                    'selector' => '{{WRAPPER}} .empty-cart-message p',
                    'separator' => 'after',
                ]
        );

        $this->add_responsive_control(
			'go_to_shop_align',
			[
				'label' => __( 'Go To Shop Align', text_domain ),
				'type' => Controls_Manager::CHOOSE,
                'separator' => 'before',
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .go-to-shop-box' => 'text-align: {{VALUE}}',
                ],
			]
		);


        $this->start_controls_tabs(
            'style_tabs',
        );
        $this->start_controls_tab(
            'style_normal_tab_go_to_shop',
                [
                    'label' => esc_html__( 'Normal', text_domain ),
                ]
        );
        $this->add_control(
            'go_to_shop_btn',
                [
                    'label' => esc_html__( 'Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .go-to-shop-button' => 'color: {{VALUE}}',
                    ],
                ]
        );
        $this->add_control(
            'go_to_shop_btn_bg',
                [
                    'label' => esc_html__( 'Background Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .go-to-shop-button' => 'background-color: {{VALUE}}',
                    ],
                ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'style_hover_tab_go_to_shop',
                [
                    'label' => esc_html__( 'Hover', text_domain ),
                ]
        );
        $this->add_control(
            'go_to_shop_btn_hover_color',
                [
                    'label' => esc_html__( 'Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .go-to-shop-button:hover' => 'color: {{VALUE}}',
                    ],
                ]
        );
        $this->add_control(
            'go_to_shop_btn_hover_bg',
                [
                    'label' => esc_html__( 'Background Color', text_domain ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .go-to-shop-button:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

      

        $this->add_responsive_control(
            'go_to_shop_margin',
                [
                    'label' => esc_html__( 'Margin', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'separator' => 'before',
                    'size_units' => [ 'px', 'em' ],
                    'default' => [
                        'top' => 2,
                        'right' => 0,
                        'bottom' => 2,
                        'left' => 0,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .go-to-shop-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );
        $this->add_responsive_control(
            'go_to_shop_padding',
                [
                    'label' => esc_html__( 'Padding', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em' ],
                    'default' => [
                        'top' => 2,
                        'right' => 0,
                        'bottom' => 2,
                        'left' => 0,
                        'unit' => 'px',
                        'isLinked' => false,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .go-to-shop-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
        );


        $this->add_responsive_control(
            'go_to_shop_radius',
            [
                'label' => __( 'Border Radius', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .go-to-shop-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' => 'go_to_shop_typography',
                    'selector' => '{{WRAPPER}} .go-to-shop-button',
                ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'go_to_shop_box_shadow',
                    'selector' => '{{WRAPPER}} .go-to-shop-button',
                ]
        );


        $this->end_controls_section();
    }
    
	protected function register_general_btn_style_controls() {
        $this->start_controls_section(
            'section_btn_style',
            [
                'label' => __( 'Button Style', text_domain  ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_space',
            [
                'label' => __( 'Icon Space', text_domain  ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn i' => 'margin: 0 {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_typography',
            [
                'label' => __( 'Size Svg', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn i' => 'font-size: {{SIZE}}px;',
                    '{{WRAPPER}} .drop-down-btn svg' => 'width: {{SIZE}}px;',
                ],
            ]
        );

      
        
        $this->start_controls_tabs( 'tabs_button_colors' );
        $this->start_controls_tab('tab_button_normal',['label' => __( 'Normal', text_domain  ),]);

        $this->add_control(
            'btn_text_color',
            [
                'label' => __( 'Text Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_icon_color',
            [
                'label' => __( 'Icon Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .drop-down-btn svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'btn_bg',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('tab_button_hover',['label' => __( 'Hover', text_domain  ),]);

        $this->add_control(
            'h_btn_text_color',
            [
                'label' => __( 'Text Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'h_btn_icon_color',
            [
                'label' => __( 'Icon Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .drop-down-btn:hover svg' => 'fill: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'h_btn_bg',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => __( 'Margin', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => __( 'Padding', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => __( 'Border Radius', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'label' => __( 'Border', text_domain  ),
                'selector' => '{{WRAPPER}} .drop-down-btn',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => __( 'Box Shadow', text_domain  ),
                'selector' => '{{WRAPPER}} .drop-down-btn',
            ]
        );
		
		$this->add_control(
            'card_number_options',
            [
                'label' => __( 'Card Number Options', text_domain  ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
		$this->start_controls_tabs( 'tabs_button_colors_count' );
        $this->start_controls_tab('tab_button_normal_count',['label' => __( 'Normal', text_domain  ),]);
		
		$this->add_control(
            'card_number_color',
            [
                'label' => __( 'Icon Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .card-count' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_number_bg',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#F00',
                'selectors' => [
                    '{{WRAPPER}} .card-count' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		
		
		
		$this->end_controls_tab();
        $this->start_controls_tab('tab_button_hover_count',['label' => __( 'Hover', text_domain  ),]);
		
		$this->add_control(
            'card_number_color_hover',
            [
                'label' => __( 'Icon Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn:hover .card-count' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'card_number_bg_hover',
            [
                'label' => __( 'Background Color', text_domain  ),
                'type' => Controls_Manager::COLOR,
                'default' => '#F00',
                'selectors' => [
                    '{{WRAPPER}} .drop-down-btn:hover .card-count' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		
		$this->end_controls_tab();
        $this->end_controls_tabs();
		
		$this->add_responsive_control(
			'paddnig_count',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
				    'top' => '8',
	                'right' => '6',
	                'bottom' => '6',
	                'left' => '9',
	                'unit' => 'px',
	                'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .card-count' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
        $this->add_responsive_control(
            'card_count_position',
            [
                'label' => __( 'Card Count Position', text_domain  ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'allowed_dimensions' => [ 'top', 'right' ],
                'default' => [
                    'top' => '-12',
                    'right' => '-12',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .card-count' => 'top: {{TOP}}{{UNIT}};right: {{RIGHT}}{{UNIT}};',
                ],
            ]
        );
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_count',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} .card-count',
			]
		);
		
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        $editor = Plugin::$instance->editor->is_edit_mode();
        $show_count_cart = $settings['show_count_cart'];
        $btn_text = $settings['btn_text'];
        $btn_align = $settings['btn_align'];
        $empty_text = $settings['empty_text'];
        $this->add_render_attribute( 'btn_class','class', ['drop-down-btn', 'inline-flex', 'align-items-center']  );
        if ($btn_align == 'left') {
            $this->add_render_attribute( 'btn_class','class', ['flex-row-reverse', 'justify-content-end']);
        }
        $btn_class = $this->get_render_attribute_string( 'btn_class' );

      	
        echo "<div class='shopping-cart drop-down flex'>"
            . "<div>"
                . "<div $btn_class>$btn_text ";
                    Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] );
                    if ($show_count_cart == 'yes') {
                        if(!$editor) {
                            $cart_count = WC()->cart->get_cart_contents_count();
                            if ($cart_count > 0) {echo "<span class='card-count'>$cart_count</span>";}
                        } else {
                            echo "<span class='card-count'>1</span>";
                        }
                    }
                echo "</div>"
                    ."<div class='drop-down-offcanvas shopping-cart-content drop-down-content'>"
                        . '<div class="widget_shopping_cart_content">'
                            . '<div class="basket-title flex flex-wrap align-items-center justify-content-between">'
                                .'<div class="title">'
                                    . "سبد خرید"
                                . '</div>'
                                . '<div class="close-cart-button pointer">';
                                    Icons_Manager::render_icon($settings['close_cart_icon'], ['aria-hidden' => 'true']);
                                echo '</div>'
                            . '</div>';
                                if (!$editor) {
                                    $cart_contents = WC()->cart->get_cart();
                                    if (empty($cart_contents)) { 
                                        echo '<div class="empty-cart-message">';
                                            echo '<p>' . esc_html($empty_text) . '</p>';
                                            echo "<div class='go-to-shop-box'>";
                                            echo '<a href="' . esc_url(wc_get_page_permalink('shop')) . '" class="go-to-shop-button">برو به فروشگاه</a>';
                                            echo "</div>";
                                        echo '</div>';
                                    } else {
                                        woocommerce_mini_cart();
                                    }
                                } else {
                                    woocommerce_mini_cart();
                                }
                    echo '</div>'
                 ."</div>"
            . "</div>"
        . "</div>";
	}
}
Plugin::instance()->widgets_manager->register( new TMT_Basket );