<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class TMT_Category_Product extends Widget_Base {

    public function get_name() {
        return 'tmt-category-product';
    }

    public function get_title() {
        return __( 'Category Product', text_domain );
    }

    public function get_icon() {
        return 'eicon-product-pages';
    }

    public function get_categories() {
        return [ 'shop_daris' ];
    }

    public function get_keywords() {
        return [ 'category' ];
    }

    protected function register_controls() {
        $this->register_style_content_controls();
				$this->register_style_text_link_controls();
				$this->register_style_image_controls();
    }

    protected function register_style_content_controls(){
        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', text_domain ),
								'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

				$this->add_control(
				     'padding_content',
				     [
					      'label' => __( 'Padding', text_domain ),
					      'type' => Controls_Manager::DIMENSIONS,
					      'size_units' => [ 'px', '%', 'em' ],
					      'selectors' => [
						        '{{WRAPPER}} ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					       ],
				      ]
			     );

				$this->add_control(
			     'margin_content',
			     [
				      'label' => __( 'Margin', text_domain ),
				      'type' => Controls_Manager::DIMENSIONS,
				      'size_units' => [ 'px', '%', 'em' ],
				      'selectors' => [
					        '{{WRAPPER}} ul' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				       ],
			      ]
		      );

				$this->add_group_control(
			      Group_Control_Box_Shadow::get_type(),
			      [
				      'name' => 'box_shadow_content',
				      'label' => __( 'Box Shadow', text_domain ),
				      'selector' => '{{WRAPPER}} ul',
			      ]
		      );

        $this->end_controls_section();
    }
	  protected function register_style_text_link_controls() {
        $this->start_controls_section(
            'section_text_link',
            [
                'label' => __( 'Text Link', text_domain ),
								'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

				$this->add_group_control(
			     Group_Control_Typography::get_type(),
			      [
				     'name' => 'typography_text_link',
				     'label' => __( 'Typography', text_domain ),
				     'selector' => '{{WRAPPER}} ul li .text_link',
		 	      ]
		     );

				 $this->add_control(
 				     'padding_text_link',
 				     [
 					      'label' => __( 'Padding', text_domain ),
 					      'type' => Controls_Manager::DIMENSIONS,
 					      'size_units' => [ 'px', '%', 'em' ],
 					      'selectors' => [
 						        '{{WRAPPER}} ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
 					       ],
 				      ]
 			     );

 				$this->add_control(
 			     'margin_text_link',
 			     [
 				      'label' => __( 'Margin', text_domain ),
 				      'type' => Controls_Manager::DIMENSIONS,
 				      'size_units' => [ 'px', '%', 'em' ],
 				      'selectors' => [
 					        '{{WRAPPER}} ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
 				       ],
 			      ]
 		      );

					$this->add_control(
					 'border_radius_text_link',
					 [
							'label' => __( 'Border Radius', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors' => [
									'{{WRAPPER}} ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							 ],
						]
					);

				 $this->add_control(
					 'text_link_heading_tag',
					 [
						 'label' => __( 'Heading Tag', text_domain ),
						 'type' => Controls_Manager::SELECT,
						 'default' => 'span',
						 'options' => TMT_Title_Tags(),
					 ]
				 );

				$this->start_controls_tabs('style_tabs');
				$this->start_controls_tab('style_normal_tab', ['label' => __( 'Normal', text_domain),]);
				$this->add_group_control(
							Group_Control_Border::get_type(),
							[
								 'name' => 'border_section',
								 'label' => __( 'Border', text_domain ),
								 'selector' => '{{WRAPPER}} ul li',
							]
						);

						$this->add_control(
					     'color_text_link',
					     [
						     'label' => __( 'Color', text_domain ),
						     'type' => Controls_Manager::COLOR,
									'default' => '#020D26',
						     'selectors' => [
							      '{{WRAPPER}} ul li' => 'color: {{VALUE}}',
						       ],
					      ]
				     );

						 $this->add_control(
		 			     'bg_color_text_link',
		 			     [
		 				     'label' => __( 'Background', text_domain ),
		 				     'type' => Controls_Manager::COLOR,
		 				     'selectors' => [
		 					      '{{WRAPPER}} ul li' => 'background: {{VALUE}}',
		 				       ],
		 			      ]
		 		     );

				$this->end_controls_tab();
				$this->start_controls_tab('style_hover_tab', ['label' => __( 'Hover', text_domain ),]);
				$this->add_group_control(
							Group_Control_Border::get_type(),
							[
								 'name' => 'border_section_hover',
								 'label' => __( 'Border', text_domain ),
								 'selector' => '{{WRAPPER}} ul li:hover',
							]
						);

						$this->add_control(
							 'color_text_link_hover',
							 [
								 'label' => __( 'Color', text_domain ),
								 'type' => Controls_Manager::COLOR,
									'default' => '#020D26',
								 'selectors' => [
										'{{WRAPPER}} ul li:hover' => 'color: {{VALUE}}',
									 ],
								]
						 );

						 $this->add_control(
							 'bg_color_text_link_hover',
							 [
								 'label' => __( 'Background', text_domain ),
								 'type' => Controls_Manager::COLOR,
								 'selectors' => [
										'{{WRAPPER}} ul li:hover' => 'background: {{VALUE}}',
									 ],
								]
						 );
				$this->end_controls_tab();
				$this->end_controls_tabs();
        $this->end_controls_section();
    }
	  protected function register_style_image_controls() {
        $this->start_controls_section(
            'section_image',
            [
                'label' => __( 'Image', text_domain ),
								'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

				$this->add_control(
			     'show_image',
			     [
				      'label' => __( 'Show Image', text_domain ),
				      'type' => Controls_Manager::SWITCHER,
				      'label_on' => __( 'Show', text_domain ),
				      'label_off' => __( 'Hide', text_domain ),
				      'return_value' => 'yes',
				      'default' => 'yes',
			       ]
		      );

				$this->add_control(
			     'width_image',
			     [
				     'label' => __( 'Width', text_domain ),
				     'type' => Controls_Manager::SLIDER,
				     'size_units' => [ 'px', '%' ],
				      'range' => [
					      'px' => [
						      'min' => 0,
						      'max' => 168,
				     	    ],
					      '%' => [
						      'min' => 0,
						      'max' => 100,
					       ],
				       ],
				      'default' => [
					       'unit' => 'px',
					       'size' => 120,
				        ],
				      'selectors' => [
					       '{{WRAPPER}} ul li img' => 'width: {{SIZE}}{{UNIT}};',
				           ],
							'condition' => [
                 'show_image' => 'yes'
							],
			       ]
		       );

				$this->add_control(
		 			 'height_image',
		 			      [
		 				     'label' => __( 'Height', text_domain ),
		 				     'type' => Controls_Manager::SLIDER,
		 				     'size_units' => [ 'px', '%' ],
		 				      'range' => [
		 					      'px' => [
		 						      'min' => 0,
		 						      'max' => 200,
		 				     	    ],
		 					      '%' => [
		 						      'min' => 0,
		 						      'max' => 100,
		 					       ],
		 				       ],
		 				      'default' => [
		 					       'unit' => 'px',
		 					       'size' => 80,
		 				        ],
		 				      'selectors' => [
		 					       '{{WRAPPER}} ul li img' => 'height: {{SIZE}}{{UNIT}};',
		 				         ],
									'condition' => [
			                'show_image' => 'yes'
			 						],
		 			       ]
		 		     );

						 $this->add_control(
		 			     'border_radius_image',
		 			     [
		 				      'label' => __( 'Border Radius', text_domain ),
		 				      'type' => Controls_Manager::DIMENSIONS,
		 				      'size_units' => [ 'px', '%', 'em' ],
		 				      'selectors' => [
		 					        '{{WRAPPER}} ul li img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		 				       ],
									 'condition' => [
											 'show_image' => 'yes'
									 ],
		 			      ]
		 		      );
					   
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
				$link = get_the_permalink();
				$text_link_heading_tag = $settings['text_link_heading_tag'];

				$orderby = 'name';
				$order = 'desc';
				$hide_empty = false ;
				$cat_args = array(
				   'orderby'    => $orderby,
				   'order'      => $order,
				   'hide_empty' => $hide_empty,
				);

				$product_categories = get_terms( 'product_cat', $cat_args );


				if( !empty($product_categories) ){
				    echo "<ul>";
				        foreach ($product_categories as $key => $category) {

									$term_slug    = 't-shirts';
									$taxonomy     = 'product_cat';
									$termId       = $category->term_id;
									$thumbnail_id = get_term_meta( $termId, 'thumbnail_id', true );
									$image        = wp_get_attachment_url( $thumbnail_id );
                     echo "<a href=".get_term_link($category).">"
				             . "<li class='flex align-items-center justify-content-between'>"
				             . "<$text_link_heading_tag class='text_link'>"; echo $category->name;echo "</$text_link_heading_tag>";
								if($settings['show_image'] == 'yes'){echo '<img src="'.$image.'">';}
				             echo "</li>"
					 . "</a>";
				         }
				    echo "</ul>";
				}


    }
}

Plugin::instance()->widgets_manager->register( new TMT_Category_Product );