<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class TMT_Product_Meta extends Widget_Base {

	public function get_name() {
		return 'woocommerce-product-meta';
	}

	public function get_title() {
		return __( 'Product Meta', text_domain );
	}

	public function get_icon() {
		return 'eicon-product-meta';
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'meta', 'data', 'product' ];
	}

	public function get_categories() {
		return [ 'shop_daris' ];
    }

	protected function register_controls() {

		$this->start_controls_section(
			'section_product_meta_style',
			[
				'label' => __( 'Style', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'view',
			[
				'label' => __( 'View', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'flex-column',
				'options' => [
					'flex-column' => __( 'Vertical', text_domain ),
					'justify-content-between' => __( 'Horizontal', text_domain ),
				],
			]
		);

		$this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} .product_meta > span',
            ]
        );
		$this->add_control(
            'padding',
            [
                'label'      => esc_html__( 'Padding', text_domain ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default'    => [
                    'top' => '10',
                    'right' => '0',
                    'bottom' => '10',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .product_meta > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'margin',
            [
                'label'      => esc_html__( 'Margin', text_domain ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
								'default' => [
									'top' => '0',
									'right' => '0',
									'bottom' => '0',
									'left' => '10',
									'unit' => 'px',
									'isLinked' => false,
								],
                'selectors'  => [
                    '{{WRAPPER}} .product_meta > span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
	        	);


		$this->add_control(
				'heading_text_style',
					[
					'label' => __( 'Text', text_domain ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
						]
		   );

			 $this->add_group_control(
	 			Group_Control_Typography::get_type(),
	 			[
	 				'name' => 'text_typography',
	 				'selector' => '{{WRAPPER}} .detail-label',
	 			]
	 		);

			$this->add_control(
					'padding_text',
					[
							'label'      => esc_html__( 'Padding', text_domain ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors'  => [
									'{{WRAPPER}} .detail-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

			$this->add_control(
					'margin_text',
					[
							'label'      => esc_html__( 'Margin', text_domain ),
							'type'       => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors'  => [
									'{{WRAPPER}} .detail-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
					  ]
					);

					$this->add_control(
							 'border_radius_text',
							[
									'label'      => esc_html__( 'Border Radius', text_domain ),
									'type'       => Controls_Manager::DIMENSIONS,
									'size_units' => [ 'px', 'em', '%' ],
									'selectors'  => [
											'{{WRAPPER}} .detail-label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
									],
								]
							);

		$this->start_controls_tabs('style_tabs_text');
		$this->start_controls_tab('style_normal_tab_text', ['label' => __( 'Normal', text_domain ),]);
		$this->add_control(
			'text_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#020D26',
				'selectors' => [
					'{{WRAPPER}} .detail-label' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'text_bg_color',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .detail-label' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			 Group_Control_Border::get_type(),
			[
				'name' => 'border_text',
				'label' => __( 'Border Text', text_domain ),
				'selector' => '{{WRAPPER}} .detail-label',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab('style_hover_tab_text', ['label' => __( 'Hover', text_domain ),]);
		$this->add_control(
			'text_color_hover',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .detail-label:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'text_bg_color_hover',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .detail-label:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control(
			 Group_Control_Border::get_type(),
			[
				'name' => 'border_text_hover',
				'label' => __( 'Border Text', text_domain ),
				'selector' => '{{WRAPPER}} .detail-label:hover',
			]
		);
		$this->end_controls_tab();

	  $this->end_controls_tabs();

		$this->add_control(
			'heading_link_style',
			[
				'label' => __( 'Link', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'link_typography',
				'selector' => '{{WRAPPER}} a',
			]
		);


		$this->add_control(
				'padding_link',
				[
						'label'      => esc_html__( 'Padding', text_domain ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default' => [
	            'top' => '0',
	            'right' => '15',
	            'bottom' => '0',
	            'left' => '15',
	            'unit' => 'px',
	            'isLinked' => false,
						],
						'selectors'  => [
								'{{WRAPPER}} a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

		$this->add_control(
				'margin_link',
				[
						'label'      => esc_html__( 'Margin', text_domain ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default' => [
							'top' => '5',
							'right' => '0',
							'bottom' => '0',
							'left' => '5',
							'unit' => 'px',
							'isLinked' => false,
						],
						'selectors'  => [
								'{{WRAPPER}} a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
				  ]
				);

		$this->add_control(
				 'border_radius_link',
				[
						'label'      => esc_html__( 'Border Radius', text_domain ),
						'type'       => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default' => [
	            'top' => '20',
	            'right' => '20',
	            'bottom' => '20',
	            'left' => '20',
	            'unit' => 'px',
	            'isLinked' => false,
						],
						'selectors'  => [
								'{{WRAPPER}} a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
				);

		$this->start_controls_tabs('style_tabs_link');

    $this->start_controls_tab('style_normal_tab_link', ['label' => __( 'Normal', text_domain ),]);
		$this->add_control(
		 'link_color',
		 [
			 'label' => __( 'Color', text_domain ),
			 'type' => Controls_Manager::COLOR,
			 'default' => '#020D26',
			 'selectors' => [
				 '{{WRAPPER}} a' => 'color: {{VALUE}}',
			 ],
		 ]
	    );

	   $this->add_control(
		    'bg_color_link',
		    [
			 'label' => __( 'Background', text_domain ),
			 'type' => Controls_Manager::COLOR,
			 'selectors' => [
				 '{{WRAPPER}} a' => 'background: {{VALUE}}',
			      ],
		     ]
	    );

			$this->add_group_control(
				 Group_Control_Border::get_type(),
				[
					'name' => 'border_link',
					'label' => __( 'Border Link', text_domain ),
					'selector' => '{{WRAPPER}} a',
				]
			);
    $this->end_controls_tab();

    $this->start_controls_tab('style_hover_tab_link', ['label' => __( 'Hover', text_domain ),]);
		$this->add_control(
		 'link_color_hover',
		 [
			 'label' => __( 'Color', text_domain ),
			 'type' => Controls_Manager::COLOR,
			 'default' => '#fff',
			 'selectors' => [
				 '{{WRAPPER}} a:hover' => 'color: {{VALUE}}',
			 ],
		 ]
	    );

		 $this->add_control(
				'bg_color_link_hover',
				[
			 'label' => __( 'Background', text_domain ),
			 'type' => Controls_Manager::COLOR,
			 'default' => '#020D26',
			 'selectors' => [
				 '{{WRAPPER}} a:hover' => 'background: {{VALUE}}',
						],
				 ]
			);

			$this->add_group_control(
				 Group_Control_Border::get_type(),
				[
					'name' => 'border_link_hover',
					'label' => __( 'Border Link', text_domain ),
					'selector' => '{{WRAPPER}} a:hover',
				]
			);
    $this->end_controls_tab();

    $this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_meta_captions',
			[
				'label' => __( 'Captions', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_category_caption',
			[
				'label' => __( 'Category', text_domain ),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'category_caption_single',
			[
				'label' => __( 'Singular', text_domain ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Category', text_domain ),
			]
		);

		$this->add_control(
			'category_caption_plural',
			[
				'label' => __( 'Plural', text_domain ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Categories', text_domain ),
			]
		);

		$this->add_control(
			'heading_tag_caption',
			[
				'label' => __( 'Tag', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'tag_caption_single',
			[
				'label' => __( 'Singular', text_domain ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Tag', text_domain ),
			]
		);

		$this->add_control(
			'tag_caption_plural',
			[
				'label' => __( 'Plural', text_domain ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Tags', text_domain ),
			]
		);

		$this->add_control(
			'heading_sku_caption',
			[
				'label' => __( 'SKU', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'sku_caption',
			[
				'label' => __( 'SKU', text_domain ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'SKU', text_domain ),
			]
		);

		$this->add_control(
			'sku_missing_caption',
			[
				'label' => __( 'Missing', text_domain ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'N/A', text_domain ),
			]
		);

		$this->end_controls_section();
	}

	private function get_plural_or_single( $single, $plural, $count ) {
		return 1 === $count ? $single : $plural;
	}

	protected function render() {

		$settings = $this->get_settings();

		$view = $settings['view'];

		global $product;

		$product = wc_get_product();

		if ( empty( $product ) ) {
			return;
		}

		$sku = $product->get_sku();

		$settings = $this->get_settings_for_display();
		$sku_caption = ! empty( $settings['sku_caption'] ) ? $settings['sku_caption'] : __( 'SKU', text_domain );
		$sku_missing = ! empty( $settings['sku_missing_caption'] ) ? $settings['sku_missing_caption'] : __( 'N/A', text_domain );
		$category_caption_single = ! empty( $settings['category_caption_single'] ) ? $settings['category_caption_single'] : __( 'Category', text_domain );
		$category_caption_plural = ! empty( $settings['category_caption_plural'] ) ? $settings['category_caption_plural'] : __( 'Categories', text_domain );
		$tag_caption_single = ! empty( $settings['tag_caption_single'] ) ? $settings['tag_caption_single'] : __( 'Tag', text_domain );
		$tag_caption_plural = ! empty( $settings['tag_caption_plural'] ) ? $settings['tag_caption_plural'] : __( 'Tags', text_domain );
		?>
		<div class="product_meta flex <?php echo $view; ?>">

			<?php do_action( 'woocommerce_product_meta_start' ); ?>

			<?php if ( wc_product_sku_enabled() && ( $sku || $product->is_type( 'variable' ) ) ) : ?>
				<span class="sku_wrapper detail-container"><span class="detail-label"><?php echo esc_html( $sku_caption ); ?></span> <span class="sku"><?php echo $sku ? $sku : esc_html( $sku_missing ); ?></span></span>
			<?php endif; ?>

			<?php if ( count( $product->get_category_ids() ) ) : ?>
				<span class="posted_in detail-container"><span class="detail-label"><?php echo esc_html( $this->get_plural_or_single( $category_caption_single, $category_caption_plural, count( $product->get_category_ids() ) ) ); ?></span> : <span class="detail-content flex flex-wrap"><?php echo get_the_term_list( $product->get_id(),'product_cat'); ?></span></span>
			<?php endif; ?>

			<?php if ( count( $product->get_tag_ids() ) ) : ?>
				<span class="tagged_as detail-container"><span class="detail-label"><?php echo esc_html( $this->get_plural_or_single( $tag_caption_single, $tag_caption_plural, count( $product->get_tag_ids() ) ) ); ?></span> : <span class="detail-content flex flex-wrap"><?php echo get_the_term_list( $product->get_id(),'product_tag'); ?></span></span>
			<?php endif; ?>

			<?php do_action( 'woocommerce_product_meta_end' ); ?>

		</div>
		<?php
	}

}
Plugin::instance()->widgets_manager->register( new TMT_Product_Meta );
