<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class TMT_Shop_Elements extends Widget_Base {

	public function get_name() {
		return 'tmt-shop-elements';
	}

	public function get_title() {
		return __( 'Shop Elements', text_domain );
	}

	public function get_icon() {
		return 'eicon-product-add-to-cart';
	}

	public function get_categories() {
		return [ 'shop_daris' ];
    }

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'cart', 'product', 'Elements', 'add to cart' ];
	}

	public function on_export( $element ) {
		unset( $element['settings']['product_id'] );

		return $element;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product',
			[
				'label' => esc_html__( 'Element', text_domain ),
			]
		);

		$this->add_control(
			'element',
			[
				'label' => esc_html__( 'Element', text_domain ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					''                           => esc_html__( 'Select', text_domain ),
					'woocommerce_cart'           => esc_html__( 'Cart Page', text_domain ),
					'product_page'               => esc_html__( 'Single Product Page', text_domain ),
					'woocommerce_checkout'       => esc_html__( 'Checkout Page', text_domain ),
					'woocommerce_order_tracking' => esc_html__( 'Order Tracking Form', text_domain ),
					'woocommerce_my_account'     => esc_html__( 'My Account', text_domain ),
				],
			]
		);

		$this->add_control(
			'product_id',
			[
				'label'       => esc_html__( 'Enter Product ID', text_domain ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'condition'   => [
					'element' => [ 'product_page' ],
				],
			]
		);



		$this->end_controls_section();




		$this->start_controls_section(
			'section_checkout_style_label',
			[
				'label' => esc_html__( 'Label', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_checkout' ],
				],
			]
		);

		$this->add_control(
			'label_color',
			[
				'label'     => esc_html__( 'Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce form .form-row label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'required_color',
			[
				'label'     => esc_html__( 'Required Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce form .form-row .required' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'label_typography',
				'label' => esc_html__( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .woocommerce form .form-row label',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_checkout_style_input',
			[
				'label' => esc_html__( 'Input', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_checkout' ],
				],
			]
		);

		$this->add_control(
			'input_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text::placeholder' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_text_color',
			[
				'label'     => esc_html__( 'Text Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text' => 'color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce select' => 'color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce textarea.input-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'input_text_background',
			[
				'label'     => esc_html__( 'Background Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce select' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce textarea.input-text' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'textarea_height',
			[
				'label' => esc_html__( 'Textarea Height', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 125,
				],
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce textarea.input-text' => 'height: {{SIZE}}{{UNIT}}; display: block;',
				],
				'separator' => 'before',

			]
		);

		$this->add_control(
			'input_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text,
					 {{WRAPPER}} .woocommerce textarea.input-text,
					 {{WRAPPER}} .select2-container--default .select2-selection--single,
					 {{WRAPPER}} .woocommerce select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				    '{{WRAPPER}} .select2-container--default .select2-selection--single' => 'height: auto; min-height: 37px;',
					'{{WRAPPER}} .select2-container--default .select2-selection--single .select2-selection__rendered' => 'line-height: initial;',
				],
			]
		);

		$this->add_responsive_control(
			'input_space',
			[
				'label' => esc_html__( 'Element Space', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 25,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce form .form-row' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'input_border_show',
			[
				'label' => esc_html__( 'Border Style', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_on' => 'Hide',
				'label_off' => 'Show',
				'return_value' => 'yes',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'        => 'input_border',
				'label'       => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '
					{{WRAPPER}} .woocommerce .input-text,
					{{WRAPPER}} .woocommerce select,
					{{WRAPPER}} .select2-container--default .select2-selection--single',
				'condition' => [
					'input_border_show' => 'yes',
				],
			]
		);

		$this->add_control(
			'input_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text,
					 {{WRAPPER}} .select2-container--default .select2-selection--single,
					 {{WRAPPER}} .woocommerce select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_checkout_style_order_table',
			[
				'label' => esc_html__( 'Order Table', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_checkout' ],
				],
			]
		);

		$this->add_control(
			'order_table_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart th,
					{{WRAPPER}} .woocommerce table.shop_table.cart td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'order_table_border_show',
			[
				'label' => esc_html__( 'Border Style', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_on' => 'Hide',
				'label_off' => 'Show',
				'return_value' => 'yes',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'        => 'order_table_border',
				'label'       => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '{{WRAPPER}} .woocommerce table.shop_table.cart',

				'condition' => [
					'order_table_border_show' => 'yes',
				],
			]
		);

		$this->add_control(
			'order_table_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();



		// Payment section
		$this->start_controls_section(
			'section_style_checkout_payment',
			[
				'label' => esc_html__( 'Payment', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_checkout' ],
				],
			]
		);

		$this->add_control(
			'checkout_payment_color',
			[
				'label'     => esc_html__( 'Text Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout #payment, {{WRAPPER}} .woocommerce-checkout #payment div.payment_box' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'checkout_payment_background',
			[
				'label'     => esc_html__( 'Background Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-checkout #payment' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce-checkout #payment div.payment_box' => 'opacity:0.5;',
					'{{WRAPPER}} .woocommerce-checkout #payment div.payment_box::before' => 'opacity:0.5;',
				],
			]
		);

		$this->add_control(
			'checkout_payment_button_heading',
			[
				'label' => esc_html__( 'Button Style', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->start_controls_tabs( 'tabs_payment_button_style' );

		$this->start_controls_tab(
			'tab_payment_button_normal',
			[
				'label' => esc_html__( 'Normal', text_domain ),
			]
		);

		$this->add_control(
			'payment_button_text_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'payment_button_background_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'payment_button_border',
				'label' => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .woocommerce input.button',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'payment_button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'payment_button_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'payment_button_text_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'payment_button_typography',
				'label' => esc_html__( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .woocommerce input.button',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_payment_button_hover',
			[
				'label' => esc_html__( 'Hover', text_domain ),
			]
		);

		$this->add_control(
			'payment_button_hover_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'payment_button_background_hover_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'payment_button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();



		// TRacking section
		$this->start_controls_section(
			'section_tracking_style_label',
			[
				'label' => esc_html__( 'Label', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_order_tracking' ],
				],
			]
		);

		$this->add_control(
			'tracking_label_color',
			[
				'label'     => esc_html__( 'Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce form .form-row label' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tracking_label_typography',
				'label' => esc_html__( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .woocommerce form .form-row label',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_tracking_style_input',
			[
				'label' => esc_html__( 'Input', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_order_tracking' ],
				],
			]
		);

		$this->add_control(
			'tracking_input_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text::placeholder' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tracking_input_text_color',
			[
				'label'     => esc_html__( 'Text Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text' => 'color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce select' => 'color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce textarea.input-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tracking_input_text_background',
			[
				'label'     => esc_html__( 'Background Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce select' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce textarea.input-text' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tracking_input_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text,
					 {{WRAPPER}} .woocommerce textarea.input-text,
					 {{WRAPPER}} .select2-container--default .select2-selection--single,
					 {{WRAPPER}} .woocommerce select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				    '{{WRAPPER}} .select2-container--default .select2-selection--single' => 'height: auto; min-height: 37px;',
					'{{WRAPPER}} .select2-container--default .select2-selection--single .select2-selection__rendered' => 'line-height: initial;',
				],
			]
		);

		$this->add_responsive_control(
			'tracking_input_space',
			[
				'label' => esc_html__( 'Element Space', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 25,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce form .form-row' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'tracking_input_border_show',
			[
				'label' => esc_html__( 'Border Style', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_on' => 'Hide',
				'label_off' => 'Show',
				'return_value' => 'yes',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'        => 'tracking_input_border',
				'label'       => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '
					{{WRAPPER}} .woocommerce .input-text,
					{{WRAPPER}} .woocommerce select,
					{{WRAPPER}} .select2-container--default .select2-selection--single',
				'condition' => [
					'tracking_input_border_show' => 'yes',
				],
			]
		);

		$this->add_control(
			'tracking_input_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text,
					 {{WRAPPER}} .select2-container--default .select2-selection--single,
					 {{WRAPPER}} .woocommerce select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_style_tracking',
			[
				'label' => esc_html__( 'Button', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_order_tracking' ],
				],
			]
		);

		$this->add_control(
			'tracking_button_heading',
			[
				'label' => esc_html__( 'Button Style', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->start_controls_tabs( 'tabs_tracking_button_style' );

		$this->start_controls_tab(
			'tab_tracking_button_normal',
			[
				'label' => esc_html__( 'Normal', text_domain ),
			]
		);

		$this->add_control(
			'tracking_button_text_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tracking_button_background_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tracking_button_border',
				'label' => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .woocommerce input.button',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'tracking_button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tracking_button_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'tracking_button_text_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tracking_button_typography',
				'label' => esc_html__( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .woocommerce input.button',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_tracking_button_hover',
			[
				'label' => esc_html__( 'Hover', text_domain ),
			]
		);

		$this->add_control(
			'tracking_button_hover_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tracking_button_background_hover_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tracking_button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce input.button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();




		// Cart style

		$this->start_controls_section(
			'section_cart_style_heading',
			[
				'label' => esc_html__( 'Table Heading', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_cart' ],
				],
			]
		);

		$this->add_control(
			'cart_table_heading_color',
			[
				'label'     => esc_html__( 'Text Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart th' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_table_heading_background',
			[
				'label'     => esc_html__( 'Background Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart th' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'section_cart_style_table',
			[
				'label' => esc_html__( 'Table Content', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_cart' ],
				],
			]
		);

		$this->add_control(
			'cart_table_color',
			[
				'label'     => esc_html__( 'Text Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart td *' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_table_background',
			[
				'label'     => esc_html__( 'Background Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_table_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'cart_table_border_show',
			[
				'label' => esc_html__( 'Border Style', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_on' => 'Hide',
				'label_off' => 'Show',
				'return_value' => 'yes',
				'separator' => 'before',
			]
		);



		$this->add_control(
			'cart_table_border_width',
			[
				'label' => esc_html__( 'Border Width', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .woocommerce table.shop_table.cart td' => 'border-top-width: {{TOP}}{{UNIT}};',
				],
				'condition'   => [
					'cart_table_border_show' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'cart_table_border_color',
			[
				'label' => esc_html__( 'Border Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table.shop_table.cart' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .woocommerce table.shop_table.cart td' => 'border-top-color: {{VALUE}};',
				],
				'condition'   => [
					'cart_table_border_show' => [ 'yes' ],
				],
			]
		);

		$this->add_control(
			'cart_table_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce .input-text,
					 {{WRAPPER}} .select2-container--default .select2-selection--single,
					 {{WRAPPER}} .woocommerce select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_cart_style_input',
			[
				'label' => esc_html__( 'Input', text_domain ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_cart' ],
				],
			]
		);

		$this->add_control(
			'cart_input_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.cart .input-text::placeholder' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_input_text_color',
			[
				'label'     => esc_html__( 'Text Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.cart .input-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_input_text_background',
			[
				'label'     => esc_html__( 'Background Color', text_domain ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} table.cart .input-text' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_input_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} table.cart .input-text, {{WRAPPER}} table.cart td.actions .coupon .input-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing: content-box;',
				],
			]
		);


		$this->add_control(
			'cart_input_border_show',
			[
				'label' => esc_html__( 'Border Style', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'label_on' => 'Hide',
				'label_off' => 'Show',
				'return_value' => 'yes',
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), [
				'name'        => 'cart_input_border',
				'label'       => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default'     => '1px',
				'selector'    => '
					{{WRAPPER}} table.cart .input-text,
					{{WRAPPER}} table.cart td.actions .coupon .input-text',
				'condition' => [
					'cart_input_border_show' => 'yes',
				],
			]
		);

		$this->add_control(
			'cart_input_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} table.cart .input-text,
					 {{WRAPPER}} .select2-container--default .select2-selection--single,
					 {{WRAPPER}} .woocommerce select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		// Cart table button
		$this->start_controls_section(
			'section_style_cart_button',
			[
				'label' => esc_html__( 'Coupon/Update Button', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_cart' ],
				],
			]
		);

		$this->add_control(
			'cart_button_heading',
			[
				'label' => esc_html__( 'Button Style', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->start_controls_tabs( 'tabs_cart_button_style' );

		$this->start_controls_tab(
			'tab_cart_button_normal',
			[
				'label' => esc_html__( 'Normal', text_domain ),
			]
		);

		$this->add_control(
			'cart_button_text_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_button_background_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'cart_button_border',
				'label' => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .woocommerce table tr td input.button',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'cart_button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'cart_button_box_shadow',
				'selector' => '{{WRAPPER}} .woocommerce table tr td input.button',
			]
		);

		$this->add_control(
			'cart_button_text_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cart_button_typography',
				'label' => esc_html__( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .woocommerce table tr td input.button',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_cart_button_hover',
			[
				'label' => esc_html__( 'Hover', text_domain ),
			]
		);

		$this->add_control(
			'cart_button_hover_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_button_background_hover_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce table tr td input.button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


		// Cart table button
		$this->start_controls_section(
			'section_style_cart_checkout_button',
			[
				'label' => esc_html__( 'Checkout Button', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_cart' ],
				],
			]
		);

		$this->add_control(
			'cart_checkout_button_heading',
			[
				'label' => esc_html__( 'Button Style', text_domain ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->start_controls_tabs( 'tabs_cart_checkout_button_style' );

		$this->start_controls_tab(
			'tab_cart_checkout_button_normal',
			[
				'label' => esc_html__( 'Normal', text_domain ),
			]
		);

		$this->add_control(
			'cart_checkout_button_text_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_checkout_button_background_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'cart_checkout_button_border',
				'label' => esc_html__( 'Border', text_domain ),
				'placeholder' => '1px',
				'default' => '1px',
				'selector' => '{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'cart_checkout_button_border_radius',
			[
				'label' => esc_html__( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'cart_checkout_button_box_shadow',
				'selector' => '{{WRAPPER}} .wpcf7-submit',
			]
		);

		$this->add_control(
			'cart_checkout_button_text_padding',
			[
				'label' => esc_html__( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cart_checkout_button_typography',
				'label' => esc_html__( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button',
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_cart_checkout_button_hover',
			[
				'label' => esc_html__( 'Hover', text_domain ),
			]
		);

		$this->add_control(
			'cart_checkout_button_hover_color',
			[
				'label' => esc_html__( 'Text Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_checkout_button_background_hover_color',
			[
				'label' => esc_html__( 'Background Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'cart_checkout_button_hover_border_color',
			[
				'label' => esc_html__( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .wc-proceed-to-checkout a.checkout-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();


		// Account style
		$this->start_controls_section(
			'section_style_my_account',
			[
				'label' => esc_html__( 'My Account Style', text_domain ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'element' => [ 'woocommerce_my_account' ],
				],
			]
		);

		$this->add_control(
			'my_account_notice',
			[
				'label' => '<i>My Account does not support any style because my account others menu is dynamic part of My Account widget. We are sorry for it.</i>',
				'type' => Controls_Manager::RAW_HTML,


			]
		);

		$this->end_controls_section();


	}

	private function get_shortcode() {
		$settings = $this->get_settings_for_display();

		switch ( $settings['element'] ) {
			case '':
				return '';
				break;

			case 'product_page':

				if ( ! empty( $settings['product_id'] ) ) {
					$product_data = get_post( $settings['product_id'] );
					$product = ! empty( $product_data ) && in_array( $product_data->post_type, array( 'product', 'product_variation' ) ) ? wc_setup_product_data( $product_data ) : false;
				}

				if ( empty( $product ) && current_user_can( 'manage_options' ) ) {
					return esc_html__( 'Please set a valid product', text_domain );
				}

				$this->add_render_attribute( 'shortcode', 'id', $settings['product_id'] );
				break;

			case 'woocommerce_cart':
			case 'woocommerce_checkout':
			case 'woocommerce_order_tracking':
				break;
		}

		$shortcode = sprintf( '[%s %s]', $settings['element'], $this->get_render_attribute_string( 'shortcode' ) );

		return $shortcode;
	}

	protected function render() {
		$shortcode = $this->get_shortcode();

		if ( empty( $shortcode ) ) {
			return;
		}


		$html = do_shortcode( $shortcode );

		if ( 'woocommerce_checkout' === $this->get_settings( 'element' ) && '<div class="woocommerce"></div>' === $html ) {
			$html = '<div class="woocommerce">' . esc_html__( 'Your cart is currently empty.', text_domain ) . '</div>';
		}

		echo  $html;

	}

	public function render_plain_content() {
		echo $this->get_shortcode();
	}
}
Plugin::instance()->widgets_manager->register( new TMT_Shop_Elements );
