<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class TMT_Woocommerce_Breadcrumbs extends Widget_Base {

	public function get_name() {
		return 'tmt-woocommerce-breadcrumbs';
	}

	public function get_title() {
		return __( 'Woocommerce Breadcrumbs', text_domain );
	}

	public function get_icon() {
		return 'eicon-heart-o';
	}

	public function get_categories() {
        return [ 'shop_lotus' ];
	}

	public function get_keywords() {
		return [ 'Woocommerce', 'Breadcrumbs'];
	}

    protected function register_controls() {
        $this->register_general_content_controls();
        $this->register_general_style_controls();
    }
    protected function register_general_content_controls() {
        $this->start_controls_section(
            'section_btn_content',
            [
                'label' => __( 'Content', text_domain ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-breadcrumb' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
    }

    protected function register_general_style_controls() {
        $this->start_controls_section(
            'section_btn_style',
            [
                'label' => __( 'Style', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'selector' => '{{WRAPPER}} .woocommerce-breadcrumb a,{{WRAPPER}} .woocommerce-breadcrumb',
            ]
        );

        $this->add_control(
            'link_color',
            [
                'label' => __( 'Link Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-breadcrumb a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_hover_color',
            [
                'label' => __( 'Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-breadcrumb a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'color_breadcrumb_active',
            [
                'label' => __( 'Active Breadcrumbs Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'separator'    => 'before',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-breadcrumb' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        $editor = Plugin::$instance->editor->is_edit_mode();
		
		if($editor) {
            echo '<div style="text-align:center;color: white;background-color: darkgray;padding: 10px;border-radius: 4px;">' . __('Woocommerce Breadcrumbs', text_domain) . '</div>';
        } else {
            if (class_exists('WooCommerce') && is_woocommerce()) :
                woocommerce_breadcrumb();
            endif;
        }

	}
}
Plugin::instance()->widgets_manager->register( new TMT_Woocommerce_Breadcrumbs );