<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor social icons widget.
 *
 * Elementor widget that displays icons to social pages like Facebook and Twitter.
 *
 * @since 1.0.0
 */
class TMT_Social_Share extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve social icons widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'tmt-social-share';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve social icons widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Social Share', text_domain );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve social icons widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-social-icons';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'social', 'icon', 'link' ];
	}

    public function get_categories() {
        return [ 'single_daris' ];
    }

	/**
	 * Register social icons widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

    protected function register_controls() {
        $this->register_general_content_controls();
        $this->register_general_style_controls();
				$this->register_general_style_linkedin_controls();
				$this->register_general_style_pinterest_controls();
				$this->register_general_style_twitter_controls();
				$this->register_general_style_google_plus_controls();
				$this->register_general_style_facebook_controls();
				$this->register_general_style_mail_controls();
				$this->register_general_style_Whatsapp_controls();
				$this->register_general_style_telegram_controls();
				$this->register_general_style_instagram_controls();
    }
    protected function register_general_content_controls() {
        $this->start_controls_section(
            'section_social_icon',
            [
                'label' => __( 'Social Icons', text_domain ),
            ]
        );

				$this->add_control(
            'enable_text_icon',
            [
                'label' => __( 'Show Text Icon', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );

        $this->add_control(
            'linkedin',
            [
                'label' => __( 'Linkedin', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'pinterest',
            [
                'label' => __( 'Pinterest', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'twitter',
            [
                'label' => __( 'Twitter', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'google_plus',
            [
                'label' => __( 'Google Plus', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'facebook',
            [
                'label' => __( 'Facebook', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'mail',
            [
                'label' => __( 'Mail', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'whatsapp',
            [
                'label' => __( 'Whatsapp', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
        $this->add_control(
            'telegram',
            [
                'label' => __( 'Telegram', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );
				$this->add_control(
            'instagram',
            [
                'label' => __( 'Instagram', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Show', text_domain ),
                'label_off' => __( 'Hide', text_domain ),
                'return_value' => true,
                'default' => true,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', text_domain ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', text_domain ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', text_domain ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', text_domain ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
            ]
        );


        $this->end_controls_section();
    }
    protected function register_general_style_controls() {
        $this->start_controls_section(
            'section_social_style',
            [
                'label' => __( 'Icon', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'padding',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default'   => [
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'margin',
            [
                'label' => __( 'Margin', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
				$this->add_responsive_control(
            'margin_text',
            [
                'label' => __( 'space Between', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} i span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('style_icons_tabs');
        $this->start_controls_tab('style_icons_normal_tab', ['label' => __( 'Normal', text_domain ),]);

        $this->add_control(
            'icon_secondary_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default'   => '#793ba8',
                'selectors' => [
                    '{{WRAPPER}} i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_primary_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'border_radius',
            [
                'label' => __( 'Border Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} a',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} a',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_icons_hover_tab', ['label' => __( 'Hover', text_domain ),]);

        $this->add_control(
            'hover_secondary_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hover_primary_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'hover_border_radius',
            [
                'label' => __( 'Border Radius', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} a:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_box_shadow',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'hover_border',
                'label' => __( 'Border', text_domain ),
                'selector' => '{{WRAPPER}} a:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }



		protected function register_general_style_linkedin_controls() {
        $this->start_controls_section(
            'section_style_linkedin',
            [
                'label' => __( 'Linkedin', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'linkedin' => true
								],
            ]
        );

				$this->add_control(
			      'Background_color_linkedin',
			      [
				      'label' => __( 'Background', text_domain ),
				      'type' => Controls_Manager::COLOR,
				      'selectors' => [
					      '{{WRAPPER}} .bg-linkedin' => 'background-color: {{VALUE}}',
				      ],
			      ]
		      );


        $this->end_controls_section();
    }
		protected function register_general_style_pinterest_controls() {
        $this->start_controls_section(
            'section_style_pinterest',
            [
                'label' => __( 'Pinterest', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'pinterest' => true
								]
            ]
        );
				$this->add_control(
			      'Background_color_pinterest',
			      [
				      'label' => __( 'Background', text_domain ),
				      'type' => Controls_Manager::COLOR,
				      'selectors' => [
					      '{{WRAPPER}} .bg-pinterest' => 'background-color: {{VALUE}}',
				      ],
			      ]
		      );
        $this->end_controls_section();
    }
		protected function register_general_style_twitter_controls() {
        $this->start_controls_section(
            'section_style_twitter',
            [
                'label' => __( 'Twitter', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'twitter' => true
								]
            ]
        );
				$this->add_control(
			      'Background_color_twitter',
			      [
				      'label' => __( 'Background', text_domain ),
				      'type' => Controls_Manager::COLOR,
				      'selectors' => [
					      '{{WRAPPER}} .bg-twitter' => 'background-color: {{VALUE}}',
				      ],
			      ]
		      );
        $this->end_controls_section();
    }
		protected function register_general_style_google_plus_controls() {
        $this->start_controls_section(
            'section_style_google_plus',
            [
                'label' => __( 'Google Plus', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'google_plus' => true
								]
            ]
        );
				$this->add_control(
			      'Background_color_google_plus',
			      [
				      'label' => __( 'Background', text_domain ),
				      'type' => Controls_Manager::COLOR,
				      'selectors' => [
					      '{{WRAPPER}} .bg-google-plus' => 'background-color: {{VALUE}}',
				      ],
			      ]
		      );


        $this->end_controls_section();
    }
		protected function register_general_style_facebook_controls() {
        $this->start_controls_section(
            'section_style_facebook',
            [
                'label' => __( 'Facebook', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'facebook' => true
								]
            ]
        );
				$this->add_control(
						'Background_color_facebook',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .bg-facebook' => 'background-color: {{VALUE}}',
							],
						]
					);

        $this->end_controls_section();
    }
		protected function register_general_style_mail_controls() {
        $this->start_controls_section(
            'section_style_mail',
            [
                'label' => __( 'Mail', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'mail' => true
								]
            ]
        );
				$this->add_control(
						'Background_color_mail',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .bg-mail' => 'background-color: {{VALUE}}',
							],
						]
					);

        $this->end_controls_section();
    }
		protected function register_general_style_whatsapp_controls() {
        $this->start_controls_section(
            'section_style_whatsapp',
            [
                'label' => __( 'Whatsapp', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'whatsapp' => true
								]
            ]
        );
				$this->add_control(
						'Background_color_whatsapp',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .bg-whatsapp' => 'background-color: {{VALUE}}',
							],
						]
					);

        $this->end_controls_section();
    }
		protected function register_general_style_telegram_controls() {
        $this->start_controls_section(
            'section_style_telegram',
            [
                'label' => __( 'Telegram', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'telegram' => true
								]
            ]
        );
				$this->add_control(
						'Background_color_telegram',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .bg-telegram' => 'background-color: {{VALUE}}',
							],
						]
					);


        $this->end_controls_section();
    }
		protected function register_general_style_instagram_controls() {
        $this->start_controls_section(
            'section_style_instagram',
            [
                'label' => __( 'Instagram', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
								'condition' =>[
									'instagram' => true
								]
            ]
        );
				$this->add_control(
						'Background_color_instagram',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .bg-instagram' => 'background-color: {{VALUE}}',
							],
						]
					);

        $this->end_controls_section();
    }

	/**
	 * Render social icons widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$enable_text_icon = $settings['enable_text_icon'];


		$align = $settings['align'];
        $blog_name = get_bloginfo('name');
        $url = urlencode(get_the_permalink());
        $title = urlencode(html_entity_decode(get_the_title(), ENT_COMPAT, 'UTF-8'));
        $media = urlencode(get_the_post_thumbnail_url(get_the_ID(), 'full'));

        echo "<ul class='flex align-items-center justify-content-$align'>";
        if ($settings['linkedin'] == true) {
            echo "<li>"
						 ."<a class='bg-linkedin' href='http://www.linkedin.com/shareArticle?mini=true&amp;url=$url&amp;title=$title&amp;summary=&amp;source=$blog_name;'>"
						  ."<i class='fab fa-linkedin-in'>";
							if($enable_text_icon == true) {echo "<span>linkedin</span>";}
							  echo "</i>"
								."</a>"
						    ."</li>";
        }
        if ($settings['pinterest'] == true) {
            echo "<li>"
						."<a class='bg-pinterest' href='https://pinterest.com/pin/create/button/?url=$url&amp;media=$media&amp;description=$title'>"
						 ."<i class='fab fa-pinterest-p'>";
						 if($enable_text_icon == true) {echo "<span>pinterest</span>";}
						  echo"</i>"
						 ."</a>"
						 ."</li>";
        }
        if ($settings['twitter'] == true) {
            echo "<li>"
						."<a class='bg-twitter' href='https://twitter.com/intent/tweet?text=$title&amp;url=$url&amp;via=WPCrumbs'>"
						."<i class='fab fa-twitter'>";
						if($enable_text_icon == true) {echo "<span>twitter</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
        if ($settings['google_plus'] == true) {
            echo "<li>"
						."<a class='bg-google-plus' href='https://plus.google.com/share?url=$url'>"
						."<i class='fab fa-google-plus-g'>";
						if($enable_text_icon == true) {echo "<span>google plus</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
        if ($settings['facebook'] == true) {
            echo "<li>"
						."<a class='bg-facebook' href='https://www.facebook.com/sharer/sharer.php?u=$url'>"
						."<i class='fab fa-facebook-f'>";
						if($enable_text_icon == true) {echo "<span>facebook</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
        if ($settings['mail'] == true) {
            echo "<li>"
						."<a class='bg-mail' href='mailto:?subject=$title&amp;body=$url'>"
						."<i class='far fa-envelope'>";
						if($enable_text_icon == true) {echo "<span>mail</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
				if ($settings['whatsapp'] == true) {
            echo "<li>"
						."<a class='bg-whatsapp' href='https://api.whatsapp.com/send?text=$url'>"
						."<i class='fab fa-whatsapp'>";
						if($enable_text_icon == true) {echo "<span>whatsapp</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
        if ($settings['telegram'] == true) {
            echo "<li>"
						."<a class='bg-telegram' href='https://telegram.me/share/url?url=$url&text=$title'>"
						."<i class='fab fa-telegram-plane'>";
						if($enable_text_icon == true) {echo "<span>telegram</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
				if ($settings['instagram'] == true) {
            echo "<li>"
						."<a class='bg-instagram' href='https://instagram.me/share/url?url=$url&text=$title'>"
						."<i class='fab fa-instagram'>";
						if($enable_text_icon == true) {echo "<span>instagram</span>";}
						 echo"</i>"
						."</a>"
						."</li>";
        }
        echo "</ul>";
	}
}
Plugin::instance()->widgets_manager->register( new TMT_Social_Share );
