jQuery(document).ready(function ($) {

    $(document).on('click', '.elementor-product-simple .single_add_to_cart_button:not(.disabled)', function (e) {
        e.preventDefault();

        var $thisbutton = $(this),
            $form = $thisbutton.closest('form.cart'),
            id = $thisbutton.val(),
            product_qty = $form.find('input[name=quantity]').val() || 1,
            product_id = $form.find('input[name=product_id]').val() || id,
            variation_id = $form.find('input[name=variation_id]').val() || 0;

        var data = {
            action: 'woocommerce_ajax_add_to_cart',
            product_id: product_id,
            product_sku: '',
            quantity: product_qty,
            variation_id: variation_id,
        };

        $(document.body).trigger('adding_to_cart', [$thisbutton, data]);

        $.ajax({
            type: 'post',
            url: wc_add_to_cart_params.ajax_url,
            data: data,
            beforeSend: function (response) {
                $thisbutton.removeClass('added').addClass('loading');
            },
            complete: function (response) {
                $thisbutton.addClass('added').removeClass('loading');
            },
            success: function (response) {

                if (response.error && response.product_url) {
                    window.location = response.product_url;
                    return;
                } else {
                    $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $thisbutton]);
                    var count = $('.shopping-cart .card-count').text();
                    var x = parseInt(count) + parseInt(product_qty);
                    $('.shopping-cart .card-count').html(x);
                }
            },
        });

        return false;
    });

    // wc_add_to_cart_params is required to continue, ensure the object exists
    if (typeof wc_add_to_cart_params === 'undefined')
        return false;

    // Ajax add to cart
    $(document).on('click', '.variations_form .single_add_to_cart_button', function (e) {

        e.preventDefault();

        $variation_form = $(this).closest('.variations_form');
        var var_id = $variation_form.find('input[name=variation_id]').val();
        var product_id = $variation_form.find('input[name=product_id]').val();
        var quantity = $variation_form.find('input[name=quantity]').val();

        //attributes = [];
        $('.ajaxerrors').remove();
        var item = {},
            check = true;

        variations = $variation_form.find('select[name^=attribute]');

        /* Updated code to work with radio button - mantish - WC Variations Radio Buttons - 8manos */
        if (!variations.length) {
            variations = $variation_form.find('[name^=attribute]:checked');
        }

        /* Backup Code for getting input variable */
        if (!variations.length) {
            variations = $variation_form.find('input[name^=attribute]');
        }

        variations.each(function () {

            var $this = $(this),
                attributeName = $this.attr('name'),
                attributevalue = $this.val(),
                index,
                attributeTaxName;

            $this.removeClass('error');

            if (attributevalue.length === 0) {
                index = attributeName.lastIndexOf('_');
                attributeTaxName = attributeName.substring(index + 1);

                $this
                    .addClass('required error')
                    .before('<div class="ajaxerrors"><p>Please select ' + attributeTaxName + '</p></div>')

                check = false;
            } else {
                item[attributeName] = attributevalue;
            }

        });

        if (!check) {
            return false;
        }

        var $thisbutton = $(this);

        if ($thisbutton.is('.variations_form .single_add_to_cart_button')) {

            $thisbutton.removeClass('added');
            $thisbutton.addClass('loading');

            var data = {
                action: 'woocommerce_add_to_cart_variable_tmt',
            };

            $variation_form.serializeArray().map(function (attr) {
                if (attr.name !== 'add-to-cart') {
                    if (attr.name.endsWith('[]')) {
                        let name = attr.name.substring(0, attr.name.length - 2);
                        if (!(name in data)) {
                            data[name] = [];
                        }
                        data[name].push(attr.value);
                    } else {
                        data[attr.name] = attr.value;
                    }
                }
            });

            // Trigger event
            $('body').trigger('adding_to_cart', [$thisbutton, data]);

            // Ajax action
            $.post(wc_add_to_cart_params.ajax_url, data, function (response) {

                if (!response) {
                    return;
                }

                if (response.error && response.product_url) {
                    window.location = response.product_url;
                    return;
                }

                // Redirect to cart option
                if (wc_add_to_cart_params.cart_redirect_after_add === 'yes') {
                    window.location = wc_add_to_cart_params.cart_url;
                    return;
                }

                // Trigger event so themes can refresh other areas.
                $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $thisbutton]);
                var count = document.querySelector(".shopping-cart .card-count").textContent;
                var x = parseInt(count) + parseInt(quantity);
                $('.shopping-cart .card-count').html(x);

            });

            return false;

        } else {

            return true;
        }

    });

    // offcanvas
    $(".drop-down-offcanvas").on("click", function () {
        $(".drop-down-content").slideUp(0).removeClass('content-open');
        $(".drop-down-btn").removeClass("tmt-open");
    });

    $(".drop-down-offcanvas > div").on("click", function (e) {
        e.stopPropagation();
    });

    // shopping cart
    $(".shopping-cart .drop-down-btn").on("click", function (e) {
        e.preventDefault();
        if ($(this).hasClass("tmt-open")) {
            $(this).removeClass("tmt-open");
            $(this).next(".drop-down-content").slideUp(0).removeClass('content-open');
        } else {
            $(".shopping-cart .drop-down-btn").removeClass("tmt-open");
            $(".shopping-cart .drop-down-content").slideUp(0).removeClass('content-open');
            $(this).addClass("tmt-open");
            $(this).next(".drop-down-content").slideDown(0).addClass('content-open');
        }
    });

    // New code: Close cart with close button
    $(".close-cart-button").on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        $(this).closest(".drop-down-content").slideUp(0).removeClass('content-open');
        $(".shopping-cart .drop-down-btn").removeClass("tmt-open");
    });

    $('body').on('added_to_cart', function () {
        $.ajax({
            url: wc_add_to_cart_params.ajax_url,
            type: 'POST',
            data: {
                action: 'woocommerce_get_refreshed_fragments'
            },
            success: function (response) {
                if (response && response.fragments) {
                    $.each(response.fragments, function (key, value) {
                        $(key).replaceWith(value);
                    });
                }
            }
        });

        setTimeout(function () {
            location.reload();
        }, 200);
    });






    $('.wpcf7-submit').parent().addClass('tmt-wpcf7-submit');
    $(".tmt-preloader").delay(2000).fadeOut("fast");
    $(".drop-down-btn").parents('.elementor-top-column').addClass('position-drop-down');

    // Accordion
    $(".tmt-accordion-title").on("click", function () {
        if ($(this).hasClass("tmt-open")) {
            $(this).removeClass("tmt-open");
            $(this).siblings(".tmt-accordion-content").slideUp(200);
        } else {
            if ($(this).hasClass("multiple")) { }
            else {
                $(".tmt-accordion-title").removeClass("tmt-open");
                $(".tmt-accordion-content").slideUp(200);
            }
            $(this).addClass("tmt-open");
            $(this).siblings(".tmt-accordion-content").slideDown(200);
        }
    });


    // Whatsapp
    $(".whatsapp-pupup").click(function (e) {
        e.stopPropagation();
        $(".whatsapp-chat").toggleClass("open-chat");
        $(this).children("i").toggleClass("fab fa-whatsapp fas fa-times");
    });


    // Tabs    
    $('.tab-nav-item').on("click", function () {
        var id = $(this).attr('rel');
        $(this).parents('.tmt-tabs').find('.tmt-open').removeClass('tmt-open');
        $(this).addClass('tmt-open');
        $('#' + id).addClass('tmt-open');
    });

    // START Back to Top Settings
    var filter = $('#top');
    $(window).scroll(function () {
        if ($(window).scrollTop() > 500) {
            filter.fadeIn();
        } else {
            filter.fadeOut();
        }
    });
    filter.on('click', function (e) {
        e.preventDefault();
        $('html, body').animate({ scrollTop: 0 }, '300');
    });
    // END Back to Top Settings


    // Modal
    $(".tmt-modal-botton a").click(function (e) {
        e.stopPropagation();
        $(this).parents(".tmt-modal").toggleClass("tmt-open");
        $(".tmt-modal-close,.tmt-modal-bg").click(function (e) { e.stopPropagation(); $(this).parents(".tmt-modal").removeClass("tmt-open"); });
    });
    $(".auto .tmt-modal-close,.auto .tmt-modal-bg").click(function (e) {
        e.stopPropagation();
        $(this).parents(".tmt-modal-bg").css({ "opacity": "0", "visibility": "hidden", "animation": "none" });
        $(this).css({ "opacity": "0", "visibility": "hidden", "animation": "none" });
    });
    $('.tmt-modal-box').click(function (e) { e.stopPropagation(); });


    // Icon header : search form & user login
    $(window).click(function () {
        $(".user-login .drop-down-content, .search-form .drop-down-content").slideUp(300);
        $(".user-login .drop-down-btn, .search-form .drop-down-btn").removeClass("tmt-open");
    });

    $(".user-login .drop-down-content, .user-login .drop-down-btn").on('click', function (e) {
        e.stopPropagation();
    });

    $(".search-form .drop-down-content, .search-form .drop-down-btn").on('click', function (e) {
        e.stopPropagation();
    });

    // Handle user login dropdown
    $(".user-login .drop-down-btn").on("click", function (e) {
        e.preventDefault();
        const $this = $(this);

        if ($this.hasClass("tmt-open")) {
            $this.removeClass("tmt-open");
            $this.next(".drop-down-content").slideUp(300);
        } else {
            $(".user-login .drop-down-btn").removeClass("tmt-open");
            $(".user-login .drop-down-content").slideUp(300);
            $this.addClass("tmt-open");
            $this.next(".drop-down-content").slideDown(300);
        }
    });

    // Handle search form dropdown
    $(".search-form .drop-down-btn").on("click", function (e) {
        e.preventDefault();
        const $this = $(this);

        if ($this.hasClass("tmt-open")) {
            $this.removeClass("tmt-open");
            $this.next(".drop-down-content").slideUp(300);
        } else {
            $(".search-form .drop-down-btn").removeClass("tmt-open");
            $(".search-form .drop-down-content").slideUp(300);
            $this.addClass("tmt-open");
            $this.next(".drop-down-content").slideDown(300);
        }
    });


});


(function ($) {
    var WidgetElementorSliderHandler = function ($scope, $) {
        $scope.find('.tmt-slider-yes').each(function () {
            var setting = $(this).attr("data-swiper"),
                id = $(this).attr("id"),
                items = JSON.parse(setting);
            const swiperParams = {
                slidesPerView: items.columns,
                navigation: {
                    nextEl: '#' + id + ' .swiper-button-next',
                    prevEl: '#' + id + ' .swiper-button-prev',
                },
                loop: items.infinite,
                centeredSlides: items.centerMode,
                pagination: {

                    el: '#' + id + ' .swiper-pagination',
                    clickable: true,
                },
                breakpoints: {
                    10: { slidesPerView: items.columns_mobile, },
                    480: { slidesPerView: items.columns_mobile_h, },
                    768: { slidesPerView: items.columns_tablet, },
                    1024: { slidesPerView: items.columns, },
                }
            };

            if (items.autoplay) {
                swiperParams.autoplay = {
                    delay: items.speed,
                    disableOnInteraction: false
                };
                if (items.pause_on_hover) {
                    $('#' + id).on('mouseover', function () { swiper.autoplay.stop(); });
                    $('#' + id).on('mouseout', function () { swiper.autoplay.start(); });
                }
            }

            if (items.effect && items.effect !== 'none') {
                switch (items.effect) {
                    case 'fade':
                        swiperParams.effect = "fade";
                        break;
                    case 'cube':
                        swiperParams.effect = "cube";
                        swiperParams.grabCursor = true;
                        swiperParams.cubeEffect = {
                            shadow: true,
                            slideShadows: true,
                            shadowOffset: 20,
                            shadowScale: 0.94,
                        };
                        break;
                    case 'coverflow':
                        swiperParams.effect = "coverflow";
                        swiperParams.grabCursor = true;
                        swiperParams.coverflowEffect = {
                            rotate: 50,
                            stretch: 0,
                            depth: 100,
                            modifier: 1,
                            slideShadows: true,
                        };
                        break;
                    case 'flip':
                        swiperParams.effect = "flip";
                        swiperParams.grabCursor = true;
                        break;
                    case 'cards':
                        swiperParams.effect = "cards";
                        swiperParams.grabCursor = true;
                        break;
                    case 'creative':
                        swiperParams.effect = "creative";
                        switch (items['creative-type']) {
                            case "1":
                                swiperParams.creativeEffect = {
                                    prev: {
                                        shadow: true,
                                        translate: [0, 0, -400],
                                    },
                                    next: {
                                        translate: ["100%", 0, 0],
                                    },
                                };
                                break;
                            case "2":
                                swiperParams.creativeEffect = {
                                    prev: {
                                        shadow: true,
                                        translate: ["-120%", 0, -500],
                                    },
                                    next: {
                                        shadow: true,
                                        translate: ["120%", 0, -500],
                                    },
                                };
                                break;
                            case "3":
                                swiperParams.creativeEffect = {
                                    prev: {
                                        shadow: true,
                                        translate: ["-20%", 0, -1],
                                    },
                                    next: {
                                        translate: ["100%", 0, 0],
                                    },
                                };
                                break;
                            case "4":
                                swiperParams.creativeEffect = {
                                    prev: {
                                        shadow: true,
                                        translate: [0, 0, -800],
                                        rotate: [180, 0, 0],
                                    },
                                    next: {
                                        shadow: true,
                                        translate: [0, 0, -800],
                                        rotate: [-180, 0, 0],
                                    },
                                };
                                break;
                            case "5":
                                swiperParams.creativeEffect = {
                                    prev: {
                                        shadow: true,
                                        translate: ["-125%", 0, -800],
                                        rotate: [0, 0, -90],
                                    },
                                    next: {
                                        shadow: true,
                                        translate: ["125%", 0, -800],
                                        rotate: [0, 0, 90],
                                    },
                                };
                                break;
                            case "6":
                                swiperParams.creativeEffect = {
                                    prev: {
                                        shadow: true,
                                        origin: "left center",
                                        translate: ["-5%", 0, -200],
                                        rotate: [0, 100, 0],
                                    },
                                    next: {
                                        origin: "right center",
                                        translate: ["5%", 0, -200],
                                        rotate: [0, -100, 0],
                                    },
                                };
                                break;
                        }
                        break;
                }
            }

            const swiper = new Swiper('#' + id, swiperParams);
        });
    }

    var WidgetElementorMenuHandler = function ($scope, $) {
        $scope.find('.menu').click(function () { $('.responsive-fix .tmt-navbar-wrapper').removeClass('open-menu'); });
        $scope.find(window).click(function () { $('.responsive-under .tmt-navbar-wrapper').removeClass('open-menu'); });
        $scope.find('.responsive-under .tmt-navbar-wrapper').click(function (e) { e.stopPropagation(); });
        $scope.find('.main-menu').click(function (e) { e.stopPropagation(); });
        $scope.find(".bars").click(function (e) {
            e.preventDefault();
            if ($(this).parents('.tmt-navbar-wrapper').hasClass('open-menu')) {
                $('.tmt-navbar-wrapper').removeClass('open-menu');
            } else {
                $('.tmt-navbar-wrapper').removeClass('open-menu');
                $(this).parents('.tmt-navbar-wrapper').addClass('open-menu');
            }
        });
        $scope.find(".menu-item-has-children").click(function (e) { e.stopPropagation(); $(this).toggleClass('open-sub-menu'); });
        $scope.find(".menu-item-has-children > ul").click(function (e) { e.stopPropagation(); $(this).addClass('open-sub-menu'); });
        $scope.find(".open-sub-menu-yes .menu-item-has-children").addClass('open-sub-menu');
        $scope.find("li.mega-menu").parents("li.menu-item-has-children").addClass("main-mega-menu");
    };

    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/tmt-image-box.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/themento_slides.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/themento_slider_member.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/tmt-post-grid.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/tmt-testimonial.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/tmt-post-list.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/tmt_archive_product.default', WidgetElementorSliderHandler);
        elementorFrontend.hooks.addAction('frontend/element_ready/tmt-navbar.default', WidgetElementorMenuHandler);
    });
})(jQuery);

