<?php

use Themento\Admin\Config_Setting;

$Config_Setting = new Config_Setting();
$elements = $Config_Setting->Elementor_Elements();
$modules = get_option('tmt_active_modules_option', []);

foreach ($elements as $element) {
    $id = $element['id'];
    if ($modules[$id] == true && $element['category'] == 'general') {
        require wp_directory . '/inc/elements/' . $id . '.php';
    } elseif ($modules[$id] == true && $element['category'] == 'single') {
        require wp_directory . '/inc/elements/single/' . $id . '.php';
    } elseif (woo && ($modules[$id] == true && $element['category'] == 'shop')) {
        require wp_directory . '/inc/elements/shop/' . $id . '.php';
    }
}


if(class_exists('bn_parsidate')){
    if ( get_locale() == 'fa_IR' && !wpp_is_active( 'persian_date' ) ) {
        add_filter( 'the_time', 'wpp_fix_post_time', 10, 2 );
        add_filter( 'the_date', 'wpp_fix_post_date', 10, 2 );
        add_filter( 'get_the_time', 'wpp_fix_post_date', 10, 2 );
        add_filter( 'get_the_date', 'wpp_fix_post_date', 100, 2 );
        add_filter( 'get_comment_time', 'wpp_fix_comment_time', 10, 2 );
        add_filter( 'get_comment_date', 'wpp_fix_comment_date', 10, 2 );
        add_filter( 'date_i18n', 'wpp_fix_i18n', 10, 4 );
        add_filter( 'wp_date', 'wpp_fix_i18n', 10, 4 );
    }
}

