<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
class TMT_Archive_Product extends Widget_Base
{

    public function get_name()
    {
        return 'tmt_archive_product';
    }
    public function get_title()
    {
        return __('Archive Product', text_domain);
    }
    public function get_icon()
    {
        return 'eicon-products';
    }

    public function get_script_depends() {
        return [ 'swiper' ];
    }
     public function get_style_depends() {
        return [ 'swiper' ];
    }

    
    public function get_categories()
    {
        return ['shop_daris'];
    }

  

    protected function register_controls()
    {
        $this->register_general_product_grid_controls();
        $this->register_general_style_product_grid_controls();
        $this->register_sort_by_style_product_grid_controls();
        $this->register_image_style_product_grid_controls();
        $this->register_title_style_product_grid_controls();
        $this->register_rating_style_product_grid_controls();
        $this->register_price_style_product_grid_controls();
        $this->register_badge_style_product_grid_controls();
        $this->register_pagination_product_grid_controls();
        $this->register_button_style_product_grid_controls();
        $this->register_style_arrows_dots_slider_controls();
        $this->register_general_slider_controls();
    }



    protected function register_general_product_grid_controls()
    {
        $this->start_controls_section(
            'section_product_grid',
            [
                'label' => __('Product Settings', text_domain)
            ]
        );

        $this->add_control(
            'product_type',
            [
                'label' => __('Post Type', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'product',
                'options' => [
                    'product' => __('Product', text_domain),
                    'loop' => __('Loop',   text_domain),
                    'related' => __('Related', text_domain),
                ],
            ]
        );

        $this->add_control(
            'show_product_type',
            [
                'label'   => esc_html__('Show Product', text_domain),
                'type'    => Controls_Manager::SELECT,
                'default' => 'all',
                'options' => [
                    'all'      => esc_html__('All Products', text_domain),
                    'onsale'   => esc_html__('On Sale', text_domain),
                    'featured' => esc_html__('Featured', text_domain),
                ],
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'product_grid_columns',
            [
                'label' => __('Number of Columns', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'cols-4',
                'options' => [
                    'cols-1' => __('1 Columns', text_domain),
                    'cols-2' => __('2 Columns', text_domain),
                    'cols-3' => __('3 Columns', text_domain),
                    'cols-4' => __('4 Columns', text_domain),
                    'cols-5' => __('5 Columns', text_domain),
                    'cols-6' => __('6 Columns', text_domain),
                ],
                'condition' => [
                    'enable_slider!' => 'yes'
                ],
            ]
        );

        // object fit
        $this->add_control(
            'object_fit',
                [
                'label' => __( 'Image Fit', text_domain ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'inherit'    => __( 'None', text_domain ),
                    'cover'      => __( 'Cover', text_domain ),
                    'contain'    => __( 'Contain', text_domain ),
                    'fill'       => __( 'Fill', text_domain ),
                    'scale-down' => __( 'Scale Down', text_domain ),
                    ],
                'default' => 'inherit',
                'selectors' => [
                    '{{WRAPPER}} .img-product img' => 'object-fit: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'products_count',
            [
                'label' => __('Number of Posts', text_domain),
                'type' => Controls_Manager::NUMBER,
                'default' => '4',
                'condition' => [
                    'product_type!' => 'loop',
                ],
            ]
        );

        $this->add_control(
            'products_order',
            [
                'label' => __('Order', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'asc' => __('Ascending', text_domain),
                    'desc' => __('Descending', text_domain)
                ],
                'condition' => [
                    'product_type!' => 'loop',
                ],
            ]
        );
        $product_categories = get_terms('product_cat');

        $options = [];
        foreach ($product_categories as $category) {
            $options[$category->slug] = $category->name;
        }

        $this->add_control(
            'product_categories',
            [
                'label'       => esc_html__('Categories', text_domain),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $options,
                'default'     => [],
                'label_block' => true,
                'multiple'    => true,
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'exclude_products',
            [
                'label'       => esc_html__('Exclude Product(s)', text_domain),
                'type'        => Controls_Manager::TEXT,
                'placeholder'     => 'product_id',
                'label_block' => true,
                'description' => __('Write product id here, if you want to exclude multiple products so use comma as separator. Such as 1 , 2', text_domain),
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'enable_slider',
            [
                'label' => __('Enable Slider', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'label_on' => __('Show', text_domain),
                'label_off' => __('Hide', text_domain),
                'return_value' => 'yes',
                'default' => '',
            ]
        );

        $this->add_control(
            'hide_free',
            [
                'label'   => esc_html__('Hide Free', text_domain),
                'type'    => Controls_Manager::SWITCHER,
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'hide_out_stock',
            [
                'label'   => esc_html__('Hide Out of Stock', text_domain),
                'type'    => Controls_Manager::SWITCHER,
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order by', text_domain),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date'  => esc_html__('Date', text_domain),
                    'price' => esc_html__('Price', text_domain),
                    'sales' => esc_html__('Sales', text_domain),
                    'rand'  => esc_html__('Random', text_domain),
                ],
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __('Title Tag', text_domain),
                'type' => Controls_Manager::SELECT,
                'separator' => 'before',
                'label_block' => true,
                'multiple' => true,
                'options' => TMT_Title_Tags(),
                'default' => 'div',
            ]
        );

        $this->add_control(
            'show_sale_flash',
            [
                'label' => __('Show Sale Flash', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'sale_flash_text',
            [
                'label' => __('Text', text_domain),
                'type' => Controls_Manager::TEXT,
                'default' => __('OFF', 'lotus'),
                'condition' => [
                    'show_sale_flash' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_add_to_card',
            [
                'label' => __('Show Add To Card', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'text_button',
            [
                'label' => __('Text Button', text_domain),
                'type' => Controls_Manager::TEXT,
                'default' => __('Add To Card', text_domain),
                'placeholder' => __('Write the text of the button', text_domain),
                'condition' => [
                    'show_add_to_card' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_icon_add_to_card',
            [
                'label' => __('Show Icon Add To Card', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [
                    'show_add_to_card' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'show_rating',
            [
                'label'   => esc_html__('Rating', text_domain),
                'type'    => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => '',
            ]
        );

        // $this->add_control(
        //     'animation_mode',
        //     [
        //         'label' => __('Animation Mode', text_domain),
        //         'type' => Controls_Manager::SWITCHER,
        //         'label_on' => __('Show', text_domain),
        //         'label_off' => __('Hide', text_domain),
        //         'return_value' => 'yes',
        //         'default' => 'yes',
        //         'selectors' => [
        //             '{{WRAPPER}} .product:hover .tmt-product-item' => 'box-shadow: 0 0 5px rgba(0,0,0,.15);
        //             -moz-box-shadow: 0 0 5px rgba(0,0,0,.15);
        //             -webkit-box-shadow: 0 0 5px rgba(0,0,0,.15);
        //             position: relative;
        //             z-index: 5;
        //             margin-bottom:-120px;',

        //             '{{WRAPPER}} .tmt-product-item:hover .hover-box' => 'opacity: 1;
        //             visibility: visible;
        //             bottom: 15px;',

        //             '{{WRAPPER}} .tmt-product-item .hover-box' => 'position: absolute;
        //             left: 0;
        //             right: 0;
        //             bottom: -30px;
        //             opacity: 0;
        //             visibility: hidden;
        //             z-index: 1;
        //             transition: all .3s ease;
        //             -moz-transition: all .3s ease;
        //             -webkit-transition: all .3s ease;
        //             -o-transition: all .3s ease;
        //             padding: 10px 0;
        //             display:flex;
        //             flex-direction: column;
        //             text-align:center;',
        //         ],
        //     ]
        // );

        $this->add_control(
            'show_pagination',
            [
                'label' => __('Show Pagination', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
                'default' => '',
                'condition' => [
                    'product_type' => 'product',
                ],
            ]
        );
        $this->add_control(
            'remove_sort_by',
            [
                'label'   => esc_html__('Remove Sort By', text_domain),
                'type'    => Controls_Manager::SWITCHER,
                'prefix_class' => 'remove-sort-by-',
                'condition' => [
                    'product_type' => 'loop',
                ],
            ]
        );
        $this->add_control(
            'remove_result_count',
            [
                'label'   => esc_html__('Remove Result Count', text_domain),
                'type'    => Controls_Manager::SWITCHER,
                'prefix_class' => 'remove-result-count-',
                'condition' => [
                    'product_type' => 'loop',
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function register_general_slider_controls()
    {
        $this->start_controls_section(
            'section_slider_options',
            [
                'label' => __('Slider Options', text_domain),
                'type' => Controls_Manager::SECTION,
                'condition' => [
                    'enable_slider' => 'yes',
                ],

            ]
        );
        $this->add_control(
            'slider_columns',
            [
                'label' => __('Number of Columns', text_domain),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_tablet',
            [
                'label' => __('Columns Tablet', text_domain),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_mobile',
            [
                'label' => __('Columns Mobile', text_domain),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'navigation',
            [
                'label' => __('Navigation', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'both',
                'options' => [
                    'both' => __('Arrows and Dots', text_domain),
                    'arrows' => __('Arrows', text_domain),
                    'dots' => __('Dots', text_domain),
                    'none' => __('None', text_domain),
                ],
            ]
        );
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __('Pause on Hover', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __('Autoplay', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __('Autoplay Speed', text_domain),
                'type' => Controls_Manager::NUMBER,
                'default' => 2000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label' => __('Infinite Loop', text_domain),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label' => __('Center Mode', text_domain),
                'type' => Controls_Manager::SWITCHER,
            ]
        );
        $this->add_control(
            'effect',
            [
                'label' => __('Effect', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'      => __('None', text_domain),
                    'fade'      => __('Fade', text_domain),
                    'cube'      => __('Cube', text_domain),
                    'coverflow' => __('Coverflow', text_domain),
                    'flip'      => __('Flip', text_domain),
                    'cards'     => __('Cards', text_domain),
                    'creative'  => __('Creative', text_domain),
                ],
            ]
        );
        $this->add_control(
            'creative_type',
            [
                'label' => __('Creative Type', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => __('Type', text_domain) . ' 1',
                    '2' => __('Type', text_domain) . ' 2',
                    '3' => __('Type', text_domain) . ' 3',
                    '4' => __('Type', text_domain) . ' 4',
                    '5' => __('Type', text_domain) . ' 5',
                    '6' => __('Type', text_domain) . ' 6',
                ],
                'condition' => [
                    'effect' => 'creative'
                ],
            ]
        );
        $this->end_controls_section();
    }
    protected function register_general_style_product_grid_controls()
    {

        $this->start_controls_section(
            'general_style',
            [
                'label'     => esc_html__('General', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'align_title',
            [
                'label'   => __('Alignment', text_domain),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', text_domain),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon'  => 'eicon-h-align-center',
                    ],
                    'right'  => [
                        'title' => __('Right', text_domain),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'default'   => 'center',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item .title_price' => 'text-align: {{VALUE}};',
                ],
            ]
        );


        // margin woocommerce
        $this->add_responsive_control(
            'margin_products',
            [
                'label' => __('Margin Products', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .woocommerce .products , {{WRAPPER}} .woocommerce .products-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_gap_column',
            [
                'label'   => esc_html__('Column Gap', text_domain),
                'type'    => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                    ],
                ],
                'default' => [
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide , {{WRAPPER}} .product , {{WRAPPER}} .tmt-product-box' => 'padding-right: {{SIZE}}px;padding-left: {{SIZE}}px',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_gap_row',
            [
                'label'   => esc_html__('Spacing Between Rows', text_domain),
                'type'    => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                    ],
                ],
                'default' => [
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product , {{WRAPPER}} .tmt-product-box' => 'padding-top: {{SIZE}}px;padding-bottom: {{SIZE}}px',
                ],
            ]
        );

        //  height
        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__('Height', text_domain),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                        'step' => 1,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'rem',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product , {{WRAPPER}} .tmt-product-item' => 'height:{{SIZE}}{{UNIT}}',
                ],
            ]
        );


        $this->add_responsive_control(
            'item_padding',
            [
                'label'      => esc_html__('Item Padding', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '15',
                    'left' => '5',
                    'unit' => 'px',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tmt-product-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label'      => esc_html__('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tmt-product-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_item_style');
        $this->start_controls_tab('tab_item_normal', ['label' => esc_html__('Normal', text_domain),]);

        $this->add_control(
            'item_background',
            [
                'label'     => esc_html__('Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'item_border',
                'label'       => esc_html__('Border Color', text_domain),
                'selector'    => '{{WRAPPER}} .tmt-product-item',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'item_shadow',
                'selector' => '{{WRAPPER}} .tmt-product-item',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('tab_item_hover', ['label' => esc_html__('Hover', text_domain),]);

        $this->add_control(
            'item_hover_background',
            [
                'label'     => esc_html__('Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'item_hover_border_color',
            [
                'label'     => esc_html__('Border Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'item_border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'item_hover_shadow',
                'selector' => '{{WRAPPER}} .tmt-product-item:hover',
            ]
        );

        $this->add_responsive_control(
            'aimation_down',
            [
                'label' => __('Animation Down', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 130,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 80,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product:hover .tmt-product-item' => 'padding-bottom: {{SIZE}}px;',
                ],
                'condition' => [
                    'animation_mode' => 'yes'
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    protected function register_sort_by_style_product_grid_controls()
    {
        $this->start_controls_section(
            'sort_by_style',
            [
                'label' => esc_html__('Sort By', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'product_type' => 'loop',
                ],
            ]
        );
        $this->start_controls_tabs('sort_by_style_tabs_sort');
        $this->start_controls_tab('sort_by_style_normal_tab', ['label' => __('Normal', text_domain),]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sort_by_typography',
                'label' => esc_html__('Typography', text_domain),
                'selector' => '{{WRAPPER}} .sort-by',
            ]
        );
        $this->add_control(
            'sort_by_color',
            [
                'label' => esc_html__('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#20262A',
                'selectors' => [
                    '{{WRAPPER}} .sort-by,{{WRAPPER}} .sort-by a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'sort_by_bg_color',
            [
                'label' => esc_html__('Bachground Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sort-by a' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sort_by_margin',
            [
                'label' => esc_html__('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .sort-by a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'sort_by_shadow',
                'selector' => '{{WRAPPER}} .sort-by a',
            ]
        );


        $this->add_responsive_control(
            'sort_by_padding',
            [
                'label' => esc_html__('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '5',
                    'right' => '10',
                    'bottom' => '5',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sort-by a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'sort_by_border_radius',
            [
                'label' => esc_html__('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sort-by a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'sort_by_color_icon',
            [
                'label' => esc_html__('Color Icon', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#eead16',
                'selectors' => [
                    '{{WRAPPER}} .sort-by i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('sort_by_style_active_tab', ['label' => __('Active', text_domain),]);

        $this->add_control(
            'active_by_bg_color',
            [
                'label' => esc_html__('Hover Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .sort-by a:hover,{{WRAPPER}} .sort-by a.active' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'active_sort_by_bg_color',
            [
                'label' => esc_html__('Bachground Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#eead16',
                'selectors' => [
                    '{{WRAPPER}} .sort-by a:hover,{{WRAPPER}} .sort-by a.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }
    protected function register_image_style_product_grid_controls()
    {
        $this->start_controls_section(
            'image_style',
            [
                'label'     => esc_html__('Image', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label'   => esc_html__('Height', text_domain),
                'type'    => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 5,
                    ],
                    'rem' => [
                        'min'  => 0,
                        'max'  => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .img-product' => 'height: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'animation_mode!' => 'yes'
                ],
            ]
        );
        $this->add_responsive_control(
            'width',
            [
                'label'   => esc_html__('Width', text_domain),
                'type'    => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1000,
                        'step' => 5,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item img' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'image_border',
                'label'    => esc_html__('Image Border', text_domain),
                'selector' => '{{WRAPPER}} .img-product',
            ]
        );

        $this->start_controls_tabs('style_tabs_image');
        $this->start_controls_tab('style_normal_tab', ['label' => __('Normal', 'elementor'),]);

        $this->add_control(
            'bg_color_img',
            [
                'label' => __('Background', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item .img-product' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item .img-product' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_tab', ['label' => __('Hover', 'elementor'),]);

        $this->add_control(
            'hover_normal_bg_color_img',
            [
                'label' => __('Background Normal', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item .img-product:hover' => 'transition:.5s;background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_bg_color_img',
            [
                'label' => __('Background', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item .img-product:before,.tmt-product-item .img-product:after' => 'background:{{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_border_radius_hover',
            [
                'label'      => esc_html__('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item .img-product:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    protected function register_rating_style_product_grid_controls()
    {
        $this->start_controls_section(
            'style_rating',
            [
                'label'     => esc_html__('Rating', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'rating_color',
            [
                'label'     => esc_html__('Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#e7e7e7',
                'selectors' => [
                    '{{WRAPPER}} .star-rating:before' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'active_rating_color',
            [
                'label'     => esc_html__('Active Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#FFCC00',
                'selectors' => [
                    '{{WRAPPER}} .star-rating span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'rating_margin',
            [
                'label'      => esc_html__('Margin', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .star-rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function register_title_style_product_grid_controls()
    {
        $this->start_controls_section(
            'title_style',
            [
                'label'     => esc_html__('Title', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        // $this->add_responsive_control(
        //     'align_title',
        //     [
        //         'label'   => __('Alignment', text_domain),
        //         'type'    => Controls_Manager::CHOOSE,
        //         'options' => [
        //             'left' => [
        //                 'title' => __('Left', text_domain),
        //                 'icon'  => 'eicon-h-align-left',
        //             ],
        //             'center' => [
        //                 'title' => __('Center', text_domain),
        //                 'icon'  => 'eicon-h-align-center',
        //             ],
        //             'right'  => [
        //                 'title' => __('Right', text_domain),
        //                 'icon'  => 'eicon-h-align-right',
        //             ],
        //         ],
        //         'default'   => 'center',
        //         'separator' => 'before',
        //     ]
        // );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#172541',
                'selectors' => [
                    '{{WRAPPER}} .tmt-wc-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hover_title_color',
            [
                'label'     => esc_html__('Hover Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product:hover .tmt-wc-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => esc_html__('Margin', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tmt-wc-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => esc_html__('Typography', text_domain),
                'selector' => '{{WRAPPER}} .tmt-wc-title a',
            ]
        );
        $this->end_controls_section();
    }
    protected function register_price_style_product_grid_controls()
    {
        $this->start_controls_section(
            'style_price',
            [
                'label'     => esc_html__('Price', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bg_price_color',
            [
                'label'     => esc_html__('Background Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .price' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_padding',
            [
                'label'      => esc_html__('Padding', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'price_margin',
            [
                'label'      => esc_html__('Margin', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => '0',
                    'right' => '10',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'price_radius',
            [
                'label'      => esc_html__('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .price' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'sale_price_heading',
            [
                'label'     => esc_html__('Price', text_domain),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'sale_price_color',
            [
                'label'     => esc_html__('Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#172541',
                'selectors' => [
                    '{{WRAPPER}} .price ins,{{WRAPPER}} .price .woocommerce-Price-amount' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'sale_price_typography',
                'label'    => esc_html__('Typography', text_domain),
                'selector' => '{{WRAPPER}} .price ins,{{WRAPPER}} .price .woocommerce-Price-amount',
            ]
        );

        $this->add_control(
            'old_price_heading',
            [
                'label'     => esc_html__('Price Del', text_domain),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'old_price_color',
            [
                'label'     => esc_html__('Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#000',
                'selectors' => [
                    '{{WRAPPER}} .price del,{{WRAPPER}} .price del .woocommerce-Price-amount' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'old_price_typography',
                'label'    => esc_html__('Typography', text_domain),
                'selector' => '{{WRAPPER}} .price del .woocommerce-Price-amount',
            ]
        );



        $this->end_controls_section();
    }
    protected function register_badge_style_product_grid_controls()
    {
        $this->start_controls_section(
            'style_badge',
            [
                'label'     => esc_html__('Badge', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_sale_flash' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'layout_badge',
            [
                'label' => __('Layout', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'row',
                'options' => [
                    'column'  => __('Vertical', text_domain),
                    'column-reverse' => __('Vertical Reverse', text_domain),
                    'row'  => __('Row', text_domain),
                    'row-reverse' => __('Row Reverse', text_domain),
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-offer' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'badge_width',
            [
                'label' => esc_html__('Width', text_domain),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'em',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-offer' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'badge_height',
            [
                'label' => esc_html__('Height', text_domain),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'em',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-offer' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'badge_line_height',
            [
                'label' => esc_html__('Line Height', text_domain),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'em',
                    'size' => 3,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-offer' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'badge_text_color',
            [
                'label'     => esc_html__('Text Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-offer' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'badge_bg_color',
            [
                'label'     => esc_html__('Background Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#172541',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-offer' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'badge_padding',
            [
                'label'      => esc_html__('Padding', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default'    => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tmt-product-offer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'badge_border_radius',
            [
                'label'      => esc_html__('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .tmt-product-offer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'badge_position',
            [
                'label'      => esc_html__('Position', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top', 'right'],
                'size_units' => ['px', '%'],
                'default'    => [
                    'top' => '20',
                    'right' => '20',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .tmt-product-offer' => 'position:absolute; top: {{TOP}}{{UNIT}}; right: {{RIGHT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'badge_border',
                'label'       => esc_html__('Border', text_domain),
                'selector'    => '{{WRAPPER}} .tmt-product-offer',
                'separator'   => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'badge_shadow',
                'selector' => '{{WRAPPER}} .tmt-product-offer',
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_badge',
                'label' => __('Typography', text_domain),
                'selector' => '{{WRAPPER}} .tmt-product-offer',
            ]
        );

        $this->end_controls_section();
    }
    protected function register_button_style_product_grid_controls()
    {
        $this->start_controls_section(
            'style_button',
            [
                'label'     => esc_html__('Button', text_domain),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('style_tabs_button');
        $this->start_controls_tab('style_normal_tab_button', ['label' => __('Normal', 'elementor'),]);


        $this->add_control(
            'color_button',
            [
                'label' => __('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item  .add-to-cart .button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'bg_color_button',
            [
                'label' => __('Background', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#02108B',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item  .add-to-cart .button' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_tab_button', ['label' => __('Hover', 'elementor'),]);

        $this->add_control(
            'color_button_hover',
            [
                'label' => __('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item  .add-to-cart .button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hover_bg_color_button',
            [
                'label' => __('Background', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#03B610D6',
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item  .add-to-cart .button:hover' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'align_button',
            [
                'label'   => __('Alignment', text_domain),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => __('Right', text_domain),
                        'icon'  => 'eicon-flex eicon-justify-end-h',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon'  => 'eicon-flex eicon-justify-center-h',
                    ],
                    'end'  => [
                        'title' => __('Left', text_domain),
                        'icon'  => 'eicon-flex eicon-justify-start-h',
                    ],
                    'between'  => [
                        'title' => __('Space between', text_domain),
                        'icon'  => 'eicon-justify-space-between-h',
                    ],
                ],
                'default'   => 'center',
                'separator' => 'before',
            ]
        );



        $this->add_responsive_control(
            'padding_button',
            [
                'label' => __('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'top' => '5',
                    'right' => '10',
                    'bottom' => '5',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item  .add-to-cart .button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius_button',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'top' => '5',
                    'right' => '5',
                    'bottom' => '5',
                    'left' => '5',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-product-item  .add-to-cart .button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_button',
                'label' => __('Typography', text_domain),
                'selector' => '{{WRAPPER}} .tmt-product-item  .add-to-cart .button',
            ]
        );

        $this->end_controls_section();
    }
    protected function register_pagination_product_grid_controls()
    {
        $this->start_controls_section(
            'section_pagination_post_grid_style',
            [
                'label' => __('Pagination', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'post_grid_pagination_alignment',
            [
                'label' => __('Pagination Alignment', text_domain),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => __('Right', text_domain),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => __('Left', text_domain),
                        'icon' => 'eicon-text-align-left',
                    ]
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination' => 'text-align: {{VALUE}};',
                ]
            ]
        );


        $this->start_controls_tabs('style_pagination_tabs');
        $this->start_controls_tab('style_pagination_normal_tab', ['label' => __('Normal', text_domain),]);

        $this->add_control(
            'post_grid_pagination_number_color',
            [
                'label' => __('Pagination Number Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span,{{WRAPPER}} .woocommerce-pagination a' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'post_grid_pagination_bg_color',
            [
                'label' => __('Pagination Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span,{{WRAPPER}} .woocommerce-pagination a' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'post_grid_pagination_border',
                'selector' => '{{WRAPPER}} .woocommerce-pagination span,{{WRAPPER}} .woocommerce-pagination a',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_pagination_hover_tab', ['label' => __('Hover', text_domain),]);

        $this->add_control(
            'post_grid_pagination_number_hover_color',
            [
                'label' => __('Pagination Number Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span.current,{{WRAPPER}} .woocommerce-pagination a:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'post_grid_pagination_bg_hover_color',
            [
                'label' => __('Pagination Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'default' => '#FDB60D',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span.current,{{WRAPPER}} .woocommerce-pagination a:hover' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'post_grid_pagination_hover_border',
                'selector' => '{{WRAPPER}} .woocommerce-pagination span.current,{{WRAPPER}} .woocommerce-pagination a:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'post_grid_pagination_border_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span,{{WRAPPER}} .woocommerce-pagination a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_grid_pagination_margin',
            [
                'label' => __('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => '20',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span,{{WRAPPER}} .woocommerce-pagination a' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'post_grid_pagination_padding',
            [
                'label' => __('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'default' => [
                    'top' => '8',
                    'right' => '15',
                    'bottom' => '4',
                    'left' => '15',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-pagination span,{{WRAPPER}} .woocommerce-pagination a' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->end_controls_section();
    }
    protected function register_style_arrows_dots_slider_controls()
    {
        $this->start_controls_section(
            'section_style_navigation',
            [
                'label' => __('Navigation', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'navigation' => ['arrows', 'dots', 'both'],
                ],
            ]
        );
        $this->add_control(
            'heading_style_arrows',
            [
                'label' => __('Arrows', text_domain),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );
        $this->add_responsive_control(
            'right_arrow',
            [
                'label' => __('Right Arrow', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top', 'right'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'left_arrow',
            [
                'label' => __('Left Arrow', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top', 'left'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'top: {{TOP}}%;left: {{LEFT}}%;right: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_size',
            [
                'label' => __('Arrows Size', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );
        $this->start_controls_tabs('arrows_icon_tabs');
        $this->start_controls_tab('arrows_icon_normal', [
            'label' => __('Normal', text_domain),
            'condition' => [
                'navigation' => ['arrows', 'both'],
            ],
        ]);

        $this->add_control(
            'arrows_color',
            [
                'label' => __('Icon Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );
        $this->add_control(
            'arrows_background_color',
            [
                'label' => __('Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab('arrows_icon_hover', [
            'label' => __('Hover', text_domain),
            'condition' => [
                'navigation' => ['arrows', 'both'],
            ],
        ]);

        $this->add_control(
            'arrows_hover_color',
            [
                'label' => __('Icon Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );
        $this->add_control(
            'arrows_hover_background_color',
            [
                'label' => __('Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'arrow_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['arrows', 'both'],
                ],
            ]
        );

        $this->add_control(
            'heading_style_dots',
            [
                'label' => __('Dots', text_domain),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => ['dots', 'both'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_position',
            [
                'label' => __('Dots Position', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => ['top', 'right'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => ['dots', 'both'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_width',
            [
                'label' => __('Width', text_domain),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_height',
            [
                'label' => __('Height', text_domain),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'dots_color',
            [
                'label' => __('Dots Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => ['dots', 'both'],
                ],
            ]
        );
        $this->add_control(
            'active_dot_color',
            [
                'label' => __('Active Dot Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
                'default' => '#4054B2',
                'condition' => [
                    'navigation' => ['dots', 'both'],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_width',
            [
                'label' => __('Width', text_domain),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_height',
            [
                'label' => __('Height', text_domain),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => ['px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_margin',
            [
                'label' => esc_html__('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],

                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'   => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );

        $this->add_control(

            'style_outline_hover',
            [
                'label' => __('Style Outline', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => [
                    'none' => __('None', text_domain),
                    'solid'  => __('Solid', text_domain),
                    'dashed' => __('Dashed', text_domain),
                    'dotted' => __('Dotted', text_domain),
                    'double' => __('Double', text_domain),
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-style:{{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'outline_thickness_hover',
            [
                'label' => __('Thickness', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-width: {{SIZE}}px;',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
        );

        $this->add_control(
            'outline_color_hover',
            [
                'label' => __('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-color: {{VALUE}}',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
        );

        $this->add_control(
            'outline_offset_hover',
            [
                'label' => __('Padding', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-offset: {{SIZE}}px;',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
        );

        $this->add_control(
            'border_radius_outline_hover',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
        );


        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings();
        $editor = Plugin::$instance->editor->is_edit_mode();
        $product_grid_columns = $settings['product_grid_columns'];
        $show_product_type = $settings['show_product_type'];
        $show_sale_flash = $settings['show_sale_flash'];
        $sale_flash_text = $settings['sale_flash_text'];
        $product_type = $settings['product_type'];
        $title_tag = $settings['title_tag'];
        // $align_title = $settings['align_title'];
        $align_button = $settings['align_button'];
        $text_button = $settings['text_button'];

        $id = $this->get_id();
        // $terms =  wp_get_post_terms( $id, 'product_cat' );
        // if ($show_category && !empty($terms)) {
        //     echo "<div class='tmt-wc-category'>"
        //         . '<a href="'.get_term_link($terms[0], 'product_cat').'">'.$terms[0]->name.'</a>';
        //     echo "</div>";
        // }



        $enable_slider = $settings['enable_slider'];
        if ($enable_slider == 'yes') {
            $is_rtl = is_rtl();
            $direction = $is_rtl ? 'rtl' : 'ltr';
            $show_dots = (in_array($settings['navigation'], ['dots', 'both']));
            $show_arrows = (in_array($settings['navigation'], ['arrows', 'both']));
            $columns = $settings['slider_columns'];
            $columns_tablet = $settings['slider_columns_tablet'];
            $columns_mobile = $settings['slider_columns_mobile'];
            $pause_on_hover = $settings['pause_on_hover'];
            $infinite = $settings['infinite'];
            $autoplay = $settings['autoplay'];
            $centerMode = $settings['centerMode'];
            $autoplay_speed = $settings['autoplay_speed'];
            $effect = $settings['effect'];
            $data_swiper = [
                'columns' => absint($columns),
                'columns_tablet' => absint($columns_tablet),
                'columns_mobile_h' => $columns_tablet == 1 ? 1 : $columns_tablet - 1,
                'columns_mobile' => absint($columns_mobile),
                'autoplay' => ('yes' === $autoplay),
                'speed' => absint($autoplay_speed),
                'pause_on_hover' => ('yes' === $pause_on_hover),
                'infinite' => ('yes' === $infinite),
                'centerMode' => ('yes' === $centerMode),
                'effect' => $effect,
            ];
            if ($effect == 'creative') {
                $data_swiper['creative-type'] = $settings['creative_type'];
            }

            $this->add_render_attribute('slides', [
                'data-swiper' => wp_json_encode($data_swiper),
            ]);
        }

        switch ($product_type) {

            case "loop":
                if ($editor) {
                    echo "<div class='woocommerce woocommerce-archive'>";
                    do_action('woocommerce_before_main_content');

                    do_action('woocommerce_before_shop_loop');

                    echo "<ul class='products flex flex-wrap $product_grid_columns'>";

                    $args = array(
                        'post_type' => 'product',
                        'posts_per_page' => 10,
                    );
                    $loop = new \WP_Query($args);
                    while ($loop->have_posts()) : $loop->the_post();
                        $this->Shop_Loop($settings, $show_sale_flash, $sale_flash_text, $title_tag, $align_button, $text_button);
                    endwhile;
                    wp_reset_postdata();
                    echo "</ul>";
                    do_action('woocommerce_after_shop_loop');

                    do_action('woocommerce_after_main_content');

                    echo "</div>";
                } else {
                    echo "<div class='woocommerce woocommerce-archive'>";
                    do_action('woocommerce_before_main_content');

                    if (woocommerce_product_loop()) {
                        do_action('woocommerce_before_shop_loop');

                        echo "<ul class='products flex flex-wrap $product_grid_columns'>";

                        if (wc_get_loop_prop('total')) {
                            while (have_posts()) {
                                the_post();

                                do_action('woocommerce_shop_loop');

                                $this->Shop_Loop($settings, $show_sale_flash, $sale_flash_text, $title_tag, $align_button, $text_button);
                            }
                        }
                        echo "</ul>";
                        do_action('woocommerce_after_shop_loop');
                    } else {
                        do_action('woocommerce_no_products_found');
                    }

                    do_action('woocommerce_after_main_content');
                    echo "</div>";
                }
                break;

            case "product":
                echo "<div class='woocommerce'>";
                $exclude_products = ($settings['exclude_products']) ? explode(',', $settings['exclude_products']) : [];
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array(
                    'posts_per_page' => $settings['products_count'],
                    'post_status' => 'publish',
                    'order' => $settings['products_order'],
                    'post_type' => 'product',
                    'post__not_in'        => $exclude_products,
                    'paged' => $paged,
                );
                if (!empty($settings['product_categories'])) {
                    $args['tax_query'][] = array(
                        'taxonomy'           => 'product_cat',
                        'field'              => 'slug',
                        'terms'              => $settings['product_categories'],
                        'post__not_in'       => $exclude_products,
                    );
                }
                if ('yes' == $settings['hide_free']) {
                    $args['meta_query'][] = array(
                        'key'     => '_price',
                        'value'   => 0,
                        'compare' => '>',
                        'type'    => 'DECIMAL',
                    );
                }
                $product_visibility_term_ids = wc_get_product_visibility_term_ids();
                if ('yes' == $settings['hide_out_stock']) {
                    $args['tax_query'][] = array(
                        array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => $product_visibility_term_ids['outofstock'],
                            'operator' => 'NOT IN',
                        ),
                    ); // WPCS: slow query ok.
                }
                switch ($show_product_type) {
                    case 'featured':
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'term_taxonomy_id',
                            'terms'    => $product_visibility_term_ids['featured'],
                        );
                        break;
                    case 'onsale':
                        $product_ids_on_sale    = wc_get_product_ids_on_sale();
                        $product_ids_on_sale[]  = 0;
                        $args['post__in'] = $product_ids_on_sale;
                        break;
                }
                switch ($settings['orderby']) {
                    case 'price':
                        $args['meta_key'] = '_price'; // WPCS: slow query ok.
                        $args['orderby']  = 'meta_value_num';
                        break;
                    case 'rand':
                        $args['orderby'] = 'rand';
                        break;
                    case 'sales':
                        $args['meta_key'] = 'total_sales'; // WPCS: slow query ok.
                        $args['orderby']  = 'meta_value_num';
                        break;
                    default:
                        $args['orderby'] = 'date';
                }
                $query = new \WP_Query($args);




                if ($enable_slider == 'yes') {
                    echo "<ul class='products-slider-grid'><div id='slider-$id' class='swiper tmt-slider-yes products-slider' dir='$direction' " . $this->get_render_attribute_string('slides') . ">"
                        . "<div class='swiper-wrapper'>";
                    // echo "<div id='products' class='products-slider dir='$direction' $slides'>";
                } else {
                    echo "<ul class='products flex flex-wrap $product_grid_columns'>";
                }



                if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
                        $this->Shop_Loop($settings, $show_sale_flash, $sale_flash_text, $title_tag, $align_button, $text_button);
                    endwhile;

                    if ($enable_slider == 'yes') {
                        echo '</div>';
                        if ($show_dots) {
                            echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
                        }
                        if ($show_arrows) {
                            echo "<div class='tmt-sw-button swiper-button-prev'></div>"
                                . "<div class='tmt-sw-button swiper-button-next'></div>";
                        }
                    }

                    echo "</div>"
                        . "</ul>";

                    if (('yes' === $settings['show_pagination'])) {
                        $GLOBALS['wp_query']->max_num_pages = $query->max_num_pages;
                        daris_the_posts_navigation(3);
                    };
                endif;
                wp_reset_postdata();

                break;

            case "related":
                echo "<div class='woocommerce'>";
                global $post;
                // get categories
                $cat_terms = wp_get_post_terms($post->ID, 'product_cat');
                foreach ($cat_terms as $term) $cats_array[] = $term->term_id;

                // get tags
                $tag_terms = wp_get_post_terms($post->ID, 'product_tag');
                foreach ($tag_terms as $term) $tags_array[] = $term->term_id;

                $args = array(
                    'orderby' => 'rand',
                    'posts_per_page' => $settings['products_count'],
                    'post_status' => 'publish',
                    'post_type' => 'product',
                    'post__not_in' => array($post->ID),
                    'tax_query' => array(
                        'relation' => 'AND',
                    ),
                );

                if (!empty($cat_terms)) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'field' => 'id',
                            'terms' => $cats_array
                        ),
                    );
                }

                if (!empty($tag_terms)) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_tag',
                            'field' => 'id',
                            'terms' => $tags_array
                        ),
                    );
                }



                $query = new \WP_Query($args);

                if ($enable_slider == 'yes') {
                    echo "<ul class='products-slider-grid'><div id='slider-$id' class='swiper tmt-slider-yes products-slider' dir='$direction' " . $this->get_render_attribute_string('slides') . ">"
                        . "<div class='swiper-wrapper'>";
                    // echo "<div id='products' class='products-slider dir='$direction' $slides'>";
                } else {
                    echo "<ul class='products flex flex-wrap $product_grid_columns'>";
                }

                // echo "<ul class='products flex flex-wrap $product_grid_columns'>";
                if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();
                        $this->Shop_Loop($settings, $show_sale_flash, $sale_flash_text, $title_tag, $align_button, $text_button);
                    endwhile;

                    if ($enable_slider == 'yes') {
                        echo '</div>';
                        if ($show_dots) {
                            echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
                        }
                        if ($show_arrows) {
                            echo "<div class='tmt-sw-button swiper-button-prev'></div>"
                                . "<div class='tmt-sw-button swiper-button-next'></div>";
                        }
                    }

                    echo "</div>"
                        . "</ul>";
                endif;
                wp_reset_postdata();

                break;
        }
    }

    private function shop_loop($settings, $show_sale_flash, $sale_flash_text, $title_tag, $align_button, $text_button)
    {
        global $product;
        if (empty($product) || !$product->is_visible()) {
            return;
        }
        $link = get_the_permalink();
        $title = get_the_title();
        $id = $product->get_id();

?>
        <li class="<?php echo ($settings['enable_slider'] == 'yes') ? 'swiper-slide' : 'tmt-product-box' ?>" <?php wc_product_class('', $product); ?>>
            <div class="tmt-product-item">
                <!--image-->
                <a class='img-product' href='<?php echo $link ?>'>
                    <?php woocommerce_template_loop_product_thumbnail();
                    echo wp_get_attachment_image(get_post_meta(get_the_ID(), 'second_featured_image', true), 'full');
                    ?>
                    <div class=' flex flex-column justify-content-center align-items-center'>
                        <?php if ($product->is_on_sale() && $show_sale_flash == 'yes') {
                            echo "<div class='tmt-product-offer flex align-items-center justify-content-center'>"
                                . "<span>" . tmt_get_sell_price($id) . "</span>"
                                . "<span> $sale_flash_text </span>"
                                . "</div>";
                        } ?>
                    </div>
                </a>
                <!--image-->

                <!--price &&& title-->
                <div class='title_price'>
                    <?php
                    echo "<$title_tag class='tmt-wc-title'><a href='$link'>$title</a></$title_tag>";

                    ?>
                </div>

                <!--add to card-->
                <div class="hover-box">
                    <?php if ($settings['show_add_to_card'] == 'yes') { ?>
                        <div class="flex align-items-center justify-content-<?php echo $align_button ?>">
                            <?php woocommerce_template_loop_price(); ?>
                            <div class="add-to-cart">
                                <?php woocommerce_template_loop_add_to_cart(); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>

            </div>
        </li>

<?php

    }
}
Plugin::instance()->widgets_manager->register(new TMT_Archive_Product);
