<?php

namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
class Themento_Slider_Member extends Widget_Base
{
    public function get_name()
    {
        return 'themento_slider_member';
    }

    public function get_title()
    {
        return __('Slider Member', text_domain);
    }

    public function get_icon()
    {
        return 'eicon-person';
    }

    public function get_script_depends() {
        return [ 'swiper' ];
    }
     public function get_style_depends() {
        return [ 'swiper' ];
    }

    public function get_categories()
    {
        return [text_domain];
    }

    public function get_keywords()
    {
        return ['member', 'team', 'experts'];
    }

   

    protected function register_controls()
    {
        $this->register_content_controls();
        $this->register_slider_contols();
        $this->register_style_general_controls();
        $this->register_style_image_controls();
        $this->register_style_role_controls();
        $this->register_style_name_controls();
        $this->register_style_icon_controls();
        $this->register_style_navigation_controls();
    }


    // register content controls
    protected function register_content_controls()
    {
        $this->start_controls_section(
            'section_slides',
            [
                'label' => __('Slides', text_domain),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        // repeater social
        $repeater_social=new Repeater();

        // social title
        $repeater_social->add_control(
             'social_title',
             [
                 'label'   => __('Title', text_domain),
                 'type'    => Controls_Manager::TEXT,
                 'default' => 'Facebook',
             ]
         );
 
        // social link
        $repeater_social->add_control(
             'social_link',
             [
                 'label'   => __('Link', text_domain),
                 'type'    => Controls_Manager::URL,
                 'default' => ['http://www.facebook.com/test/' => ''],
             ]
         );
 
 
         // social icon
         $repeater_social->add_control(
             'social_icon',
             [
                 'label'   => __('Choose Icon', text_domain),
                 'type' => Controls_Manager::ICONS,
                 'default' => [
                     'value' => 'fab fa-facebook-f',
                     'library' => 'solid',
                 ],
             ]
        );
 
 
         
        // repeater slides
        $repeater_slides = new Repeater();


        // photo
        $repeater_slides->add_control(
            'photo',
            [
                'label'   => __('Choose Photo', text_domain),
                'type'    => Controls_Manager::MEDIA,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => wp_directory_uri . '/assets/images/member.svg',
                ],
            ]
        );

        $repeater_slides->add_control(
            'object_fit',
            [
                'label' => __('Image Fit', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill'       => __('Fill', text_domain),
                    'contain'    => __('Contain', text_domain),
                    'cover'      => __('Cover', text_domain),
                    'scale-down' => __('Scale Down', text_domain),
                    'none'       => __('None', text_domain),
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-img img' => 'object-fit: {{VALUE}};',
                ]
            ]
        );


        // role
        $repeater_slides->add_control(
            'role',
            [
                'label'       => __('Role', text_domain),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('Managing Director', text_domain),
                'placeholder' => __('Member Role', text_domain),
                'dynamic'     => ['active' => true],
            ]
        );


        // name
        $repeater_slides->add_control(
            'name',
            [
                'label' => __('Name', text_domain),
                'type' => Controls_Manager::TEXT,
                'default' => __('Ali Amini', text_domain),
            ]
        );

        // add social to slide
        $repeater_slides->add_control(
            'social_repeater',
            [
                'label' => __('Social Lists', text_domain),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater_social->get_controls(),
                'default' => [
                    [
                        'social_link'       => 'https://www.facebook.com/test/', text_domain,
                        'social_icon'       => ['value' => 'fab fa-facebook-f', 'library' => 'fa-solid'],
                        'social_title'      => 'Facebook',
                    ],
                    [
                        'social_link'       => 'https://www.twitter.com/test/', text_domain,
                        'social_icon'       => ['value' => 'fab fa-twitter', 'library' => 'fa-solid'],
                        'social_title'      => 'Twitter',
                    ],
                    [
                        'social_link'       => 'https://www.instagram.com/themento.net/', text_domain,
                        'social_icon'       => ['value' => 'fab fa-instagram', 'library' => 'fa-solid'],
                        'social_title'      => 'Instagram',
                    ],
                    [
                        'social_link'       => 'https://www.telegram.me/test/', text_domain,
                        'social_icon'       => ['value' => 'fab fa-telegram-plane', 'library' => 'fa-solid'],
                        'social_title'      => 'Telegram',
                    ],
                ],
                'title_field' => '{{{ social_title }}}',
            ]
        );
      


        // slides
        $this->add_control(
            'slides',
            [
                'label' => __('Slides', text_domain),
                'type' => Controls_Manager::REPEATER,
                'show_label' => true,
                'fields' =>  $repeater_slides->get_controls(),
                'default' => [
                    [
                        'text' => __('Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain),
                        'name' => __('Ali Amini 1', text_domain),
                        'title' => __('CEO 1', text_domain),
                    ],
                    [
                        'text' => __('Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain),
                        'name' => __('Ali Amini 2', text_domain),
                        'title' => __('CEO 2', text_domain),
                    ],
                    [
                        'text' => __('Lorem ipsum dolor sit amet consectetur adipiscing elit dolor', text_domain),
                        'name' => __('Ali Amini 3', text_domain),
                        'title' => __('CEO 3', text_domain),
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );

       

        $this->end_controls_section();
    }


    // register slider controls
    protected function register_slider_contols() {
        $this->start_controls_section(
            'section_slider_options',
            [
                'label' => __( 'Slider Options', text_domain ),
                'type' => Controls_Manager::SECTION,
            ]
        );
        $this->add_control(
            'slider_columns',
            [
	            'label' => __( 'Number of Columns', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_tablet',
            [
	            'label' => __( 'Columns Tablet', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'slider_columns_mobile',
            [
	            'label' => __( 'Columns Mobile', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
            ]
        );
        $this->add_control(
            'navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'both',
                'options' => [
                    'both' => __( 'Arrows and Dots', text_domain ),
                    'arrows' => __( 'Arrows', text_domain ),
                    'dots' => __( 'Dots', text_domain ),
                    'none' => __( 'None', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __( 'Pause on Hover', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Autoplay', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __( 'Autoplay Speed', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'default' => 2000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label' => __( 'Infinite Loop', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label' => __( 'Center Mode', text_domain ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );
        $this->add_control(
            'effect',
            [
                'label' => __( 'Effect', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
	                'none'      => __( 'None', text_domain ),
	                'fade'      => __( 'Fade', text_domain ),
	                'cube'      => __( 'Cube', text_domain ),
                    'coverflow' => __( 'Coverflow', text_domain ),
                    'flip'      => __( 'Flip', text_domain ),
                    'cards'     => __( 'Cards', text_domain ),
                    'creative'  => __( 'Creative', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'creative_type',
            [
                'label' => __( 'Creative Type', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
	                '1' => __( 'Type', text_domain ) . ' 1',
	                '2' => __( 'Type', text_domain ) . ' 2',
                    '3' => __( 'Type', text_domain ) . ' 3',
                    '4' => __( 'Type', text_domain ) . ' 4',
                    '5' => __( 'Type', text_domain ) . ' 5',
                    '6' => __( 'Type', text_domain ) . ' 6',
                ],
                'condition' => [
                    'effect' => 'creative'
                ],
            ]
        );
        $this->end_controls_section();
    }


    // register style general controls
    protected function register_style_general_controls() {
        $this->start_controls_section(
            'section_style_general',
            [
                'label' => __( 'General', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
         // margin posts
         $this->add_responsive_control(
            'margin_posts',
            [
                'label' => __( 'Margin Posts', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '0',
                    'right' => '10',
                    'bottom' => '0',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-member-slides' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
         // padding posts
         $this->add_responsive_control(
            'padding_posts',
            [
                'label' => __( 'Padding Posts', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => '0',
                    'right' => '10',
                    'bottom' => '0',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        // padding
        $this->add_responsive_control(
            'card_padding',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        // background
        $this->add_control(
            'card_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                        '{{WRAPPER}} .slider-card' => 'background-color: {{VALUE}};',
                ],
            ]
        );    

        // border radius
        $this->add_responsive_control(
            'card_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                        '{{WRAPPER}} .slider-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // border
        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'card_border',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} .slider-card',
			]
		);	

        // box shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'card_shadow',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} .slider-card',
            ]
        );


        $this->end_controls_section();
        
    }

    // register style image controls
    protected function register_style_image_controls() {
        $this->start_controls_section(
            'section_style_photo',
             [
                'label' => __('Photo', text_domain), 
                'tab'   => Controls_Manager::TAB_STYLE,
             ]
        );

        $this->start_controls_tabs('tabs_photo_style');

        $this->start_controls_tab(
            'tab_photo_normal',
            [
                'label' => __('Normal', text_domain),
            ]
        );



        // photo background
        $this->add_control(
            'photo_background',
            [
                'label'     => __('Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-img' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // box shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_photo',
                'label' => __('Box Shadow', text_domain),
                'selector' => '{{WRAPPER}} .slider-card .slider-img',
            ]
        );

        // width photo
        $this->add_responsive_control(
            'width_photo',
            [
                'label' => __('Width', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-img img' => 'width: {{SIZE}}%;',
                ],
            ]
        );

        // height photo
        $this->add_responsive_control(
            'height_photo',
            [
                'label' => __('Height', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-img img' => 'height: {{SIZE}}px;',
                ],
            ]
        );


        // photo opacity
        $this->add_control(
            'photo_opacity',
            [
                'label'   => __('Opacity (%)', text_domain),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 1,
                ],
                'range' => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-img img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        // photo padding
        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => __('Image Padding', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_margin',
            [
                'label'      => __('Image Margin', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // photo border radius
        $this->add_responsive_control(
            'photo_border_radius',
            [
                'label'      => __('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-card .slider-img, {{WRAPPER}} .slider-card .slider-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
                ],
            ]
        );


        // photo border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'photo_border',
                'label'       => __('Border', text_domain),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .slider-card .slider-img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_photo_hover',
             [
                'label' => __('Hover', text_domain),
            ]
        );

        // photo hover border color
        $this->add_control(
            'photo_hover_border_color',
            [
                'label'     => __('Border Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'border_border!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-img:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        // photo hover opacity
        $this->add_control(
            'photo_hover_opacity',
            [
                'label'   => __('Opacity (%)', text_domain),
                'type'    => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 1,
                ],
                'range' => [
                    'px' => [
                        'max'  => 1,
                        'min'  => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-img:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );


        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    // register style role controls
    protected function register_style_role_controls() {
        $this->start_controls_section(
            'section_style_role',
            [
                'label' => __( 'Role', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        // text align
        $this->add_responsive_control(
            'role_text_align',
            [
                'label'   => __('Text Alignment', text_domain),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', text_domain),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', text_domain),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .role' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_style_role');
        $this->start_controls_tab(
            'tab_style_role_normal',
            [
                'label' => __('Normal', text_domain),
            ]
        );

        // role color
        $this->add_control(
            'role_color',
            [
                'label'     => __('Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .role' => 'color: {{VALUE}};',
                ],
            ]
        );

        // role background
        $this->add_control(
            'role_bgc',
            [
                'label'     => __('Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .role' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_style_role_hover',
            [
                'label' => __('Hover', text_domain),
            ]
        );

        $this->add_control(
            'role_color_hover',
            [
                'label'     => __('Color Hover', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .role:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // padding
        $this->add_responsive_control(
			'role_padding',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .slider-card .role' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
        );
        // margin
        $this->add_responsive_control(
			'role_margin',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .slider-card .role' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'role_typography',
                'selector' => '{{WRAPPER}} .slider-card .role',
            ]
        );



        $this->end_controls_section();
    }

    // register style name controls
    protected function register_style_name_controls() {
        $this->start_controls_section(
            'section_style_name',
            [
                'label' => __( 'Name', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        // text align
        $this->add_responsive_control(
            'name_text_align',
            [
                'label'   => __('Text Alignment', text_domain),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', text_domain),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', text_domain),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .name' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_style_name');
        $this->start_controls_tab(
            'tab_style_name_normal',
            [
                'label' => __('Normal', text_domain),
            ]
        );

        // name color
        $this->add_control(
            'name_color',
            [
                'label'     => __('Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .name' => 'color: {{VALUE}};',
                ],
            ]
        );

        // name background
        $this->add_control(
            'name_bgc',
            [
                'label'     => __('Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .name' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_style_name_hover',
             [
                'label' => __('Hover', text_domain),
            ]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label'     => __('Color Hover', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // padding
        $this->add_responsive_control(
			'name_padding',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .slider-card .name' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
        );
        // margin
        $this->add_responsive_control(
			'name_margin',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors' => [
					'{{WRAPPER}} .slider-card .name' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
			]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_typography',
                'selector' => '{{WRAPPER}} .slider-card .name',
            ]
        );



        $this->end_controls_section();
    }

    // register style icon controls
    protected function register_style_icon_controls() {
        $this->start_controls_section(
            'section_style_social_icon',
            [
                'label' => __('Social Icon', text_domain),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

          // text align
        $this->add_responsive_control(
            'social_icon_text_align',
            [
                'label'   => __('Text Alignment', text_domain),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', text_domain),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', text_domain),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-card-social' => 'text-align: {{VALUE}};',
                ],
            ]
        );


        $this->start_controls_tabs('style_tabs_icon');
		$this->start_controls_tab(
            'style_normal_tab_icon',
             [
                'label' => __( 'Normal', text_domain ),
            ]
        );
       
        // icon background
        $this->add_control(
            'icon_background',
            [
                'label'     => __('Icon Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-card-social .tmt-member-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        // icon color
        $this->add_control(
            'icon_color',
            [
                'label'     => __('Icon Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-card-social  .tmt-member-icon' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

		$this->start_controls_tab(
            'style_hover_tab_icon',
             [
                'label' => __( 'Hover', text_domain ),
            ]
        );

           // icon background
           $this->add_control(
            'icon_hover_background',
            [
                'label'     => __('Icon Background', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-card-social .tmt-member-icon:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );


        // icon color
        $this->add_control(
            'icon_hover_color',
            [
                'label'     => __('Icon Color', text_domain),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .slider-card-social  .tmt-member-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        // width
        $this->add_responsive_control(
            'width_social_icon',
            [
                'label' => __( 'Width Social Icon', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .tmt-member-icon' => 'width:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // height
        $this->add_responsive_control(
            'height_social_icon',
            [
                'label' => __( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .tmt-member-icon' => 'height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        // line height
        $this->add_responsive_control(
            'line_height_social_icon',
            [
                'label' => __( 'Line Height Social Icon', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'rem' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slider-card .tmt-member-icon' => 'line-height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // icon content padding
        $this->add_responsive_control(
            'social_icon_content_padding',
            [
                'label'      => __('Padding', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-card .slider-card-social' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // icon content margin
        $this->add_responsive_control(
            'social_icon_content_margin',
            [
                'label'      => __('Margin', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-card .slider-card-social' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // icon content border radius
        $this->add_responsive_control(
            'social_icon_content_border_radius',
            [
                'label'      => __('Border Radius', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-card .slider-card-social .tmt-member-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        // social icon border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'        => 'social_icon_border',
                'label'       => __('Border', text_domain),
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .slider-card .tmt-member-icon',
            ]
        );


        // social icon padding
        $this->add_responsive_control(
            'social_icon_padding',
            [
                'label'      => __('Padding', text_domain),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-card .tmt-member-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // social icon size
        $this->add_responsive_control(
            'social_icon_size',
            [
                'label'     => __('Icon Size', text_domain),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .tmt-member-icon i'        => 'min-width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .slider-card .tmt-member-icon i:before' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // social icon indent
        $this->add_responsive_control(
            'social_icon_indent',
            [
                'label'     => __('Icon Spacing', text_domain),
                'type'      => Controls_Manager::SLIDER,
                'selectors' => [
                    '{{WRAPPER}} .slider-card .tmt-member-icon + .tmt-member-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

       

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_social',
                'label' => __('Box Shadow', text_domain),
                'selector' => '{{WRAPPER}} .slider-card .slider-card-social .tmt-member-icon',
            ]
        );


        $this->end_controls_section();
    }


    // register style navigation controls
    protected function register_style_navigation_controls() {
        $this->start_controls_section(
            'section_style_navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'navigation' => [ 'arrows', 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'arrow_width',
                [
                    'label' => esc_html__( 'Width', text_domain ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', 'em' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'em' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                            'unit' => 'em',
                            'size' => 1,
                    ],
                    'selectors' => [
                            '{{WRAPPER}} .tmt-sw-button' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'navigation' => [ 'arrows', 'both' ],
                    ],
                ]
            );
        $this->add_responsive_control(
        'arrow_height',
            [
                'label' => esc_html__( 'Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                        'unit' => 'em',
                        'size' => 1,
                ],
                'selectors' => [
                        '{{WRAPPER}} .tmt-sw-button' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
        'arrow_line_height',
            [
                'label' => esc_html__( 'Line Height', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                        'unit' => 'em',
                        'size' => 1,
                ],
                'selectors' => [
                        '{{WRAPPER}} .tmt-sw-button' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'heading_style_arrows',
            [
                'label' => __( 'Arrows', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'right_arrow',
            [
                'label' => __( 'Right Arrow', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'left_arrow',
            [
                'label' => __( 'Left Arrow', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'left' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-next' => 'top: {{TOP}}%;left: {{LEFT}}%;right: auto;',
                ],
                'condition' => [
                    'navigation' => ['both', 'arrows'],
                ],
            ]
        );
        $this->add_responsive_control(
            'arrows_size',
            [
                'label' => __( 'Arrows Size', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->start_controls_tabs( 'arrows_icon_tabs' );
        $this->start_controls_tab( 'arrows_icon_normal', [ 
            'label' => __( 'Normal', text_domain ),
            'condition' => [
                'navigation' => [ 'arrows', 'both' ],
            ],
        ] );

        $this->add_control(
            'arrows_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'arrows_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab( 'arrows_icon_hover', [ 
            'label' => __( 'Hover', text_domain ),
            'condition' => [
                'navigation' => [ 'arrows', 'both' ],
            ],
        ] );

        $this->add_control(
            'arrows_hover_color',
            [
                'label' => __( 'Icon Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'arrows_hover_background_color',
            [
                'label' => __( 'Background Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'arrow_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_padding',
            [
                'label' => esc_html__('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .tmt-sw-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => [ 'arrows', 'both' ],
                ],
            ]
        );

        $this->add_control(
            'heading_style_dots',
            [
                'label' => __( 'Dots', text_domain ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_position',
            [
                'label' => __( 'Dots Position', text_domain ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => [ 'top', 'right' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
                ],
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_width',
            [
                'label' => __( 'Width', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_slider_height',
            [
                'label' => __( 'Height', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_control(
            'dots_color',
            [
                'label' => __( 'Dots Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}};',
                ],
                'default' => '#FFFFFF',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_control(
            'active_dot_color',
            [
                'label' => __( 'Active Dot Color', text_domain ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
                'default' => '#4054B2',
                'condition' => [
                    'navigation' => [ 'dots', 'both' ],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_width',
            [
                'label' => __( 'Width', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'active_dots_slider_height',
            [
                'label' => __( 'Height', text_domain ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'size_units' => [ 'px'],
                'selectors'  => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_margin',
            [
                'label' => esc_html__('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],

                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );
        $this->add_responsive_control(
            'dots_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default'   => [
                    'top' => '50',
                    'right' => '50',
                    'bottom' => '50',
                    'left' => '50',
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
                ],
                'condition' => [
                    'navigation' => ['both', 'dots'],
                ],
            ]
        );

       $this->add_control(

           'style_outline_hover',
           [
               'label' => __( 'Style Outline', text_domain ),
               'type' => Controls_Manager::SELECT,
               'default' => 'solid',
               'options' => [
                   'none' => __( 'None', text_domain ),
                   'solid'  => __( 'Solid', text_domain ),
                   'dashed' => __( 'Dashed', text_domain ),
                   'dotted' => __( 'Dotted', text_domain ),
                   'double' => __( 'Double', text_domain ),
                ],
               'selectors' => [
                   '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-style:{{VALUE}}',
                ],
               ]
       );

       $this->add_control(
          'outline_thickness_hover',
          [
            'label' => __( 'Thickness', text_domain ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ],
            ],
            'default' => [
                'size' => 50,
            ],
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-width: {{SIZE}}px;',
            ],
            'condition' => [
                'style_outline_hover!' => 'none',
                'navigation' =>  'dots',
            ],
        ]
       );

       $this->add_control(
           'outline_color_hover',
           [
            'label' => __( 'Color', text_domain ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-color: {{VALUE}}',
            ],
            'condition' => [
                'style_outline_hover!' => 'none',
                'navigation' =>  'dots',
                ],
            ]
       );

        $this->add_control(
            'outline_offset_hover',
            [
                'label' => __( 'Padding', text_domain ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                    'min' => 0,
                    'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'outline-offset: {{SIZE}}px;',
                ],
                'condition' => [
                    'style_outline_hover!' => 'none',
                    'navigation' =>  'dots',
                ],
            ]
            );

            $this->add_control(
                'border_radius_outline_hover',
                [
                    'label' => __( 'Border Radius', text_domain ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                    'condition' => [
                        'style_outline_hover!' => 'none',
                        'navigation' =>  'dots',
                    ],
                ]
            );


            $this->end_controls_section();
        
    }

    // render
    protected function render() {
        $settings = $this->get_settings();


        $id = $this->get_id();
        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
        $show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
        $columns = $settings['slider_columns'];
        $columns_tablet = $settings['slider_columns_tablet'];
        $columns_mobile = $settings['slider_columns_mobile'];
        $pause_on_hover = $settings['pause_on_hover'];
        $infinite = $settings['infinite'];
        $autoplay = $settings['autoplay'];
        $centerMode = $settings['centerMode'];
        $autoplay_speed = $settings['autoplay_speed'];
        $effect = $settings['effect'];
        $data_swiper = [
            'columns' => absint($columns),
            'columns_tablet' => absint($columns_tablet),
            'columns_mobile_h' => $columns_tablet == 1 ? 1 : $columns_tablet - 1,
            'columns_mobile' => absint($columns_mobile),
            'autoplay' => ( 'yes' === $autoplay ),
            'speed' => absint($autoplay_speed),
            'pause_on_hover' => ( 'yes' === $pause_on_hover ),
            'infinite' => ( 'yes' === $infinite ),
            'centerMode' => ( 'yes' === $centerMode ),
            'effect' => $effect,
        ];
        if($effect == 'creative') {
            $data_swiper['creative-type'] = $settings['creative_type'];
        }

        $this->add_render_attribute( 'slides', [
            'data-swiper' => wp_json_encode( $data_swiper ),
        ] );

        if ( $settings['slides'] ) { 

             echo "<div id='slider-$id' class='swiper tmt-slider-yes tmt-member-slides' dir='$direction' ". $this->get_render_attribute_string( 'slides' ) .">"
                . "<div class='swiper-wrapper'>";
                    foreach($settings['slides'] as $slide) {
                        $id = $slide['_id'];
                        $img_url = $slide['photo']['url'];
                        $role = $slide['role'];
                        $name = $slide['name'];
                                                
                        echo "<div class='swiper-slide elementor-repeater-item-$id'>"
                            . "<div class='slider-card'>"
                                ."<div class='slider-img'>"
                                    ."<img src='$img_url' alt='$name' title='$name'>"
                                ."</div>"
                                . "<div class='slider-card-content'>"
                                        . "<div class='role'>";
                                            echo $role;
                                        echo "</div>"
                                        . "<div class='name'>";
                                            echo $name;
                                        echo "</div>"
                                . "</div>";
                                echo "<div class='slider-card-social'>";?>
                                    <?php
                                    if(!empty($slide['social_repeater'])):
                                    foreach ($slide['social_repeater'] as $social_list) : ?>
                                        <a href="<?php echo $social_list['social_link']['url']; ?>" class="tmt-member-icon elementor-repeater-item-<?php echo $social_list['_id']; ?>" title="<?php echo $social_list['social_title']; ?>">
                                            <?php Icons_Manager::render_icon($social_list["social_icon"]); ?>
                                        </a>
                                    <?php endforeach;endif; ?>
                                <?php echo "</div>"
                            . "</div>"
                        . "</div>";
                    }

                echo "</div>";
                if($show_dots) {
                    echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
                }
                if($show_arrows) {
                    echo "<div class='tmt-sw-button swiper-button-prev'></div>"
                    . "<div class='tmt-sw-button swiper-button-next'></div>";
                }
            echo "</div>";

        }    



    }
}



Plugin::instance()->widgets_manager->register(new Themento_Slider_Member);
