<?php

// Register project post-type
function portfolio_post_type() {

	$category = 'post-type';
	if(pll) {
		pll_register_string('tmt-post-type', 'Projects');
		pll_register_string('tmt-post-type', 'Project');
		$name = pll__('Projects');
		$singular_name = pll__('Project');
	} elseif(wpml) {
		$name = TMT_Get_Setting($category, 'name');
		$singular_name = TMT_Get_Setting($category, 'singular');
		do_action( 'wpml_register_single_string', 'tmt-post-type', 'Plural Label', $name );
		do_action( 'wpml_register_single_string', 'tmt-post-type', 'Singular Label', $singular_name );
		$name = apply_filters( 'wpml_translate_single_string', $name, 'tmt-post-type', 'Plural Label', NULL);
		$singular_name = apply_filters( 'wpml_translate_single_string', $singular_name, 'tmt-post-type', 'Singular Label', NULL);
	} else {
		$name = TMT_Get_Setting($category, 'name');
		$singular_name = TMT_Get_Setting($category, 'singular');
	}

	if(is_admin() && pll) {
		$name = TMT_Get_Setting($category, 'name');
		$singular_name = TMT_Get_Setting($category, 'singular');
	}

	$slug = TMT_Get_Setting($category, 'slug');

	$labels = array(
		'name'                  => _x( $name, 'Post Type General Name', text_domain ),
		'singular_name'         => _x( $singular_name, 'Post Type Singular Name', text_domain ),
		'menu_name'             => $name,
		'name_admin_bar'        => $singular_name,
		'archives'              => $singular_name . ' ' . __('Archives', text_domain ),
		'parent_item_colon'     => __( 'Parent', text_domain ) . ' ' . $singular_name .':',
		'all_items'             => __( 'All', text_domain ) . ' ' . $name,
		'add_new_item'          => __( 'Add New', text_domain ) . ' ' . $singular_name,
		'add_new'               => __( 'Add New', text_domain ) . ' ' . $singular_name,
		'new_item'              => __( 'Add New', text_domain ) . ' ' . $singular_name,
		'edit_item'             => __( 'Edit', text_domain ) . ' ' . $singular_name,
		'update_item'           => __( 'Update', text_domain ) . ' ' . $singular_name,
		'view_item'             => __( 'View', text_domain ) . ' ' . $singular_name,
		'view_items'            => __( 'View', text_domain ) . ' ' . $name,
		'search_items'          => __( 'Search', text_domain ) . ' ' . $singular_name,
	);
	$args = array(
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'trackbacks', 'revisions', 'custom-fields', 'page-attributes', 'post-formats', ),
		'taxonomies'            => array( 'portfolio_cat', 'portfolio_tags' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'post',
		'show_in_rest'          => true,
	);
	if(! TMT_Get_Setting($category, 'disable-archive')) {
		$args['has_archive'] = true;
	}
	register_post_type( $slug, $args );

}
add_action( 'init', 'portfolio_post_type', 0 );


function mega_menu_post_type() {

    $labels = array(
        'name'                  => _x( 'Mega Menu', 'Post type general name', text_domain ),
        'singular_name'         => _x( 'Mega Menu', 'Post type singular name', text_domain ),
        'menu_name'             => _x( 'Mega Menu', 'Admin Menu text', text_domain ),
        'name_admin_bar'        => _x( 'Mega Menu', 'Add New on Toolbar', text_domain ),
        'add_new'               => __( 'Add New', text_domain ),
        'add_new_item'          => __( 'Add New Mega Menu', text_domain ),
        'new_item'              => __( 'New Mega Menu', text_domain ),
        'edit_item'             => __( 'Edit Mega Menu', text_domain ),
        'view_item'             => __( 'View Mega Menu', text_domain ),
        'all_items'             => __( 'All Mega Menu', text_domain ),
        'search_items'          => __( 'Search Mega Menu', text_domain ),
        'parent_item_colon'     => __( 'Parent Mega Menu:', text_domain ),
        'not_found'             => __( 'No Mega Menu found.', text_domain ),
        'not_found_in_trash'    => __( 'No Mega Menu found in Trash.', text_domain ),
        'archives'              => _x( 'Mega Menu archives', 'The post type archive label used in nav Menu. Default “Post Archives”. Added in 4.4', text_domain ),
        'insert_into_item'      => _x( 'Insert into Mega Menu', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', text_domain ),
        'items_list'            => _x( 'Mega Menu list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', text_domain ),
    );
    $args = array(
        'labels'                => $labels,
        'supports'              => array('title', 'editor'),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'show_in_admin_bar'     => false,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => false,
        'exclude_from_search'   => true,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
        'show_in_rest'          => false,
    );
    register_post_type( 'mega_menu', $args );

}
add_action( 'init', 'mega_menu_post_type', 0 );