<?php

function TMT_Get_Setting($category, $id)
{
    $main_option = get_option('tmt_main_option', []);
    $get_category = $main_option[$category];

    return !empty($get_category[$id]) ? $get_category[$id] : '';
}


function seo_title()
{
    if (is_singular()) {
        $title = get_the_title();
    } elseif (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_tag()) {
        $title = single_tag_title('', false);
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title('', false);
    } elseif (is_tax()) {
        $title = single_term_title('', false);
    } else {
        $title = wp_title('');
    }
    return $title;
}

if (! function_exists('daris_the_posts_navigation')) :

    function daris_the_posts_navigation($number)
    {
        the_posts_pagination(
            array(
                'mid_size' => $number,
                'prev_text' => ('<i class="fas fa-angle-double-right"></i>'),
                'next_text' => ('<i class="fas fa-angle-double-left"></i>'),
            )
        );
    }
endif;

if (! function_exists('daris_post_thumbnail')) :

    function daris_post_thumbnail($size)
    {
        if (has_post_thumbnail()) :
            the_post_thumbnail($size, array('alt' => '' . get_the_title() . '', 'title' => '' . get_the_title() . ''));
        else :
            echo '<img src="' . wp_directory_uri . '/images/thumbnail.jpg" alt="' . get_the_title() . '" />';
        endif;
    }
endif;

function TMT_avatar()
{
    $user = wp_get_current_user();
    if ($user) :
?><img src="<?php echo esc_url(get_avatar_url($user->ID)); ?>" />
    <?php endif;
}

if (! function_exists('excerpt_post')) :
    function excerpt_post($number)
    {
        preg_match("/^([^.!?\s]*[\.!?\s]+){0,$number}/", strip_tags(get_the_content()), $abstract);
        echo $abstract[0] . '...';
    }
endif;

function TMT_Position()
{
    $position_options = [
        ''              => esc_html__('Default', text_domain),
        'top-left'      => esc_html__('Top Left', text_domain),
        'top-center'    => esc_html__('Top Center', text_domain),
        'top-right'     => esc_html__('Top Right', text_domain),
        'center'        => esc_html__('Center', text_domain),
        'center-left'   => esc_html__('Center Left', text_domain),
        'center-right'  => esc_html__('Center Right', text_domain),
        'bottom-left'   => esc_html__('Bottom Left', text_domain),
        'bottom-center' => esc_html__('Bottom Center', text_domain),
        'bottom-right'  => esc_html__('Bottom Right', text_domain),
    ];

    return $position_options;
}

function TMT_Title_Tags()
{
    $title_tags = [
        'h1'   => esc_html__('H1', text_domain),
        'h2'   => esc_html__('H2', text_domain),
        'h3'   => esc_html__('H3', text_domain),
        'h4'   => esc_html__('H4', text_domain),
        'h5'   => esc_html__('H5', text_domain),
        'h6'   => esc_html__('H6', text_domain),
        'div'  => esc_html__('div', text_domain),
        'span' => esc_html__('span', text_domain),
        'p'    => esc_html__('p', text_domain),
    ];

    return $title_tags;
}

if (! function_exists('GFCommon')) :
    function themento_gravity_forms_options()
    {


        if (class_exists('GFCommon')) {
            $contact_forms = RGFormsModel::get_forms(null, 'title');
            $form_options = ['0' => esc_html__('Select Form', text_domain)];
            if (! empty($contact_forms) && ! is_wp_error($contact_forms)) {
                foreach ($contact_forms as $form) {
                    $form_options[$form->id] = $form->title;
                }
            }
        } else {
            $form_options = ['0' => esc_html__('Form Not Found!', text_domain)];
        }

        return $form_options;
    }
endif;

function add_elementor_widget_categories($elements_manager)
{
    $elements_manager->add_category(
        text_domain,
        [
            'title' => __('daris', text_domain),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'single_daris',
        [
            'title' => __('Single daris', text_domain),
            'icon' => 'fa fa-plug',
        ]
    );
    $elements_manager->add_category(
        'shop_daris',
        [
            'title' => __('Shop daris', text_domain),
            'icon' => 'fa fa-plug',
        ]
    );
}
add_action('elementor/elements/categories_registered', 'add_elementor_widget_categories');


if (woo) {

    add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'custom_ajax_add_to_cart');
    add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'custom_ajax_add_to_cart');

    function custom_ajax_add_to_cart()
    {
        $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
        $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);

        $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);

        if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity)) {
            do_action('woocommerce_ajax_added_to_cart', $product_id);
            WC_AJAX::get_refreshed_fragments();
        } else {
            $data = array(
                'error' => true,
                'product_url' => get_permalink($product_id)
            );
            echo wp_send_json($data);
        }
        wp_die();
    }


    add_action('wp_ajax_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart_handler');
    add_action('wp_ajax_nopriv_woocommerce_ajax_add_to_cart', 'woocommerce_ajax_add_to_cart_handler');

    function woocommerce_ajax_add_to_cart_handler()
    {
        $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
        $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
        $variation_id = absint($_POST['variation_id']);

        $cart_item_key = WC()->cart->add_to_cart($product_id, $quantity, $variation_id);

        if ($cart_item_key) {
            wc_add_to_cart_message([$product_id], true);
            wp_send_json_success([
                'fragments' => apply_filters('woocommerce_add_to_cart_fragments', WC()->cart->get_cart_fragments()),
                'cart_hash' => WC()->cart->get_cart_hash(),
            ]);
        } else {
            wp_send_json_error(['error' => true, 'message' => __('Product cannot be added to cart', 'woocommerce')]);
        }
    }


    add_action('wp_footer', 'tmt_add_wc_button_script');
    function tmt_add_wc_button_script()
    {
    ?>
        <script>
            jQuery(document).ready(function($) {
                var ajaxurl = "<?php echo esc_attr(admin_url('admin-ajax.php')); ?>";
                $(document.body).on('click', '.l-add-to-cart', function(e) {
                    e.preventDefault();

                    var $this = $(this);
                    $this.html('<i class="fa fa-spinner fa-spin fa-fw"></i>');
                    var id = $(this).data("product-id");
                    var data = {
                        action: 'tmt_add_add_to_cart',
                        product_id: id
                    };
                    $.post(ajaxurl, data, function(response) {
                        if (response.success) {
                            var count = document.querySelector(".shopping-cart .card-count").textContent;
                            count++;
                            $('.shopping-cart .card-count').html(count);
                            $(".fa-spinner").fadeOut('fast');
                            $this.html('<i class="fas fa-check"></i>');
                            $(document.body).trigger('wc_fragment_refresh');
                        } else {
                            $(".fa-spinner").fadeOut('fast');
                            $this.html('<i class="fas fa-check"></i>');
                        }
                    }, 'json');
                })
            });
        </script>
        <?php
    }
    add_action('wp_ajax_tmt_add_add_to_cart', "tmt_add_add_to_cart");
    add_action('wp_ajax_nopriv_tmt_add_add_to_cart', "tmt_add_add_to_cart");
    function tmt_add_add_to_cart()
    {
        $retval = array(
            'success' => false,
            'message' => ""
        );
        if (!function_exists("WC")) {
            $retval['message'] = "woocommerce not installed";
        } elseif (empty($_POST['product_id'])) {
            $retval['message'] = "no product id provided";
        } else {
            $product_id = $_POST['product_id'];
            if (tmt_add_cart_contains($product_id)) {
                $retval['message'] = "product already in cart";
            } else {
                $cart = WC()->cart;
                $retval['success'] = $cart->add_to_cart($product_id);
                if (!$retval['success']) {
                    $retval['message'] = "product could not be added to cart";
                } else {
                    $retval['message'] = "product added to cart";
                }
            }
        }
        echo json_encode($retval);
        wp_die();
    }
    function tmt_add_cart_contains($product_id)
    {
        $cart = WC()->cart;
        $cart_items = $cart->get_cart();
        if ($cart_items) {
            foreach ($cart_items as $item) {
                $product = $item['data'];
                if ($product_id == $product->id) {
                    return true;
                }
            }
        }
        return false;
    }

    if (TMT_Get_Setting('general-settings', 'edpc')) {
        function tmt_addcatagory_description($category)
        {
            if (!empty($category->description)) {
                echo '<div class="term-description">' . $category->description . '</div>';
            }
        }
        add_action('woocommerce_after_subcategory_title', 'tmt_addcatagory_description', 10, 1);
    }

    function tmt_woo_remove_wc_breadcrumbs_notices()
    {
        remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
        remove_action('woocommerce_before_single_product', 'woocommerce_output_all_notices', 10);
    }
    add_action('init', 'tmt_woo_remove_wc_breadcrumbs_notices');

    function tmt_custom_add_to_cart_message()
    {
        $cart_url = wc_get_cart_url();
        $message = "<div class='tmt-add-to-cart-message flex justify-content-between align-items-center'><p>" . __('Your product has been added to cart.', text_domain) . "</p><a class='button' href='$cart_url'>" . __('View cart', text_domain) . "</a></div>";

        return $message;
    }
    add_filter('wc_add_to_cart_message_html', 'tmt_custom_add_to_cart_message');

    function custom_postimage_meta_box_save($post_id)
    {

        if (! current_user_can('edit_posts', $post_id)) {
            return 'not permitted';
        }

        if (isset($_POST['custom_postimage_meta_box_nonce']) && wp_verify_nonce($_POST['custom_postimage_meta_box_nonce'], 'custom_postimage_meta_box')) {

            //same array as in custom_postimage_meta_box_func($post)
            $meta_key = 'second_featured_image';
            if ($meta_key) {
                if (isset($_POST[$meta_key]) && intval($_POST[$meta_key]) != '') {
                    update_post_meta($post_id, $meta_key, intval($_POST[$meta_key]));
                } else {
                    update_post_meta($post_id, $meta_key, '');
                }
            }
        }
    }

    function custom_postimage_meta_box_func($post)
    {

        //an array with all the images (ba meta key). The same array has to be in custom_postimage_meta_box_save($post_id) as well.
        $meta_key = 'second_featured_image';

        if ($meta_key) {
            $image_meta_val = get_post_meta($post->ID, $meta_key, true);
        ?>
            <div class="custom_postimage_wrapper" id="<?php echo $meta_key; ?>_wrapper" style="margin-bottom:20px;">
                <img src="<?php echo ($image_meta_val != '' ? wp_get_attachment_image_src($image_meta_val)[0] : ''); ?>" style="width:100%;display: <?php echo ($image_meta_val != '' ? 'block' : 'none'); ?>" alt="">
                <a class="addimage button" onclick="custom_postimage_add_image('<?php echo $meta_key; ?>');"><?php _e('add image', text_domain); ?></a><br>
                <a class="removeimage" style="color:#a00;cursor:pointer;display: <?php echo ($image_meta_val != '' ? 'block' : 'none'); ?>" onclick="custom_postimage_remove_image('<?php echo $meta_key; ?>');"><?php _e('remove image', text_domain); ?></a>
                <input type="hidden" name="<?php echo $meta_key; ?>" id="<?php echo $meta_key; ?>" value="<?php echo $image_meta_val; ?>" />
            </div>
        <?php } ?>
        <script>
            function custom_postimage_add_image(key) {

                var $wrapper = jQuery('#' + key + '_wrapper');

                custom_postimage_uploader = wp.media.frames.file_frame = wp.media({
                    title: '<?php _e('select image', text_domain); ?>',
                    button: {
                        text: '<?php _e('select image', text_domain); ?>'
                    },
                    multiple: false
                });
                custom_postimage_uploader.on('select', function() {

                    var attachment = custom_postimage_uploader.state().get('selection').first().toJSON();
                    var img_url = attachment['url'];
                    var img_id = attachment['id'];
                    $wrapper.find('input#' + key).val(img_id);
                    $wrapper.find('img').attr('src', img_url);
                    $wrapper.find('img').show();
                    $wrapper.find('a.removeimage').show();
                });
                custom_postimage_uploader.on('open', function() {
                    var selection = custom_postimage_uploader.state().get('selection');
                    var selected = $wrapper.find('input#' + key).val();
                    if (selected) {
                        selection.add(wp.media.attachment(selected));
                    }
                });
                custom_postimage_uploader.open();
                return false;
            }

            function custom_postimage_remove_image(key) {
                var $wrapper = jQuery('#' + key + '_wrapper');
                $wrapper.find('input#' + key).val('');
                $wrapper.find('img').hide();
                $wrapper.find('a.removeimage').hide();
                return false;
            }
        </script>
    <?php
        wp_nonce_field('custom_postimage_meta_box', 'custom_postimage_meta_box_nonce');
    }

    add_action('after_setup_theme', 'custom_postimage_setup');
    function custom_postimage_setup()
    {
        add_action('add_meta_boxes', 'custom_postimage_meta_box');
        add_action('save_post', 'custom_postimage_meta_box_save');
    }

    function custom_postimage_meta_box()
    {

        //on which post types should the box appear?
        $post_types = ['product'];
        foreach ($post_types as $pt) {
            add_meta_box('custom_postimage_meta_box', __('Second thumbnail'), 'custom_postimage_meta_box_func', $pt, 'side', 'low');
        }
    }


    function tmt_get_sell_price($id)
    {
        $product = wc_get_product($id);
        if ($product->is_type('variable')) {
            $var_regular_price = array();
            $var_sale_price = array();
            $var_diff_price = array();
            $available_variations = $product->get_available_variations();
            foreach ($available_variations as $key => $available_variation) {
                $variation_id = $available_variation['variation_id']; // Getting the variable id of just the 1st product. You can loop $available_variations to get info about each variation.
                $variable_product = new WC_Product_Variation($variation_id);

                $variable_product_regular_price = $variable_product->get_regular_price();
                $variable_product_sale_price = $variable_product->get_sale_price();

                if (! empty($variable_product_regular_price)) {
                    $var_regular_price[] = $variable_product_regular_price;
                } else {
                    $var_regular_price[] = 0;
                }
                if (! empty($variable_product_sale_price)) {
                    $var_sale_price[] = $variable_product_sale_price;
                } else {
                    $var_sale_price[] = 0;
                }
            }

            foreach ($var_regular_price as $key => $reg_price) {
                if (isset($var_sale_price[$key]) && $var_sale_price[$key] !== 0) {
                    $var_diff_price[] = $reg_price - $var_sale_price[$key];
                } else {
                    $var_diff_price[] = 0;
                }
            }

            $best_key = array_search(max($var_diff_price), $var_diff_price);

            $regular_price = $var_regular_price[$best_key];
            $sale_price = $var_sale_price[$best_key];
        } else {
            $regular_price = $product->get_regular_price();
            $sale_price = $product->get_sale_price();
        }

        $regular_price = wc_get_price_to_display($product, array('qty' => 1, 'price' => $regular_price));
        $sale_price = wc_get_price_to_display($product, array('qty' => 1, 'price' => $sale_price));

        $savings = ceil((($regular_price - $sale_price) / $regular_price) * 100) . '%';

        return $savings;
    }

    add_filter('wc_add_to_cart_message_html', 'tmt_custom_add_to_cart_message');


    add_filter('woocommerce_available_variation', function ($available_variations, \WC_Product_Variable $variable, \WC_Product_Variation $variation) {
        if (empty($available_variations['price_html'])) {
            $available_variations['price_html'] = '<span class="price">' . $variation->get_price_html() . '</span>';
        }

        return $available_variations;
    }, 10, 3);


}

// Remove Wordpress From Admin Pages Titles
function tmt_my_admin_title($admin_title, $title)
{
    return $title . ' - ' . get_bloginfo('name');
}
add_filter('admin_title', 'tmt_my_admin_title', 10, 2);
add_filter('login_title', 'tmt_my_admin_title', 10, 2);


if (TMT_Get_Setting('general-settings', 'rd-after-login')) {
    apply_filters('login_redirect', 'tmt_redirect_after_login');
    function tmt_redirect_after_login()
    {
        $rd_after_login_url = TMT_Get_Setting('general-settings', 'rd-after-login-url');
        $url = !empty($rd_after_login_url) ? $rd_after_login_url : get_home_url();
        wp_safe_redirect($url);
        exit;
    }
}

if (TMT_Get_Setting('general-settings', 'rd-after-logout')) {
    add_action('wp_logout', 'tmt_redirect_after_logout');
    function tmt_redirect_after_logout()
    {
        $rd_after_logout_url = TMT_Get_Setting('general-settings', 'rd-after-logout-url');
        $url = !empty($rd_after_logout_url) ? $rd_after_logout_url : get_home_url();
        wp_safe_redirect($url);
        exit;
    }
}

function TMT_Translations()
{
    __('Current loop', text_domain);
    __('Theme Settings', text_domain);
    __('License registration', text_domain);
}


add_action('after_switch_theme', 'tmt_after_switch_theme_update');
function tmt_after_switch_theme_update()
{
    do_action('tmt_update_custom_styles');
}

add_action('upgrader_process_complete', 'tmt_on_theme_update', 10, 2);
function tmt_on_theme_update($upgrader_object, $options)
{
    if ($options['action'] === 'update' && $options['type'] === 'theme') {
        do_action('tmt_update_custom_styles');
    }
}

if (! get_option('dismissed_tmt_admin_notice')) {
    function tmt_admin_notice()
    {
        echo '<div class="notice notice-error tmt-admin-notice"><p>بعد از بروزرسانی قالب در صورت وجود بهم ریختگی در ظاهر سایت و پنل تنظیمات ابتدا وارد منو المنتور >> ابزار ها شوید و یکبار دکمه "بازسازی فایل‌ها و داده" را بزنید. سپس از پشخوان وردپرس وارد منو تنظیمات قالب شوید و یکبار تنظیمات را ذخیره کنید.
            در  نهایت جهت مشاهده تغییرات در پنل تنظیمات و خروجی سایت یکبار کلید های ترکیبی Ctrl + F5 را بزنید.</p><a id="tmt-notice-closed" class="button-primary" style="margin-bottom: 10px;background-color: #d63638;border-color: #d63638;" href="#">بستن پیغام</a></div>';
    }
    add_action('admin_notices', 'tmt_admin_notice');
}

add_action('wp_ajax_tmt_close_notice_action', 'tmt_close_notice_action_callback');
function tmt_close_notice_action_callback()
{
    update_option('dismissed_tmt_admin_notice', true);
    die();
}

add_action('admin_footer', 'tmt_inline_admin_script');
function tmt_inline_admin_script()
{
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#tmt-notice-closed').click(function(e) {
                e.preventDefault();
                var notice = $('.tmt-admin-notice');
                $.ajax({
                    type: 'POST',
                    url: '<?php echo admin_url('admin-ajax.php'); ?>',
                    data: {
                        action: 'tmt_close_notice_action'
                    },
                    success: function(response) {
                        notice.slideUp(100, function() {
                            notice.slideUp();
                        });
                    }
                });
            });
        });
    </script>
<?php
}
